/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.DefaultHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandlerFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestEventHandlerFactory {
    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowRegisteringEventsWhichCannotBeInstantiated() {
        class NonCompatibleEventHandler
        implements EventHandler {
            NonCompatibleEventHandler() {
            }

            public void handle(EventHandler.Context withinContext) throws Exception {
            }

            public long fromEventId() {
                return 0L;
            }

            public long toEventId() {
                return 0L;
            }

            public DumpType dumpType() {
                return null;
            }
        }
        EventHandlerFactory.register((String)"anyEvent", NonCompatibleEventHandler.class);
    }

    @Test
    public void shouldProvideDefaultHandlerWhenNothingRegisteredForThatEvent() {
        NotificationEvent event = new NotificationEvent(Long.MAX_VALUE, Integer.MAX_VALUE, "shouldGiveDefaultHandler", "s");
        event.setMessageFormat("json-0.2");
        EventHandler eventHandler = EventHandlerFactory.handlerFor((NotificationEvent)event);
        Assert.assertTrue((boolean)(eventHandler instanceof DefaultHandler));
    }
}

