/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CopyUtils.class, FileUtils.class, Utils.class, UserGroupInformation.class})
@PowerMockIgnore(value={"javax.management.*"})
public class TestCopyUtils {
    @Test
    public void distcpShouldNotBeCalledOnlyForOneFile() throws Exception {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        PowerMockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn(Mockito.mock(UserGroupInformation.class));
        HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
        ((HiveConf)Mockito.doReturn((Object)1L).when((Object)conf)).getLong(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE.varname, 0x2000000L);
        CopyUtils copyUtils = new CopyUtils("", conf, null);
        long MB_128 = 0x8000000L;
        Assert.assertFalse((boolean)copyUtils.limitReachedForLocalCopy(MB_128, 1L));
    }

    @Test
    public void distcpShouldNotBeCalledForSmallerFileSize() throws Exception {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        PowerMockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn(Mockito.mock(UserGroupInformation.class));
        HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
        CopyUtils copyUtils = new CopyUtils("", conf, null);
        long MB_16 = 0x1000000L;
        Assert.assertFalse((boolean)copyUtils.limitReachedForLocalCopy(MB_16, 100L));
    }

    @Test(expected=IOException.class)
    public void shouldThrowExceptionOnDistcpFailure() throws Exception {
        Path destination = (Path)Mockito.mock(Path.class);
        Path source = (Path)Mockito.mock(Path.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        List<Path> srcPaths = Arrays.asList(source, source);
        HiveConf conf = (HiveConf)Mockito.mock(HiveConf.class);
        CopyUtils copyUtils = (CopyUtils)Mockito.spy((Object)new CopyUtils(null, conf, fs));
        PowerMockito.mockStatic(FileUtils.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)destination.getFileSystem((Configuration)ArgumentMatchers.same((Object)conf))).thenReturn((Object)fs);
        PowerMockito.when((Object)source.getFileSystem((Configuration)ArgumentMatchers.same((Object)conf))).thenReturn((Object)fs);
        PowerMockito.when((Object)FileUtils.distCp((FileSystem)((FileSystem)ArgumentMatchers.same((Object)fs)), (List)ArgumentMatchers.anyListOf(Path.class), (Path)((Path)ArgumentMatchers.same((Object)destination)), (boolean)ArgumentMatchers.anyBoolean(), (UserGroupInformation)((UserGroupInformation)ArgumentMatchers.eq(null)), (HiveConf)((HiveConf)ArgumentMatchers.same((Object)conf)), (HadoopShims)((HadoopShims)ArgumentMatchers.same((Object)ShimLoader.getHadoopShims())))).thenReturn((Object)false);
        PowerMockito.when((Object)Utils.getUGI()).thenReturn(Mockito.mock(UserGroupInformation.class));
        ((CopyUtils)Mockito.doReturn((Object)false).when((Object)copyUtils)).regularCopy((FileSystem)ArgumentMatchers.same((Object)fs), ArgumentMatchers.anyListOf(ReplChangeManager.FileInfo.class));
        copyUtils.doCopy(destination, srcPaths);
    }

    @Test
    public void testParallelCopySuccess() throws Exception {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        PowerMockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn(Mockito.mock(UserGroupInformation.class));
        HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
        PowerMockito.when((Object)conf.getIntVar(HiveConf.ConfVars.REPL_PARALLEL_COPY_TASKS)).thenReturn((Object)2);
        PowerMockito.when((Object)conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)).thenReturn((Object)true);
        FileSystem destFs = (FileSystem)Mockito.mock(FileSystem.class);
        PowerMockito.when((Object)destFs.exists((Path)Mockito.any())).thenReturn((Object)true);
        CopyUtils copyUtils = new CopyUtils(UserGroupInformation.getCurrentUser().getUserName(), conf, destFs);
        CopyUtils copyUtilsSpy = (CopyUtils)Mockito.spy((Object)copyUtils);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorService mockExecutorService = (ExecutorService)Mockito.spy((Object)executorService);
        PowerMockito.when((Object)copyUtilsSpy.getExecutorService()).thenReturn((Object)mockExecutorService);
        Path destination = new Path("dest");
        Path source = (Path)Mockito.mock(Path.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ReplChangeManager.FileInfo srcFileInfo = new ReplChangeManager.FileInfo(fs, source, "path1");
        List<ReplChangeManager.FileInfo> srcFiles = Arrays.asList(srcFileInfo);
        ((CopyUtils)Mockito.doNothing().when((Object)copyUtilsSpy)).doCopy((Map.Entry)Mockito.any(), (UserGroupInformation)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean());
        copyUtilsSpy.copyAndVerify(destination, srcFiles, source, true, true);
        Class<List> listClass = List.class;
        ArgumentCaptor callableCapture = ArgumentCaptor.forClass(listClass);
        ((ExecutorService)Mockito.verify((Object)mockExecutorService, (VerificationMode)Mockito.times((int)0))).invokeAll((Collection)callableCapture.capture());
        ReplChangeManager.FileInfo srcFileInfo1 = new ReplChangeManager.FileInfo(fs, source, "path2");
        ReplChangeManager.FileInfo srcFileInfo2 = new ReplChangeManager.FileInfo(fs, source, "path3");
        srcFiles = Arrays.asList(srcFileInfo1, srcFileInfo2);
        executorService = Executors.newFixedThreadPool(2);
        mockExecutorService = (ExecutorService)Mockito.spy((Object)executorService);
        PowerMockito.when((Object)copyUtilsSpy.getExecutorService()).thenReturn((Object)mockExecutorService);
        copyUtilsSpy.copyAndVerify(destination, srcFiles, source, true, true);
        ((ExecutorService)Mockito.verify((Object)mockExecutorService, (VerificationMode)Mockito.times((int)1))).invokeAll((Collection)callableCapture.capture());
    }
}

