/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.grant.GrantDesc;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationTestUtil;
import org.apache.hadoop.hive.ql.parse.authorization.ListSizeMatcher;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.junit.Assert;

public class PrivilegesTestBase {
    protected static final String DB = "default";
    protected static final String TABLE = "table1";
    protected static final String TABLE_QNAME = "default.table1";
    protected static final String USER = "user1";

    public static void grantUserTable(String privStr, PrivilegeType privType, QueryState queryState, Hive db) throws Exception {
        Context ctx = new Context((Configuration)new HiveConf());
        DDLWork work = AuthorizationTestUtil.analyze("GRANT " + privStr + " ON TABLE " + TABLE + " TO USER " + USER, queryState, db, ctx);
        GrantDesc grantDesc = (GrantDesc)work.getDDLDesc();
        Assert.assertNotNull((String)"Grant should not be null", (Object)grantDesc);
        for (PrivilegeDesc privilege : ListSizeMatcher.inList(grantDesc.getPrivileges()).ofSize(1)) {
            Assert.assertEquals((Object)privType, (Object)privilege.getPrivilege().getPriv());
        }
        for (PrincipalDesc principal : ListSizeMatcher.inList(grantDesc.getPrincipals()).ofSize(1)) {
            Assert.assertEquals((Object)PrincipalType.USER, (Object)principal.getType());
            Assert.assertEquals((Object)USER, (Object)principal.getName());
        }
        Assert.assertTrue((String)"Expected table", (boolean)grantDesc.getPrivilegeSubject().getTable());
        Assert.assertEquals((Object)TABLE_QNAME, (Object)grantDesc.getPrivilegeSubject().getObject());
    }
}

