/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;

public class AuthorizationTestUtil {
    public static DDLWork analyze(ASTNode ast, QueryState queryState, Hive db) throws Exception {
        BaseSemanticAnalyzer analyzer = DDLSemanticAnalyzerFactory.getAnalyzer((ASTNode)ast, (QueryState)queryState, (Hive)db);
        SessionState.start((HiveConf)queryState.getConf());
        analyzer.analyze(ast, new Context((Configuration)queryState.getConf()));
        List rootTasks = analyzer.getRootTasks();
        return (DDLWork)((Task)AuthorizationTestUtil.inList(rootTasks).ofSize(1).get(0)).getWork();
    }

    public static DDLWork analyze(String command, QueryState queryState, Hive db, Context ctx) throws Exception {
        return AuthorizationTestUtil.analyze(AuthorizationTestUtil.parse(command, ctx), queryState, db);
    }

    private static ASTNode parse(String command, Context ctx) throws Exception {
        return ParseUtils.parse((String)command, (Context)ctx);
    }

    public static <E> ListSizeMatcher<E> inList(List<E> list) {
        return new ListSizeMatcher(list);
    }

    public static class ListSizeMatcher<E> {
        private final List<E> list;

        private ListSizeMatcher(List<E> list) {
            this.list = list;
        }

        private List<E> ofSize(int size) {
            Assert.assertEquals((String)this.list.toString(), (long)size, (long)this.list.size());
            return this.list;
        }
    }
}

