/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.Quotation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class TestReplicationSemanticAnalyzer {
    private static ParseDriver driver = new ParseDriver();
    private static HiveConf hiveConf = TestReplicationSemanticAnalyzer.buildHiveConf();

    public static HiveConf buildHiveConf() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT, Quotation.NONE.stringValue());
        return conf;
    }

    private static ASTNode parse(String command) throws Exception {
        SessionState.start((HiveConf)hiveConf);
        return (ASTNode)driver.parse(command, (Configuration)hiveConf).getTree().getChild(0);
    }

    private static void assertWithClause(ASTNode root, int replConfigIndex) {
        ASTNode replConfig = (ASTNode)root.getChild(replConfigIndex);
        Assert.assertEquals((Object)"TOK_REPL_CONFIG", (Object)replConfig.getText());
        Assert.assertEquals((long)1L, (long)replConfig.getChildCount());
        ASTNode replConfigList = (ASTNode)replConfig.getChild(0);
        Assert.assertEquals((Object)"TOK_REPL_CONFIG_LIST", (Object)replConfigList.getText());
        Assert.assertEquals((long)2L, (long)replConfigList.getChildCount());
        TestReplicationSemanticAnalyzer.assertConfig(replConfigList, 0, "'key.1'", "'value.1'");
        TestReplicationSemanticAnalyzer.assertConfig(replConfigList, 1, "'key.2'", "'value.2'");
    }

    private static void assertConfig(ASTNode replConfigList, int atIndex, String expectedKey, String expectedValue) {
        ASTNode configOne = (ASTNode)replConfigList.getChild(atIndex);
        Assert.assertEquals((Object)"TOK_TABLEPROPERTY", (Object)configOne.getText());
        Assert.assertEquals((long)2L, (long)configOne.getChildCount());
        Assert.assertEquals((Object)expectedKey, (Object)configOne.getChild(0).getText());
        Assert.assertEquals((Object)expectedValue, (Object)configOne.getChild(1).getText());
    }

    private static void assertToEventId(ASTNode fromClauseRootNode) {
        ASTNode child = (ASTNode)fromClauseRootNode.getChild(1);
        Assert.assertEquals((Object)"TOK_TO", (Object)child.getText());
        Assert.assertEquals((long)0L, (long)child.getChildCount());
        child = (ASTNode)fromClauseRootNode.getChild(2);
        Assert.assertEquals((Object)"200", (Object)child.getText());
        Assert.assertEquals((long)0L, (long)child.getChildCount());
    }

    private static ASTNode assertFromEvent(int expectedNumberOfChildren, ASTNode root) {
        ASTNode child = (ASTNode)root.getChild(2);
        Assert.assertEquals((Object)"TOK_FROM", (Object)child.getText());
        Assert.assertEquals((long)child.getChildCount(), (long)expectedNumberOfChildren);
        ASTNode fromClauseChild = (ASTNode)child.getChild(0);
        Assert.assertEquals((Object)"100", (Object)fromClauseChild.getText());
        Assert.assertEquals((long)0L, (long)fromClauseChild.getChildCount());
        return child;
    }

    private static void assertTableName(ASTNode root) {
        ASTNode child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)"TOK_REPL_TABLES", (Object)child.getText());
        Assert.assertEquals((long)1L, (long)child.getChildCount());
        Assert.assertEquals((Object)"'test_table'", (Object)child.getChild(0).getText());
    }

    private static void assertDatabase(int expectedNumberOfChildren, ASTNode root) {
        Assert.assertEquals((Object)"TOK_REPL_DUMP", (Object)root.getText());
        Assert.assertEquals((long)expectedNumberOfChildren, (long)root.getChildCount());
        ASTNode child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)"testDb", (Object)child.getText());
        Assert.assertEquals((long)0L, (long)child.getChildCount());
    }

    public static class ReplStatus {
        @Test
        public void parseTargetDbName() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl status targetTestDbName");
            this.assertTargetDatabaseName(root);
        }

        @Test
        public void parseWithClause() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl status targetTestDbName with('hive.metastore.uris'='thrift://localhost:12341')");
            this.assertTargetDatabaseName(root);
            ASTNode child = (ASTNode)root.getChild(1);
            Assert.assertEquals((Object)"TOK_REPL_CONFIG", (Object)child.getText());
            Assert.assertEquals((long)1L, (long)child.getChildCount());
            child = (ASTNode)child.getChild(0);
            Assert.assertEquals((Object)"TOK_REPL_CONFIG_LIST", (Object)child.getText());
            ASTNode configNode = (ASTNode)child.getChild(0);
            Assert.assertEquals((Object)"TOK_TABLEPROPERTY", (Object)configNode.getText());
            Assert.assertEquals((long)2L, (long)configNode.getChildCount());
            Assert.assertEquals((Object)"'hive.metastore.uris'", (Object)configNode.getChild(0).getText());
            Assert.assertEquals((Object)"'thrift://localhost:12341'", (Object)configNode.getChild(1).getText());
        }

        private void assertTargetDatabaseName(ASTNode root) {
            ASTNode child = (ASTNode)root.getChild(0);
            Assert.assertEquals((Object)"targetTestDbName", (Object)child.getText());
            Assert.assertEquals((long)0L, (long)child.getChildCount());
        }
    }

    public static class ReplLoad {
        @Test
        public void parseFromLocation() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl load testDbName");
            this.assertFromLocation(1, root);
        }

        @Test
        public void parseTargetDbName() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl load testDbName into targetTestDbName");
            this.assertFromLocation(2, root);
            this.assertTargetDatabaseName(root);
        }

        @Test
        public void parseWithClause() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl load testDbName into targetTestDbName with ('mapred.job.queue.name'='repl','hive.repl.approx.max.load.tasks'='100')");
            this.assertFromLocation(3, root);
            this.assertTargetDatabaseName(root);
            ASTNode child = (ASTNode)root.getChild(2);
            Assert.assertEquals((Object)"TOK_REPL_CONFIG", (Object)child.getText());
            Assert.assertEquals((long)1L, (long)child.getChildCount());
            child = (ASTNode)child.getChild(0);
            Assert.assertEquals((Object)"TOK_REPL_CONFIG_LIST", (Object)child.getText());
            Assert.assertEquals((long)2L, (long)child.getChildCount());
            ASTNode configNode = (ASTNode)child.getChild(0);
            Assert.assertEquals((Object)"TOK_TABLEPROPERTY", (Object)configNode.getText());
            Assert.assertEquals((long)2L, (long)configNode.getChildCount());
            Assert.assertEquals((Object)"'mapred.job.queue.name'", (Object)configNode.getChild(0).getText());
            Assert.assertEquals((Object)"'repl'", (Object)configNode.getChild(1).getText());
            configNode = (ASTNode)child.getChild(1);
            Assert.assertEquals((Object)"TOK_TABLEPROPERTY", (Object)configNode.getText());
            Assert.assertEquals((long)2L, (long)configNode.getChildCount());
            Assert.assertEquals((Object)"'hive.repl.approx.max.load.tasks'", (Object)configNode.getChild(0).getText());
            Assert.assertEquals((Object)"'100'", (Object)configNode.getChild(1).getText());
        }

        private void assertFromLocation(int expectedNumberOfChildren, ASTNode root) {
            Assert.assertEquals((Object)"TOK_REPL_LOAD", (Object)root.getText());
            Assert.assertEquals((long)expectedNumberOfChildren, (long)root.getChildCount());
            ASTNode child = (ASTNode)root.getChild(0);
            Assert.assertEquals((Object)"testDbName", (Object)child.getText());
            Assert.assertEquals((long)0L, (long)child.getChildCount());
        }

        private void assertTargetDatabaseName(ASTNode root) {
            ASTNode child = (ASTNode)root.getChild(1);
            Assert.assertEquals((Object)"TOK_DBNAME", (Object)child.getText());
            Assert.assertEquals((long)1L, (long)child.getChildCount());
            child = (ASTNode)child.getChild(0);
            Assert.assertEquals((Object)"targetTestDbName", (Object)child.getText());
            Assert.assertEquals((long)0L, (long)child.getChildCount());
        }
    }

    public static class ReplDumpWithClause {
        @Test
        public void parseDb() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl dump testDb with ('key.1'='value.1','key.2'='value.2')");
            TestReplicationSemanticAnalyzer.assertDatabase(2, root);
            TestReplicationSemanticAnalyzer.assertWithClause(root, 1);
        }

        @Test
        public void parseTableName() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl dump testDb.'test_table' with ('key.1'='value.1','key.2'='value.2')");
            TestReplicationSemanticAnalyzer.assertDatabase(3, root);
            TestReplicationSemanticAnalyzer.assertTableName(root);
            TestReplicationSemanticAnalyzer.assertWithClause(root, 2);
        }
    }

    public static class ReplDump {
        @Test
        public void parseDbPattern() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl dump `*`");
            Assert.assertEquals((Object)"TOK_REPL_DUMP", (Object)root.getText());
            Assert.assertEquals((long)1L, (long)root.getChildCount());
            ASTNode child = (ASTNode)root.getChild(0);
            Assert.assertEquals((Object)"`*`", (Object)child.getText());
            Assert.assertEquals((long)0L, (long)child.getChildCount());
        }

        @Test
        public void parseDb() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl dump testDb");
            TestReplicationSemanticAnalyzer.assertDatabase(1, root);
        }

        @Test
        public void parseTableName() throws Exception {
            ASTNode root = TestReplicationSemanticAnalyzer.parse("repl dump testDb.'test_table'");
            TestReplicationSemanticAnalyzer.assertDatabase(2, root);
            TestReplicationSemanticAnalyzer.assertTableName(root);
        }
    }
}

