/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.ddl.DDLTask;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveDecimalParse {
    @Test
    public void testDecimalType() throws ParseException {
        String query = "create table `dec` (d decimal)";
        String type = this.getColumnType(query);
        Assert.assertEquals((Object)"decimal(10,0)", (Object)type);
    }

    @Test
    public void testDecimalType1() throws ParseException {
        String query = "create table `dec` (d decimal(5))";
        String type = this.getColumnType(query);
        Assert.assertEquals((Object)"decimal(5,0)", (Object)type);
    }

    @Test
    public void testDecimalType2() throws ParseException {
        String query = "create table `dec` (d decimal(9,7))";
        String type = this.getColumnType(query);
        Assert.assertEquals((Object)"decimal(9,7)", (Object)type);
    }

    @Test
    public void testDecimalType3() throws ParseException {
        String query = "create table `dec` (d decimal(66,7))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("Decimal precision out of allowed range [1,38]"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    @Test
    public void testDecimalType4() throws ParseException {
        String query = "create table `dec` (d decimal(0,7))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("Decimal precision out of allowed range [1,38]"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    @Test
    public void testDecimalType5() throws ParseException {
        String query = "create table `dec` (d decimal(7,33))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("Decimal scale must be less than or equal to precision"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    @Test
    public void testDecimalType6() throws ParseException {
        String query = "create table `dec` (d decimal(7,-1))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("extraneous input '-' expecting Number"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    @Test
    public void testDecimalType7() throws ParseException {
        String query = "create table `dec` (d decimal(7,33,4))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("missing ) at ',' near ',' in column name or constraint"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    @Test
    public void testDecimalType8() throws ParseException {
        String query = "create table `dec` (d decimal(7a))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("mismatched input '7a' expecting Number near '('"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    @Test
    public void testDecimalType9() throws ParseException {
        String query = "create table `dec` (d decimal(20,23))";
        Driver driver = this.createDriver();
        try {
            driver.compile(query, true, false);
        }
        catch (CommandProcessorException cpe) {
            Assert.assertTrue((String)("Got " + cpe.getResponseCode() + ", expected not zero"), (cpe.getResponseCode() != 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)cpe.getMessage(), (boolean)cpe.getMessage().contains("Decimal scale must be less than or equal to precision"));
            return;
        }
        Assert.assertTrue((String)"Expected to receive an exception", (boolean)false);
    }

    private Driver createDriver() {
        HiveConf conf = new HiveConf(Driver.class);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        return driver;
    }

    private String getColumnType(String query) {
        Driver driver = this.createDriver();
        int rc = driver.compile(query, true);
        if (rc != 0) {
            return null;
        }
        QueryPlan plan = driver.getPlan();
        DDLTask task = (DDLTask)plan.getRootTasks().get(0);
        DDLWork work = (DDLWork)task.getWork();
        CreateTableDesc spec = (CreateTableDesc)work.getDDLDesc();
        FieldSchema fs = (FieldSchema)spec.getCols().get(0);
        return fs.getType();
    }
}

