/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.signature.OpSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignatureFactory;
import org.apache.hadoop.hive.ql.optimizer.signature.RuntimeStatsPersister;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.mapper.PersistedRuntimeStats;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestRuntimeStatsPersistence {
    GenericUDF udf = new GenericUDFConcat();
    CompilationOpContext cCtx = new CompilationOpContext();
    OpTreeSignatureFactory signatureFactory = OpTreeSignatureFactory.newCache();

    private Operator<?> getFilTsOp(int i, int j) {
        Operator<TableScanDesc> ts = this.getTsOp(i);
        Operator<? extends OperatorDesc> fil = this.getFilterOp(j);
        this.connectOperators(ts, fil);
        return fil;
    }

    private void connectOperators(Operator<?> parent, Operator<?> child) {
        parent.getChildOperators().add(child);
        child.getParentOperators().add(parent);
    }

    @Test
    public void checkPersistJoinCondDesc() throws Exception {
        JoinCondDesc jcd = new JoinCondDesc(1, 2, 3);
        JoinCondDesc jcd2 = this.persistenceLoop(jcd, JoinCondDesc.class);
        Assert.assertEquals((Object)jcd, (Object)jcd2);
    }

    @Test
    public void checkPersistingSigWorks() throws Exception {
        OpSignature sig = OpSignature.of(this.getTsOp(3));
        OpSignature sig2 = this.persistenceLoop(sig, OpSignature.class);
        Assert.assertEquals((Object)sig, (Object)sig2);
    }

    @Test
    public void checkPersistingTreeSigWorks() throws Exception {
        OpTreeSignature sig = this.signatureFactory.getSignature(this.getFilTsOp(3, 4));
        OpTreeSignature sig2 = this.persistenceLoop(sig, OpTreeSignature.class);
        Assert.assertEquals((Object)sig, (Object)sig2);
    }

    @Test
    public void checkCanStoreAsGraph() throws Exception {
        Operator<TableScanDesc> ts = this.getTsOp(0);
        Operator<? extends OperatorDesc> fil1 = this.getFilterOp(1);
        Operator<? extends OperatorDesc> fil2 = this.getFilterOp(2);
        Operator<? extends OperatorDesc> fil3 = this.getFilterOp(3);
        this.connectOperators(ts, fil1);
        this.connectOperators(ts, fil2);
        this.connectOperators(fil1, fil3);
        this.connectOperators(fil2, fil3);
        OpTreeSignature sig = this.signatureFactory.getSignature(fil3);
        OpTreeSignature sig2 = this.persistenceLoop(sig, OpTreeSignature.class);
        Assert.assertEquals((Object)sig, (Object)sig2);
        OpTreeSignature o0 = (OpTreeSignature)((OpTreeSignature)sig.getParentSig().get(0)).getParentSig().get(0);
        OpTreeSignature o1 = (OpTreeSignature)((OpTreeSignature)sig.getParentSig().get(1)).getParentSig().get(0);
        Assert.assertTrue((String)"these have to be the same instance", (o0 == o1 ? 1 : 0) != 0);
        OpTreeSignature p0 = (OpTreeSignature)((OpTreeSignature)sig2.getParentSig().get(0)).getParentSig().get(0);
        OpTreeSignature p1 = (OpTreeSignature)((OpTreeSignature)sig2.getParentSig().get(1)).getParentSig().get(0);
        Assert.assertTrue((String)"these have to be the same instance", (p0 == p1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)p0, (Object)p1);
    }

    @Test
    public void checkCanStore() throws Exception {
        ArrayList<PersistedRuntimeStats> rsm = new ArrayList<PersistedRuntimeStats>();
        rsm.add(new PersistedRuntimeStats(this.signatureFactory.getSignature(this.getTsOp(0)), new OperatorStats("ts0"), null));
        rsm.add(new PersistedRuntimeStats(this.signatureFactory.getSignature(this.getTsOp(1)), new OperatorStats("ts1"), null));
        List rsm2 = this.persistenceLoop(rsm, List.class);
        OpTreeSignature k1 = ((PersistedRuntimeStats)rsm.iterator().next()).sig;
        OpTreeSignature k2 = ((PersistedRuntimeStats)rsm2.iterator().next()).sig;
        Assert.assertEquals((Object)k1, (Object)k2);
        Assert.assertEquals(rsm, (Object)rsm2);
    }

    private <T> T persistenceLoop(T sig, Class<T> clazz) throws IOException {
        RuntimeStatsPersister sp = RuntimeStatsPersister.INSTANCE;
        String stored = sp.encode(sig);
        System.out.println(stored);
        Object sig2 = sp.decode(stored, clazz);
        return (T)sig2;
    }

    private Operator<? extends OperatorDesc> getFilterOp(int constVal) {
        ExprNodeConstantDesc pred = new ExprNodeConstantDesc((Object)constVal);
        FilterDesc fd = new FilterDesc((ExprNodeDesc)pred, true);
        Operator op = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)fd);
        return op;
    }

    private Operator<TableScanDesc> getTsOp(int i) {
        Table tblMetadata = new Table("db", "table");
        TableScanDesc desc = new TableScanDesc("alias", tblMetadata);
        ArrayList as = Lists.newArrayList((Object[])new ExprNodeDesc[]{new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)i), new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "c1", "aa", false)});
        ExprNodeGenericFuncDesc f1 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, this.udf, (List)as);
        desc.setFilterExpr(f1);
        Operator ts = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)desc);
        return ts;
    }
}

