/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePointLookupOptimizerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHivePointLookupOptimizerRule {
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    RelOptHiveTable tableMock;
    @Mock
    Table hiveTableMDMock;
    private HepPlanner planner;
    private RelBuilder builder;

    @Before
    public void before() {
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        programBuilder.addRuleInstance((RelOptRule)new HivePointLookupOptimizerRule.FilterCondition(2));
        this.planner = new HepPlanner(programBuilder.build());
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RelOptCluster optCluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)rexBuilder);
        RelDataType rowTypeMock = typeFactory.createStructType(MyRecord.class);
        ((RelOptHiveTable)Mockito.doReturn((Object)rowTypeMock).when((Object)this.tableMock)).getRowType();
        ((RelOptSchema)Mockito.doReturn((Object)this.tableMock).when((Object)this.schemaMock)).getTableForMember((List)ArgumentMatchers.any());
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)this.hiveTableMDMock).when((Object)this.tableMock)).getHiveTableMD();
        this.builder = HiveRelFactories.HIVE_BUILDER.create(optCluster, this.schemaMock);
    }

    public RexNode or(RexNode ... args) {
        return this.builder.call((SqlOperator)SqlStdOperatorTable.OR, args);
    }

    public RexNode and(RexNode ... args) {
        return this.builder.call((SqlOperator)SqlStdOperatorTable.AND, args);
    }

    public RexNode eq(String field, int value) {
        return this.builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.builder.field(field), this.builder.literal((Object)value)});
    }

    @Test
    public void testSimpleCase() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.and(this.or(this.eq("f1", 1), this.eq("f1", 2)), this.or(this.eq("f2", 3), this.eq("f2", 4)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"AND(IN($0, 1, 2), IN($1, 3, 4))", (Object)condition.toString());
    }

    @Test
    public void testSimpleStructCase() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.or(this.and(this.eq("f1", 1), this.eq("f2", 1)), this.and(this.eq("f1", 2), this.eq("f2", 2)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"IN(ROW($0, $1), ROW(1, 1), ROW(2, 2))", (Object)condition.toString());
    }

    @Test
    public void testObscuredSimple() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.or(this.eq("f2", 99), this.eq("f1", 1), this.eq("f1", 2))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"OR(IN($0, 1, 2), =($1, 99))", (Object)condition.toString());
    }

    @Test
    public void testRecursionIsNotObstructed() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.and(this.or(this.eq("f1", 1), this.eq("f1", 2)), this.or(this.and(this.or(this.eq("f2", 1), this.eq("f2", 2)), this.or(this.eq("f3", 1), this.eq("f3", 2))), this.and(this.or(this.eq("f2", 3), this.eq("f2", 4)), this.or(this.eq("f3", 3), this.eq("f3", 4)))))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"AND(IN($0, 1, 2), OR(AND(IN($1, 1, 2), IN($2, 1, 2)), AND(IN($1, 3, 4), IN($2, 3, 4))))", (Object)condition.toString());
    }

    private static class MyRecord {
        public int f1;
        public int f2;
        public int f3;

        private MyRecord() {
        }
    }
}

