/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.SharedWorkOptimizer;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestSharedWorkOptimizer {
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> unset = EnumSet.of(ReduceSinkDesc.ReducerTraits.UNSET);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> fixed = EnumSet.of(ReduceSinkDesc.ReducerTraits.FIXED);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> uniform = EnumSet.of(ReduceSinkDesc.ReducerTraits.UNIFORM);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> autoparallel = EnumSet.of(ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> uniformAutoparallel = EnumSet.of(ReduceSinkDesc.ReducerTraits.UNIFORM, ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
    CompilationOpContext cCtx = new CompilationOpContext();

    private void ensureDeduplicate(EnumSet<ReduceSinkDesc.ReducerTraits> traits1, int numReducers1, EnumSet<ReduceSinkDesc.ReducerTraits> traits2, int numReducers2, EnumSet<ReduceSinkDesc.ReducerTraits> expectedTraits, int expectedNumReducers) {
        ReduceSinkDesc rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        ReduceSinkDesc rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        boolean deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf1, (ReduceSinkDesc)rsConf2);
        Assert.assertTrue((boolean)deduplicated);
        Assert.assertEquals(expectedTraits, (Object)rsConf1.getReducerTraits());
        Assert.assertEquals((long)expectedNumReducers, (long)rsConf1.getNumReducers());
        rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf2, (ReduceSinkDesc)rsConf1);
        Assert.assertTrue((boolean)deduplicated);
        Assert.assertEquals(expectedTraits, (Object)rsConf2.getReducerTraits());
        Assert.assertEquals((long)expectedNumReducers, (long)rsConf2.getNumReducers());
    }

    private void ensureNotDeduplicate(EnumSet<ReduceSinkDesc.ReducerTraits> traits1, int numReducers1, EnumSet<ReduceSinkDesc.ReducerTraits> traits2, int numReducers2) {
        ReduceSinkDesc rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        ReduceSinkDesc rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        boolean deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf1, (ReduceSinkDesc)rsConf2);
        Assert.assertFalse((boolean)deduplicated);
        rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf1, (ReduceSinkDesc)rsConf2);
        Assert.assertFalse((boolean)deduplicated);
    }

    @Test
    public void testDeduplicate() {
        this.ensureDeduplicate(unset, 0, unset, 0, unset, 0);
        this.ensureDeduplicate(unset, 0, fixed, 1, fixed, 1);
        this.ensureDeduplicate(unset, 0, uniform, 1, uniform, 1);
        this.ensureDeduplicate(unset, 0, autoparallel, 1, autoparallel, 1);
        this.ensureDeduplicate(unset, 0, uniformAutoparallel, 1, uniformAutoparallel, 1);
        this.ensureDeduplicate(fixed, 1, fixed, 1, fixed, 1);
        this.ensureNotDeduplicate(fixed, 1, fixed, 2);
        this.ensureDeduplicate(fixed, 1, uniform, 1, fixed, 1);
        this.ensureDeduplicate(fixed, 1, autoparallel, 2, fixed, 1);
        this.ensureDeduplicate(fixed, 1, uniformAutoparallel, 2, fixed, 1);
        this.ensureDeduplicate(uniform, 1, uniform, 2, uniform, 2);
        this.ensureNotDeduplicate(uniform, 1, autoparallel, 2);
        this.ensureDeduplicate(uniform, 1, uniformAutoparallel, 2, uniform, 2);
        this.ensureDeduplicate(autoparallel, 1, uniformAutoparallel, 2, autoparallel, 2);
        this.ensureDeduplicate(uniformAutoparallel, 1, uniformAutoparallel, 2, uniformAutoparallel, 2);
    }

    @Test
    public void testTSCmp() {
        ArrayList li = Lists.newArrayList((Object[])new TableScanOperator[]{this.addFilter(this.getTsOp(), 1), this.getTsOp()});
        li.sort(new SharedWorkOptimizer.TSComparator());
        Assert.assertNull((Object)((TableScanDesc)((TableScanOperator)li.get(0)).getConf()).getFilterExpr());
    }

    @Test
    public void testTSCmpOrdersById() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        ArrayList li1 = Lists.newArrayList((Object[])new TableScanOperator[]{ts1, ts2});
        ArrayList li2 = Lists.newArrayList((Object[])new TableScanOperator[]{ts2, ts1});
        li1.sort(new SharedWorkOptimizer.TSComparator());
        li2.sort(new SharedWorkOptimizer.TSComparator());
        Assert.assertTrue((li1.get(0) == li2.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void testTSCmpOrdersByDataSizeDesc() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        TableScanOperator ts3 = this.getTsOp();
        ts1.setStatistics(new Statistics(100L, 100L, 1L, 1L));
        ts2.setStatistics(new Statistics(1000L, 1000L, 1L, 1L));
        ts3.setStatistics(new Statistics(10L, 10L, 1L, 1L));
        ArrayList li1 = Lists.newArrayList((Object[])new TableScanOperator[]{ts1, ts3, ts2});
        li1.sort(new SharedWorkOptimizer.TSComparator());
        Assert.assertTrue((((TableScanOperator)li1.get(0)).getStatistics().getDataSize() == 1000L ? 1 : 0) != 0);
        Assert.assertTrue((((TableScanOperator)li1.get(1)).getStatistics().getDataSize() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((((TableScanOperator)li1.get(2)).getStatistics().getDataSize() == 10L ? 1 : 0) != 0);
    }

    private TableScanOperator getTsOp() {
        Table tblMetadata = new Table("db", "table");
        TableScanDesc desc = new TableScanDesc("alias_" + this.cCtx.nextOperatorId(), tblMetadata);
        Operator ts = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)desc);
        return (TableScanOperator)ts;
    }

    private TableScanOperator addFilter(TableScanOperator ts, int i) {
        TableScanDesc desc = (TableScanDesc)ts.getConf();
        ArrayList as = Lists.newArrayList((Object[])new ExprNodeDesc[]{new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)i), new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "c1", "aa", false)});
        GenericUDFConcat udf = new GenericUDFConcat();
        ExprNodeGenericFuncDesc f1 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)udf, (List)as);
        desc.setFilterExpr(f1);
        return ts;
    }
}

