/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestGetPartitions;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientGetPartitionsTempTable
extends TestGetPartitions {
    private HiveConf conf;
    private static final String USER_NAME = "user0";
    private static final List<String> GROUPS = Lists.newArrayList((Object[])new String[]{"group0", "group1"});
    private static final String PART_PRIV = "PARTITION_LEVEL_PRIVILEGE";

    public TestSessionHiveMetastoreClientGetPartitionsTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        super.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.getClient().dropDatabase("testpartdb", true, true, true);
    }

    private void initHiveConf() throws HiveException {
        this.conf = Hive.get().getConf();
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols, boolean setPartitionLevelPrivileges) throws TException {
        TableBuilder builder = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).setTemporary(true);
        partCols.forEach(col -> builder.addPartCol(col, "string"));
        Table table = builder.build((Configuration)this.conf);
        if (setPartitionLevelPrivileges) {
            table.putToParameters(PART_PRIV, "true");
        }
        client.createTable(table);
        return table;
    }

    protected void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder builder = new PartitionBuilder().inTable(table);
        values.forEach(arg_0 -> ((PartitionBuilder)builder).addValue(arg_0));
        Partition partition = builder.build((Configuration)this.conf);
        if (table.getParameters().containsKey(PART_PRIV) && ((String)table.getParameters().get(PART_PRIV)).equals("true")) {
            PrincipalPrivilegeSet privileges = new PrincipalPrivilegeSet();
            HashMap userPrivileges = new HashMap();
            userPrivileges.put(USER_NAME, new ArrayList());
            privileges.setUserPrivileges(userPrivileges);
            HashMap groupPrivileges = new HashMap();
            GROUPS.forEach(g -> {
                List cfr_ignored_0 = groupPrivileges.put(g, new ArrayList());
            });
            privileges.setGroupPrivileges(groupPrivileges);
            partition.setPrivileges(privileges);
        }
        client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionsByNamesEmptyParts() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        this.getClient().getPartitionsByNames("testpartdb", "testparttable", (List)Lists.newArrayList((Object[])new String[]{"", ""}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionsByNamesNullDbName() throws Exception {
        super.testGetPartitionsByNamesNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionsByNamesNullTblName() throws Exception {
        super.testGetPartitionsByNamesNullTblName();
    }

    @Test
    public void testGetPartitionWithAuthInfo() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.getClient());
        Partition partition = this.getClient().getPartitionWithAuthInfo("testpartdb", "testparttable", (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), USER_NAME, GROUPS);
        Assert.assertNotNull((Object)partition);
        this.assertAuthInfoReturned(USER_NAME, GROUPS, partition);
    }

    @Test
    public void testGetPartitionWithAuthInfoEmptyUserGroup() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.getClient());
        Partition partition = this.getClient().getPartitionWithAuthInfo("testpartdb", "testparttable", (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "", (List)Lists.newArrayList());
        Assert.assertNotNull((Object)partition);
        this.assertAuthInfoReturned(USER_NAME, GROUPS, partition);
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionWithAuthInfoNullDbName() throws Exception {
        super.testGetPartitionWithAuthInfoNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionWithAuthInfoNullTblName() throws Exception {
        super.testGetPartitionWithAuthInfoNullTblName();
    }

    private void assertAuthInfoReturned(String userName, List<String> groups, Partition partition) {
        PrincipalPrivilegeSet privileges = partition.getPrivileges();
        Assert.assertNotNull((Object)privileges);
        TestCase.assertTrue((boolean)privileges.getUserPrivileges().containsKey(userName));
        for (String group : groups) {
            TestCase.assertTrue((boolean)privileges.getGroupPrivileges().containsKey(group));
        }
    }
}

