/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestDropPartitions;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientDropPartitionsTempTable
extends TestDropPartitions {
    private HiveConf conf;

    public TestSessionHiveMetastoreClientDropPartitionsTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.getClient().dropDatabase("test_drop_part_db", true, true, true);
        this.getMetaStore().cleanWarehouseDirs();
        new DatabaseBuilder().setName("test_drop_part_db").create(this.getClient(), (Configuration)this.conf);
        this.createTable("test_drop_part_table", TestSessionHiveMetastoreClientDropPartitionsTempTable.getYearAndMonthPartCols(), null);
        this.createPartitions();
    }

    private void initHiveConf() throws HiveException {
        this.conf = Hive.get().getConf();
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTable(String tableName, List<FieldSchema> partCols, Map<String, String> tableParams) throws Exception {
        TableBuilder builder = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName("test_drop_part_db").setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).setPartCols(partCols).setLocation(this.getMetaStore().getWarehouseRoot() + "/" + tableName)).setTemporary(true);
        if (tableParams != null) {
            builder.setTableParams(tableParams);
        }
        return builder.create(this.getClient(), (Configuration)this.conf);
    }

    protected Partition createPartition(List<String> values, List<FieldSchema> partCols) throws Exception {
        ((PartitionBuilder)new PartitionBuilder().setDbName("test_drop_part_db").setTableName("test_drop_part_table").setValues(values).setCols(partCols)).addToTable(this.getClient(), (Configuration)this.conf);
        Partition partition = this.getClient().getPartition("test_drop_part_db", "test_drop_part_table", values);
        return partition;
    }

    protected Partition createPartition(String tableName, String location, List<String> values, List<FieldSchema> partCols, Map<String, String> partParams) throws Exception {
        ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("test_drop_part_db").setTableName(tableName).setValues(values).setCols(partCols)).setLocation(location)).setPartParams(partParams).addToTable(this.getClient(), (Configuration)this.conf);
        Partition partition = this.getClient().getPartition("test_drop_part_db", tableName, values);
        return partition;
    }

    protected void checkPartitionsAfterDelete(String tableName, List<Partition> droppedPartitions, List<Partition> existingPartitions, boolean deleteData, boolean purge) throws Exception {
        Path partitionPath;
        List partitions = this.getClient().listPartitions("test_drop_part_db", tableName, (short)-1);
        Assert.assertEquals((String)("The table " + tableName + " has " + partitions.size() + " partitions, but it should have " + existingPartitions.size()), (long)existingPartitions.size(), (long)partitions.size());
        for (Partition droppedPartition : droppedPartitions) {
            Assert.assertFalse((boolean)partitions.contains(droppedPartition));
            partitionPath = new Path(droppedPartition.getSd().getLocation());
            if (deleteData) {
                Assert.assertFalse((String)("The location '" + partitionPath.toString() + "' should not exist."), (boolean)this.getMetaStore().isPathExists(partitionPath));
                continue;
            }
            Assert.assertTrue((String)("The location '" + partitionPath.toString() + "' should exist."), (boolean)this.getMetaStore().isPathExists(partitionPath));
        }
        for (Partition existingPartition : existingPartitions) {
            Assert.assertTrue((boolean)partitions.contains(existingPartition));
            partitionPath = new Path(existingPartition.getSd().getLocation());
            Assert.assertTrue((String)("The location '" + partitionPath.toString() + "' should exist."), (boolean)this.getMetaStore().isPathExists(partitionPath));
        }
    }
}

