/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestAppendPartitions;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientAppendPartitionTempTable
extends TestAppendPartitions {
    private HiveConf conf;

    public TestSessionHiveMetastoreClientAppendPartitionTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.cleanUpDatabase();
        this.createTables();
    }

    private void initHiveConf() throws HiveException {
        this.conf = Hive.get().getConf();
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTable(String tableName, List<FieldSchema> partCols, Map<String, String> tableParams, String tableType, String location) throws Exception {
        TableBuilder builder = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName("test_append_part_db").setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).setPartCols(partCols).setType(tableType).setLocation(location)).setTemporary(true);
        if (tableParams != null) {
            builder.setTableParams(tableParams);
        }
        builder.create(this.getClient(), (Configuration)this.conf);
        return this.getClient().getTable("test_append_part_db", tableName);
    }

    protected void verifyPartition(Partition partition, Table table, List<String> expectedPartValues, String partitionName) throws Exception {
        Assert.assertEquals((Object)table.getTableName(), (Object)partition.getTableName());
        Assert.assertEquals((Object)table.getDbName(), (Object)partition.getDbName());
        Assert.assertEquals(expectedPartValues, (Object)partition.getValues());
        Assert.assertNotEquals((long)0L, (long)partition.getCreateTime());
        Assert.assertEquals((long)0L, (long)partition.getParameters().size());
        StorageDescriptor partitionSD = partition.getSd();
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/" + partitionName), (Object)partitionSD.getLocation());
        Assert.assertTrue((boolean)this.getMetaStore().isPathExists(new Path(partitionSD.getLocation())));
    }
}

