/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestAlterPartitions;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientAlterPartitionsTempTable
extends TestAlterPartitions {
    private HiveConf conf;
    private static final String PART_PRIV = "PARTITION_LEVEL_PRIVILEGE";

    public TestSessionHiveMetastoreClientAlterPartitionsTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.cleanDB();
        this.createDB("testpartdb");
    }

    private void initHiveConf() throws HiveException {
        this.conf = Hive.get().getConf();
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols, boolean setPartitionLevelPrivilages) throws Exception {
        TableBuilder builder = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).setTemporary(true);
        partCols.forEach(col -> builder.addPartCol(col, "string"));
        Table table = builder.build(this.getMetaStore().getConf());
        if (setPartitionLevelPrivilages) {
            table.putToParameters(PART_PRIV, "true");
        }
        client.createTable(table);
        return table;
    }

    protected void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder builder = new PartitionBuilder().inTable(table);
        values.forEach(arg_0 -> ((PartitionBuilder)builder).addValue(arg_0));
        Partition partition = builder.build((Configuration)this.conf);
        this.getClient().add_partition(partition);
    }

    protected void addPartitions(IMetaStoreClient client, Table table, List<String> values) throws Exception {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (int i = 0; i < values.size(); ++i) {
            partitions.add(((PartitionBuilder)new PartitionBuilder().inTable(table).addValue(values.get(i)).setLocation(MetaStoreTestUtils.getTestWarehouseDir((String)(values.get(i) + i)))).build((Configuration)this.conf));
        }
        client.add_partitions(partitions);
    }

    protected void assertPartitionUnchanged(Partition partition, List<String> testValues, List<String> partCols) throws Exception {
        Assert.assertFalse((boolean)partition.getParameters().containsKey("hmsTestParam001"));
        ArrayList<String> expectedKVPairs = new ArrayList<String>();
        for (int i = 0; i < partCols.size(); ++i) {
            expectedKVPairs.add(partCols.get(i) + "=" + testValues.get(i));
        }
        Table table = this.getClient().getTable(partition.getDbName(), partition.getTableName());
        String partPath = String.join((CharSequence)"/", expectedKVPairs);
        Assert.assertEquals((Object)partition.getSd().getLocation(), (Object)(table.getSd().getLocation() + "/" + partPath));
        Assert.assertEquals((long)2L, (long)partition.getSd().getCols().size());
    }

    protected void assertPartitionChanged(Partition partition, List<String> testValues, List<String> partCols) throws Exception {
        Assert.assertEquals((Object)"testValue001", partition.getParameters().get("hmsTestParam001"));
        ArrayList<String> expectedKVPairs = new ArrayList<String>();
        for (int i = 0; i < partCols.size(); ++i) {
            expectedKVPairs.add(partCols.get(i) + "=" + testValues.get(i));
        }
        Table table = this.getClient().getTable(partition.getDbName(), partition.getTableName());
        String partPath = String.join((CharSequence)"/", expectedKVPairs);
        Assert.assertEquals((Object)partition.getSd().getLocation(), (Object)(table.getSd().getLocation() + "/" + partPath + "/hh=01"));
        Assert.assertEquals((long)123456789L, (long)partition.getCreateTime());
        Assert.assertEquals((long)123456789L, (long)partition.getLastAccessTime());
        Assert.assertEquals((long)3L, (long)partition.getSd().getCols().size());
    }

    @Test(expected=InvalidOperationException.class)
    public void testRenamePartitionNullNewPart() throws Exception {
        super.testRenamePartitionNullNewPart();
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsNullPartition() throws Exception {
        super.testAlterPartitionsNullPartition();
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxNullPartition() throws Exception {
        super.testAlterPartitionsWithEnvironmentCtxNullPartition();
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsNullPartitions() throws Exception {
        super.testAlterPartitionsNullPartitions();
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterPartitionsWithEnvironmentCtxNullPartitions() throws Exception {
        super.testAlterPartitionsWithEnvironmentCtxNullPartitions();
    }

    @Test
    public void testAlterPartitionsCheckRollbackNullPartition() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        List oldParts = this.getClient().listPartitions("testpartdb", "testparttable", (short)-1);
        this.assertPartitionRollback(oldParts, Lists.newArrayList((Object[])new Partition[]{(Partition)oldParts.get(0), null, (Partition)oldParts.get(1)}));
    }

    @Test
    public void testAlterPartitionsCheckRollbackNullPartitions() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        this.assertPartitionRollback(this.getClient().listPartitions("testpartdb", "testparttable", (short)-1), Lists.newArrayList((Object[])new Partition[]{null, null}));
    }

    @Test
    public void testAlterPartitionsCheckRollbackPartValsNull() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        List oldParts = this.getClient().listPartitions("testpartdb", "testparttable", (short)-1);
        Partition partition = new Partition((Partition)oldParts.get(0));
        partition.setValues(null);
        this.assertPartitionRollback(oldParts, Lists.newArrayList((Object[])new Partition[]{partition}));
    }

    @Test
    public void testAlterPartitionsCheckRollbackUnknownPartition() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        Table table = this.getClient().getTable("testpartdb", "testparttable");
        Partition newPart1 = new PartitionBuilder().inTable(table).addValue("1111").addValue("1111").addValue("11").build((Configuration)this.conf);
        List oldPartitions = this.getClient().listPartitions("testpartdb", "testparttable", (short)-1);
        Partition newPart2 = new Partition((Partition)oldPartitions.get(0));
        TestSessionHiveMetastoreClientAlterPartitionsTempTable.makeTestChangesOnPartition((Partition)newPart2);
        this.assertPartitionRollback(oldPartitions, Lists.newArrayList((Object[])new Partition[]{newPart2, newPart1}));
    }

    @Test
    public void testAlterPartitionsCheckRollbackChangeDBName() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        List oldPartitions = this.getClient().listPartitions("testpartdb", "testparttable", (short)-1);
        Partition newPart1 = new Partition((Partition)oldPartitions.get(3));
        newPart1.setDbName("testpartdb_changed");
        this.assertPartitionRollback(oldPartitions, Lists.newArrayList((Object[])new Partition[]{(Partition)oldPartitions.get(0), (Partition)oldPartitions.get(1), newPart1, (Partition)oldPartitions.get(2)}));
    }

    @Test
    public void testAlterPartitionsCheckRollbackChangeTableName() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        List oldPartitions = this.getClient().listPartitions("testpartdb", "testparttable", (short)-1);
        Partition newPart1 = new Partition((Partition)oldPartitions.get(3));
        newPart1.setTableName("testparttable_changed");
        this.assertPartitionRollback(oldPartitions, Lists.newArrayList((Object[])new Partition[]{(Partition)oldPartitions.get(0), (Partition)oldPartitions.get(1), newPart1, (Partition)oldPartitions.get(2)}));
    }

    private void assertPartitionRollback(List<Partition> oldParts, List<Partition> alterParts) throws TException {
        try {
            this.getClient().alter_partitions("testpartdb", "testparttable", alterParts);
        }
        catch (InvalidOperationException | MetaException e) {
            Assert.assertEquals(oldParts, (Object)this.getClient().listPartitions("testpartdb", "testparttable", (short)-1));
            return;
        }
        Assert.fail((String)"Exception should have been thrown.");
    }
}

