/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestAddPartitionsFromPartSpec;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientAddPartitionsFromSpecTempTable
extends TestAddPartitionsFromPartSpec {
    private HiveConf conf;

    public TestSessionHiveMetastoreClientAddPartitionsFromSpecTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.getClient().dropDatabase("test_partition_db", true, true, true);
        this.getMetaStore().cleanWarehouseDirs();
        new DatabaseBuilder().setName("test_partition_db").create(this.getClient(), (Configuration)this.conf);
    }

    private void initHiveConf() throws HiveException {
        this.conf = Hive.get().getConf();
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTable(String dbName, String tableName, List<FieldSchema> partCols, String location) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).addTableParam("partTestTableParamKey", "partTestTableParamValue").setPartCols(partCols).addStorageDescriptorParam("partTestSDParamKey", "partTestSDParamValue")).setSerdeName(tableName)).setStoredAsSubDirectories(false)).addSerdeParam("partTestSerdeParamKey", "partTestSerdeParamValue")).setLocation(location)).setTemporary(true).create(this.getClient(), (Configuration)this.conf);
        return this.getClient().getTable(dbName, tableName);
    }

    protected void verifyPartition(Table table, String name, List<String> values, int index) throws Exception {
        Partition part = this.getClient().getPartition(table.getDbName(), table.getTableName(), name);
        Assert.assertNotNull((String)"The partition should not be null.", (Object)part);
        Assert.assertEquals((String)"The table name in the partition is not correct.", (Object)table.getTableName(), (Object)part.getTableName());
        List partValues = part.getValues();
        Assert.assertEquals((long)values.size(), (long)partValues.size());
        Assert.assertTrue((String)"The partition has wrong values.", (boolean)partValues.containsAll(values));
        Assert.assertEquals((String)"The DB name in the partition is not correct.", (Object)table.getDbName(), (Object)part.getDbName());
        Assert.assertEquals((String)"The last access time is not correct.", (long)123456L, (long)part.getLastAccessTime());
        Assert.assertEquals((String)"The partition's parameter map should contain the partparamkey - partparamvalue pair.", (Object)("partparamvalue" + index), part.getParameters().get("partparamkey" + index));
        StorageDescriptor sd = part.getSd();
        Assert.assertNotNull((String)"The partition's storage descriptor must not be null.", (Object)sd);
        Assert.assertEquals((String)"The input format is not correct.", (Object)("TestInputFormat" + index), (Object)sd.getInputFormat());
        Assert.assertEquals((String)"The output format is not correct.", (Object)("TestOutputFormat" + index), (Object)sd.getOutputFormat());
        Assert.assertEquals((String)"The serdeInfo name is not correct.", (Object)("partserde" + index), (Object)sd.getSerdeInfo().getName());
        Assert.assertEquals((String)"The parameter map of the partition's storage descriptor should contain the partsdkey - partsdvalue pair.", (Object)("partsdvalue" + index), sd.getParameters().get("partsdkey" + index));
        Assert.assertEquals((String)"The parameter's location is not correct.", (Object)(this.getMetaStore().getWarehouseRoot() + "/" + "test_partition_table" + "/" + name), (Object)sd.getLocation());
        Assert.assertTrue((String)"The parameter's location should exist on the file system.", (boolean)this.getMetaStore().isPathExists(new Path(sd.getLocation())));
        Assert.assertFalse((String)"The partition should not inherit the table parameters.", (boolean)part.getParameters().keySet().contains(table.getParameters().keySet()));
    }
}

