/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.Quotation;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class TestHiveUtils {
    @Test
    public void testUnparseIdentifierWithBackTicksWhenQuotationIsNone() {
        HiveConf conf = this.createConf(Quotation.NONE);
        String id = "any``id";
        String unparsed = HiveUtils.unparseIdentifier((String)id, (Configuration)conf);
        MatcherAssert.assertThat((Object)unparsed, (Matcher)Is.is((Object)"`any``id`"));
    }

    @Test
    public void testUnparseIdentifierWithBackTicksWhenQuotationIsBackTicks() {
        HiveConf conf = this.createConf(Quotation.BACKTICKS);
        String id = "any``id";
        String unparsed = HiveUtils.unparseIdentifier((String)id, (Configuration)conf);
        MatcherAssert.assertThat((Object)unparsed, (Matcher)Is.is((Object)"`any````id`"));
    }

    @Test
    public void testUnparseIdentifierWithBackTicksWhenQuotationIsStandard() {
        HiveConf conf = this.createConf(Quotation.STANDARD);
        String id = "any``id";
        String unparsed = HiveUtils.unparseIdentifier((String)id, (Configuration)conf);
        MatcherAssert.assertThat((Object)unparsed, (Matcher)Is.is((Object)"`any````id`"));
    }

    @Test
    public void testUnparseIdentifierWithDoubleQuotesWhenQuotationIsNone() {
        HiveConf conf = this.createConf(Quotation.NONE);
        String id = "any\"\"id";
        String unparsed = HiveUtils.unparseIdentifier((String)id, (Configuration)conf);
        MatcherAssert.assertThat((Object)unparsed, (Matcher)Is.is((Object)"`any\"\"id`"));
    }

    @Test
    public void testUnparseIdentifierWithDoubleQuotesWhenQuotationIsBackTicks() {
        HiveConf conf = this.createConf(Quotation.BACKTICKS);
        String id = "any\"\"id";
        String unparsed = HiveUtils.unparseIdentifier((String)id, (Configuration)conf);
        MatcherAssert.assertThat((Object)unparsed, (Matcher)Is.is((Object)"`any\"\"id`"));
    }

    @Test
    public void testUnparseIdentifierWithDoubleQuotesWhenQuotationIsStandard() {
        HiveConf conf = this.createConf(Quotation.STANDARD);
        String id = "any\"\"id";
        String unparsed = HiveUtils.unparseIdentifier((String)id, (Configuration)conf);
        MatcherAssert.assertThat((Object)unparsed, (Matcher)Is.is((Object)"`any\"\"id`"));
    }

    private HiveConf createConf(Quotation quotation) {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT, quotation.stringValue());
        return conf;
    }
}

