/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TestHiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.thrift.TException;
import org.junit.Before;
import org.junit.Test;

public class TestHiveMetaStoreClientApiArgumentsChecker {
    private Hive hive;
    private IMetaStoreClient msc;
    private FileSystem fs;
    static final String DB_NAME = "db";
    static final String TABLE_NAME = "table";
    private IMetaStoreClient client;
    private Table t;
    protected static final String USER_NAME = "user0";

    @Before
    public void setUp() throws Exception {
        this.client = new TestHiveMetaStoreClient((Configuration)new HiveConf(Hive.class));
        this.hive = Hive.get((IMetaStoreClient)this.client);
        this.hive.getConf().set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "15");
        this.hive.getConf().set(MetastoreConf.ConfVars.MSCK_PATH_VALIDATION.getVarname(), "throw");
        this.msc = new HiveMetaStoreClient((Configuration)this.hive.getConf());
        this.hive.getConf().setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)this.hive.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        this.hive.getConf().set("hive.txn.valid.txns", "1:");
        this.hive.getConf().set("hive.txn.valid.writeids", "table:1:");
        this.hive.getConf().setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.TestTxnManager");
        SessionState.start((HiveConf)this.hive.getConf());
        SessionState.get().initTxnMgr(this.hive.getConf());
        Context ctx = new Context((Configuration)this.hive.getConf());
        SessionState.get().getTxnMgr().openTxn(ctx, USER_NAME);
        this.t = new Table();
        org.apache.hadoop.hive.metastore.api.Table tTable = new org.apache.hadoop.hive.metastore.api.Table();
        tTable.setId(Long.MAX_VALUE);
        this.t.setTTable(tTable);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("transactional", "true");
        tTable.setParameters(parameters);
        tTable.setTableType(TableType.MANAGED_TABLE.toString());
        this.t.setTableName(TABLE_NAME);
        this.t.setDbName(DB_NAME);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema());
        this.t.setPartCols(partCols);
    }

    @Test
    public void testGetPartition() throws HiveException {
        this.hive.getPartition(this.t, DB_NAME, TABLE_NAME, null);
    }

    @Test
    public void testGetPartitions() throws HiveException {
        this.hive.getPartitions(this.t);
    }

    @Test
    public void testGetPartitionNames() throws HiveException {
        this.hive.getPartitionNames(DB_NAME, TABLE_NAME, null, (short)-1);
    }

    @Test
    public void testGetPartitionNames2() throws HiveException {
        this.hive.getPartitionNames(this.t, null, null, (short)-1);
    }

    @Test
    public void testGetPartitionsByNames1() throws HiveException {
        GetPartitionsByNamesRequest req = new GetPartitionsByNamesRequest();
        req.setDb_name(DB_NAME);
        req.setTbl_name(TABLE_NAME);
        this.hive.getPartitionsByNames(req, this.t);
    }

    @Test
    public void testGetPartitionsByNames2() throws HiveException {
        GetPartitionsByNamesRequest req = new GetPartitionsByNamesRequest();
        req.setDb_name(DB_NAME);
        req.setTbl_name(TABLE_NAME);
        this.hive.getPartitionsByNames(DB_NAME, TABLE_NAME, null, this.t);
    }

    @Test
    public void testGetPartitionsByNames3() throws HiveException {
        GetPartitionsByNamesRequest req = new GetPartitionsByNamesRequest();
        req.setDb_name(DB_NAME);
        req.setTbl_name(TABLE_NAME);
        this.hive.getPartitionsByNames(this.t, new ArrayList(), true);
    }

    @Test
    public void testGetPartitionsByExpr() throws HiveException, TException {
        ArrayList partitions = new ArrayList();
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        this.hive.getPartitionsByExpr(this.t, node, this.hive.getConf(), partitions);
    }
}

