/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlanStatus;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.StringAppender;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.hive.serde2.thrift.test.Complex;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHive {
    protected static Hive hm;
    protected static HiveConf hiveConf;
    private static final String SEPARATOR = "/";
    private static final char SEPARATOR_CHAR = '/';
    private static final String CUR_DIR = ".";
    private static final boolean WINDOWS;
    private static final Pattern hasDriveLetterSpecifier;

    @BeforeClass
    public static void setUp() throws Exception {
        hiveConf = new HiveConf(TestHive.class);
        hm = TestHive.setUpImpl(hiveConf);
    }

    private static Hive setUpImpl(HiveConf hiveConf) throws Exception {
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setFloat("fs.trash.checkpoint.interval", 30.0f);
        hiveConf.setFloat("fs.trash.interval", 30.0f);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, true);
        MetastoreConf.setBoolVar((org.apache.hadoop.conf.Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        SessionState.start((HiveConf)hiveConf);
        try {
            return Hive.get((HiveConf)hiveConf);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to initialize Hive Metastore using configuration: \n" + hiveConf);
            throw e;
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        try {
            hiveConf.setFloat("fs.trash.checkpoint.interval", 30.0f);
            hiveConf.setFloat("fs.trash.interval", 30.0f);
            Hive.closeCurrent();
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to close Hive Metastore using configruation: \n " + hiveConf);
            throw e;
        }
    }

    @Test
    public void testTable() throws Throwable {
        try {
            String tableName = "table_for_testtable";
            try {
                hm.dropTable("default", tableName);
            }
            catch (HiveException e1) {
                e1.printStackTrace();
                Assert.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            List fields = tbl.getCols();
            fields.add(new FieldSchema("col1", "int", "int -- first column"));
            fields.add(new FieldSchema("col2", "string", "string -- second column"));
            fields.add(new FieldSchema("col3", "double", "double -- thrift column"));
            tbl.setFields(fields);
            tbl.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
            tbl.setInputFormatClass(SequenceFileInputFormat.class);
            tbl.setProperty("comment", "this is a test table created as part junit tests");
            List bucketCols = tbl.getBucketCols();
            bucketCols.add("col1");
            try {
                tbl.setBucketCols(bucketCols);
            }
            catch (HiveException e) {
                e.printStackTrace();
                Assert.assertTrue((String)("Unable to set bucket column for table: " + tableName), (boolean)false);
            }
            ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
            partCols.add(new FieldSchema("ds", "string", "partition column, date but in string format as date type is not yet supported in QL"));
            tbl.setPartCols(partCols);
            tbl.setNumBuckets(512);
            tbl.setOwner("pchakka");
            tbl.setRetention(10);
            tbl.setSerdeParam("field.delim", "1");
            tbl.setSerdeParam("line.delim", "\n");
            tbl.setSerdeParam("mapkey.delim", "3");
            tbl.setSerdeParam("collection.delim", "2");
            tbl.setSerdeParam("field.delim", "1");
            tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            tbl.setStoredAsSubDirectories(false);
            tbl.setRewriteEnabled(false);
            this.setNullCreateTableGrants();
            try {
                hm.createTable(tbl);
            }
            catch (HiveException e) {
                e.printStackTrace();
                Assert.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            this.validateTable(tbl, tableName);
            try {
                hm.dropTable("default", tableName, true, false);
                Table ft2 = hm.getTable("default", tableName, false);
                Assert.assertNull((String)"Unable to drop table ", (Object)ft2);
            }
            catch (HiveException e) {
                Assert.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTable failed");
            throw e;
        }
    }

    private void setNullCreateTableGrants() {
        SessionState.get().setCreateTableGrants(null);
    }

    @Test
    public void testThriftTable() throws Throwable {
        String tableName = "table_for_test_thrifttable";
        try {
            try {
                hm.dropTable("default", tableName);
            }
            catch (HiveException e1) {
                System.err.println(StringUtils.stringifyException((Throwable)e1));
                Assert.assertTrue((String)"Unable to drop table", (boolean)false);
            }
            Table tbl = new Table("default", tableName);
            tbl.setInputFormatClass(SequenceFileInputFormat.class.getName());
            tbl.setOutputFormatClass(SequenceFileOutputFormat.class.getName());
            tbl.setSerializationLib(ThriftDeserializer.class.getName());
            tbl.setSerdeParam("serialization.class", Complex.class.getName());
            tbl.setSerdeParam("serialization.format", TBinaryProtocol.class.getName());
            tbl.setStoredAsSubDirectories(false);
            tbl.setRewriteEnabled(false);
            this.setNullCreateTableGrants();
            try {
                hm.createTable(tbl);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            this.validateTable(tbl, tableName);
            hm.dropTable("default", tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testThriftTable() failed");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaStoreApiTiming() throws Throwable {
        Logger logger = LogManager.getLogger((String)"hive.ql.metadata.Hive");
        Level oldLevel = logger.getLevel();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        loggerConfig.setLevel(Level.DEBUG);
        ctx.updateLoggers();
        StringAppender appender = StringAppender.createStringAppender("%m");
        appender.addToLogger(logger.getName(), Level.DEBUG);
        appender.start();
        try {
            hm.clearMetaCallTiming();
            hm.getAllDatabases();
            hm.dumpAndClearMetaCallTiming("test");
            String logStr = appender.getOutput();
            String expectedString = "getAllDatabases_()=";
            Assert.assertTrue((String)(logStr + " should contain <" + expectedString), (boolean)logStr.contains(expectedString));
            appender.reset();
            hm.dumpAndClearMetaCallTiming("test");
            logStr = appender.getOutput();
            Assert.assertFalse((String)(logStr + " should not contain <" + expectedString), (boolean)logStr.contains(expectedString));
        }
        finally {
            loggerConfig.setLevel(oldLevel);
            ctx.updateLoggers();
            appender.removeFromLogger(logger.getName());
        }
    }

    private void validateTable(Table tbl, String tableName) throws MetaException {
        Warehouse wh = new Warehouse((org.apache.hadoop.conf.Configuration)hiveConf);
        Table ft = null;
        try {
            tbl.getTTable().setPrivilegesIsSet(false);
            ft = hm.getTable("default", tableName);
            Assert.assertTrue((boolean)ft.getTTable().isSetId());
            ft.getTTable().unsetId();
            Assert.assertNotNull((String)"Unable to fetch table", (Object)ft);
            ft.checkValidity((org.apache.hadoop.conf.Configuration)hiveConf);
            Assert.assertEquals((String)("Table names didn't match for table: " + tableName), (Object)tbl.getTableName(), (Object)ft.getTableName());
            Assert.assertEquals((String)("Table owners didn't match for table: " + tableName), (Object)tbl.getOwner(), (Object)ft.getOwner());
            Assert.assertEquals((String)("Table retention didn't match for table: " + tableName), (long)tbl.getRetention(), (long)ft.getRetention());
            Assert.assertEquals((String)"Data location is not set correctly", (Object)wh.getDefaultTablePath(hm.getDatabase("default"), tableName).toString(), (Object)ft.getDataLocation().toString());
            tbl.setDataLocation(ft.getDataLocation());
            tbl.setCreateTime(ft.getTTable().getCreateTime());
            tbl.getParameters().put("transient_lastDdlTime", ft.getParameters().get("transient_lastDdlTime"));
            if (tbl.getTTable().isSetWriteId() != ft.getTTable().isSetWriteId()) {
                ft.getTTable().setWriteId(0L);
                tbl.getTTable().setWriteId(0L);
            }
            if (tbl.getTTable().isSetAccessType() != ft.getTTable().isSetAccessType()) {
                tbl.getTTable().setAccessType(ft.getTTable().getAccessType());
            }
            tbl.getTTable().unsetId();
            Assert.assertTrue((String)("Tables  doesn't match: " + tableName + " (" + ft.getTTable() + "; " + tbl.getTTable() + ")"), (boolean)ft.getTTable().equals(tbl.getTTable()));
            Assert.assertEquals((String)"SerializationLib is not set correctly", (Object)tbl.getSerializationLib(), (Object)ft.getSerializationLib());
            Assert.assertEquals((String)"Serde is not set correctly", (Object)tbl.getDeserializer().getClass().getName(), (Object)ft.getDeserializer().getClass().getName());
        }
        catch (HiveException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            Assert.assertTrue((String)("Unable to fetch table correctly: " + tableName), (boolean)false);
        }
    }

    private static Table createTestTable(String dbName, String tableName) throws HiveException {
        Table tbl = new Table(dbName, tableName);
        tbl.setInputFormatClass(SequenceFileInputFormat.class.getName());
        tbl.setOutputFormatClass(SequenceFileOutputFormat.class.getName());
        tbl.setSerializationLib(ThriftDeserializer.class.getName());
        tbl.setSerdeParam("serialization.class", Complex.class.getName());
        tbl.setSerdeParam("serialization.format", TBinaryProtocol.class.getName());
        return tbl;
    }

    @Test
    public void testHiveCloseCurrent() throws Throwable {
        Hive hive1 = Hive.get();
        Hive.closeCurrent();
        Hive hive2 = Hive.get();
        Hive.closeCurrent();
        Assert.assertTrue((hive1 != hive2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAndDropTables() throws Throwable {
        try {
            String dbName = "db_for_testgettables";
            String table1Name = "table1";
            hm.dropDatabase(dbName, true, true, true);
            Database db = new Database();
            db.setName(dbName);
            hm.createDatabase(db);
            ArrayList<String> ts = new ArrayList<String>(2);
            ts.add(table1Name);
            ts.add("table2");
            Table tbl1 = TestHive.createTestTable(dbName, (String)ts.get(0));
            hm.createTable(tbl1);
            Table tbl2 = TestHive.createTestTable(dbName, (String)ts.get(1));
            hm.createTable(tbl2);
            List fts = hm.getTablesForDb(dbName, ".*");
            Assert.assertEquals(ts, (Object)fts);
            Assert.assertEquals((long)2L, (long)fts.size());
            fts = hm.getTablesForDb(dbName, ".*1");
            Assert.assertEquals((long)1L, (long)fts.size());
            Assert.assertEquals(ts.get(0), fts.get(0));
            Table table1 = hm.getTable(dbName, table1Name);
            Assert.assertNotNull((Object)table1);
            Assert.assertEquals((Object)table1Name, (Object)table1.getTableName());
            FileSystem fs = table1.getPath().getFileSystem((org.apache.hadoop.conf.Configuration)hiveConf);
            Assert.assertTrue((boolean)fs.exists(table1.getPath()));
            hm.dropTable(dbName, table1Name);
            Assert.assertFalse((boolean)fs.exists(table1.getPath()));
            for (String tableName : hm.getAllTables(dbName)) {
                Table table = hm.getTable(dbName, tableName);
                hm.dropTable(dbName, tableName);
                Assert.assertFalse((boolean)fs.exists(table.getPath()));
            }
            hm.dropDatabase(dbName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testGetAndDropTables() failed");
            throw e;
        }
    }

    @Test
    public void testWmNamespaceHandling() throws Throwable {
        HiveConf hiveConf = new HiveConf(this.getClass());
        Hive hm = TestHive.setUpImpl(hiveConf);
        final AtomicReference hm2r = new AtomicReference();
        Thread pointlessThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HiveConf hiveConf2 = new HiveConf(this.getClass());
                hiveConf2.setVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE, "hm2");
                try {
                    hm2r.set(TestHive.setUpImpl(hiveConf2));
                }
                catch (Exception e) {
                    System.err.println(StringUtils.stringifyException((Throwable)e));
                }
            }
        });
        pointlessThread.start();
        pointlessThread.join();
        Hive hm2 = (Hive)hm2r.get();
        Assert.assertNotNull((Object)hm2);
        hm.createResourcePlan(new WMResourcePlan("hm"), null, false);
        Assert.assertEquals((long)1L, (long)hm.getAllResourcePlans().size());
        Assert.assertEquals((long)0L, (long)hm2.getAllResourcePlans().size());
        hm2.createResourcePlan(new WMResourcePlan("hm"), null, false);
        WMNullableResourcePlan changes = new WMNullableResourcePlan();
        changes.setStatus(WMResourcePlanStatus.ACTIVE);
        hm.alterResourcePlan("hm", changes, true, false, false);
        WMPool pool = new WMPool("hm", "foo");
        pool.setAllocFraction(0.0);
        pool.setQueryParallelism(1);
        try {
            hm.createWMPool(pool);
            Assert.fail((String)"Expected exception");
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
        pool.unsetNs();
        hm2.createWMPool(pool);
        changes.unsetNs();
        hm2.alterResourcePlan("hm", changes, true, false, false);
    }

    @Test
    public void testDropTableTrash() throws Throwable {
        if (!ShimLoader.getHadoopShims().supportTrashFeature()) {
            return;
        }
        try {
            String dbName = "db_for_testdroptable";
            hm.dropDatabase(dbName, true, true, true);
            Database db = new Database();
            db.setName(dbName);
            hm.createDatabase(db);
            ArrayList<String> ts = new ArrayList<String>(2);
            String tableBaseName = "droptable";
            ts.add(tableBaseName + "1");
            ts.add(tableBaseName + "2");
            Table tbl1 = TestHive.createTestTable(dbName, (String)ts.get(0));
            hm.createTable(tbl1);
            Table tbl2 = TestHive.createTestTable(dbName, (String)ts.get(1));
            hm.createTable(tbl2);
            Table table1 = hm.getTable(dbName, (String)ts.get(0));
            Assert.assertNotNull((Object)table1);
            Assert.assertEquals(ts.get(0), (Object)table1.getTableName());
            Path path1 = table1.getPath();
            FileSystem fs = path1.getFileSystem((org.apache.hadoop.conf.Configuration)hiveConf);
            Assert.assertTrue((boolean)fs.exists(path1));
            Path trashDir = ShimLoader.getHadoopShims().getCurrentTrashPath((org.apache.hadoop.conf.Configuration)hiveConf, fs);
            Assert.assertNotNull((String)"trash directory should not be null", (Object)trashDir);
            Path trash1 = TestHive.mergePaths(trashDir, path1);
            Path pathglob = trash1.suffix("*");
            Object[] before = fs.globStatus(pathglob);
            hm.dropTable(dbName, (String)ts.get(0));
            Assert.assertFalse((boolean)fs.exists(path1));
            Object[] after = fs.globStatus(pathglob);
            Assert.assertTrue((String)"trash dir before and after DROP TABLE noPURGE are not different", (before.length != after.length ? 1 : 0) != 0);
            Table table2 = hm.getTable(dbName, (String)ts.get(1));
            Assert.assertNotNull((Object)table2);
            Assert.assertEquals(ts.get(1), (Object)table2.getTableName());
            Path path2 = table2.getPath();
            Assert.assertTrue((boolean)fs.exists(path2));
            Path trash2 = TestHive.mergePaths(trashDir, path2);
            System.out.println("trashDir2 is " + trash2);
            pathglob = trash2.suffix("*");
            before = fs.globStatus(pathglob);
            hm.dropTable(dbName, (String)ts.get(1), true, true, true);
            Assert.assertFalse((boolean)fs.exists(path2));
            after = fs.globStatus(pathglob);
            Arrays.sort(before);
            Arrays.sort(after);
            Assert.assertEquals((String)"trash dir before and after DROP TABLE PURGE are different", (long)before.length, (long)after.length);
            Assert.assertTrue((String)"trash dir before and after DROP TABLE PURGE are different", (boolean)Arrays.equals(before, after));
            for (String tableName : hm.getAllTables(dbName)) {
                Table table = hm.getTable(dbName, tableName);
                hm.dropTable(dbName, tableName);
                Assert.assertFalse((boolean)fs.exists(table.getPath()));
            }
            hm.dropDatabase(dbName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testDropTableTrash() failed");
            throw e;
        }
    }

    private FileStatus[] getTrashContents() throws Exception {
        FileSystem fs = FileSystem.get((org.apache.hadoop.conf.Configuration)hiveConf);
        Path trashDir = ShimLoader.getHadoopShims().getCurrentTrashPath((org.apache.hadoop.conf.Configuration)hiveConf, fs);
        return fs.globStatus(trashDir.suffix("/*"));
    }

    private Table createPartitionedTable(String dbName, String tableName) throws Exception {
        try {
            hm.dropTable(dbName, tableName);
            hm.createTable(tableName, Arrays.asList("key", "value"), Arrays.asList("ds", "hr"), TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            return hm.getTable(dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unable to drop and create table " + StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName) + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    private void cleanUpTableQuietly(String dbName, String tableName) {
        try {
            hm.dropTable(dbName, tableName, true, true, true);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropPartitionsWithPurge() throws Exception {
        String dbName = "default";
        String tableName = "table_for_testDropPartitionsWithPurge";
        try {
            ImmutableMap partitionSpec = new ImmutableMap.Builder().put((Object)"ds", (Object)"20141216").put((Object)"hr", (Object)"12").build();
            int trashSizeBeforeDrop = this.getTrashContents().length;
            Table table = this.createPartitionedTable(dbName, tableName);
            hm.createPartition(table, (Map)partitionSpec);
            Partition partition = hm.getPartition(table, (Map)partitionSpec, false);
            Assert.assertNotNull((String)"Newly created partition shouldn't be null!", (Object)partition);
            hm.dropPartition(dbName, tableName, partition.getValues(), PartitionDropOptions.instance().deleteData(true).purgeData(true));
            int trashSizeAfterDropPurge = this.getTrashContents().length;
            Assert.assertEquals((String)"After dropPartitions(purge), trash should've remained unchanged!", (long)trashSizeBeforeDrop, (long)trashSizeAfterDropPurge);
            hm.createPartition(table, (Map)partitionSpec);
            partition = hm.getPartition(table, (Map)partitionSpec, false);
            Assert.assertNotNull((String)"Newly created partition shouldn't be null!", (Object)partition);
            hm.dropPartition(dbName, tableName, partition.getValues(), PartitionDropOptions.instance().deleteData(true).purgeData(false));
            int trashSizeWithoutPurge = this.getTrashContents().length;
            Assert.assertEquals((String)"After dropPartitions(noPurge), data should've gone to trash!", (long)trashSizeBeforeDrop, (long)trashSizeWithoutPurge);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            this.cleanUpTableQuietly(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoPurgeTablesAndPartitions() throws Throwable {
        String dbName = "default";
        String tableName = "table_for_testAutoPurgeTablesAndPartitions";
        try {
            Table table = this.createPartitionedTable(dbName, tableName);
            table.getParameters().put("skip.trash", "true");
            hm.alterTable(tableName, table, false, null, true);
            ImmutableMap partitionSpec = new ImmutableMap.Builder().put((Object)"ds", (Object)"20141216").put((Object)"hr", (Object)"12").build();
            int trashSizeBeforeDrop = this.getTrashContents().length;
            hm.createPartition(table, (Map)partitionSpec);
            Partition partition = hm.getPartition(table, (Map)partitionSpec, false);
            Assert.assertNotNull((String)"Newly created partition shouldn't be null!", (Object)partition);
            hm.dropPartition(dbName, tableName, partition.getValues(), PartitionDropOptions.instance().deleteData(true).purgeData(false));
            int trashSizeAfterDrop = this.getTrashContents().length;
            Assert.assertEquals((String)"After dropPartition(noPurge), data should still have skipped trash.", (long)trashSizeBeforeDrop, (long)trashSizeAfterDrop);
            trashSizeBeforeDrop = trashSizeAfterDrop;
            hm.dropTable(dbName, tableName);
            trashSizeAfterDrop = this.getTrashContents().length;
            Assert.assertEquals((String)"After dropTable(noPurge), data should still have skipped trash.", (long)trashSizeBeforeDrop, (long)trashSizeAfterDrop);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected failure: " + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            this.cleanUpTableQuietly(dbName, tableName);
        }
    }

    @Test
    public void testPartition() throws Throwable {
        try {
            String tableName = "table_for_testpartition";
            try {
                hm.dropTable("default", tableName);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to drop table: " + tableName), (boolean)false);
            }
            LinkedList<String> cols = new LinkedList<String>();
            cols.add("key");
            cols.add("value");
            LinkedList<String> part_cols = new LinkedList<String>();
            part_cols.add("ds");
            part_cols.add("hr");
            try {
                hm.createTable(tableName, cols, part_cols, TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create table: " + tableName), (boolean)false);
            }
            Table tbl = null;
            try {
                tbl = hm.getTable("default", tableName);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to fetch table: " + tableName), (boolean)false);
            }
            HashMap<String, String> part_spec = new HashMap<String, String>();
            part_spec.clear();
            part_spec.put("ds", "2008-04-08");
            part_spec.put("hr", "12");
            try {
                hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            part_spec.clear();
            part_spec.put("ds", "2008-04-08");
            part_spec.put("hr", "13");
            try {
                hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            part_spec.clear();
            part_spec.put("ds", "2008-04-08");
            part_spec.put("hr", "14");
            try {
                hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            part_spec.clear();
            part_spec.put("ds", "2008-04-07");
            part_spec.put("hr", "12");
            try {
                hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            part_spec.clear();
            part_spec.put("ds", "2008-04-07");
            part_spec.put("hr", "13");
            try {
                hm.createPartition(tbl, part_spec);
            }
            catch (HiveException e) {
                System.err.println(StringUtils.stringifyException((Throwable)e));
                Assert.assertTrue((String)("Unable to create parition for table: " + tableName), (boolean)false);
            }
            this.checkPartitionsConsistency(tbl);
            HashMap<String, String> partialSpec = new HashMap<String, String>();
            partialSpec.put("ds", "2008-04-07");
            Assert.assertEquals((long)2L, (long)hm.getPartitions(tbl, partialSpec).size());
            partialSpec = new HashMap();
            partialSpec.put("ds", "2008-04-08");
            Assert.assertEquals((long)3L, (long)hm.getPartitions(tbl, partialSpec).size());
            partialSpec = new HashMap();
            partialSpec.put("hr", "13");
            Assert.assertEquals((long)2L, (long)hm.getPartitions(tbl, partialSpec).size());
            partialSpec = new HashMap();
            Assert.assertEquals((long)5L, (long)hm.getPartitions(tbl, partialSpec).size());
            partialSpec = new HashMap();
            partialSpec.put("hr", "14");
            Assert.assertEquals((long)1L, (long)hm.getPartitions(tbl, partialSpec).size());
            hm.dropTable("default", tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testPartition() failed");
            throw e;
        }
    }

    private void checkPartitionsConsistency(Table tbl) throws Exception {
        Set allParts = hm.getAllPartitionsOf(tbl);
        List allParts2 = hm.getPartitions(tbl);
        Assert.assertEquals((String)"inconsistent results: getAllPartitionsOf/getPartitions", (Object)allParts, new HashSet(allParts2));
        Partition singlePart = (Partition)allParts2.get(0);
        Partition singlePart2 = hm.getPartition(tbl, (Map)singlePart.getSpec(), false);
        Assert.assertEquals((String)"inconsistent results: getPartition", (Object)singlePart, (Object)singlePart2);
        ArrayList exprs = Lists.newArrayList((Object[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)true), new ExprNodeConstantDesc((Object)true)});
        ExprNodeGenericFuncDesc trueExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), "and", (List)exprs);
        ArrayList allParts3 = new ArrayList();
        hm.getPartitionsByExpr(tbl, trueExpr, hm.getConf(), allParts3);
        Assert.assertEquals((String)"inconsistent results: getPartitionsByExpr", (Object)allParts2, allParts3);
    }

    @Test
    public void testHiveRefreshOnConfChange() throws Throwable {
        Hive prevHiveObj = Hive.get();
        prevHiveObj.getDatabaseCurrent();
        HiveConf newHconf = new HiveConf(hiveConf);
        Hive newHiveObj = Hive.get((HiveConf)newHconf);
        Assert.assertTrue((prevHiveObj == newHiveObj ? 1 : 0) != 0);
        newHiveObj = Hive.get((HiveConf)newHconf, (boolean)true);
        Assert.assertTrue((prevHiveObj != newHiveObj ? 1 : 0) != 0);
        prevHiveObj = Hive.get();
        prevHiveObj.getDatabaseCurrent();
        newHconf = new HiveConf(hiveConf);
        newHconf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, newHconf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES) + 1);
        newHiveObj = Hive.get((HiveConf)newHconf);
        Assert.assertTrue((prevHiveObj != newHiveObj ? 1 : 0) != 0);
    }

    private static Path mergePaths(Path path1, Path path2) {
        String path2Str = path2.toUri().getPath();
        path2Str = path2Str.substring(TestHive.startPositionWithoutWindowsDrive(path2Str));
        return new Path(path1.toUri().getScheme(), path1.toUri().getAuthority(), path1.toUri().getPath() + path2Str);
    }

    private static int startPositionWithoutWindowsDrive(String path) {
        if (TestHive.hasWindowsDrive(path)) {
            return path.charAt(0) == '/' ? 3 : 2;
        }
        return 0;
    }

    private static boolean hasWindowsDrive(String path) {
        return WINDOWS && hasDriveLetterSpecifier.matcher(path).find();
    }

    static {
        WINDOWS = System.getProperty("os.name").startsWith("Windows");
        hasDriveLetterSpecifier = Pattern.compile("^/?[a-zA-Z]:");
    }
}

