/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManagerEndToEndTestBase;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Test;

public class TestDbTxnManagerIsolationProperties
extends DbTxnManagerEndToEndTestBase {
    @Test
    public void basicOpenTxnsNoDirtyRead() throws Exception {
        this.driver.run("drop table if exists gap");
        this.driver.run("create table gap (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("select * from gap");
        long first = this.txnMgr.getCurrentTxnId();
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.compileAndRespond("insert into gap values(1,2)");
        long second = txnMgr2.getCurrentTxnId();
        Assert.assertTrue((String)"Sequence number goes onward", (second > first ? 1 : 0) != 0);
        this.driver2.run();
        TestDbTxnManagerIsolationProperties.swapTxnManager(this.txnMgr);
        this.driver.run();
        FetchTask fetchTask = this.driver.getFetchTask();
        ArrayList res = new ArrayList();
        fetchTask.fetch(res);
        Assert.assertEquals((String)"No dirty read", (long)0L, (long)res.size());
    }

    @Test
    public void gapOpenTxnsNoDirtyRead() throws Exception {
        this.driver.run("drop table if exists gap");
        this.driver.run("create table gap (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("select * from gap");
        long first = this.txnMgr.getCurrentTxnId();
        this.driver.run();
        this.driver.run("select * from gap");
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        this.txnHandler.setOpenTxnTimeOutMillis(30000L);
        this.deleteTransactionId(first);
        CommandProcessorResponse resp = this.driver2.compileAndRespond("select * from gap");
        long third = txnMgr2.getCurrentTxnId();
        Assert.assertTrue((String)"Sequence number goes onward", (third > first ? 1 : 0) != 0);
        ValidTxnList validTxns = txnMgr2.getValidTxns();
        Assert.assertEquals((String)"Expect to see the gap as open", (long)first, (long)validTxns.getMinOpenTxn());
        this.txnHandler.setOpenTxnTimeOutMillis(1000L);
        this.setBackSequence(first);
        TestDbTxnManagerIsolationProperties.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("insert into gap values(1,2)");
        long forth = this.txnMgr.getCurrentTxnId();
        Assert.assertEquals((long)first, (long)forth);
        this.driver.run();
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.run();
        FetchTask fetchTask = this.driver2.getFetchTask();
        ArrayList res = new ArrayList();
        fetchTask.fetch(res);
        Assert.assertEquals((String)"No dirty read", (long)0L, (long)res.size());
    }

    @Test
    public void multipleGapOpenTxnsNoDirtyRead() throws Exception {
        this.driver.run("drop table if exists gap");
        this.driver.run("create table gap (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        OpenTxnsResponse openTxns = this.txnHandler.openTxns(new OpenTxnRequest(10, "user", "local"));
        openTxns.getTxn_ids().stream().forEach(txnId -> this.silentCommitTxn(new CommitTxnRequest(txnId.longValue())));
        long first = (Long)openTxns.getTxn_ids().get(0);
        long last = (Long)openTxns.getTxn_ids().get(9);
        this.driver.run("select * from gap");
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        this.txnHandler.setOpenTxnTimeOutMillis(30000L);
        this.deleteTransactionId(first, last);
        CommandProcessorResponse resp = this.driver2.compileAndRespond("select * from gap");
        long next = txnMgr2.getCurrentTxnId();
        Assert.assertTrue((String)"Sequence number goes onward", (next > last ? 1 : 0) != 0);
        ValidTxnList validTxns = txnMgr2.getValidTxns();
        Assert.assertEquals((String)"Expect to see the gap as open", (long)first, (long)validTxns.getMinOpenTxn());
        this.txnHandler.setOpenTxnTimeOutMillis(1000L);
        this.setBackSequence(first);
        TestDbTxnManagerIsolationProperties.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("insert into gap values(1,2)");
        next = this.txnMgr.getCurrentTxnId();
        Assert.assertEquals((long)first, (long)next);
        this.driver.run();
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.run();
        FetchTask fetchTask = this.driver2.getFetchTask();
        ArrayList res = new ArrayList();
        fetchTask.fetch(res);
        Assert.assertEquals((String)"No dirty read", (long)0L, (long)res.size());
    }

    @Test
    public void gapOpenTxnsDirtyRead() throws Exception {
        this.driver.run("drop table if exists gap");
        this.driver.run("create table gap (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("select * from gap");
        long first = this.txnMgr.getCurrentTxnId();
        this.driver.run();
        this.driver.run("select * from gap");
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        this.deleteTransactionId(first);
        CommandProcessorResponse resp = this.driver2.compileAndRespond("select * from gap");
        long third = txnMgr2.getCurrentTxnId();
        Assert.assertTrue((String)"Sequence number goes onward", (third > first ? 1 : 0) != 0);
        ValidTxnList validTxns = txnMgr2.getValidTxns();
        Assert.assertNull((String)"Expect to see no gap", (Object)validTxns.getMinOpenTxn());
        this.setBackSequence(first);
        TestDbTxnManagerIsolationProperties.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("insert into gap values(1,2)");
        long forth = this.txnMgr.getCurrentTxnId();
        Assert.assertEquals((long)first, (long)forth);
        this.driver.run();
        TestDbTxnManagerIsolationProperties.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.run();
        FetchTask fetchTask = this.driver2.getFetchTask();
        ArrayList res = new ArrayList();
        fetchTask.fetch(res);
        Assert.assertEquals((String)"Dirty read!", (long)1L, (long)res.size());
    }

    private void silentCommitTxn(CommitTxnRequest commitTxnRequest) {
        try {
            this.txnHandler.commitTxn(commitTxnRequest);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void deleteTransactionId(long txnId) throws SQLException {
        this.deleteTransactionId(txnId, txnId);
    }

    private void deleteTransactionId(long minTxnId, long maxTxnId) throws SQLException {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)conf);
        DataSource ds = dsp.create((Configuration)conf);
        Connection dbConn = ds.getConnection();
        Statement stmt = dbConn.createStatement();
        stmt.executeUpdate("DELETE FROM TXNS WHERE TXN_ID >=" + minTxnId + " AND TXN_ID <=" + maxTxnId);
        dbConn.commit();
        stmt.close();
        dbConn.close();
    }

    private void setBackSequence(long txnId) throws SQLException {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)conf);
        DataSource ds = dsp.create((Configuration)conf);
        Connection dbConn = ds.getConnection();
        Statement stmt = dbConn.createStatement();
        stmt.executeUpdate("ALTER TABLE TXNS ALTER TXN_ID RESTART WITH " + txnId);
        dbConn.commit();
        stmt.close();
        dbConn.close();
    }

    public static HiveTxnManager swapTxnManager(HiveTxnManager txnMgr) {
        return SessionState.get().setTxnMgr(txnMgr);
    }
}

