/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.AcidHouseKeeperService;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManagerEndToEndTestBase;
import org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDbTxnManager2
extends DbTxnManagerEndToEndTestBase {
    @Rule
    public TemporaryFolder exportFolder = new TemporaryFolder();

    @Test
    public void testMetadataOperationLocks() throws Exception {
        boolean isStrict = conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, false);
        this.dropTable(new String[]{"T"});
        this.driver.run("create table if not exists T (a int, b int)");
        this.driver.compileAndRespond("insert into T values (1,2)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("alter table T SET TBLPROPERTIES ('transactional'='true')", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T", null, locks);
        txnMgr2.rollbackTxn();
        this.txnMgr.commitTxn();
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, isStrict);
    }

    @Test
    public void testLocksInSubquery() throws Exception {
        this.testLocksInSubquery(false);
    }

    @Test
    public void testLocksInSubquerySharedWrite() throws Exception {
        this.testLocksInSubquery(true);
    }

    private void testLocksInSubquery(boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"T", "S", "R"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table if not exists T (a int, b int)");
        this.driver.run("create table if not exists S (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists R (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("delete from S where a in (select a from T where b = 1)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "one");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "S", null, locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("update S set a = 7 where a in (select a from T where b = 1)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "one");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "S", null, locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("insert into R select * from S where a in (select a from T where b = 1)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "three");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "S", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "R", null, locks);
        this.txnMgr.rollbackTxn();
    }

    @Test
    public void testCreateTable() throws Exception {
        this.dropTable(new String[]{"T"});
        this.driver.compileAndRespond("create table if not exists T (a int, b int)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
    }

    @Test
    public void testInsertOverwriteCreate() throws Exception {
        this.testInsertOverwriteCreate(false, false);
    }

    @Test
    public void testInsertOverwriteCreateAcid() throws Exception {
        this.testInsertOverwriteCreate(true, false);
    }

    @Test
    public void testInsertOverwriteCreateSharedWrite() throws Exception {
        this.testInsertOverwriteCreate(true, true);
    }

    private void testInsertOverwriteCreate(boolean isTransactional, boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"T2", "T3"});
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)isTransactional);
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table if not exists T2(a int)");
        this.driver.run("create table T3(a int) stored as ORC");
        this.driver.compileAndRespond("insert overwrite table T3 select a from T2", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T2", null, locks);
        TestDbTxnManager2.checkLock(isTransactional && sharedWrite ? LockType.EXCL_WRITE : LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T3", null, locks);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        this.driver.run("drop table if exists T1");
        this.driver.run("drop table if exists T2");
    }

    @Test
    public void testInsertOverwritePartitionedCreate() throws Exception {
        this.testInsertOverwritePartitionedCreate(false, false);
    }

    @Test
    public void testInsertOverwritePartitionedCreateAcid() throws Exception {
        this.testInsertOverwritePartitionedCreate(true, false);
    }

    @Test
    public void testInsertOverwritePartitionedCreateSharedWrite() throws Exception {
        this.testInsertOverwritePartitionedCreate(true, true);
    }

    private void testInsertOverwritePartitionedCreate(boolean isTransactional, boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"T4", "T5"});
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)isTransactional);
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table T4 (name string, gpa double) partitioned by (age int) stored as ORC");
        this.driver.run("create table T5(name string, age int, gpa double)");
        this.driver.compileAndRespond("INSERT OVERWRITE TABLE T4 PARTITION (age) SELECT  name, age, gpa FROM T5", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T5", null, locks);
        TestDbTxnManager2.checkLock(isTransactional && sharedWrite ? LockType.EXCL_WRITE : LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T4", null, locks);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        this.driver.run("drop table if exists T5");
        this.driver.run("drop table if exists T4");
    }

    @Test
    public void testBasicBlocking() throws Exception {
        this.dropTable(new String[]{"T6"});
        this.driver.run("create table if not exists T6(a int)");
        this.driver.compileAndRespond("select a from T6", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("drop table if exists T6", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks);
        this.txnMgr.rollbackTxn();
        ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T6", null, locks);
        txnMgr2.rollbackTxn();
        this.driver.run("drop table if exists T6");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected number of locks found", (long)0L, (long)locks.size());
    }

    @Test
    public void testLockConflictDbTable() throws Exception {
        this.dropTable(new String[]{"temp.T7"});
        this.driver.run("create database if not exists temp");
        this.driver.run("create table if not exists temp.T7(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("update temp.T7 set a = 5 where b = 6", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("drop database if exists temp", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "temp", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "temp", null, null, locks);
        this.txnMgr.commitTxn();
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "temp", null, null, locks);
        txnMgr2.commitTxn();
    }

    @Test
    public void testUpdateSelectUpdate() throws Exception {
        this.testUpdateSelectUpdate(false);
    }

    @Test
    public void testUpdateSelectUpdateSharedWrite() throws Exception {
        this.testUpdateSelectUpdate(true);
    }

    private void testUpdateSelectUpdate(boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"T8"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table T8(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("delete from T8 where b = 89", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.run("start transaction");
        this.driver.compileAndRespond("select a from T8", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler");
        this.driver.compileAndRespond("update T8 set a = 1 where b = 1", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "T8", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "T8", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "T8", null, locks);
        this.driver.releaseLocksAndCommitOrRollback(false, this.txnMgr);
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T8", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "T8", null, locks);
        this.driver.releaseLocksAndCommitOrRollback(true, txnMgr2);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("drop table if exists T6");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected number of locks found", (long)0L, (long)locks.size());
    }

    @Test
    public void testLockRetryLimit() throws Exception {
        this.dropTable(new String[]{"T9"});
        conf.setIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES, 2);
        conf.setBoolVar(HiveConf.ConfVars.TXN_MGR_DUMP_LOCK_STATE_ON_ACQUIRE_TIMEOUT, true);
        this.driver.run("create table T9(a int)");
        this.driver.compileAndRespond("select * from T9", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Vincent Vega");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T9", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("drop table T9", true);
        try {
            txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Winston Winnfield");
        }
        catch (LockException ex) {
            Assert.assertEquals((String)"Got wrong lock exception", (Object)ErrorMsg.LOCK_ACQUIRE_TIMEDOUT, (Object)ex.getCanonicalErrorMsg());
        }
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T9", null, locks);
        txnMgr2.closeTxnManager();
    }

    @Test
    public void testLockBlockedBy() throws Exception {
        this.dropTable(new String[]{"TAB_BLOCKED"});
        this.driver.run("create table TAB_BLOCKED (a int, b int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("select * from TAB_BLOCKED", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "I AM SAM");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_BLOCKED", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("drop table TAB_BLOCKED", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "SAM I AM", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_BLOCKED", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "TAB_BLOCKED", null, locks);
        Assert.assertEquals((String)"BlockedByExtId doesn't match", (long)locks.get(0).getLockid(), (long)locks.get(1).getBlockedByExtId());
        Assert.assertEquals((String)"BlockedByIntId doesn't match", (long)locks.get(0).getLockIdInternal(), (long)locks.get(1).getBlockedByIntId());
    }

    @Test
    public void testDummyTxnManagerOnAcidTable() throws Exception {
        this.dropTable(new String[]{"T10", "T11"});
        this.driver.run("create table T10 (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table T11 (a int, b int) clustered by(b) into 2 buckets stored as orc");
        this.useDummyTxnManagerTemporarily(conf);
        try {
            this.driver.compileAndRespond("select * from T10", true);
            assert (false);
        }
        catch (CommandProcessorException e) {
            Assert.assertEquals((long)ErrorMsg.TXNMGR_NOT_ACID.getErrorCode(), (long)e.getResponseCode());
            Assert.assertTrue((boolean)e.getMessage().contains("This command is not allowed on an ACID table"));
        }
        this.useDummyTxnManagerTemporarily(conf);
        try {
            this.driver.compileAndRespond("insert into table T10 values (1, 2)", true);
        }
        catch (CommandProcessorException e) {
            Assert.assertEquals((long)ErrorMsg.TXNMGR_NOT_ACID.getErrorCode(), (long)e.getResponseCode());
            Assert.assertTrue((boolean)e.getMessage().contains("This command is not allowed on an ACID table"));
        }
        this.useDummyTxnManagerTemporarily(conf);
        try {
            this.driver.compileAndRespond("update T10 set a=0 where b=1", true);
        }
        catch (CommandProcessorException e) {
            Assert.assertEquals((long)ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getErrorCode(), (long)e.getResponseCode());
            Assert.assertTrue((boolean)e.getMessage().contains("Attempt to do update or delete using transaction manager that does not support these operations."));
        }
        this.useDummyTxnManagerTemporarily(conf);
        try {
            this.driver.compileAndRespond("delete from T10", true);
        }
        catch (CommandProcessorException e) {
            Assert.assertEquals((long)ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getErrorCode(), (long)e.getResponseCode());
            Assert.assertTrue((boolean)e.getMessage().contains("Attempt to do update or delete using transaction manager that does not support these operations."));
        }
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
    }

    private void useDummyTxnManagerTemporarily(HiveConf hiveConf) throws Exception {
        hiveConf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager");
        this.txnMgr = SessionState.get().initTxnMgr(hiveConf);
        Assert.assertTrue((boolean)(this.txnMgr instanceof DummyTxnManager));
    }

    @Test
    public void testMetastoreTablesCleanup() throws Exception {
        this.dropTable(new String[]{"temp.T10", "temp.T11", "temp.T12p", "temp.T13p"});
        this.driver.run("create database if not exists temp");
        this.driver.run("create table temp.T10 (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table temp.T11 (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table temp.T12p (a int, b int) partitioned by (ds string, hour string) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table temp.T13p (a int, b int) partitioned by (ds string, hour string) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into temp.T10 values (1, 1)");
        this.driver.run("insert into temp.T10 values (2, 2)");
        this.driver.run("insert into temp.T11 values (3, 3)");
        this.driver.run("insert into temp.T11 values (4, 4)");
        this.driver.run("insert into temp.T12p partition (ds='today', hour='1') values (5, 5)");
        this.driver.run("insert into temp.T12p partition (ds='tomorrow', hour='2') values (6, 6)");
        this.driver.run("insert into temp.T12p partition (ds='tomorrow', hour='2') values (13, 13)");
        this.driver.run("insert into temp.T13p partition (ds='today', hour='1') values (7, 7)");
        this.driver.run("insert into temp.T13p partition (ds='tomorrow', hour='2') values (8, 8)");
        int count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\" in ('t10', 't11')");
        Assert.assertEquals((long)4L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\" in ('t12p', 't13p')");
        Assert.assertEquals((long)5L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.driver.run("insert into temp.T10 values (9, 9)");
        this.driver.run("insert into temp.T11 values (10, 10)");
        this.driver.run("insert into temp.T12p partition (ds='today', hour='1') values (11, 11)");
        this.driver.run("insert into temp.T13p partition (ds='today', hour='1') values (12, 12)");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)4L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\"='t10'");
        Assert.assertEquals((long)1L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\"='t10'");
        Assert.assertEquals((long)2L, (long)count);
        this.driver.run("drop table temp.T10");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\"='t10'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\"='t10'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\"='t12p' and \"TC_PARTITION\"='ds=today/hour=1'");
        Assert.assertEquals((long)1L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\"='t12p' and \"CTC_PARTITION\"='ds=today/hour=1'");
        Assert.assertEquals((long)1L, (long)count);
        this.driver.run("alter table temp.T12p drop partition (ds='today', hour='1')");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\"='t12p' and \"TC_PARTITION\"='ds=today/hour=1'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\"='t12p' and \"CTC_PARTITION\"='ds=today/hour=1'");
        Assert.assertEquals((long)0L, (long)count);
        this.driver.run("alter table temp.T11 compact 'minor'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11' and \"CQ_STATE\"='r' and \"CQ_TYPE\"='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runCleaner(conf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\"='t11' and \"CC_STATE\"='s' and \"CC_TYPE\"='i'");
        Assert.assertEquals((long)1L, (long)count);
        this.driver.run("alter table temp.T12p partition (ds='tomorrow', hour='2') compact 'minor'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p' and \"CQ_PARTITION\"='ds=tomorrow/hour=2' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p' and \"CQ_PARTITION\"='ds=tomorrow/hour=2' and \"CQ_STATE\"='r' and \"CQ_TYPE\"='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runCleaner(conf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\"='t12p' and \"CC_STATE\"='s' and \"CC_TYPE\"='i'");
        Assert.assertEquals((long)1L, (long)count);
        this.driver.run("insert into temp.T11 values (14, 14)");
        this.driver.run("insert into temp.T12p partition (ds='tomorrow', hour='2') values (15, 15)");
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, true);
        this.driver.run("alter table temp.T11 compact 'major'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\"='t11' and \"CC_STATE\"='f' and \"CC_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        this.driver.run("alter table temp.T12p partition (ds='tomorrow', hour='2') compact 'major'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p' and \"CQ_PARTITION\"='ds=tomorrow/hour=2' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p' and \"CQ_PARTITION\"='ds=tomorrow/hour=2' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\"='t12p' and \"CC_STATE\"='f' and \"CC_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, false);
        this.driver.run("alter table temp.T11 compact 'major'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        this.driver.run("alter table temp.T12p partition (ds='tomorrow', hour='2') compact 'major'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p' and \"CQ_PARTITION\"='ds=tomorrow/hour=2' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        this.driver.run("drop table temp.T11");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t11'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\"='t11'");
        Assert.assertEquals((long)0L, (long)count);
        this.driver.run("alter table temp.T12p drop partition (ds='tomorrow', hour='2')");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t12p'");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\"='t12p'");
        Assert.assertEquals((long)0L, (long)count);
        this.driver.run("alter table temp.T13p partition (ds='today', hour='1') compact 'major'");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\"='t13p' and \"CQ_STATE\"='i' and \"CQ_TYPE\"='a'");
        Assert.assertEquals((long)1L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)1L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)2L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)1L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        this.driver.run("drop database if exists temp cascade");
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"TXN_COMPONENTS\" where \"TC_DATABASE\"='temp' and \"TC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_DATABASE\"='temp' and \"CTC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPACTION_QUEUE\" where \"CQ_DATABASE\"='temp' and \"CQ_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        count = TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_COMPACTIONS\" where \"CC_DATABASE\"='temp' and \"CC_TABLE\" in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCheckExpectedLocks() throws Exception {
        this.testCheckExpectedLocks(false);
    }

    @Test
    public void testCheckExpectedLocksSharedWrite() throws Exception {
        this.testCheckExpectedLocks(true);
    }

    private void testCheckExpectedLocks(boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"acidPart", "nonAcidPart"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table acidPart(a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table nonAcidPart(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.driver.compileAndRespond("insert into nonAcidPart partition(p) values(1,2,3)", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "nonAcidPart", null, locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("insert into nonAcidPart partition(p=1) values(5,6)", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "nonAcidPart", "p=1", locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("insert into acidPart partition(p) values(1,2,3)", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "acidPart", null, locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("insert into acidPart partition(p=1) values(5,6)", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "acidPart", "p=1", locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("update acidPart set b = 17 where a = 1", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "acidPart", null, locks);
        this.txnMgr.rollbackTxn();
        this.driver.compileAndRespond("update acidPart set b = 17 where p = 1", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "acidPart", null, locks);
        this.txnMgr.rollbackTxn();
    }

    @Test
    public void testCheckExpectedLocks2() throws Exception {
        this.dropTable(new String[]{"tab_acid", "tab_not_acid"});
        this.driver.run("create table if not exists tab_acid (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists tab_not_acid (na int, nb int) partitioned by (np string) clustered by (na) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.driver.run("insert into tab_acid partition(p) (a,b,p) values(1,2,'foo'),(3,4,'bar')");
        this.driver.run("insert into tab_not_acid partition(np) (na,nb,np) values(1,2,'blah'),(3,4,'doh')");
        this.txnMgr.openTxn(this.ctx, "T1");
        this.driver.compileAndRespond("select * from tab_acid inner join tab_not_acid on a = na", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "T2");
        this.driver.compileAndRespond("insert into tab_not_acid partition(np='doh') values(5,6)", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "tab_not_acid", "np=doh", locks);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, false);
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr3.openTxn(this.ctx, "T3");
        this.driver.compileAndRespond("insert into tab_not_acid partition(np='blah') values(7,8)", true);
        ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(txnMgr3);
        Assert.assertEquals((String)"Unexpected lock count", (long)6L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, true);
    }

    @Test
    public void testCheckExpectedReadLocksForNonAcidTables() throws Exception {
        this.dropTable(new String[]{"tab_acid", "tab_not_acid"});
        this.driver.run("create table if not exists tab_acid (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists tab_not_acid (na int, nb int) partitioned by (np string) clustered by (na) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.driver.run("insert into tab_acid partition(p) (a,b,p) values(1,2,'foo'),(3,4,'bar')");
        this.driver.run("insert into tab_not_acid partition(np) (na,nb,np) values(1,2,'blah'),(3,4,'doh')");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_NONACID_READ_LOCKS, false);
        HiveTxnManager txnMgr1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr1.openTxn(this.ctx, "T1");
        this.driver.compileAndRespond("select * from tab_acid inner join tab_not_acid on a = na", true);
        txnMgr1.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr1);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "T2");
        this.driver.compileAndRespond("insert into tab_not_acid partition(np='doh') values(5,6)", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr3.openTxn(this.ctx, "T3");
        this.driver.compileAndRespond("insert into tab_not_acid partition(np='blah') values(7,8)", true);
        ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(txnMgr3);
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_NONACID_READ_LOCKS, HiveConf.ConfVars.HIVE_TXN_NONACID_READ_LOCKS.defaultBoolVal);
    }

    @Test
    public void testLockingOnInsertIntoNonNativeTables() throws Exception {
        this.dropTable(new String[]{"tab_not_acid"});
        this.driver.run("create table if not exists tab_not_acid (a int, b int)  STORED BY 'org.apache.hadoop.hive.ql.metadata.StorageHandlerMock'");
        this.txnMgr.openTxn(this.ctx, "T1");
        this.driver.compileAndRespond("insert into tab_not_acid values(1,2)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
    }

    @Test
    public void testLockingOnInsertOverwriteNonNativeTables() throws Exception {
        this.dropTable(new String[]{"tab_not_acid"});
        this.driver.run("create table if not exists tab_not_acid (a int, b int)   STORED BY 'org.apache.hadoop.hive.ql.metadata.StorageHandlerMock'");
        this.txnMgr.openTxn(this.ctx, "T1");
        this.driver.compileAndRespond("insert overwrite table tab_not_acid values(1,2)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
        this.txnMgr.rollbackTxn();
        this.dropTable(new String[]{"tab_not_acid"});
    }

    public static ShowLocksResponseElement checkLock(LockType expectedType, LockState expectedState, String expectedDb, String expectedTable, String expectedPartition, List<ShowLocksResponseElement> actuals) {
        return TestDbTxnManager2.checkLock(expectedType, expectedState, expectedDb, expectedTable, expectedPartition, actuals, false);
    }

    private static ShowLocksResponseElement checkLock(LockType expectedType, LockState expectedState, String expectedDb, String expectedTable, String expectedPartition, List<ShowLocksResponseElement> actuals, boolean skipFirst) {
        boolean skip = skipFirst;
        for (ShowLocksResponseElement actual : actuals) {
            if (expectedType != actual.getType() || expectedState != actual.getState() || !StringUtils.equals((CharSequence)TestDbTxnManager2.normalizeCase(expectedDb), (CharSequence)TestDbTxnManager2.normalizeCase(actual.getDbname())) || !StringUtils.equals((CharSequence)TestDbTxnManager2.normalizeCase(expectedTable), (CharSequence)TestDbTxnManager2.normalizeCase(actual.getTablename())) || !StringUtils.equals((CharSequence)TestDbTxnManager2.normalizeCase(expectedPartition), (CharSequence)TestDbTxnManager2.normalizeCase(actual.getPartname()))) continue;
            if (!skip) {
                return actual;
            }
            skip = false;
        }
        Assert.fail((String)("Could't find {" + expectedType + ", " + expectedState + ", " + expectedDb + ", " + expectedTable + ", " + expectedPartition + "} in " + actuals));
        throw new IllegalStateException("How did it get here?!");
    }

    public static HiveTxnManager swapTxnManager(HiveTxnManager txnMgr) {
        return SessionState.get().setTxnMgr(txnMgr);
    }

    @Test
    public void testShowLocksFilterOptions() throws Exception {
        this.driver.run("drop table if exists db1.t14");
        this.driver.run("drop table if exists db2.t14");
        this.driver.run("drop table if exists db2.t15");
        this.driver.run("drop table if exists db2.t16");
        this.driver.run("drop database if exists db1");
        this.driver.run("drop database if exists db2");
        this.driver.run("create database if not exists db1");
        this.driver.run("create database if not exists db2");
        this.driver.run("create table if not exists db1.t14 (a int, b int) partitioned by (ds string) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists db2.t14 (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists db2.t15 (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists db2.t16 (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, true);
        HiveTxnManager txnMgr1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr1);
        this.driver.compileAndRespond("insert into table db1.t14 partition (ds='today') values (1, 2)", true);
        txnMgr1.acquireLocks(this.driver.getPlan(), this.ctx, "Tom");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("insert into table db1.t14 partition (ds='tomorrow') values (3, 4)", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Jerry");
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr3);
        this.driver.compileAndRespond("select * from db2.t15", true);
        txnMgr3.acquireLocks(this.driver.getPlan(), this.ctx, "Donald");
        HiveTxnManager txnMgr4 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr4);
        this.driver.compileAndRespond("select * from db2.t16", true);
        txnMgr4.acquireLocks(this.driver.getPlan(), this.ctx, "Hillary");
        HiveTxnManager txnMgr5 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr5);
        this.driver.compileAndRespond("select * from db2.t14", true);
        txnMgr5.acquireLocks(this.driver.getPlan(), this.ctx, "Obama");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=today", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=tomorrow", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t15", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t16", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t14", null, locks);
        locks = this.getLocksWithFilterOptions(txnMgr3, "db2", null, null);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t15", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t16", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t14", null, locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("use db1");
        locks = this.getLocksWithFilterOptions(this.txnMgr, null, "t14", null);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=today", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=tomorrow", locks);
        Map<String, String> partSpec = Collections.singletonMap("ds", "today");
        locks = this.getLocksWithFilterOptions(this.txnMgr, null, "t14", partSpec);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=today", locks);
        this.driver.run("use db2");
        locks = this.getLocksWithFilterOptions(txnMgr3, null, "t15", null);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t15", null, locks);
    }

    private static String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    private List<ShowLocksResponseElement> getLocks() throws Exception {
        return this.getLocks(this.txnMgr);
    }

    private List<ShowLocksResponseElement> getLocks(HiveTxnManager txnMgr) throws Exception {
        ShowLocksResponse rsp = ((DbLockManager)txnMgr.getLockManager()).getLocks();
        return rsp.getLocks();
    }

    @Test
    public void testWriteSetTracking1() throws Exception {
        this.dropTable(new String[]{"TAB_PART"});
        this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("select * from TAB_PART", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Nicholas");
        this.txnMgr.commitTxn();
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Alexandra");
        txnMgr2.commitTxn();
    }

    private void dropTable(String[] tabs) throws Exception {
        for (String tab : tabs) {
            this.driver.run("drop table if exists " + tab);
        }
    }

    @Test
    public void testWriteSetTracking2() throws Exception {
        this.dropTable(new String[]{"TAB_PART", "TAB2"});
        this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists TAB2 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        this.txnMgr.openTxn(this.ctx, "Peter");
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Peter");
        txnMgr2.openTxn(this.ctx, "Catherine");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        this.txnMgr.commitTxn();
        this.driver.compileAndRespond("update TAB2 set b = 9 where p = 'doh'", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Catherine");
        txnMgr2.commitTxn();
    }

    @Test
    public void testWriteSetTracking3() throws Exception {
        this.dropTable(new String[]{"TAB_PART"});
        this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into TAB_PART partition(p='blah') values(1,2)");
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        long txnId = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Known");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        long txnId2 = txnMgr2.getCurrentTxnId();
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Unknown", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        long writeId = this.txnMgr.getTableWriteId("default", "TAB_PART");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, "default", "TAB_PART", Collections.singletonList("p=blah"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        adp.setTxnid(txnId2);
        writeId = txnMgr2.getTableWriteId("default", "TAB_PART");
        adp.setWriteid(writeId);
        this.txnHandler.addDynamicPartitions(adp);
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        Assert.assertNotNull((String)"Didn't get exception", (Object)((Object)expectedException));
        Assert.assertEquals((String)"Got wrong message code", (Object)ErrorMsg.TXN_ABORTED, (Object)expectedException.getCanonicalErrorMsg());
        Assert.assertEquals((String)"Exception msg didn't match", (Object)("Aborting [txnid:" + txnId2 + "," + txnId2 + "] due to a write conflict on default/tab_part/p=blah committed by [txnid:" + txnId + "," + txnId2 + "] u/u"), (Object)expectedException.getCause().getMessage());
    }

    @Test
    public void testWriteSetTracking4() throws Exception {
        this.dropTable(new String[]{"TAB_PART", "TAB2"});
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists TAB2 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.txnMgr.openTxn(this.ctx, "Long Running");
        this.driver.compileAndRespond("select a from TAB_PART where p = 'blah'", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Long Running");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "Short Running");
        this.driver.compileAndRespond("update TAB2 set b = 7 where p = 'blah'", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Short Running");
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", null, locks);
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest("default", "tab2");
        rqst.setTxnIds(Collections.singletonList(txnMgr2.getCurrentTxnId()));
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)txnMgr2.getCurrentTxnId(), (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "tab2", Collections.EMPTY_LIST);
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        txnMgr2.openTxn(this.ctx, "T3");
        this.driver.compileAndRespond("update TAB2 set b = 7 where p = 'two'", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T3");
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", null, locks);
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        rqst = new AllocateTableWriteIdsRequest("default", "tab2");
        rqst.setTxnIds(Collections.singletonList(txnMgr2.getCurrentTxnId()));
        writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)txnMgr2.getCurrentTxnId(), (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "tab2", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        AcidHouseKeeperService houseKeeper = new AcidHouseKeeperService();
        houseKeeper.setConf((Configuration)conf);
        houseKeeper.run();
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        this.driver.compileAndRespond("update TAB2 set b = 17 where a = 1", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Long Running");
        rqst = new AllocateTableWriteIdsRequest("default", "tab2");
        rqst.setTxnIds(Collections.singletonList(this.txnMgr.getCurrentTxnId()));
        writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)this.txnMgr.getCurrentTxnId(), (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "tab2", Collections.EMPTY_LIST);
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)0L, (long)locks.size());
        this.txnMgr.openTxn(this.ctx, "Long Running");
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        houseKeeper.run();
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
    }

    @Test
    public void testWriteSetTracking5() throws Exception {
        this.dropTable(new String[]{"TAB_PART"});
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into TAB_PART partition(p='blah') values(1,2)");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        this.txnMgr.openTxn(this.ctx, "Known");
        long txnId = txnMgr2.openTxn(this.ctx, "Unknown");
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Known");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Unknown", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        this.txnMgr.rollbackTxn();
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest("default", "TAB_PART");
        rqst.setTxnIds(Collections.singletonList(txnId));
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)txnId, (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "TAB_PART", Collections.singletonList("p=blah"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        txnMgr2.commitTxn();
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
    }

    @Test
    public void testWriteSetTracking6() throws Exception {
        this.dropTable(new String[]{"TAB2"});
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        this.driver.run("create table if not exists TAB2(a int, b int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.compileAndRespond("select * from TAB2 where a = 113", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Works");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB2", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update TAB2 set b = 17 where a = 101", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Horton");
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB2", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", null, locks);
        txnMgr2.commitTxn();
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB2", null, locks);
        this.txnMgr.commitTxn();
        this.txnMgr.openTxn(this.ctx, "Long Running");
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        AcidHouseKeeperService writeSetService = new AcidHouseKeeperService();
        writeSetService.setConf((Configuration)conf);
        writeSetService.run();
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
    }

    @Test
    public void testWriteSetTracking7() throws Exception {
        this.dropTable(new String[]{"tab2", "TAB2"});
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\""));
        this.driver.run("create table if not exists tab2 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab2 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update tab2 set b = 7 where p='two'", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=two", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("update tab2 set b = 7 where p='one'", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=one", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab2");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab2", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=one", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab2");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab2", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=one' and \"WS_OPERATION_TYPE\"='u'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='u'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TABLE\"='tab2' and \"CTC_PARTITION\" is not null"));
        this.driver.run("drop table if exists tab1");
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')");
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update tab1 set b = 7 where b=1", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T5");
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("update tab1 set b = 7 where b = 2", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T6", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        writeId = txnMgr2.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=one' and \"WS_OPERATION_TYPE\"='u' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='u' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\" is not null"));
    }

    @Test
    public void testWriteSetTracking8() throws Exception {
        this.dropTable(new String[]{"tab1", "TAB1"});
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update tab1 set b = 7 where b=1", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("update tab1 set b = 7 where p='two'", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=one' and \"WS_OPERATION_TYPE\"='u' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='u' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\" is not null"));
    }

    @Test
    public void testWriteSetTracking9() throws Exception {
        this.dropTable(new String[]{"TAB1"});
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update tab1 set b = 7 where b=1", true);
        long idTxnUpdate1 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("delete from tab1 where p='two' and b=2", true);
        long idTxnDelete1 = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + (idTxnUpdate1 - 1L) + " and \"CTC_TABLE\"='tab1'")));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + idTxnUpdate1 + " and \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\"='p=one'")));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + idTxnDelete1 + " and \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\"='p=two'")));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=one' and \"WS_OPERATION_TYPE\"='u' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='d' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\" is not null"));
    }

    @Test
    public void testWriteSetTracking10() throws Exception {
        this.dropTable(new String[]{"TAB1"});
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("update tab1 set b = 7 where b=2", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.compileAndRespond("delete from tab1 where p='two' and b=2", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        LockException exception = null;
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException e) {
            exception = e;
        }
        Assert.assertNotNull((String)"Expected exception", (Object)((Object)exception));
        Assert.assertEquals((String)"Exception msg doesn't match", (Object)"Aborting [txnid:5,5] due to a write conflict on default/tab1/p=two committed by [txnid:4,5] d/u", (Object)exception.getCause().getMessage());
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='u' and \"WS_TABLE\"='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\" is not null"));
    }

    @Test
    public void testWriteSetTracking11() throws Exception {
        this.dropTable(new String[]{"TAB1"});
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("delete from tab1 where b=2", true);
        long txnIdDelete = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("start transaction");
        this.driver.compileAndRespond("select * from tab1 where b=1 and p='one'", true);
        long txnIdSelect = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        this.driver.compileAndRespond("delete from tab1 where p='two' and b=2", true);
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        LockException expectedException = null;
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException ex) {
            expectedException = ex;
        }
        Assert.assertNotNull((String)"Didn't get expected d/d conflict", (Object)((Object)expectedException));
        Assert.assertEquals((Object)"Transaction manager has aborted the transaction txnid:5.  Reason: Aborting [txnid:5,5] due to a write conflict on default/tab1/p=two committed by [txnid:4,5] d/d", (Object)expectedException.getMessage());
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='d' and \"WS_TABLE\"='tab1' and \"WS_TXNID\"=" + txnIdDelete)));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_PARTITION\"='p=two' and \"WS_OPERATION_TYPE\"='d' and \"WS_TABLE\"='tab1' and \"WS_TXNID\"=" + txnIdSelect)));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TABLE\"='tab1' and \"CTC_PARTITION\" is not null"));
    }

    @Test
    public void testCompletedTxnComponents() throws Exception {
        this.dropTable(new String[]{"TAB1", "tab_not_acid2"});
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists tab_not_acid2 (a int, b int)");
        this.driver.run("insert into tab_not_acid2 values(1,1),(2,2)");
        this.driver.run("from tab_not_acid2 insert into tab1 partition(p='two')(a,b) select a,b insert into tab_not_acid2(a,b) select a,b ");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\""), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\""));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\""), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=6 and \"CTC_TABLE\"='tab1'"));
    }

    @Test
    public void testMultiInsert() throws Exception {
        this.dropTable(new String[]{"TAB1", "tab_not_acid"});
        this.driver.run("drop table if exists tab1");
        this.driver.run("drop table if exists tab_not_acid");
        this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists tab_not_acid (a int, b int, p string)");
        this.driver.run("insert into tab_not_acid values(1,1,'one'),(2,2,'two')");
        this.driver.run("insert into tab1 partition(p) values(3,3,'one'),(4,4,'two')");
        this.driver.run("from tab_not_acid insert into tab1 partition(p)(a,b,p) select a,b,p insert into tab_not_acid(a,b) select a,b where p='two'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\""), (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\""));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\""), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=9"));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\""), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=9 and \"CTC_TABLE\"='tab1'"));
    }

    @Test
    public void testMultiInsertOnDynamicallyPartitionedMmTable() throws Exception {
        this.dropTable(new String[]{"tabMmDp", "tab_not_acid"});
        this.driver.run("create table if not exists tabMmDp (a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        this.driver.run("create table if not exists tab_not_acid (a int, b int, p string)");
        this.driver.run("insert into tab_not_acid values (1 ,1, 'one'), (2, 2, 'two')");
        this.driver.run("from tab_not_acid insert into tabMmDp select a,b,p insert into tabMmDp select a,b,p");
        String completedTxnComponentsContents = TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"");
        Assert.assertEquals((String)completedTxnComponentsContents, (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\""));
        Assert.assertEquals((String)completedTxnComponentsContents, (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=6"));
        Assert.assertEquals((String)completedTxnComponentsContents, (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=6 and \"CTC_TABLE\"='tabmmdp'"));
        Assert.assertEquals((String)completedTxnComponentsContents, (long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=6 and \"CTC_TABLE\"='tabmmdp' and \"CTC_UPDATE_DELETE\"='N'"));
        this.dropTable(new String[]{"tabMmDp", "tab_not_acid"});
    }

    private List<ShowLocksResponseElement> getLocksWithFilterOptions(HiveTxnManager txnMgr, String dbName, String tblName, Map<String, String> partSpec) throws Exception {
        if (dbName == null && tblName != null) {
            dbName = SessionState.get().getCurrentDatabase();
        }
        ShowLocksRequest rqst = new ShowLocksRequest();
        rqst.setDbname(dbName);
        rqst.setTablename(tblName);
        if (partSpec != null) {
            String partName = FileUtils.makePartName(new ArrayList<String>(partSpec.keySet()), new ArrayList<String>(partSpec.values()));
            rqst.setPartname(partName);
        }
        ShowLocksResponse rsp = ((DbLockManager)txnMgr.getLockManager()).getLocks(rqst);
        return rsp.getLocks();
    }

    @Test
    public void testShowLocksAgentInfo() throws Exception {
        this.driver.run("create table if not exists XYZ (a int, b int)");
        this.driver.compileAndRespond("select a from XYZ where b = 8", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "XYZ");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "XYZ", null, locks);
        Assert.assertEquals((String)"Wrong AgentInfo", (Object)this.driver.getPlan().getQueryId(), (Object)locks.get(0).getAgentInfo());
    }

    @Test
    public void testMerge3Way() throws Exception {
        this.testMerge3Way(false, false);
    }

    @Test
    public void testMerge3WayConflict() throws Exception {
        this.testMerge3Way(true, false);
    }

    @Test
    public void testMerge3WayConflictSharedWrite() throws Exception {
        this.testMerge3Way(true, true);
    }

    private void testMerge3Way(boolean causeConflict, boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"target", "source", "source2"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table target (a int, b int) partitioned by (p int, q int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target partition(p,q) values (1,2,1,2), (3,4,1,2), (5,6,1,3), (7,8,2,2)");
        this.driver.run("create table source (a int, b int, p int, q int)");
        this.driver.run("insert into source values (9,10,1,2),        (3,4,1,2), (11,12,1,3), (5,13,1,3), (7,8,2,2), (14,15,1,1)");
        this.driver.run("create table source2 (a int, b int, p int, q int)");
        this.driver.run("insert into source2 values (9,100,1,2),      (3,4,1,2),         (5,13,1,3),       (7,8,2,2), (14,15,2,1)");
        this.driver.compileAndRespond("merge into target t using source s on t.a=s.b when matched and t.a=5 then update set b=s.b when matched and t.a in (3,7) then delete when not matched and t.a >= 8 then insert values(s.a, s.b, s.p, s.q)", true);
        long txnId1 = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver.compileAndRespond("merge into target t using source2 s on t.a=s.b when matched and t.a=" + (causeConflict ? 5 : 9) + " then update set b=s.b when matched and t.a in (" + (causeConflict ? "3,7" : "11, 13") + ") then delete when not matched and t.a >= 8 then insert values(s.a, s.b, s.p, s.q)", true);
        long txnId2 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T1", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)10L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        long extLockId = TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", null, locks, sharedWrite).getLockid();
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "source2", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", "p=1/q=2", locks, sharedWrite);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", "p=1/q=3", locks, sharedWrite);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", "p=2/q=2", locks, sharedWrite);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId1)));
        long writeId = this.txnMgr.getTableWriteId("default", "target");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Collections.singletonList("p=1/q=3"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=2/q=2"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3", "p=1/q=1"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId1 + " and \"TC_OPERATION_TYPE\"='u'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId1 + " and \"TC_OPERATION_TYPE\"='d'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId1 + " and \"TC_OPERATION_TYPE\"='i'")));
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)6L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + txnId1)));
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnId1 + " and \"WS_OPERATION_TYPE\"='u'")));
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnId1 + " and \"WS_OPERATION_TYPE\"='d'")));
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(extLockId);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source2", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId2)));
        writeId = txnMgr2.getTableWriteId("default", "target");
        adp = new AddDynamicPartitions(txnId2, writeId, "default", "target", Collections.singletonList(causeConflict ? "p=1/q=3" : "p=1/p=2"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        if (causeConflict) {
            adp = new AddDynamicPartitions(txnId2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=2/q=2"));
            adp.setOperationType(DataOperationType.DELETE);
            this.txnHandler.addDynamicPartitions(adp);
        }
        adp = new AddDynamicPartitions(txnId2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3", "p=1/q=1"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId2 + " and \"TC_OPERATION_TYPE\"='u'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)(causeConflict ? 2 : 0), (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId2 + " and \"TC_OPERATION_TYPE\"='d'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId2 + " and \"TC_OPERATION_TYPE\"='i'")));
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        if (causeConflict && sharedWrite) {
            Assert.assertNotNull((String)"Didn't get exception", (Object)((Object)expectedException));
            try {
                Assert.assertEquals((Object)"Transaction manager has aborted the transaction txnid:11.  Reason: Aborting [txnid:11,11] due to a write conflict on default/target/p=1/q=2 committed by [txnid:10,11] d/d", (Object)expectedException.getMessage());
            }
            catch (ComparisonFailure ex) {
                try {
                    Assert.assertEquals((Object)"Transaction manager has aborted the transaction txnid:11.  Reason: Aborting [txnid:11,11] due to a write conflict on default/target/p=2/q=2 committed by [txnid:10,11] d/d", (Object)expectedException.getMessage());
                }
                catch (ComparisonFailure ex2) {
                    Assert.assertEquals((Object)"Transaction manager has aborted the transaction txnid:11.  Reason: Aborting [txnid:11,11] due to a write conflict on default/target/p=1/q=3 committed by [txnid:10,11] u/u", (Object)expectedException.getMessage());
                }
            }
            Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + txnId2)));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnId2)));
        } else {
            Assert.assertNull((String)("Unexpected exception " + (Object)((Object)expectedException)), (Object)((Object)expectedException));
            Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)(causeConflict ? 6L : 4L), (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + txnId2)));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnId2 + " and \"WS_OPERATION_TYPE\"='u'")));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)(causeConflict ? 2L : 0L), (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnId2 + " and \"WS_OPERATION_TYPE\"='d'")));
        }
        this.dropTable(new String[]{"target", "source", "source2"});
    }

    @Test
    public void testMergeUnpartitioned() throws Exception {
        this.testMergeUnpartitioned(false, false);
    }

    @Test
    public void testMergeUnpartitionedConflict() throws Exception {
        this.testMergeUnpartitioned(true, false);
    }

    @Test
    public void testMergeUnpartitionedConflictSharedWrite() throws Exception {
        this.testMergeUnpartitioned(true, true);
    }

    private void testMergeUnpartitioned(boolean causeConflict, boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table target (a int, b int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,2), (3,4), (5,6), (7,8)");
        this.driver.run("create table source (a int, b int)");
        if (causeConflict) {
            this.driver.compileAndRespond("update target set b = 2 where a=1", true);
        } else {
            this.driver.compileAndRespond("insert into target values(9,10),(11,12)", true);
        }
        long txnid1 = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid1)));
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        if (causeConflict) {
            Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
            TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
        } else {
            Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
            TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        }
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver.compileAndRespond("merge into target t using source s on t.a=s.a when matched then delete when not matched then insert values(s.a,s.b)", true);
        long txnid2 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, causeConflict && !sharedWrite ? LockState.WAITING : LockState.ACQUIRED, "default", "source", null, locks);
        long extLockId = TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, causeConflict && !sharedWrite ? LockState.WAITING : LockState.ACQUIRED, "default", "target", null, locks, sharedWrite).getLockid();
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)(causeConflict ? 1L : 0L), (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnid1 + " and \"WS_OPERATION_TYPE\"=" + (causeConflict ? "'u'" : "'i'"))));
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(extLockId);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid2)));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid2 + " and \"TC_OPERATION_TYPE\"='d'")));
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        if (causeConflict && sharedWrite) {
            Assert.assertNotNull((String)"Didn't get exception", (Object)((Object)expectedException));
            Assert.assertEquals((String)"Got wrong message code", (Object)ErrorMsg.TXN_ABORTED, (Object)expectedException.getCanonicalErrorMsg());
            Assert.assertEquals((String)"Exception msg didn't match", (Object)"Aborting [txnid:7,7] due to a write conflict on default/target committed by [txnid:6,7] d/u", (Object)expectedException.getCause().getMessage());
        } else {
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnid2 + " and \"WS_OPERATION_TYPE\"='d'")));
        }
    }

    @Test
    public void testInsertMergeInsertLocking() throws Exception {
        this.testMergeInsertLocking(false);
    }

    @Test
    public void testInsertMergeInsertLockingSharedWrite() throws Exception {
        this.testMergeInsertLocking(true);
    }

    private void testMergeInsertLocking(boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table target (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,2), (3,4)");
        this.driver.run("create table source (a int, b int)");
        this.driver.run("insert into source values (5,6), (7,8)");
        this.driver.compileAndRespond("insert into target values (5, 6)");
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver.compileAndRespond("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b)");
        txnMgr2.acquireLocks(this.driver.getPlan(), this.driver.getContext(), "T2", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
    }

    @Test
    public void testConcurrentInsertMergeInsertGenerateDuplicates() throws Exception {
        this.testConcurrentMergeInsert("insert into target values (5, 6)", false, false, true);
    }

    @Test
    public void testConcurrentInsertMergeInsertSharedWriteGenerateDuplicates() throws Exception {
        this.testConcurrentMergeInsert("insert into target values (5, 6)", true, false, true);
    }

    @Test
    public void testConcurrent2MergeInsertsNoDuplicates() throws Exception {
        this.testConcurrentMergeInsert("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b)", false, false, false);
    }

    @Test
    public void testConcurrent2MergeInsertsSharedWriteNoDuplicates() throws Exception {
        this.testConcurrentMergeInsert("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b)", true, false, false);
    }

    @Test
    public void testConcurrent2MergeInsertsNoDuplicatesSlowCompile() throws Exception {
        this.testConcurrentMergeInsert("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b)", false, true, false);
    }

    @Test
    public void testConcurrent2MergeInsertsSharedWriteNoDuplicatesSlowCompile() throws Exception {
        this.testConcurrentMergeInsert("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b)", true, true, false);
    }

    @Test
    public void testConcurrentInsertMergeInsertNoDuplicates() throws Exception {
        this.testConcurrentMergeInsert("insert into source values (3, 4)", false, false, false);
    }

    private void testConcurrentMergeInsert(String query, boolean sharedWrite, boolean slowCompile, boolean extectedDuplicates) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver2.getConf().setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table target (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,2), (3,4)");
        this.driver.run("create table source (a int, b int)");
        this.driver.run("insert into source values (5,6), (7,8)");
        if (!slowCompile) {
            this.driver.compileAndRespond(query);
        }
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.compileAndRespond("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b)");
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        if (!slowCompile) {
            this.driver.run();
        } else {
            this.driver.run(query);
        }
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        try {
            this.driver2.run();
        }
        catch (CommandProcessorException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("write conflict on default/target"));
        }
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("select * from target");
        ArrayList res = new ArrayList();
        this.driver.getFetchTask().fetch(res);
        Assert.assertEquals((String)("Duplicate records " + (extectedDuplicates ? "" : "not") + "found"), (long)(extectedDuplicates ? 5L : 4L), (long)res.size());
        this.dropTable(new String[]{"target", "source"});
    }

    @Test
    public void testConcurrentUpdateMergeUpdateConflict() throws Exception {
        this.testConcurrentUpdateMergeUpdateConflict(false);
    }

    @Test
    public void testConcurrentUpdateMergeUpdateConflictSlowCompile() throws Exception {
        this.testConcurrentUpdateMergeUpdateConflict(true);
    }

    private void testConcurrentUpdateMergeUpdateConflict(boolean slowCompile) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        this.driver2.getConf().setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, true);
        this.driver.run("create table target (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,2), (3,4)");
        this.driver.run("create table source (a int, b int)");
        this.driver.run("insert into source values (5,6), (7,8)");
        if (!slowCompile) {
            this.driver.compileAndRespond("update target set a=5 where a=1");
        }
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.compileAndRespond("merge into target t using source s on t.a = s.a when matched then update set b=8");
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        if (!slowCompile) {
            this.driver.run();
        } else {
            this.driver.run("update target set a=5 where a=1");
        }
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.run();
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("select * from target");
        ArrayList res = new ArrayList();
        this.driver.getFetchTask().fetch(res);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((String)"Lost Update", (Object)"5\t8", res.get(1));
    }

    @Test
    public void testConcurrent2MergeUpdatesConflict() throws Exception {
        this.testConcurrent2MergeUpdatesConflict(false);
    }

    @Test
    public void testConcurrent2MergeUpdatesConflictSlowCompile() throws Exception {
        this.testConcurrent2MergeUpdatesConflict(true);
    }

    private void testConcurrent2MergeUpdatesConflict(boolean slowCompile) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        this.driver2.getConf().setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, true);
        this.driver.run("create table target (name string, age int) stored as orc TBLPROPERTIES('transactional'='true')");
        this.driver.run("insert into target values ('amy', 88), ('drake', 44), ('earl', 21)");
        this.driver.run("create table source (name string, age int) stored as orc TBLPROPERTIES('transactional'='true')");
        this.driver.run("insert into source values ('amy', 35), ('bob', 66), ('cal', 21)");
        if (!slowCompile) {
            this.driver.compileAndRespond("merge into target t using source s on t.name = s.name when matched then update set age=10");
        }
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.compileAndRespond("merge into target t using source s on t.age = s.age when matched then update set age=10");
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        if (!slowCompile) {
            this.driver.run();
        } else {
            this.driver.run("merge into target t using source s on t.name = s.name when matched then update set age=10");
        }
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.run();
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("select * from target where age=10");
        ArrayList res = new ArrayList();
        this.driver.getFetchTask().fetch(res);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((String)"Lost Update", (Object)"[earl\t10, amy\t10]", (Object)((Object)res).toString());
    }

    @Test
    public void testConcurrent2InsertOverwritesDiffPartitions() throws Exception {
        this.testConcurrent2InsertOverwrites(false);
    }

    @Test
    public void testConcurrent2InsertOverwritesSamePartition() throws Exception {
        this.testConcurrent2InsertOverwrites(true);
    }

    private void testConcurrent2InsertOverwrites(boolean conflict) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        this.driver2.getConf().setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, true);
        this.driver.run("create table target (a int) partitioned by (b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,2), (3,4)");
        this.driver.run("create table source (a int)");
        this.driver.run("insert into source values (5), (7)");
        this.driver.compileAndRespond("insert overwrite table target partition (b='2') select * from source");
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.compileAndRespond("insert overwrite table target partition (b='" + (conflict ? 2 : 4) + "') select * from source");
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run();
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver2.run();
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("select * from target");
        ArrayList res = new ArrayList();
        this.driver.getFetchTask().fetch(res);
        Assert.assertEquals((long)(conflict ? 3L : 4L), (long)res.size());
    }

    @Test
    public void testInsertOverwriteMergeInsertDynamicPartitioningSequential() throws Exception {
        this.dropTable(new String[]{"target", "source"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, false);
        this.driver.run("create table target (a int, b int) partitioned by (c int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,1,1), (2,2,1)");
        this.driver.run("create table source (a int, b int) partitioned by (c int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into source values (3,3,2), (4,4,2)");
        this.driver.run("insert into source values (5,5,2), (6,6,3)");
        this.driver.run("insert overwrite table target partition (c=2) select 3, 3");
        this.driver.run("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b, s.c)");
        this.driver.run("select * from target");
        ArrayList res = new ArrayList();
        this.driver.getFetchTask().fetch(res);
        Assert.assertEquals((String)"Duplicate records found", (long)6L, (long)res.size());
        Assert.assertTrue((String)"Partition 3 was skipped", (boolean)res.contains("6\t6\t3"));
        this.dropTable(new String[]{"target", "source"});
    }

    @Test
    public void testInsertOverwriteMergeInsertDynamicPartitioningConflict() throws Exception {
        this.testInsertOverwriteMergeInsertDynamicPartitioningConflict(false);
    }

    @Test
    public void testInsertOverwriteMergeInsertDynamicPartitioningConflictSlowCompile() throws Exception {
        this.testInsertOverwriteMergeInsertDynamicPartitioningConflict(true);
    }

    private void testInsertOverwriteMergeInsertDynamicPartitioningConflict(boolean slowCompile) throws Exception {
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, true);
        conf.setBoolVar(HiveConf.ConfVars.TXN_MERGE_INSERT_X_LOCK, true);
        Driver driver3 = new Driver(new QueryState.Builder().withHiveConf(conf).build(), null);
        this.dropTable(new String[]{"target", "source"});
        this.driver.run("create table target (a int, b int) partitioned by (c int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target values (1,1,1), (2,2,1)");
        this.driver.run("create table source (a int, b int) partitioned by (c int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into source values (3,3,2), (4,4,2)");
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(new HiveConf(conf));
        if (!slowCompile) {
            this.driver.compileAndRespond("insert into source values (5,5,2), (6,6,3)");
            TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
            this.driver2.compileAndRespond("insert overwrite table target partition (c=2) select 3, 3");
        }
        DbTxnManager txnMgr3 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(new HiveConf(conf));
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr3);
        driver3.compileAndRespond("merge into target t using source s on t.a = s.a when not matched then insert values (s.a, s.b, s.c)");
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        if (!slowCompile) {
            this.driver.run();
        } else {
            this.driver.run("insert into source values (5,5,2), (6,6,3)");
        }
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        if (!slowCompile) {
            this.driver2.run();
        } else {
            this.driver2.run("insert overwrite table target partition (c=2) select 3, 3");
        }
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr3);
        driver3.run();
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("select * from target");
        ArrayList res = new ArrayList();
        this.driver.getFetchTask().fetch(res);
        Assert.assertEquals((String)"Duplicate records found", (long)6L, (long)res.size());
        Assert.assertTrue((String)"Partition 3 was skipped", (boolean)res.contains("6\t6\t3"));
        driver3.close();
        this.dropTable(new String[]{"target", "source"});
    }

    @Test
    public void testDynamicPartitionInsert() throws Exception {
        this.testDynamicPartitionInsert(false);
    }

    @Test
    public void testDynamicPartitionInsertSharedWrite() throws Exception {
        this.testDynamicPartitionInsert(true);
    }

    private void testDynamicPartitionInsert(boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"target"});
        this.driver.run("create table target (a int, b int) partitioned by (p int, q int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        long txnid1 = this.txnMgr.openTxn(this.ctx, "T1");
        this.driver.compileAndRespond("insert into target partition(p=1,q) values (1,2,2), (3,4,2), (5,6,3), (7,8,2)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        Assert.assertEquals((String)("HIVE_LOCKS mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"HIVE_LOCKS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"HIVE_LOCKS\" where \"HL_TXNID\"=" + txnid1)));
        this.txnMgr.rollbackTxn();
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid1)));
        this.driver.run("insert into target partition(p=1,q) values (1,2,2), (3,4,2), (5,6,3), (7,8,2)");
        this.driver.run("select count(*) from target");
        ArrayList r = new ArrayList();
        this.driver.getResults(r);
        Assert.assertEquals((String)"", (Object)"4", r.get(0));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)(txnid1 + 1L)) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"COMPLETED_TXN_COMPONENTS\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"COMPLETED_TXN_COMPONENTS\" where \"CTC_TXNID\"=" + (txnid1 + 1L))));
        long txnid2 = this.txnMgr.openTxn(this.ctx, "T1");
        this.driver.compileAndRespond("insert into target partition(p=1,q) values (10,2,2), (30,4,2), (50,6,3), (70,8,2)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        long writeId = this.txnMgr.getTableWriteId("default", "target");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnid2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=2"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid2)));
        this.txnMgr.commitTxn();
    }

    @Test
    public void testMergePartitioned() throws Exception {
        this.testMergePartitioned(false, false);
    }

    @Test
    public void testMergePartitionedConflict() throws Exception {
        this.testMergePartitioned(true, false);
    }

    @Test
    public void testMergePartitionedConflictSharedWrite() throws Exception {
        this.testMergePartitioned(true, true);
    }

    private void testMergePartitioned(boolean causeConflict, boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table target (a int, b int) partitioned by (p int, q int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into target partition(p,q) values (1,2,1,2), (3,4,1,2), (5,6,1,3), (7,8,2,2)");
        this.driver.run("create table source (a1 int, b1 int, p1 int, q1 int)");
        this.driver.compileAndRespond("update target set b = 2 where p=1", true);
        long txnId1 = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver.compileAndRespond("merge into target using source on target.p=source.p1 and target.a=source.a1 when matched then update set b = 11 when not matched then insert values(a1,b1,p1,q1)", true);
        long txnid2 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)7L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "source", null, locks);
        long extLockId = TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", null, locks).getLockid();
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", "p=1/q=2", locks, sharedWrite);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", "p=1/q=3", locks, sharedWrite);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, sharedWrite ? LockState.ACQUIRED : LockState.WAITING, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId1)));
        long writeId = this.txnMgr.getTableWriteId("default", "target");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnId1 + " and \"TC_OPERATION_TYPE\"='u'")));
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnId1 + " and \"WS_OPERATION_TYPE\"='u'")));
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(extLockId);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.SHARED_WRITE : LockType.EXCL_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid2)));
        writeId = txnMgr2.getTableWriteId("default", "target");
        adp = new AddDynamicPartitions(txnid2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid2 + " and \"TC_OPERATION_TYPE\"='i'")));
        adp = new AddDynamicPartitions(txnid2, writeId, "default", "target", Collections.singletonList(causeConflict ? "p=1/q=2" : "p=1/q=1"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"TXN_COMPONENTS\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"TXN_COMPONENTS\" where \"TC_TXNID\"=" + txnid2 + " and \"TC_OPERATION_TYPE\"='u'")));
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        if (causeConflict && sharedWrite) {
            Assert.assertNotNull((String)"Didn't get exception", (Object)((Object)expectedException));
            Assert.assertEquals((String)"Got wrong message code", (Object)ErrorMsg.TXN_ABORTED, (Object)expectedException.getCanonicalErrorMsg());
            Assert.assertEquals((String)"Exception msg didn't match", (Object)"Aborting [txnid:7,7] due to a write conflict on default/target/p=1/q=2 committed by [txnid:6,7] u/u", (Object)expectedException.getCause().getMessage());
        } else {
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnid2 + " and \"WS_OPERATION_TYPE\"='u'")));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TestTxnDbUtil.queryToString((Configuration)conf, (String)"select * from \"WRITE_SET\"")), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from \"WRITE_SET\" where \"WS_TXNID\"=" + txnid2)));
        }
        this.dropTable(new String[]{"target", "source"});
    }

    @Test
    public void testShowTablesLock() throws Exception {
        this.dropTable(new String[]{"T", "T2"});
        this.driver.run("create table T (a int, b int)");
        this.txnMgr.openTxn(this.ctx, "Fifer");
        this.driver.compileAndRespond("insert into T values(1,3)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t", null, locks);
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "Fidler");
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver.compileAndRespond("show tables", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Fidler");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks);
        this.txnMgr.commitTxn();
        txnMgr2.rollbackTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks((HiveTxnManager)txnMgr2).size());
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.driver.run("create table T2 (a int, b int) partitioned by (p int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.driver.compileAndRespond("insert into T2 partition(p=1) values(1,3)", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t2", "p=1", locks);
        txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "Fidler");
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.driver.compileAndRespond("show tables", true);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Fidler", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t2", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks);
        this.txnMgr.commitTxn();
        txnMgr2.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks((HiveTxnManager)txnMgr2).size());
    }

    @Test
    public void testFairness() throws Exception {
        this.testFairness(false);
    }

    @Test
    public void testFairnessZeroWaitRead() throws Exception {
        this.testFairness(true);
    }

    private void testFairness(boolean zeroWaitRead) throws Exception {
        this.dropTable(new String[]{"T6"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !zeroWaitRead);
        this.driver.run("create table if not exists T6(a int)");
        this.driver.compileAndRespond("select a from T6", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("drop table if exists T6", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks);
        long extLockId = TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks).getLockid();
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr3);
        this.driver.compileAndRespond("select a from T6", true);
        try {
            ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "Fifer", false);
        }
        catch (LockException ex) {
            Assert.assertTrue((boolean)zeroWaitRead);
            Assert.assertEquals((String)"Exception msg didn't match", (Object)(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg() + " LockResponse(lockid:" + (extLockId + 1L) + ", state:NOT_ACQUIRED, errorMessage:Unable to acquire read lock due to an exclusive lock {lockid:" + extLockId + " intLockId:1 txnid:" + txnMgr2.getCurrentTxnId() + " db:default table:t6 partition:null state:WAITING type:EXCLUSIVE})"), (Object)ex.getMessage());
        }
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)(zeroWaitRead ? 2 : 3), (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks);
        if (!zeroWaitRead) {
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T6", null, locks);
        }
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks);
    }

    @Test
    public void testFairness2() throws Exception {
        this.testFairness2(false);
    }

    @Test
    public void testFairness2ZeroWaitRead() throws Exception {
        this.testFairness2(true);
    }

    private void testFairness2(boolean zeroWaitRead) throws Exception {
        this.dropTable(new String[]{"T7"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !zeroWaitRead);
        this.driver.run("create table if not exists T7 (a int) partitioned by (p int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into T7 partition(p) values(1,1),(1,2)");
        this.driver.compileAndRespond("select a from T7 ", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.driver.compileAndRespond("alter table T7 drop partition (p=1)", true);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=2", locks);
        long extLockId = TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T7", "p=1", locks).getLockid();
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr3);
        this.driver.compileAndRespond("select a from T7", true);
        try {
            ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "Fifer", false);
        }
        catch (LockException ex) {
            Assert.assertTrue((boolean)zeroWaitRead);
            Assert.assertEquals((String)"Exception msg didn't match", (Object)(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg() + " LockResponse(lockid:" + (extLockId + 1L) + ", state:NOT_ACQUIRED, errorMessage:Unable to acquire read lock due to an exclusive lock {lockid:" + extLockId + " intLockId:1 txnid:" + txnMgr2.getCurrentTxnId() + " db:default table:t7 partition:p=1 state:WAITING type:EXCLUSIVE})"), (Object)ex.getMessage());
        }
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)(zeroWaitRead ? 3 : 5), (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=2", locks);
        if (!zeroWaitRead) {
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=1", locks);
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=2", locks);
        }
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T7", "p=1", locks);
        this.txnMgr.commitTxn();
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(zeroWaitRead ? 2 : 4).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)(zeroWaitRead ? 1 : 3), (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        if (!zeroWaitRead) {
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=1", locks);
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=2", locks);
            txnMgr2.rollbackTxn();
            ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(1).getLockid());
            locks = this.getLocks();
            Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=1", locks);
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=2", locks);
        } else {
            txnMgr2.rollbackTxn();
        }
        txnMgr3.rollbackTxn();
        this.dropTable(new String[]{"T7"});
    }

    @Test
    public void testValidWriteIdListSnapshot() throws Exception {
        this.dropTable(new String[]{"temp.T7"});
        this.driver.run("create database if not exists temp");
        this.driver.run("create table if not exists temp.T7(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        long baseTxnId = this.txnMgr.openTxn(this.ctx, "u0");
        long baseWriteId = this.txnMgr.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)1L, (long)baseWriteId);
        this.txnMgr.commitTxn();
        HiveTxnManager txnMgr1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        long underHwmOpenTxnId = txnMgr1.openTxn(this.ctx, "u1");
        Assert.assertTrue((String)"Invalid txn ID", (underHwmOpenTxnId > baseTxnId ? 1 : 0) != 0);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        long testTxnId = txnMgr2.openTxn(this.ctx, "u2");
        Assert.assertTrue((String)"Invalid txn ID", (testTxnId > underHwmOpenTxnId ? 1 : 0) != 0);
        String testValidTxns = txnMgr2.getValidTxns().toString();
        ValidWriteIdList testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)baseWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        long aboveHwmOpenTxnId = txnMgr3.openTxn(this.ctx, "u3");
        Assert.assertTrue((String)"Invalid txn ID", (aboveHwmOpenTxnId > testTxnId ? 1 : 0) != 0);
        long aboveHwmOpenWriteId = txnMgr3.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)2L, (long)aboveHwmOpenWriteId);
        long underHwmOpenWriteId = txnMgr1.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)3L, (long)underHwmOpenWriteId);
        testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)underHwmOpenWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(underHwmOpenWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(aboveHwmOpenWriteId));
        txnMgr1.commitTxn();
        testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)underHwmOpenWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(underHwmOpenWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(aboveHwmOpenWriteId));
        long testWriteId = txnMgr2.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)4L, (long)testWriteId);
        testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)testWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(testWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(underHwmOpenWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(aboveHwmOpenWriteId));
        txnMgr2.commitTxn();
        txnMgr3.commitTxn();
        this.driver.run("drop database if exists temp cascade");
    }

    @Test
    public void testValidTxnList() throws Exception {
        long readTxnId = this.txnMgr.openTxn(this.ctx, "u0", TxnType.READ_ONLY);
        HiveTxnManager txnManager1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnManager1.openTxn(this.ctx, "u0");
        ValidTxnList validTxns = txnManager1.getValidTxns();
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        validTxns = txnManager1.getValidTxns(Arrays.asList(TxnType.REPL_CREATED));
        Assert.assertEquals((long)1L, (long)validTxns.getInvalidTransactions().length);
        Assert.assertEquals((long)readTxnId, (long)validTxns.getInvalidTransactions()[0]);
        txnManager1.commitTxn();
        this.txnMgr.commitTxn();
        long replTxnId = this.txnMgr.openTxn(this.ctx, "u0", TxnType.REPL_CREATED);
        txnManager1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnManager1.openTxn(this.ctx, "u0");
        validTxns = txnManager1.getValidTxns();
        Assert.assertEquals((long)1L, (long)validTxns.getInvalidTransactions().length);
        Assert.assertEquals((long)replTxnId, (long)validTxns.getInvalidTransactions()[0]);
        validTxns = txnManager1.getValidTxns(Arrays.asList(TxnType.REPL_CREATED));
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        validTxns = txnManager1.getValidTxns(Arrays.asList(TxnType.READ_ONLY));
        Assert.assertEquals((long)1L, (long)validTxns.getInvalidTransactions().length);
        Assert.assertEquals((long)replTxnId, (long)validTxns.getInvalidTransactions()[0]);
        this.txnMgr.commitTxn();
        validTxns = txnManager1.getValidTxns();
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        validTxns = txnManager1.getValidTxns(Arrays.asList(TxnType.READ_ONLY));
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        txnManager1.commitTxn();
    }

    @Test
    public void testAddPartitionLocks() throws Exception {
        this.dropTable(new String[]{"T", "Tstage"});
        this.driver.run("create table T (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true')");
        this.driver.run("create table Tstage (a int, b int)  clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='false')");
        this.driver.run("insert into Tstage values(0,2),(1,4)");
        String exportLoc = this.exportFolder.newFolder("1").toString();
        this.driver.run("export table Tstage to '" + exportLoc + "'");
        this.driver.compileAndRespond("ALTER TABLE T ADD if not exists PARTITION (p=0) location '" + exportLoc + "/data'", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T", null, locks);
    }

    @Test
    public void testLoadData() throws Exception {
        this.testLoadData(false);
    }

    @Test
    public void testLoadDataSharedWrite() throws Exception {
        this.testLoadData(true);
    }

    private void testLoadData(boolean sharedWrite) throws Exception {
        this.dropTable(new String[]{"T2"});
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, !sharedWrite);
        this.driver.run("create table T2(a int) stored as ORC TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into T2 values(1)");
        String exportLoc = this.exportFolder.newFolder("1").toString();
        this.driver.run("export table T2 to '" + exportLoc + "/2'");
        this.driver.compileAndRespond("load data inpath '" + exportLoc + "/2/data' overwrite into table T2");
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(sharedWrite ? LockType.EXCL_WRITE : LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T2", null, locks);
        this.txnMgr.commitTxn();
    }

    @Test
    public void testMmConversionLocks() throws Exception {
        this.dropTable(new String[]{"T"});
        this.driver.run("create table T (a int, b int) tblproperties('transactional'='false')");
        this.driver.run("insert into T values(0,2),(1,4)");
        this.driver.compileAndRespond("ALTER TABLE T set tblproperties('transactional'='true', 'transactional_properties'='insert_only')", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T", null, locks);
    }

    @Test
    public void testTruncateWithBaseLockingExlWrite() throws Exception {
        this.testTruncate(true);
    }

    @Test
    public void testTruncateWithExl() throws Exception {
        this.testTruncate(false);
    }

    private void testTruncate(boolean useBaseDir) throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRUNCATE_ACID_USE_BASE, (boolean)useBaseDir);
        this.dropTable(new String[]{"T"});
        this.driver.run("create table T (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.driver.run("insert into T values(0,2),(1,4)");
        this.driver.run("truncate table T");
        this.driver.compileAndRespond("truncate table T");
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(useBaseDir ? LockType.EXCL_WRITE : LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T", null, locks);
        this.txnMgr.commitTxn();
        this.dropTable(new String[]{"T"});
    }

    @Test
    public void testAnalyze() throws Exception {
        this.dropTable(new String[]{"tab_acid", "tab_not_acid"});
        this.driver.run("create table tab_not_acid (key string, value string) partitioned by (ds string, hr string) stored as textfile");
        this.driver.run("insert into tab_not_acid partition (ds='2008-04-08', hr='11') values ('238', 'val_238')");
        this.driver.run("analyze table tab_not_acid PARTITION (ds, hr) compute statistics");
        this.driver.run("create table tab_acid (key string, value string) partitioned by (ds string, hr string) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("insert into tab_acid PARTITION (ds, hr) select * from tab_not_acid");
        this.driver.run("analyze table tab_acid PARTITION (ds, hr) compute statistics");
        this.driver.compileAndRespond("analyze table tab_not_acid PARTITION(ds, hr) compute statistics", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "dummy");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "ds=2008-04-08/hr=11", locks);
        this.txnMgr.commitTxn();
        this.driver.compileAndRespond("analyze table tab_acid PARTITION(ds, hr) compute statistics");
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "dummy");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "ds=2008-04-08/hr=11", locks);
    }

    @Test
    public void testFullTableReadLock() throws Exception {
        this.dropTable(new String[]{"tab_acid", "tab_not_acid"});
        conf.setIntVar(HiveConf.ConfVars.HIVE_LOCKS_PARTITION_THRESHOLD, 2);
        this.driver.run("create table if not exists tab_acid (a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.driver.run("create table if not exists tab_not_acid (na int, nb int) partitioned by (np string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.driver.run("insert into tab_acid partition(p) (a,b,p) values(1,2,'foo'),(3,4,'bar')");
        this.driver.run("insert into tab_not_acid partition(np) (na,nb,np) values(1,2,'blah'),(3,4,'doh')");
        this.driver.compileAndRespond("select * from tab_acid inner join tab_not_acid on a = na", true);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
    }
}

