/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClientWithLocalCache;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class DbTxnManagerEndToEndTestBase {
    protected static HiveConf conf = new HiveConf(Driver.class);
    protected HiveTxnManager txnMgr;
    protected Context ctx;
    protected Driver driver;
    protected Driver driver2;
    protected TxnStore txnHandler;

    public DbTxnManagerEndToEndTestBase() {
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        conf.setBoolVar(HiveConf.ConfVars.TXN_MERGE_INSERT_X_LOCK, true);
        TestTxnDbUtil.setConfValues((Configuration)conf);
    }

    @BeforeClass
    public static void setUpDB() throws Exception {
        TestTxnDbUtil.prepDb((Configuration)conf);
    }

    @Before
    public void setUp() throws Exception {
        if (conf.getBoolVar(HiveConf.ConfVars.MSC_CACHE_ENABLED)) {
            HiveMetaStoreClientWithLocalCache.init((Configuration)conf);
        }
        SessionState.start((HiveConf)conf);
        this.ctx = new Context((Configuration)conf);
        this.driver = new Driver(new QueryState.Builder().withHiveConf(conf).nonIsolated().build());
        this.driver2 = new Driver(new QueryState.Builder().withHiveConf(conf).build());
        conf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, false);
        TestTxnDbUtil.cleanDb((Configuration)conf);
        SessionState ss = SessionState.get();
        ss.initTxnMgr(conf);
        this.txnMgr = ss.getTxnMgr();
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
        this.txnHandler = TxnUtils.getTxnStore((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        this.driver.close();
        this.driver2.close();
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
    }
}

