/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.junit.Test;

public class TestSearchArgumentImpl {
    private ExpressionTree not(ExpressionTree arg) {
        return new ExpressionTree(ExpressionTree.Operator.NOT, new ExpressionTree[]{arg});
    }

    private ExpressionTree and(ExpressionTree ... arg) {
        return new ExpressionTree(ExpressionTree.Operator.AND, arg);
    }

    private ExpressionTree or(ExpressionTree ... arg) {
        return new ExpressionTree(ExpressionTree.Operator.OR, arg);
    }

    private static ExpressionTree leaf(int id) {
        SearchArgumentImpl.PredicateLeafImpl result = new SearchArgumentImpl.PredicateLeafImpl(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.LONG, "x", (Object)id, null);
        result.setId(id);
        return new ExpressionTree((PredicateLeaf)result);
    }

    private ExpressionTree constant(SearchArgument.TruthValue val) {
        return new ExpressionTree(val);
    }

    public static PredicateLeaf createPredicateLeaf(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal, List<Object> literalList) {
        return new SearchArgumentImpl.PredicateLeafImpl(operator, type, columnName, literal, literalList, null);
    }

    @Test
    public void testNotPushdown() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)TestSearchArgumentImpl.leaf(1)).toOldString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(TestSearchArgumentImpl.leaf(1))).toOldString());
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.not(TestSearchArgumentImpl.leaf(1)))).toOldString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.not(this.not(TestSearchArgumentImpl.leaf(1))))).toOldString());
        Assert.assertEquals((String)"(or leaf-1 (not leaf-2))", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.and(this.not(TestSearchArgumentImpl.leaf(1)), TestSearchArgumentImpl.leaf(2)))).toOldString());
        Assert.assertEquals((String)"(and (not leaf-1) leaf-2)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.or(TestSearchArgumentImpl.leaf(1), this.not(TestSearchArgumentImpl.leaf(2))))).toOldString());
        Assert.assertEquals((String)"(or (or (not leaf-1) leaf-2) leaf-3)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.or(this.not(this.and(TestSearchArgumentImpl.leaf(1), this.not(TestSearchArgumentImpl.leaf(2)))), this.not(this.not(TestSearchArgumentImpl.leaf(3))))).toOldString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES))).toOldString());
        Assert.assertEquals((String)"YES", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NO))).toOldString());
        Assert.assertEquals((String)"NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NULL))).toOldString());
        Assert.assertEquals((String)"YES_NO", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NO))).toOldString());
        Assert.assertEquals((String)"YES_NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NO_NULL))).toOldString());
        Assert.assertEquals((String)"NO_NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NULL))).toOldString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toOldString());
    }

    @Test
    public void testFlatten() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)TestSearchArgumentImpl.leaf(1)).toOldString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.constant(SearchArgument.TruthValue.NO)).toString());
        Assert.assertEquals((String)"(not (not leaf-1))", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.not(this.not(TestSearchArgumentImpl.leaf(1)))).toOldString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2))).toOldString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-2) leaf-3)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.or(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), TestSearchArgumentImpl.leaf(3))).toOldString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.and(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), this.and(TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4)))).toOldString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.or(TestSearchArgumentImpl.leaf(1), this.or(TestSearchArgumentImpl.leaf(2), this.or(TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4))))).toOldString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.or(this.or(this.or(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), TestSearchArgumentImpl.leaf(3)), TestSearchArgumentImpl.leaf(4))).toOldString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4 leaf-5 leaf-6)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.or(this.or(TestSearchArgumentImpl.leaf(1), this.or(TestSearchArgumentImpl.leaf(2), TestSearchArgumentImpl.leaf(3))), this.or(this.or(TestSearchArgumentImpl.leaf(4), TestSearchArgumentImpl.leaf(5)), TestSearchArgumentImpl.leaf(6)))).toOldString());
        Assert.assertEquals((String)"(and (not leaf-1) leaf-2 (not leaf-3) leaf-4 (not leaf-5) leaf-6)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.and(this.not(TestSearchArgumentImpl.leaf(1)), this.and(TestSearchArgumentImpl.leaf(2), this.not(TestSearchArgumentImpl.leaf(3)))), this.and(this.and(TestSearchArgumentImpl.leaf(4), this.not(TestSearchArgumentImpl.leaf(5))), TestSearchArgumentImpl.leaf(6)))).toOldString());
        Assert.assertEquals((String)"(not (and leaf-1 leaf-2 leaf-3))", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.not(this.and(TestSearchArgumentImpl.leaf(1), this.and(TestSearchArgumentImpl.leaf(2), TestSearchArgumentImpl.leaf(3))))).toOldString());
    }

    @Test
    public void testFoldMaybe() throws Exception {
        Assert.assertEquals((String)"(and leaf-1)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(TestSearchArgumentImpl.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toOldString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(TestSearchArgumentImpl.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL), TestSearchArgumentImpl.leaf(2))).toOldString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.constant(SearchArgument.TruthValue.YES_NO_NULL), TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toOldString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toOldString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.or(TestSearchArgumentImpl.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toOldString());
        Assert.assertEquals((String)"(or leaf-1 (and leaf-2))", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.or(TestSearchArgumentImpl.leaf(1), this.and(TestSearchArgumentImpl.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL)))).toOldString());
        Assert.assertEquals((String)"(and leaf-1)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.or(TestSearchArgumentImpl.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL)), TestSearchArgumentImpl.leaf(1))).toOldString());
        Assert.assertEquals((String)"(and leaf-100)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(TestSearchArgumentImpl.leaf(100), this.or(this.and(TestSearchArgumentImpl.leaf(0), TestSearchArgumentImpl.leaf(1)), this.and(TestSearchArgumentImpl.leaf(2), TestSearchArgumentImpl.leaf(3)), this.and(TestSearchArgumentImpl.leaf(4), TestSearchArgumentImpl.leaf(5)), this.and(TestSearchArgumentImpl.leaf(6), TestSearchArgumentImpl.leaf(7)), this.and(TestSearchArgumentImpl.leaf(8), TestSearchArgumentImpl.leaf(9)), this.and(TestSearchArgumentImpl.leaf(10), TestSearchArgumentImpl.leaf(11)), this.and(TestSearchArgumentImpl.leaf(12), TestSearchArgumentImpl.leaf(13)), this.and(TestSearchArgumentImpl.leaf(14), TestSearchArgumentImpl.leaf(15)), this.and(TestSearchArgumentImpl.leaf(16), TestSearchArgumentImpl.leaf(17)))))).toOldString());
    }

    @Test
    public void testCNF() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)TestSearchArgumentImpl.leaf(1)).toOldString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.constant(SearchArgument.TruthValue.NO)).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.not(TestSearchArgumentImpl.leaf(1))).toOldString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2))).toOldString());
        Assert.assertEquals((String)"(or (not leaf-1) leaf-2)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.not(TestSearchArgumentImpl.leaf(1)), TestSearchArgumentImpl.leaf(2))).toOldString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-2) (not leaf-3))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(this.or(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), this.not(TestSearchArgumentImpl.leaf(3)))).toOldString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-3) (or leaf-2 leaf-3) (or leaf-1 leaf-4) (or leaf-2 leaf-4))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), this.and(TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4)))).toOldString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-5) (or leaf-2 leaf-5) (or leaf-3 leaf-5) (or leaf-4 leaf-5) (or leaf-1 leaf-6) (or leaf-2 leaf-6) (or leaf-3 leaf-6) (or leaf-4 leaf-6))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2), TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4)), this.and(TestSearchArgumentImpl.leaf(5), TestSearchArgumentImpl.leaf(6)))).toOldString());
        Assert.assertEquals((String)"(and (or leaf-5 leaf-6 (not leaf-7) leaf-1 leaf-3) (or leaf-5 leaf-6 (not leaf-7) leaf-2 leaf-3) (or leaf-5 leaf-6 (not leaf-7) leaf-1 leaf-4) (or leaf-5 leaf-6 (not leaf-7) leaf-2 leaf-4))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), this.and(TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4)), this.or(TestSearchArgumentImpl.leaf(5), TestSearchArgumentImpl.leaf(6)), this.not(TestSearchArgumentImpl.leaf(7)))).toOldString());
        Assert.assertEquals((String)"(and (or leaf-8 leaf-0 leaf-3 leaf-6) (or leaf-8 leaf-1 leaf-3 leaf-6) (or leaf-8 leaf-2 leaf-3 leaf-6) (or leaf-8 leaf-0 leaf-4 leaf-6) (or leaf-8 leaf-1 leaf-4 leaf-6) (or leaf-8 leaf-2 leaf-4 leaf-6) (or leaf-8 leaf-0 leaf-5 leaf-6) (or leaf-8 leaf-1 leaf-5 leaf-6) (or leaf-8 leaf-2 leaf-5 leaf-6) (or leaf-8 leaf-0 leaf-3 leaf-7) (or leaf-8 leaf-1 leaf-3 leaf-7) (or leaf-8 leaf-2 leaf-3 leaf-7) (or leaf-8 leaf-0 leaf-4 leaf-7) (or leaf-8 leaf-1 leaf-4 leaf-7) (or leaf-8 leaf-2 leaf-4 leaf-7) (or leaf-8 leaf-0 leaf-5 leaf-7) (or leaf-8 leaf-1 leaf-5 leaf-7) (or leaf-8 leaf-2 leaf-5 leaf-7))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(TestSearchArgumentImpl.leaf(0), TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), this.and(TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4), TestSearchArgumentImpl.leaf(5)), this.and(TestSearchArgumentImpl.leaf(6), TestSearchArgumentImpl.leaf(7)), TestSearchArgumentImpl.leaf(8))).toOldString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(TestSearchArgumentImpl.leaf(0), TestSearchArgumentImpl.leaf(1)), this.and(TestSearchArgumentImpl.leaf(2), TestSearchArgumentImpl.leaf(3)), this.and(TestSearchArgumentImpl.leaf(4), TestSearchArgumentImpl.leaf(5)), this.and(TestSearchArgumentImpl.leaf(6), TestSearchArgumentImpl.leaf(7)), this.and(TestSearchArgumentImpl.leaf(8), TestSearchArgumentImpl.leaf(9)), this.and(TestSearchArgumentImpl.leaf(10), TestSearchArgumentImpl.leaf(11)), this.and(TestSearchArgumentImpl.leaf(12), TestSearchArgumentImpl.leaf(13)), this.and(TestSearchArgumentImpl.leaf(14), TestSearchArgumentImpl.leaf(15)), this.and(TestSearchArgumentImpl.leaf(16), TestSearchArgumentImpl.leaf(17)))).toString());
        Assert.assertEquals((String)"(and leaf-100 YES_NO_NULL)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(TestSearchArgumentImpl.leaf(100), this.or(this.and(TestSearchArgumentImpl.leaf(0), TestSearchArgumentImpl.leaf(1)), this.and(TestSearchArgumentImpl.leaf(2), TestSearchArgumentImpl.leaf(3)), this.and(TestSearchArgumentImpl.leaf(4), TestSearchArgumentImpl.leaf(5)), this.and(TestSearchArgumentImpl.leaf(6), TestSearchArgumentImpl.leaf(7)), this.and(TestSearchArgumentImpl.leaf(8), TestSearchArgumentImpl.leaf(9)), this.and(TestSearchArgumentImpl.leaf(10), TestSearchArgumentImpl.leaf(11)), this.and(TestSearchArgumentImpl.leaf(12), TestSearchArgumentImpl.leaf(13)), this.and(TestSearchArgumentImpl.leaf(14), TestSearchArgumentImpl.leaf(15)), this.and(TestSearchArgumentImpl.leaf(16), TestSearchArgumentImpl.leaf(17))))).toOldString());
        TestSearchArgumentImpl.assertNoSharedNodes(SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(TestSearchArgumentImpl.leaf(0), TestSearchArgumentImpl.leaf(1), TestSearchArgumentImpl.leaf(2)), this.and(TestSearchArgumentImpl.leaf(3), TestSearchArgumentImpl.leaf(4), TestSearchArgumentImpl.leaf(5)), this.and(TestSearchArgumentImpl.leaf(6), TestSearchArgumentImpl.leaf(7)), TestSearchArgumentImpl.leaf(8))), Sets.newIdentityHashSet());
    }

    private static void assertNoSharedNodes(ExpressionTree tree, Set<ExpressionTree> seen) throws Exception {
        if (seen.contains(tree) && tree.getOperator() != ExpressionTree.Operator.LEAF) {
            Assert.assertTrue((String)("repeated node in expression " + tree), (boolean)false);
        }
        seen.add(tree);
        if (tree.getChildren() != null) {
            for (ExpressionTree child : tree.getChildren()) {
                TestSearchArgumentImpl.assertNoSharedNodes(child, seen);
            }
        }
    }

    @Test
    public void testBuilder() throws Exception {
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)10L).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)"hi").equals("z", PredicateLeaf.Type.FLOAT, (Object)1.0).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 10), leaf-1 = (LESS_THAN_EQUALS y hi), leaf-2 = (EQUALS z 1.0), expr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toOldString());
        sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.LONG, (Object)10L, (Object)20L).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)"stinger").end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x), leaf-1 = (BETWEEN y 10 20), leaf-2 = (IN z 1 2 3), leaf-3 = (NULL_SAFE_EQUALS a stinger), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toOldString());
    }

    @Test
    public void testBuilderComplexTypes() throws Exception {
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("1970-1-11")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 1970-01-11), leaf-1 = (LESS_THAN_EQUALS y hi        ), leaf-2 = (EQUALS z 1), expr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toOldString());
        sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x), leaf-1 = (BETWEEN y 10 20), leaf-2 = (IN z 1 2 3), leaf-3 = (NULL_SAFE_EQUALS a stinger), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toOldString());
    }

    @Test
    public void testBuilderComplexTypes2() throws Exception {
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("2005-3-12")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 2005-03-12), leaf-1 = (LESS_THAN_EQUALS y hi        ), leaf-2 = (EQUALS z 1), expr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toOldString());
        sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x), leaf-1 = (BETWEEN y 10 20), leaf-2 = (IN z 1 2 3), leaf-3 = (NULL_SAFE_EQUALS a stinger), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toOldString());
    }

    @Test
    public void testBuilderFloat() throws Exception {
        SearchArgumentImpl sarg = (SearchArgumentImpl)SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)22L).lessThan("x1", PredicateLeaf.Type.LONG, (Object)22L).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.FLOAT, (Object)0.22).equals("z1", PredicateLeaf.Type.FLOAT, (Object)0.22).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 22), leaf-1 = (LESS_THAN x1 22), leaf-2 = (LESS_THAN_EQUALS y hi        ), leaf-3 = (EQUALS z 0.22), leaf-4 = (EQUALS z1 0.22), expr = (and leaf-0 leaf-1 leaf-2 leaf-3 leaf-4)", (String)sarg.toOldString());
    }

    @Test
    public void testTimestampSerialization() throws Exception {
        Timestamp now = new Timestamp(new java.util.Date().getTime());
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.TIMESTAMP, (Object)now).end().build();
        String serializedSarg = ConvertAstToSearchArg.sargToKryo((SearchArgument)sarg);
        SearchArgument sarg2 = ConvertAstToSearchArg.create((String)serializedSarg);
        Field literalField = SearchArgumentImpl.PredicateLeafImpl.class.getDeclaredField("literal");
        literalField.setAccessible(true);
        Assert.assertTrue((boolean)(literalField.get(sarg2.getLeaves().get(0)) instanceof java.util.Date));
        Timestamp ts = (Timestamp)((PredicateLeaf)sarg2.getLeaves().get(0)).getLiteral();
        Assert.assertEquals((Object)ts, (Object)now);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadLiteral() throws Exception {
        SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)"hi").end().build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadLiteralList() throws Exception {
        SearchArgumentFactory.newBuilder().startAnd().in("x", PredicateLeaf.Type.STRING, new Object[]{"hi", 23}).end().build();
    }
}

