/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.protobuf.ProtobufBytesWritableSerDe;
import org.apache.hadoop.hive.ql.io.protobuf.ProtobufMessageSerDe;
import org.apache.hadoop.hive.ql.io.protobuf.ProtobufSerDe;
import org.apache.hadoop.hive.ql.io.protobuf.SampleProtos;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestProtoMessageSerDe {
    private static ObjectInspector stroi = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    private static ObjectInspector intoi = PrimitiveObjectInspectorFactory.javaIntObjectInspector;
    private static ObjectInspector strmapoi = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)stroi, (ObjectInspector)stroi);
    private static ObjectInspector mfoi = TestProtoMessageSerDe.structoi(TestProtoMessageSerDe.list("key", "value"), TestProtoMessageSerDe.list(stroi, stroi));
    private static ObjectInspector m1oi = TestProtoMessageSerDe.structoi(TestProtoMessageSerDe.list("anotherMap", "noMap", "intList"), TestProtoMessageSerDe.list(strmapoi, mfoi, TestProtoMessageSerDe.listoi(intoi)));
    private ProtobufSerDe serde;
    private Configuration conf = new Configuration(false);

    private <T extends Message> ProtoMessageWritable<T> init(Class<T> clazz, String mapTypes) throws Exception {
        this.serde = new ProtobufMessageSerDe();
        Properties tbl = new Properties();
        tbl.setProperty("proto.class", clazz.getName());
        tbl.setProperty("proto.maptypes", mapTypes);
        this.serde.initialize(this.conf, tbl, null);
        Constructor cons = ProtoMessageWritable.class.getDeclaredConstructor(Parser.class);
        cons.setAccessible(true);
        return (ProtoMessageWritable)cons.newInstance((Parser)clazz.getField("PARSER").get(null));
    }

    private SampleProtos.MapFieldEntry makeMap(int i) {
        return SampleProtos.MapFieldEntry.newBuilder().setKey("key" + i).setValue("val" + i).build();
    }

    private SampleProtos.Mesg1 makeMesg1(int start) {
        return SampleProtos.Mesg1.newBuilder().addAnotherMap(this.makeMap(start + 1)).addAnotherMap(this.makeMap(start + 2)).setNoMap(this.makeMap(start + 3)).addIntList(start + 4).addIntList(start + 5).build();
    }

    @Test
    public void testSimpleMessage() throws Exception {
        ProtoMessageWritable<SampleProtos.MapFieldEntry> writable = this.init(SampleProtos.MapFieldEntry.class, " MapFieldEntry     , Invalid  ");
        Assert.assertEquals((Object)mfoi, (Object)this.serde.getObjectInspector());
        writable.setMessage((MessageLite)SampleProtos.MapFieldEntry.getDefaultInstance());
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(null, null), (Object[])((Object[])this.serde.deserialize(writable)));
        SampleProtos.MapFieldEntry proto = this.makeMap(1);
        writable.setMessage((MessageLite)proto);
        Object obj = this.serde.deserialize(writable);
        Assert.assertTrue((boolean)(obj instanceof Object[]));
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(proto.getKey(), proto.getValue()), (Object[])((Object[])obj));
    }

    @Test
    public void testMapAndList() throws Exception {
        ProtoMessageWritable<SampleProtos.Mesg1> writable = this.init(SampleProtos.Mesg1.class, "MapFieldEntry,Invalid");
        Assert.assertEquals((Object)m1oi, (Object)this.serde.getObjectInspector());
        writable.setMessage((MessageLite)SampleProtos.Mesg1.getDefaultInstance());
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(null, null, null), (Object[])((Object[])this.serde.deserialize(writable)));
        SampleProtos.Mesg1 proto = this.makeMesg1(0);
        writable.setMessage((MessageLite)proto);
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(TestProtoMessageSerDe.map("key1", "val1", "key2", "val2"), TestProtoMessageSerDe.arr("key3", "val3"), TestProtoMessageSerDe.arr(4, 5)), (Object[])((Object[])this.serde.deserialize(writable)));
    }

    @Test
    public void testMapAndListNoMapConfigured() throws Exception {
        ProtoMessageWritable<SampleProtos.Mesg1> writable = this.init(SampleProtos.Mesg1.class, "");
        Assert.assertEquals((Object)TestProtoMessageSerDe.structoi(TestProtoMessageSerDe.list("anotherMap", "noMap", "intList"), TestProtoMessageSerDe.list(TestProtoMessageSerDe.listoi(mfoi), mfoi, TestProtoMessageSerDe.listoi(intoi))), (Object)this.serde.getObjectInspector());
        writable.setMessage((MessageLite)SampleProtos.Mesg1.getDefaultInstance());
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(null, null, null), (Object[])((Object[])this.serde.deserialize(writable)));
        SampleProtos.Mesg1 proto = this.makeMesg1(0);
        writable.setMessage((MessageLite)proto);
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(TestProtoMessageSerDe.arr(TestProtoMessageSerDe.arr("key1", "val1"), TestProtoMessageSerDe.arr("key2", "val2")), TestProtoMessageSerDe.arr("key3", "val3"), TestProtoMessageSerDe.arr(4, 5)), (Object[])((Object[])this.serde.deserialize(writable)));
    }

    @Test
    public void testAll() throws Exception {
        ProtoMessageWritable<SampleProtos.AllTypes> writable = this.init(SampleProtos.AllTypes.class, "MapFieldEntry");
        ObjectInspector oi = TestProtoMessageSerDe.structoi(TestProtoMessageSerDe.list("doubleType", "floatType", "int32Type", "int64Type", "uint32Type", "uint64Type", "sint32Type", "sint64Type", "fixed32Type", "fixed64Type", "sfixed32Type", "sfixed64Type", "boolType", "stringType", "bytesType", "mapType", "stringListType", "messageType", "messageListType", "enumType"), TestProtoMessageSerDe.list(PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, PrimitiveObjectInspectorFactory.javaFloatObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, strmapoi, TestProtoMessageSerDe.listoi(stroi), m1oi, TestProtoMessageSerDe.listoi(m1oi), stroi));
        Assert.assertEquals((Object)oi, (Object)this.serde.getObjectInspector());
        writable.setMessage((MessageLite)SampleProtos.AllTypes.getDefaultInstance());
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), (Object[])((Object[])this.serde.deserialize(writable)));
        SampleProtos.AllTypes proto = SampleProtos.AllTypes.newBuilder().setDoubleType(1.0).setFloatType(2.0f).setInt32Type(3).setInt64Type(4L).setUint32Type(5).setUint64Type(6L).setSint32Type(7).setSint64Type(8L).setFixed32Type(9).setFixed64Type(10L).setSfixed32Type(11).setSfixed64Type(12L).setBoolType(true).setStringType("val13").setBytesType(ByteString.copyFrom((byte[])new byte[]{14, 15})).addMapType(this.makeMap(16)).addMapType(this.makeMap(17)).addStringListType("val18").addStringListType("val19").setMessageType(this.makeMesg1(19)).addMessageListType(this.makeMesg1(24)).addMessageListType(this.makeMesg1(29)).setEnumType(SampleProtos.AllTypes.Enum1.VAL1).build();
        writable.setMessage((MessageLite)proto);
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(1.0, Float.valueOf(2.0f), 3, 4L, 5, 6L, 7, 8L, 9, 10L, 11, 12L, true, "val13", new byte[]{14, 15}, TestProtoMessageSerDe.map("key16", "val16", "key17", "val17"), TestProtoMessageSerDe.arr("val18", "val19"), TestProtoMessageSerDe.arr(TestProtoMessageSerDe.map("key20", "val20", "key21", "val21"), TestProtoMessageSerDe.arr("key22", "val22"), TestProtoMessageSerDe.arr(23, 24)), TestProtoMessageSerDe.arr(TestProtoMessageSerDe.arr(TestProtoMessageSerDe.map("key25", "val25", "key26", "val26"), TestProtoMessageSerDe.arr("key27", "val27"), TestProtoMessageSerDe.arr(28, 29)), TestProtoMessageSerDe.arr(TestProtoMessageSerDe.map("key30", "val30", "key31", "val31"), TestProtoMessageSerDe.arr("key32", "val32"), TestProtoMessageSerDe.arr(33, 34))), "VAL1"), (Object[])((Object[])this.serde.deserialize(writable)));
    }

    @Test
    public void testBytesWritable() throws Exception {
        this.serde = new ProtobufBytesWritableSerDe();
        Properties tbl = new Properties();
        tbl.setProperty("proto.class", SampleProtos.MapFieldEntry.class.getName());
        tbl.setProperty("proto.maptypes", "MapFieldEntry");
        this.serde.initialize(this.conf, tbl, null);
        Assert.assertEquals((Object)mfoi, (Object)this.serde.getObjectInspector());
        BytesWritable writable = new BytesWritable(SampleProtos.MapFieldEntry.getDefaultInstance().toByteArray());
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(null, null), (Object[])((Object[])this.serde.deserialize((Writable)writable)));
        SampleProtos.MapFieldEntry proto = this.makeMap(1);
        writable = new BytesWritable(proto.toByteArray());
        Object obj = this.serde.deserialize((Writable)writable);
        Assert.assertTrue((boolean)(obj instanceof Object[]));
        Assert.assertArrayEquals((Object[])TestProtoMessageSerDe.arr(proto.getKey(), proto.getValue()), (Object[])((Object[])obj));
    }

    private static ObjectInspector structoi(List<String> names, List<ObjectInspector> ois) {
        return ObjectInspectorFactory.getStandardStructObjectInspector(names, ois);
    }

    private static ObjectInspector listoi(ObjectInspector oi) {
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)oi);
    }

    @SafeVarargs
    private static <T> List<T> list(T ... ts) {
        return Arrays.asList(ts);
    }

    private static Map<String, String> map(String ... s) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < s.length; i += 2) {
            ret.put(s[i], s[i + 1]);
        }
        return ret;
    }

    private static Object[] arr(Object ... objs) {
        return objs;
    }
}

