/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.ParquetTimestampUtils;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.junit.Assert;
import org.junit.Test;

public class TestParquetTimestampUtils {
    public static final ZoneId GMT = ZoneId.of("GMT");
    public static final ZoneId US_PACIFIC = ZoneId.of("US/Pacific");
    public static final ZoneId NEW_YORK = ZoneId.of("America/New_York");

    @Test
    public void testJulianDay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 0);
        Timestamp ts = Timestamp.ofEpochMilli((long)cal.getTimeInMillis());
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts, (boolean)false);
        Assert.assertEquals((long)nt.getJulianDay(), (long)2440000L);
        Timestamp tsFetched = NanoTimeUtils.getTimestamp((NanoTime)nt, (boolean)false);
        Assert.assertEquals((Object)tsFetched, (Object)ts);
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setGregorianChange(new Date(Long.MIN_VALUE));
        cal1.set(1, 2005);
        cal1.set(2, 0);
        cal1.set(5, 1);
        cal1.set(11, 0);
        Timestamp ts1 = Timestamp.ofEpochMilli((long)cal1.getTimeInMillis());
        NanoTime nt1 = NanoTimeUtils.getNanoTime((Timestamp)ts1, (boolean)false);
        Timestamp ts1Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt1, (boolean)false);
        Assert.assertEquals((Object)ts1Fetched, (Object)ts1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal2.setGregorianChange(new Date(Long.MIN_VALUE));
        cal2.set(1, 2005);
        cal2.set(2, 0);
        cal2.set(5, 31);
        cal2.set(11, 0);
        Timestamp ts2 = Timestamp.ofEpochMilli((long)cal2.getTimeInMillis());
        NanoTime nt2 = NanoTimeUtils.getNanoTime((Timestamp)ts2, (boolean)false);
        Timestamp ts2Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt2, (boolean)false);
        Assert.assertEquals((Object)ts2Fetched, (Object)ts2);
        Assert.assertEquals((long)(nt2.getJulianDay() - nt1.getJulianDay()), (long)30L);
        cal1 = new GregorianCalendar();
        cal1.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setGregorianChange(new Date(Long.MIN_VALUE));
        cal1.set(1, 5);
        cal1.set(2, 0);
        cal1.set(5, 1);
        cal1.set(11, 0);
        ts1 = Timestamp.ofEpochMilli((long)cal1.getTimeInMillis());
        nt1 = NanoTimeUtils.getNanoTime((Timestamp)ts1, (boolean)false);
        ts1Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt1, (boolean)false);
        Assert.assertEquals((Object)ts1Fetched, (Object)ts1);
        cal2 = new GregorianCalendar();
        cal2.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal2.setGregorianChange(new Date(Long.MIN_VALUE));
        cal2.set(1, 2005);
        cal2.set(2, 0);
        cal2.set(5, 31);
        cal2.set(11, 0);
        ts2 = Timestamp.ofEpochMilli((long)cal2.getTimeInMillis());
        nt2 = NanoTimeUtils.getNanoTime((Timestamp)ts2, (boolean)false);
        ts2Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt2, (boolean)false);
        Assert.assertEquals((Object)ts2Fetched, (Object)ts2);
        Assert.assertEquals((long)730517L, (long)(nt2.getJulianDay() - nt1.getJulianDay()));
        org.apache.hadoop.hive.common.type.Date d1 = org.apache.hadoop.hive.common.type.Date.ofEpochMilli((long)cal1.getTimeInMillis());
        Assert.assertEquals((Object)"0005-01-01", (Object)d1.toString());
        org.apache.hadoop.hive.common.type.Date d2 = org.apache.hadoop.hive.common.type.Date.ofEpochMilli((long)cal2.getTimeInMillis());
        Assert.assertEquals((Object)"2005-01-31", (Object)d2.toString());
    }

    @Test
    public void testNanos() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 1);
        cal.set(12, 1);
        cal.set(13, 1);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts = Timestamp.ofEpochMilli((long)cal.getTimeInMillis(), (int)1);
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts, (boolean)false, (ZoneId)GMT);
        Assert.assertEquals((long)nt.getTimeOfDayNanos(), (long)3661000000001L);
        cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        ts = Timestamp.ofEpochMilli((long)cal.getTimeInMillis(), (int)999999999);
        nt = NanoTimeUtils.getNanoTime((Timestamp)ts, (boolean)false, (ZoneId)GMT);
        Assert.assertEquals((long)nt.getTimeOfDayNanos(), (long)86399999999999L);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(1, 1968);
        cal2.set(2, 4);
        cal2.set(5, 23);
        cal2.set(11, 0);
        cal2.set(12, 10);
        cal2.set(13, 0);
        cal2.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts2 = Timestamp.ofEpochMilli((long)cal2.getTimeInMillis(), (int)10);
        Calendar cal1 = Calendar.getInstance();
        cal1.set(1, 1968);
        cal1.set(2, 4);
        cal1.set(5, 23);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.setTimeZone(TimeZone.getTimeZone("GMT"));
        Timestamp ts1 = Timestamp.ofEpochMilli((long)cal1.getTimeInMillis(), (int)1);
        NanoTime n2 = NanoTimeUtils.getNanoTime((Timestamp)ts2, (boolean)false, (ZoneId)GMT);
        NanoTime n1 = NanoTimeUtils.getNanoTime((Timestamp)ts1, (boolean)false, (ZoneId)GMT);
        Assert.assertEquals((long)(n2.getTimeOfDayNanos() - n1.getTimeOfDayNanos()), (long)600000000009L);
        NanoTime n3 = new NanoTime(n1.getJulianDay() - 1, n1.getTimeOfDayNanos() + TimeUnit.DAYS.toNanos(1L));
        Assert.assertEquals((Object)ts1, (Object)NanoTimeUtils.getTimestamp((NanoTime)n3, (boolean)false, (ZoneId)GMT, (boolean)false));
        n3 = new NanoTime(n1.getJulianDay() + 3, n1.getTimeOfDayNanos() - TimeUnit.DAYS.toNanos(3L));
        Assert.assertEquals((Object)ts1, (Object)NanoTimeUtils.getTimestamp((NanoTime)n3, (boolean)false, (ZoneId)GMT, (boolean)false));
    }

    @Test
    public void testTimezone() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1968);
        cal.set(2, 4);
        cal.set(5, 23);
        cal.set(11, 17);
        cal.set(12, 1);
        cal.set(13, 1);
        cal.setTimeZone(TimeZone.getTimeZone("US/Pacific"));
        Timestamp ts = Timestamp.ofEpochMilli((long)cal.getTimeInMillis(), (int)1);
        ts = TimestampTZUtil.convertTimestampToZone((Timestamp)ts, (ZoneId)GMT, (ZoneId)US_PACIFIC);
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts, (boolean)false, (ZoneId)US_PACIFIC);
        long timeOfDayNanos = nt.getTimeOfDayNanos();
        Assert.assertTrue((timeOfDayNanos == 61000000001L || timeOfDayNanos == 3661000000001L ? 1 : 0) != 0);
        Assert.assertEquals((long)nt.getJulianDay(), (long)2440001L);
    }

    @Test
    public void testTimezoneValues() {
        this.valueTest(false);
    }

    @Test
    public void testTimezonelessValues() {
        this.valueTest(true);
    }

    @Test
    public void testTimezoneless() {
        Timestamp ts1 = Timestamp.valueOf((String)"2011-01-01 00:30:30.111111111");
        NanoTime nt1 = NanoTimeUtils.getNanoTime((Timestamp)ts1, (boolean)true);
        Assert.assertEquals((long)nt1.getJulianDay(), (long)2455563L);
        Assert.assertEquals((long)nt1.getTimeOfDayNanos(), (long)1830111111111L);
        Timestamp ts1Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt1, (boolean)true);
        Assert.assertEquals((Object)ts1Fetched.toString(), (Object)ts1.toString());
        Timestamp ts2 = Timestamp.valueOf((String)"2011-02-02 08:30:30.222222222");
        NanoTime nt2 = NanoTimeUtils.getNanoTime((Timestamp)ts2, (boolean)true);
        Assert.assertEquals((long)nt2.getJulianDay(), (long)2455595L);
        Assert.assertEquals((long)nt2.getTimeOfDayNanos(), (long)30630222222222L);
        Timestamp ts2Fetched = NanoTimeUtils.getTimestamp((NanoTime)nt2, (boolean)true);
        Assert.assertEquals((Object)ts2Fetched.toString(), (Object)ts2.toString());
    }

    private void valueTest(boolean local) {
        this.verifyTsString("2011-01-01 01:01:01.111111111", local);
        this.verifyTsString("2012-02-02 02:02:02.222222222", local);
        this.verifyTsString("2013-03-03 03:03:03.333333333", local);
        this.verifyTsString("2014-04-04 04:04:04.444444444", local);
        this.verifyTsString("2015-05-05 05:05:05.555555555", local);
        this.verifyTsString("2016-06-06 06:06:06.666666666", local);
        this.verifyTsString("2017-07-07 07:07:07.777777777", local);
        this.verifyTsString("2018-08-08 08:08:08.888888888", local);
        this.verifyTsString("2019-09-09 09:09:09.999999999", local);
        this.verifyTsString("2020-10-10 10:10:10.101010101", local);
        this.verifyTsString("2021-11-11 11:11:11.111111111", local);
        this.verifyTsString("2022-12-12 12:12:12.121212121", local);
        this.verifyTsString("2023-01-02 13:13:13.131313131", local);
        this.verifyTsString("2024-02-02 14:14:14.141414141", local);
        this.verifyTsString("2025-03-03 15:15:15.151515151", local);
        this.verifyTsString("2026-04-04 16:16:16.161616161", local);
        this.verifyTsString("2027-05-05 17:17:17.171717171", local);
        this.verifyTsString("2028-06-06 18:18:18.181818181", local);
        this.verifyTsString("2029-07-07 19:19:19.191919191", local);
        this.verifyTsString("2030-08-08 20:20:20.202020202", local);
        this.verifyTsString("2031-09-09 21:21:21.212121212", local);
        this.verifyTsString("9999-09-09 09:09:09.999999999", local);
        this.verifyTsString("0001-01-01 00:00:00", local);
    }

    private void verifyTsString(String tsString, boolean local) {
        Timestamp ts = Timestamp.valueOf((String)tsString);
        NanoTime nt = NanoTimeUtils.getNanoTime((Timestamp)ts, (boolean)local);
        Timestamp tsFetched = NanoTimeUtils.getTimestamp((NanoTime)nt, (boolean)local);
        Assert.assertEquals((Object)tsString, (Object)tsFetched.toString());
    }

    @Test
    public void testConvertTimestampToZone() {
        Timestamp ts = Timestamp.valueOf((String)"2018-01-01 00:00:00");
        Timestamp ts1 = TimestampTZUtil.convertTimestampToZone((Timestamp)ts, (ZoneId)NEW_YORK, (ZoneId)US_PACIFIC);
        Assert.assertTrue((boolean)Timestamp.valueOf((String)"2017-12-31 21:00:00").equals((Object)ts1));
        Timestamp ts2 = TimestampTZUtil.convertTimestampToZone((Timestamp)ts, (ZoneId)US_PACIFIC, (ZoneId)NEW_YORK);
        Assert.assertTrue((boolean)Timestamp.valueOf((String)"2018-01-01 03:00:00").equals((Object)ts2));
    }

    @Test
    public void testInt64ExactValue() {
        Timestamp ts1 = Timestamp.valueOf((String)"2011-01-01 00:30:00.000000001");
        long millis = ParquetTimestampUtils.getInt64((Timestamp)ts1, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        Assert.assertEquals((long)1293841800000L, (long)millis);
        long micros = ParquetTimestampUtils.getInt64((Timestamp)ts1, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
        Assert.assertEquals((long)1293841800000000L, (long)micros);
        long nanos = ParquetTimestampUtils.getInt64((Timestamp)ts1, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS);
        Assert.assertEquals((long)1293841800000000001L, (long)nanos);
        Timestamp ts2 = Timestamp.valueOf((String)"2011-01-01 00:30:00.55555");
        millis = ParquetTimestampUtils.getInt64((Timestamp)ts2, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        Assert.assertEquals((long)1293841800555L, (long)millis);
        micros = ParquetTimestampUtils.getInt64((Timestamp)ts2, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
        Assert.assertEquals((long)1293841800555550L, (long)micros);
        nanos = ParquetTimestampUtils.getInt64((Timestamp)ts2, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS);
        Assert.assertEquals((long)1293841800555550000L, (long)nanos);
        Timestamp ts3 = Timestamp.valueOf((String)"2018-12-31 23:59:59.999999999");
        millis = ParquetTimestampUtils.getInt64((Timestamp)ts3, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        Assert.assertEquals((long)1546300799999L, (long)millis);
        micros = ParquetTimestampUtils.getInt64((Timestamp)ts3, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
        Assert.assertEquals((long)1546300799999999L, (long)micros);
        nanos = ParquetTimestampUtils.getInt64((Timestamp)ts3, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS);
        Assert.assertEquals((long)1546300799999999999L, (long)nanos);
        Timestamp ts4 = Timestamp.valueOf((String)"1968-01-31 00:30:00.000000001");
        millis = ParquetTimestampUtils.getInt64((Timestamp)ts4, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        Assert.assertEquals((long)-60564600000L, (long)millis);
        micros = ParquetTimestampUtils.getInt64((Timestamp)ts4, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
        Assert.assertEquals((long)-60564600000000L, (long)micros);
        nanos = ParquetTimestampUtils.getInt64((Timestamp)ts4, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS);
        Assert.assertEquals((long)-60564599999999999L, (long)nanos);
    }

    @Test
    public void testLegalInt64TimestampStrings() {
        this.verifyInt64TimestampValue("2011-01-01 01:01:01.111111111", true);
        this.verifyInt64TimestampValue("2012-02-02 02:02:02.222222222", true);
        this.verifyInt64TimestampValue("2013-03-03 03:03:03.333333333", true);
        this.verifyInt64TimestampValue("2014-04-04 04:04:04.444444444", true);
        this.verifyInt64TimestampValue("2015-05-05 05:05:05.555555555", true);
        this.verifyInt64TimestampValue("2016-06-06 06:06:06.666666666", true);
        this.verifyInt64TimestampValue("2017-07-07 07:07:07.777777777", true);
        this.verifyInt64TimestampValue("2018-08-08 08:08:08.888888888", true);
        this.verifyInt64TimestampValue("2019-09-09 09:09:09.999999999", true);
        this.verifyInt64TimestampValue("2020-10-10 10:10:10.101010101", true);
        this.verifyInt64TimestampValue("2021-11-11 11:11:11.111111111", true);
        this.verifyInt64TimestampValue("2022-12-12 12:12:12.121212121", true);
        this.verifyInt64TimestampValue("2023-01-02 13:13:13.131313131", true);
        this.verifyInt64TimestampValue("2024-02-02 14:14:14.141414141", true);
        this.verifyInt64TimestampValue("2025-03-03 15:15:15.151515151", true);
        this.verifyInt64TimestampValue("2026-04-04 16:16:16.161616161", true);
        this.verifyInt64TimestampValue("2027-05-05 17:17:17.171717171", true);
        this.verifyInt64TimestampValue("2028-06-06 18:18:18.181818181", true);
        this.verifyInt64TimestampValue("2029-07-07 19:19:19.191919191", true);
        this.verifyInt64TimestampValue("2030-08-08 20:20:20.202020202", true);
        this.verifyInt64TimestampValue("2031-09-09 21:21:21.212121212", true);
        this.verifyInt64TimestampValue("1969-12-31 23:59:58.123456789", true);
        this.verifyInt64TimestampValue("1969-12-31 23:59:59.999999999", true);
        this.verifyInt64TimestampValue("1970-01-01 00:00:00.0", true);
        this.verifyInt64TimestampValue("1970-01-01 00:00:00.000000001", true);
        this.verifyInt64TimestampValue("1677-09-21 00:12:43.145224192", LogicalTypeAnnotation.TimeUnit.NANOS, true);
        this.verifyInt64TimestampValue("2262-04-11 23:47:16.854775807", LogicalTypeAnnotation.TimeUnit.NANOS, true);
        this.verifyInt64TimestampValue("0001-01-01 00:00:00.001001001", LogicalTypeAnnotation.TimeUnit.MILLIS, true);
        this.verifyInt64TimestampValue("0001-01-01 00:00:00.001001001", LogicalTypeAnnotation.TimeUnit.MICROS, true);
        this.verifyInt64TimestampValue("9999-09-09 09:09:09.999999999", LogicalTypeAnnotation.TimeUnit.MILLIS, true);
        this.verifyInt64TimestampValue("9999-09-09 09:09:09.999999999", LogicalTypeAnnotation.TimeUnit.MICROS, true);
    }

    @Test
    public void testIllegalInt64TimestampStrings() {
        this.verifyInt64TimestampValue("1677-09-21 00:12:43.145224191", LogicalTypeAnnotation.TimeUnit.NANOS, false);
        this.verifyInt64TimestampValue("2262-04-11 23:47:16.854775808", LogicalTypeAnnotation.TimeUnit.NANOS, false);
    }

    private void verifyInt64TimestampValue(String tsString, boolean legal) {
        this.verifyInt64TimestampValue(tsString, LogicalTypeAnnotation.TimeUnit.MILLIS, legal);
        this.verifyInt64TimestampValue(tsString, LogicalTypeAnnotation.TimeUnit.MICROS, legal);
        this.verifyInt64TimestampValue(tsString, LogicalTypeAnnotation.TimeUnit.NANOS, legal);
    }

    private void verifyInt64TimestampValue(String tsString, LogicalTypeAnnotation.TimeUnit timeUnit, boolean legal) {
        Timestamp ts = this.truncateTimestampString(tsString, timeUnit);
        String truncatedTsString = ts.toString();
        Long int64Value = ParquetTimestampUtils.getInt64((Timestamp)ts, (LogicalTypeAnnotation.TimeUnit)timeUnit);
        if (legal) {
            Timestamp tsFetched = ParquetTimestampUtils.getTimestamp((long)int64Value, (LogicalTypeAnnotation.TimeUnit)timeUnit, (boolean)false);
            Assert.assertEquals((Object)truncatedTsString, (Object)tsFetched.toString());
        } else {
            Assert.assertEquals(null, (Object)int64Value);
        }
    }

    private Timestamp truncateTimestampString(String tsString, LogicalTypeAnnotation.TimeUnit timeUnit) {
        Timestamp ts = Timestamp.valueOf((String)tsString);
        switch (timeUnit) {
            case MILLIS: {
                ts.setNanos(ts.getNanos() / 1000000 * 1000000);
                break;
            }
            case MICROS: {
                ts.setNanos(ts.getNanos() / 1000 * 1000);
                break;
            }
        }
        return ts;
    }
}

