/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayWritableObjectInspector {
    private StructTypeInfo nestOnce(TypeInfo nestedType) {
        return (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(Arrays.asList("value"), Arrays.asList(nestedType));
    }

    private StructTypeInfo createNestedStruct(TypeInfo nestedType, int depth) {
        StructTypeInfo result = this.nestOnce(nestedType);
        for (int i = 0; i < depth; ++i) {
            result = this.nestOnce((TypeInfo)result);
        }
        return result;
    }

    @Test
    public void testIdenticalInspectorsEquals() {
        StructTypeInfo nestedStruct = this.createNestedStruct((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), 1000);
        ArrayWritableObjectInspector inspectorX = new ArrayWritableObjectInspector(true, nestedStruct, null);
        ArrayWritableObjectInspector inspectorY = new ArrayWritableObjectInspector(true, nestedStruct, null);
        Assert.assertEquals((Object)inspectorX, (Object)inspectorY);
        Assert.assertEquals((long)inspectorX.hashCode(), (long)inspectorY.hashCode());
    }

    @Test
    public void testEqualInspectorsEquals() {
        StructTypeInfo nestedStructX = this.createNestedStruct((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), 100);
        StructTypeInfo nestedStructY = this.createNestedStruct((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), 100);
        ArrayWritableObjectInspector inspectorX = new ArrayWritableObjectInspector(true, nestedStructX, null);
        ArrayWritableObjectInspector inspectorY = new ArrayWritableObjectInspector(true, nestedStructY, null);
        Assert.assertEquals((Object)inspectorX, (Object)inspectorY);
        Assert.assertEquals((long)inspectorX.hashCode(), (long)inspectorY.hashCode());
    }

    @Test
    public void testDifferentInspectorsEquals() {
        StructTypeInfo nestedStructX = this.createNestedStruct((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), 100);
        StructTypeInfo nestedStructY = this.createNestedStruct((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"), 100);
        ArrayWritableObjectInspector inspectorX = new ArrayWritableObjectInspector(true, nestedStructX, null);
        ArrayWritableObjectInspector inspectorY = new ArrayWritableObjectInspector(true, nestedStructY, null);
        Assert.assertNotEquals((Object)inspectorX, (Object)inspectorY);
        Assert.assertNotEquals((long)inspectorX.hashCode(), (long)inspectorY.hashCode());
    }
}

