/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReaderFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestGetDataColumnReaderByType {
    @Test
    public void testGetDecimalReader() throws Exception {
        DecimalTypeInfo hiveTypeInfo = new DecimalTypeInfo(7, 2);
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(20)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)5))).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromDecimalPageReader));
    }

    @Test
    public void testGetStringReader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("string");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromStringPageReader));
    }

    @Test
    public void testGetDecimalReaderFromBinaryPrimitive() throws Exception {
        DecimalTypeInfo hiveTypeInfo = new DecimalTypeInfo(7, 2);
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)5))).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromDecimalPageReader));
    }

    @Test
    public void testGetBinaryReaderNoOriginalType() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("string");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.DefaultParquetDataColumnReader));
    }

    @Test
    public void testGetBinaryReaderJsonOriginalType() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("binary");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType())).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.DefaultParquetDataColumnReader));
    }

    @Test
    public void testGetIntReader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("int");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)false))).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromInt32PageReader));
    }

    @Test
    public void testGetIntReaderNoOriginalType() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("int");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromInt32PageReader));
    }

    @Test
    public void testGetInt64ReaderNoOriginalType() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("bigint");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromInt64PageReader));
    }

    @Test
    public void testGetInt64Reader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("bigint");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)false))).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromInt64PageReader));
    }

    @Test
    public void testGetFloatReader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("float");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromFloatPageReader));
    }

    @Test
    public void testGetDoubleReader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("double");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromDoublePageReader));
    }

    @Test
    public void testGetInt96Reader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("timestamp");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromInt96PageReader));
    }

    @Test
    public void testGetBooleanReader() throws Exception {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName("boolean");
        ParquetDataColumnReader reader = ParquetDataColumnReaderFactory.getDataColumnReaderByType((PrimitiveType)((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("value")), (TypeInfo)hiveTypeInfo, null, (boolean)true, null, (boolean)false);
        Assert.assertTrue((boolean)(reader instanceof ParquetDataColumnReaderFactory.TypesFromBooleanPageReader));
    }
}

