/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.ETypeConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveCollectionConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveStructConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.MyConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestETypeConverter {
    @Test
    public void testGetDecimalConverter() throws Exception {
        DecimalTypeInfo hiveTypeInfo = new DecimalTypeInfo(7, 2);
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromBinaryConverter((TypeInfo)hiveTypeInfo, primitiveType, Binary.fromString((String)"155"));
        HiveDecimalWritable decimalWritable = (HiveDecimalWritable)writable;
        Assert.assertEquals((long)2L, (long)decimalWritable.getScale());
    }

    @Test
    public void testGetDecimalConverterIntHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("int"), primitiveType, 2200);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)22L, (long)intWritable.get());
    }

    @Test
    public void testGetDecimalConverterBigIntHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, 2200);
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)22L, (long)longWritable.get());
    }

    @Test
    public void testGetDecimalConverterFloatHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("float"), primitiveType, 2200);
        FloatWritable floatWritable = (FloatWritable)writable;
        Assert.assertEquals((long)22L, (long)((int)floatWritable.get()));
    }

    @Test
    public void testGetDecimalConverterDoubleHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("double"), primitiveType, 2200);
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((long)22L, (long)((int)doubleWritable.get()));
    }

    @Test
    public void testGetSmallBigIntConverter() {
        Timestamp timestamp = Timestamp.valueOf((String)"1998-10-03 09:58:31.231");
        long msTime = timestamp.toEpochMilli();
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(msTime);
        buf.flip();
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        Writable writable = this.getWritableFromBinaryConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, Binary.fromByteBuffer((ByteBuffer)buf));
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)msTime, (long)longWritable.get());
    }

    @Test
    public void testGetBigIntConverter() {
        Timestamp timestamp = Timestamp.valueOf((String)"1998-10-03 09:58:31.231");
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (boolean)true);
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value");
        Writable writable = this.getWritableFromBinaryConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, nanoTime.toBinary());
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)nanoTime.getTimeOfDayNanos(), (long)longWritable.get());
    }

    @Test
    public void testGetTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-06-15 15:12:20.0");
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (boolean)true);
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, nanoTime.toBinary());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetTimestampProlepticConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"1572-06-15 15:12:20.0");
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (boolean)true);
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, nanoTime.toBinary());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetInt64MillisTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.112");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, timestamp.toEpochMilli());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
    }

    @Test
    public void testGetInt64MillisTimestampProlepticConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"1572-07-15 15:12:20.112");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, timestamp.toEpochMilli());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
    }

    @Test
    public void testGetInt64MicrosTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.112233");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MICROS);
        long time = timestamp.toEpochSecond() * 1000000L + (long)(timestamp.getNanos() / 1000);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, time);
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetInt64NanosTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.11223344");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.NANOS);
        long time = timestamp.toEpochSecond() * 1000000000L + (long)timestamp.getNanos();
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, time);
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetInt64NanosAdjustedToUTCTimestampConverter() throws Exception {
        ZoneId zone = ZoneId.systemDefault();
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.11223344");
        PrimitiveType primitiveType = this.createInt64TimestampType(true, LogicalTypeAnnotation.TimeUnit.NANOS);
        long time = timestamp.toEpochSecond() * 1000000000L + (long)timestamp.getNanos();
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, time);
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        timestamp = Timestamp.ofEpochSecond((long)timestamp.toEpochSecond(), (long)timestamp.getNanos(), (ZoneId)zone);
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetTextConverter() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        Writable writable = this.getWritableFromBinaryConverter((TypeInfo)new VarcharTypeInfo(), primitiveType, Binary.fromString((String)"this_is_a_value"));
        Text textWritable = (Text)writable;
        Assert.assertEquals((Object)"this_is_a_value", (Object)textWritable.toString());
    }

    @Test
    public void testGetTextConverterNoHiveTypeInfo() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, Binary.fromString((String)"this_is_a_value"));
        Text textWritable = (Text)writable;
        Assert.assertEquals((Object)"this_is_a_value", (Object)textWritable.toString());
    }

    @Test
    public void testGetIntConverterForTinyInt() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)false))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("tinyint"), primitiveType, 125);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)125L, (long)intWritable.get());
    }

    @Test
    public void testGetIntConverterForFloat() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("float"), primitiveType, 22225);
        FloatWritable floatWritable = (FloatWritable)writable;
        Assert.assertEquals((float)22225.0f, (float)floatWritable.get(), (float)0.0f);
    }

    @Test
    public void testGetIntConverterForBigint() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, 22225);
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)22225L, (long)longWritable.get());
    }

    @Test
    public void testGetIntConverterForDouble() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("double"), primitiveType, 22225);
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((double)22225.0, (double)doubleWritable.get(), (double)0.0);
    }

    @Test
    public void testGetIntConverterForSmallint() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)false))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("smallint"), primitiveType, 32766);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)32766L, (long)intWritable.get());
    }

    @Test
    public void testGetIntConverterNoHiveTypeInfo() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, 12225);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)12225L, (long)intWritable.get());
    }

    @Test
    public void testGetDoubleConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addDouble(3276.0);
        Writable writable = converterParent.getValue();
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((double)3276.0, (double)doubleWritable.get(), (double)0.0);
    }

    @Test
    public void testGetBooleanConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addBoolean(true);
        Writable writable = converterParent.getValue();
        BooleanWritable booleanWritable = (BooleanWritable)writable;
        Assert.assertEquals((Object)true, (Object)booleanWritable.get());
    }

    @Test
    public void testGetFloatConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addFloat(3276.0f);
        Writable writable = converterParent.getValue();
        FloatWritable floatWritable = (FloatWritable)writable;
        Assert.assertEquals((float)3276.0f, (float)floatWritable.get(), (float)0.0f);
    }

    @Test
    public void testGetFloatConverterForDouble() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)this.createHiveTypeInfo("double"));
        converter.addFloat(3276.0f);
        Writable writable = converterParent.getValue();
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((double)3276.0, (double)doubleWritable.get(), (double)0.0);
    }

    @Test
    public void testGetBinaryConverter() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, Binary.fromString((String)"this_is_a_value"));
        BytesWritable byteWritable = (BytesWritable)writable;
        Assert.assertEquals((Object)"this_is_a_value", (Object)new String(byteWritable.getBytes()));
    }

    @Test
    public void testGetLongConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addLong(12225L);
        Writable writable = converterParent.getValue();
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)12225L, (long)longWritable.get());
    }

    @Test
    public void testGetConverterForList() {
        MyConverterParent converterParent = new MyConverterParent();
        GroupType type = (GroupType)Types.optionalList().element((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value")).named("array");
        HiveGroupConverter f = HiveGroupConverter.getConverterFromDescription((GroupType)type, (int)1, (ConverterParent)converterParent, null);
        Assert.assertTrue((boolean)(f instanceof HiveCollectionConverter));
    }

    @Test
    public void testGetConverterForMap() {
        MyConverterParent converterParent = new MyConverterParent();
        GroupType type = (GroupType)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value"))).named("map");
        HiveGroupConverter f = HiveGroupConverter.getConverterFromDescription((GroupType)type, (int)1, (ConverterParent)converterParent, null);
        Assert.assertTrue((boolean)(f instanceof HiveCollectionConverter));
    }

    @Test
    public void testGetConverterForStruct() {
        MyConverterParent converterParent = new MyConverterParent();
        GroupType type = (GroupType)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).named("struct");
        HiveGroupConverter f = HiveGroupConverter.getConverterFromDescription((GroupType)type, (int)1, (ConverterParent)converterParent, null);
        Assert.assertTrue((boolean)(f instanceof HiveStructConverter));
    }

    private Writable getWritableFromBinaryConverter(TypeInfo hiveTypeInfo, PrimitiveType primitiveType, Binary valueToAdd) {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)hiveTypeInfo);
        ((ETypeConverter.BinaryConverter)converter).addBinary(valueToAdd);
        return converterParent.getValue();
    }

    private Writable getWritableFromPrimitiveConverter(TypeInfo hiveTypeInfo, PrimitiveType primitiveType, Integer valueToAdd) {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)hiveTypeInfo);
        converter.addInt(valueToAdd.intValue());
        return converterParent.getValue();
    }

    private Writable getWritableFromPrimitiveConverter(TypeInfo hiveTypeInfo, PrimitiveType primitiveType, Long valueToAdd) {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)hiveTypeInfo);
        converter.addLong(valueToAdd.longValue());
        return converterParent.getValue();
    }

    private PrimitiveTypeInfo createHiveTypeInfo(String typeName) {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName(typeName);
        return hiveTypeInfo;
    }

    private PrimitiveType createInt64TimestampType(boolean isAdjustedToUTC, LogicalTypeAnnotation.TimeUnit unit) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalType = LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.timestampType((boolean)isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)unit);
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)logicalType)).named("value");
        return primitiveType;
    }
}

