/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.HiveParquetSchemaTestUtils;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveSchemaConverter {
    Configuration conf = new Configuration();

    @Test
    public void testSimpleType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a,b,c,d,e,f,g", "int,bigint,double,boolean,string,float,binary", "message hive_schema {\n  optional int32 a;\n  optional int64 b;\n  optional double c;\n  optional boolean d;\n  optional binary e (UTF8);\n  optional float f;\n  optional binary g;\n}\n");
    }

    @Test
    public void testSpecialIntType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a,b", "tinyint,smallint", "message hive_schema {\n  optional int32 a (INT_8);\n  optional int32 b (INT_16);\n}\n");
    }

    @Test
    public void testSpecialIntTypeWithLogicatlTypeAnnotations() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a,b", "tinyint,smallint", "message hive_schema {\n  optional int32 a (INTEGER(8,true));\n  optional int32 b (INTEGER(16,true));\n}\n");
    }

    @Test
    public void testDecimalType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "decimal(5,2)", "message hive_schema {\n  optional fixed_len_byte_array(3) a (DECIMAL(5,2));\n}\n");
    }

    @Test
    public void testCharType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "char(5)", "message hive_schema {\n  optional binary a (UTF8);\n}\n");
    }

    @Test
    public void testVarcharType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "varchar(10)", "message hive_schema {\n  optional binary a (UTF8);\n}\n");
    }

    @Test
    public void testDateType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "date", "message hive_schema {\n  optional int32 a (DATE);\n}\n");
    }

    @Test
    public void testTimestampType() throws Exception {
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_PARQUET_WRITE_INT64_TIMESTAMP.varname, false);
        HiveParquetSchemaTestUtils.testConversion("a", "timestamp", "message hive_schema {\n  optional int96 a;\n}\n", this.conf);
    }

    @Test
    public void testArray() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<int>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int32 array_element;\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayDecimal() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<decimal(5,2)>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional fixed_len_byte_array(3) array_element (DECIMAL(5,2));\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayTinyInt() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<tinyint>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int32 array_element (INT_8);\n    }\n  }\n}\n");
    }

    @Test
    public void testArraySmallInt() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<smallint>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int32 array_element (INT_16);\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayString() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<string>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional binary array_element (UTF8);\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayTimestamp() throws Exception {
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_PARQUET_WRITE_INT64_TIMESTAMP.varname, false);
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<timestamp>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int96 array_element;\n    }\n  }\n}\n", this.conf);
    }

    @Test
    public void testArrayStruct() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("structCol", "array<struct<a:string,b:int>>", "message hive_schema {\n  optional group structCol (LIST) {\n    repeated group bag {\n      optional group array_element {\n        optional binary a (UTF8);\n        optional int32 b;\n      }\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayInArray() throws Exception {
        List<String> columnNames = HiveParquetSchemaTestUtils.createHiveColumnsFrom("arrayCol");
        ListTypeInfo listTypeInfo = new ListTypeInfo();
        listTypeInfo.setListElementTypeInfo((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)"int").get(0));
        ArrayList<ListTypeInfo> typeInfos = new ArrayList<ListTypeInfo>();
        ListTypeInfo listTypeInfo2 = new ListTypeInfo();
        listTypeInfo2.setListElementTypeInfo((TypeInfo)listTypeInfo);
        typeInfos.add(listTypeInfo2);
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, typeInfos);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)"message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional group array_element (LIST) {\n        repeated group bag {\n          optional int32 array_element;\n        }\n      }\n    }\n  }\n}\n");
        Assert.assertEquals((Object)expectedMT, (Object)messageTypeFound);
    }

    @Test
    public void testStruct() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:int,b:double,c:boolean,d:decimal(5,2)>", "message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n    optional boolean c;\n    optional fixed_len_byte_array(3) d (DECIMAL(5,2));\n  }\n}\n");
    }

    @Test
    public void testStructInts() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:tinyint,b:smallint,c:int,d:bigint>", "message hive_schema {\n  optional group structCol {\n    optional int32 a (INT_8);\n    optional int32 b (INT_16);\n    optional int32 c;\n    optional int64 d;\n  }\n}\n");
    }

    @Test
    public void testStructStrings() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:char(5),b:varchar(25),c:string>", "message hive_schema {\n  optional group structCol {\n    optional binary a (UTF8);\n    optional binary b (UTF8);\n    optional binary c (UTF8);\n  }\n}\n");
    }

    @Test
    public void testStructTimestamp() throws Exception {
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_PARQUET_WRITE_INT64_TIMESTAMP.varname, false);
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:timestamp>", "message hive_schema {\n  optional group structCol {\n    optional int96 a;\n  }\n}\n", this.conf);
    }

    @Test
    public void testStructList() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:array<string>,b:int,c:string>", "message hive_schema {\n  optional group structCol {\n    optional group a (LIST) {\n      repeated group bag {\n        optional binary array_element (UTF8);\n      }\n    }\n    optional int32 b;\n    optional binary c (UTF8);  }\n}\n");
    }

    @Test
    public void testMap() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<string,string>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional binary value (UTF8);\n    }\n  }\n}\n");
    }

    @Test
    public void testMapDecimal() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<string,decimal(5,2)>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional fixed_len_byte_array(3) value (DECIMAL(5,2));\n    }\n  }\n}\n");
    }

    @Test
    public void testMapInts() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<smallint,tinyint>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required int32 key (INT_16);\n      optional int32 value (INT_8);\n    }\n  }\n}\n");
    }

    @Test
    public void testMapStruct() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<string,struct<a:smallint,b:int>>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value {\n        optional int32 a (INT_16);\n        optional int32 b;\n      }\n    }\n  }\n}\n");
    }

    @Test
    public void testMapList() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<string,array<string>>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value (LIST) {\n        repeated group bag {\n          optional binary array_element (UTF8);\n        }\n      }\n    }\n  }\n}\n");
    }

    @Test
    public void testLogicalTypes() throws Exception {
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_PARQUET_WRITE_INT64_TIMESTAMP.varname, true);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("string", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("int", "a", null, this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("smallint", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true), this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("tinyint", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true), this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("bigint", "a", null, this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("double", "a", null, this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("float", "a", null, this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("boolean", "a", null, this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("binary", "a", null, this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("timestamp", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("char(3)", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("varchar(30)", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), this.conf);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotation("decimal(7,2)", "a", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7), this.conf);
    }

    @Test
    public void testMapOriginalType() throws Exception {
        MessageType messageTypeFound = this.createSchema("map<string,string>", "mapCol");
        Assert.assertEquals((long)1L, (long)messageTypeFound.getFieldCount());
        Type topLevel = (Type)messageTypeFound.getFields().get(0);
        this.checkField(topLevel, "mapCol", Type.Repetition.OPTIONAL, (LogicalTypeAnnotation)LogicalTypeAnnotation.mapType());
        Assert.assertEquals((long)1L, (long)topLevel.asGroupType().getFieldCount());
        Type secondLevel = (Type)topLevel.asGroupType().getFields().get(0);
        this.checkField(secondLevel, "key_value", Type.Repetition.REPEATED, (LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance());
    }

    @Test
    public void testListOriginalType() throws Exception {
        MessageType messageTypeFound = this.createSchema("array<tinyint>", "arrayCol");
        Assert.assertEquals((long)1L, (long)messageTypeFound.getFieldCount());
        Type topLevel = (Type)messageTypeFound.getFields().get(0);
        this.checkField(topLevel, "arrayCol", Type.Repetition.OPTIONAL, (LogicalTypeAnnotation)LogicalTypeAnnotation.listType());
        Assert.assertEquals((long)1L, (long)topLevel.asGroupType().getFieldCount());
        Type secondLevel = (Type)topLevel.asGroupType().getFields().get(0);
        this.checkField(secondLevel, "bag", Type.Repetition.REPEATED, null);
        Assert.assertEquals((long)1L, (long)secondLevel.asGroupType().getFieldCount());
        Type thirdLevel = (Type)secondLevel.asGroupType().getFields().get(0);
        this.checkField(thirdLevel, "array_element", Type.Repetition.OPTIONAL, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true));
    }

    @Test
    public void testStructOriginalType() throws Exception {
        MessageType messageTypeFound = this.createSchema("struct<a:smallint,b:string>", "structCol");
        Assert.assertEquals((long)1L, (long)messageTypeFound.getFieldCount());
        Type topLevel = (Type)messageTypeFound.getFields().get(0);
        this.checkField(topLevel, "structCol", Type.Repetition.OPTIONAL, null);
        Assert.assertEquals((long)2L, (long)topLevel.asGroupType().getFieldCount());
        Type a = (Type)topLevel.asGroupType().getFields().get(0);
        this.checkField(a, "a", Type.Repetition.OPTIONAL, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true));
        Type b = (Type)topLevel.asGroupType().getFields().get(1);
        this.checkField(b, "b", Type.Repetition.OPTIONAL, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
    }

    private MessageType createSchema(String hiveColumnTypes, String hiveColumnNames) {
        List<String> columnNames = HiveParquetSchemaTestUtils.createHiveColumnsFrom(hiveColumnNames);
        List<TypeInfo> columnTypes = HiveParquetSchemaTestUtils.createHiveTypeInfoFrom(hiveColumnTypes);
        return HiveSchemaConverter.convert(columnNames, columnTypes);
    }

    private void checkField(Type field, String expectedName, Type.Repetition expectedRepetition, LogicalTypeAnnotation expectedLogicalType) {
        Assert.assertEquals((Object)expectedName, (Object)field.getName());
        Assert.assertEquals((Object)expectedLogicalType, (Object)field.getLogicalTypeAnnotation());
        Assert.assertEquals((Object)expectedRepetition, (Object)field.getRepetition());
    }
}

