/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.junit.Assert;

public class HiveParquetSchemaTestUtils {
    public static List<String> createHiveColumnsFrom(String columnNamesStr) {
        List<Object> columnNames = columnNamesStr.length() == 0 ? new ArrayList() : Arrays.asList(columnNamesStr.split(","));
        return columnNames;
    }

    public static List<TypeInfo> createHiveTypeInfoFrom(String columnsTypeStr) {
        ArrayList<TypeInfo> columnTypes = columnsTypeStr.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnsTypeStr);
        return columnTypes;
    }

    public static void testConversion(String columnNamesStr, String columnsTypeStr, String actualSchema) throws Exception {
        HiveParquetSchemaTestUtils.testConversion(columnNamesStr, columnsTypeStr, actualSchema, null);
    }

    public static void testConversion(String columnNamesStr, String columnsTypeStr, String actualSchema, Configuration conf) throws Exception {
        List<String> columnNames = HiveParquetSchemaTestUtils.createHiveColumnsFrom(columnNamesStr);
        List<TypeInfo> columnTypes = HiveParquetSchemaTestUtils.createHiveTypeInfoFrom(columnsTypeStr);
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, columnTypes, (Configuration)conf);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)actualSchema);
        Assert.assertEquals((String)("converting " + columnNamesStr + ": " + columnsTypeStr + " to " + actualSchema), (Object)expectedMT, (Object)messageTypeFound);
        List expectedFields = expectedMT.getFields();
        List actualFields = messageTypeFound.getFields();
        int n = expectedFields.size();
        for (int i = 0; i < n; ++i) {
            LogicalTypeAnnotation expectedLogicalType = ((Type)expectedFields.get(i)).getLogicalTypeAnnotation();
            LogicalTypeAnnotation actualLogicalType = ((Type)actualFields.get(i)).getLogicalTypeAnnotation();
            Assert.assertEquals((String)"Logical type annotations of the field do not match", (Object)expectedLogicalType, (Object)actualLogicalType);
        }
    }

    public static void testLogicalTypeAnnotation(String hiveColumnType, String hiveColumnName, LogicalTypeAnnotation expectedLogicalType, Configuration conf) throws Exception {
        HashMap<String, LogicalTypeAnnotation> expectedLogicalTypeForColumn = new HashMap<String, LogicalTypeAnnotation>();
        expectedLogicalTypeForColumn.put(hiveColumnName, expectedLogicalType);
        HiveParquetSchemaTestUtils.testLogicalTypeAnnotations(hiveColumnName, hiveColumnType, expectedLogicalTypeForColumn, conf);
    }

    public static void testLogicalTypeAnnotations(String hiveColumnNames, String hiveColumnTypes, Map<String, LogicalTypeAnnotation> expectedLogicalTypes, Configuration conf) throws Exception {
        List<String> columnNames = HiveParquetSchemaTestUtils.createHiveColumnsFrom(hiveColumnNames);
        List<TypeInfo> columnTypes = HiveParquetSchemaTestUtils.createHiveTypeInfoFrom(hiveColumnTypes);
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, columnTypes, (Configuration)conf);
        List actualFields = messageTypeFound.getFields();
        for (Type actualField : actualFields) {
            LogicalTypeAnnotation expectedLogicalType = expectedLogicalTypes.get(actualField.getName());
            LogicalTypeAnnotation actualLogicalType = actualField.getLogicalTypeAnnotation();
            if (expectedLogicalType != null) {
                Assert.assertNotNull((String)"The logical type annotation cannot be null.", (Object)actualLogicalType);
                Assert.assertEquals((String)"Logical type annotations of the field do not match", (Object)expectedLogicalType, (Object)actualLogicalType);
                continue;
            }
            Assert.assertNull((String)"The logical type annotation must be null.", (Object)actualLogicalType);
        }
    }
}

