/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedOrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.MockFileSystem;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.OrcTail;
import org.junit.Test;

public class TestEncodedOrcFile {
    @Test
    public void testFileSystemIsNotInitializedWithKnownTail() throws IOException {
        JobConf conf = new JobConf();
        Path path = new Path("fmock:///testtable/bucket_0");
        conf.set("hive.orc.splits.include.file.footer", "true");
        conf.set("fs.defaultFS", "fmock:///");
        conf.set("fs.mock.impl", FailingMockFileSystem.class.getName());
        OrcProto.FileTail tail = OrcProto.FileTail.newBuilder().setFooter(OrcProto.Footer.newBuilder().addTypes(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.BINARY).build()).build()).build();
        OrcFile.ReaderOptions readerOptions = EncodedOrcFile.readerOptions((Configuration)conf).filesystem(() -> {
            throw new RuntimeException("Filesystem should not have been initialized");
        }).orcTail(new OrcTail(tail, new BufferChunk(0L, 0), -1L));
        Reader reader = EncodedOrcFile.createReader((Path)path, (OrcFile.ReaderOptions)readerOptions);
        reader.rows();
    }

    private static class FailingMockFileSystem
    extends MockFileSystem {
        private FailingMockFileSystem() {
        }

        public void initialize(URI uri, Configuration conf) {
            throw new RuntimeException("Filesystem should not have been initialized");
        }
    }
}

