/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowBatchReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.OrcConf;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorizedOrcAcidRowBatchReader {
    private static final long NUM_ROWID_PER_OWID = 15000L;
    private static final long NUM_OWID = 10L;
    private JobConf conf;
    private FileSystem fs;
    private Path root;
    private ObjectInspector inspector;
    private ObjectInspector originalInspector;
    private ObjectInspector bigRowInspector;
    private ObjectInspector bigOriginalRowInspector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.conf = new JobConf();
        this.conf.set("transactional", "true");
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, true);
        this.conf.set("transactional_properties", "default");
        this.conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        this.conf.set("schema.evolution.columns", DummyRow.getColumnNamesProperty());
        this.conf.set("schema.evolution.columns.types", DummyRow.getColumnTypesProperty());
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, true);
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
        OrcConf.ROWS_BETWEEN_CHECKS.setLong((Configuration)this.conf, 1L);
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.root = new Path(workDir, "TestVectorizedOrcAcidRowBatch.testDump");
        this.fs = this.root.getFileSystem((Configuration)this.conf);
        this.root = this.fs.makeQualified(this.root);
        this.fs.delete(this.root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            this.inspector = ObjectInspectorFactory.getReflectionObjectInspector(DummyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            this.originalInspector = ObjectInspectorFactory.getReflectionObjectInspector(DummyOriginalRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            this.bigRowInspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            this.bigOriginalRowInspector = ObjectInspectorFactory.getReflectionObjectInspector(BigOriginalRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Test
    public void testDeleteEventFilteringOff() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)false);
        this.testDeleteEventFiltering();
    }

    @Test
    public void testDeleteEventFilteringOn() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        this.testDeleteEventFiltering();
    }

    private void testDeleteEventFiltering() throws Exception {
        boolean filterOn = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS);
        int bucket = 0;
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).bucket(bucket).writingBase(false).minimumWriteId(1L).maximumWriteId(1L).inspector(this.inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
        int bucketProperty = BucketCodec.V1.encode(options);
        OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(1L, 0L, options.getMinimumWriteId(), bucket));
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(2L, 1L, options.getMinimumWriteId(), bucket));
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(3L, 2L, options.getMinimumWriteId(), bucket));
        updater.close(false);
        options.minimumWriteId(2L).maximumWriteId(2L);
        updater = new OrcRecordUpdater(this.root, options);
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(4L, 0L, options.getMinimumWriteId(), bucket));
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(5L, 1L, options.getMinimumWriteId(), bucket));
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(6L, 2L, options.getMinimumWriteId(), bucket));
        updater.close(false);
        options.minimumWriteId(3L).maximumWriteId(3L);
        updater = new OrcRecordUpdater(this.root, options);
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(7L, 0L, options.getMinimumWriteId(), bucket));
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(8L, 1L, options.getMinimumWriteId(), bucket));
        updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(9L, 2L, options.getMinimumWriteId(), bucket));
        updater.close(false);
        options.minimumWriteId(4L).maximumWriteId(4L);
        updater = new OrcRecordUpdater(this.root, options);
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 0L, 1L, bucket));
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 1L, 2L, bucket));
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 2L, 3L, bucket));
        updater.close(false);
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        this.conf.set("hive.txn.valid.writeids", "tbl:5:9223372036854775807::");
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.getSplitStrategies();
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)3L, (long)splits.size());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "delta_0000001_0000001_0000/bucket_00000"), (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "delta_0000002_0000002_0000/bucket_00000"), (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(1)).isOriginal());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "delta_0000003_0000003_0000/bucket_00000"), (Object)((OrcSplit)splits.get(2)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(2)).isOriginal());
        VectorizedOrcAcidRowBatchReader vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(0), this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 1", (long)(filterOn ? 1L : 3L), (long)deleteEventRegistry.size());
        OrcRawRecordMerger.KeyInterval keyInterval = vectorizedReader.getKeyInterval();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(1L, bucketProperty, 0L), new RecordIdentifier(1L, bucketProperty, 2L)), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
        }
        vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(1), this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 2", (long)(filterOn ? 1L : 3L), (long)deleteEventRegistry.size());
        keyInterval = vectorizedReader.getKeyInterval();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(2L, bucketProperty, 0L), new RecordIdentifier(2L, bucketProperty, 2L)), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
        }
        vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(2), this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 3", (long)(filterOn ? 1L : 3L), (long)deleteEventRegistry.size());
        keyInterval = vectorizedReader.getKeyInterval();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(3L, bucketProperty, 0L), new RecordIdentifier(3L, bucketProperty, 2L)), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
        }
    }

    @Test
    public void testDeleteEventFilteringOff2() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)false);
        this.testDeleteEventFiltering2();
    }

    @Test
    public void testDeleteEventFilteringOn2() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        this.testDeleteEventFiltering2();
    }

    @Test
    public void testDeleteEventFilteringOnWithoutIdx2() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETESTMODEACIDKEYIDXSKIP, (boolean)true);
        this.testDeleteEventFiltering2();
    }

    private void testDeleteEventFiltering2() throws Exception {
        boolean filterOn = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS);
        boolean skipKeyIdx = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETESTMODEACIDKEYIDXSKIP);
        int bucket = 1;
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).bucket(bucket).writingBase(true).minimumWriteId(10000002L).maximumWriteId(10000002L).inspector(this.inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
        int bucketProperty = BucketCodec.V1.encode(options);
        OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
        updater.insert(0L, (Object)new DummyRow(1L, 0L, 0L, bucket));
        updater.insert(0L, (Object)new DummyRow(1L, 1L, 0L, bucket));
        updater.insert(0L, (Object)new DummyRow(2L, 2L, 0L, bucket));
        updater.insert(10000001L, (Object)new DummyRow(3L, 0L, 10000001L, bucket));
        updater.close(false);
        options.writingBase(false).minimumWriteId(10000004L).maximumWriteId(10000004L);
        updater = new OrcRecordUpdater(this.root, options);
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 0L, 0L, bucket));
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 5L, 10000003L, bucket));
        updater.close(false);
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        this.conf.set("hive.txn.valid.writeids", "tbl:10000005:9223372036854775807::");
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.getSplitStrategies();
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "base_10000002/bucket_00001"), (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        VectorizedOrcAcidRowBatchReader vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(0), this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 1", (long)(filterOn ? 1L : 2L), (long)deleteEventRegistry.size());
        OrcRawRecordMerger.KeyInterval keyInterval = vectorizedReader.getKeyInterval();
        SearchArgument sarg = vectorizedReader.getDeleteEventSarg();
        if (filterOn) {
            if (skipKeyIdx) {
                Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(0L, bucketProperty, 0L), new RecordIdentifier(10000001L, bucketProperty, 2L)), (Object)keyInterval);
            } else {
                Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(0L, bucketProperty, 0L), new RecordIdentifier(10000001L, bucketProperty, 0L)), (Object)keyInterval);
            }
            Assert.assertEquals((Object)"leaf-0 = (LESS_THAN originalTransaction 0), leaf-1 = (LESS_THAN bucket 536936448), leaf-2 = (LESS_THAN rowId 0), leaf-3 = (LESS_THAN_EQUALS originalTransaction 10000001), leaf-4 = (LESS_THAN_EQUALS bucket 536936448), leaf-5 = (LESS_THAN_EQUALS rowId 2), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) leaf-3 leaf-4 leaf-5)", (Object)((SearchArgumentImpl)sarg).toOldString());
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
            Assert.assertNull((Object)sarg);
        }
    }

    @Test
    public void testDeleteEventFilteringOff3() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)false);
        this.testDeleteEventFiltering3();
    }

    @Test
    public void testDeleteEventFilteringOn3() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        this.testDeleteEventFiltering3();
    }

    @Test
    public void testWithoutStatsDeleteEventFilteringOn3() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        OrcConf.ROW_INDEX_STRIDE.setLong((Configuration)this.conf, 0L);
        this.testDeleteEventFiltering3();
    }

    private void testDeleteEventFiltering3() throws Exception {
        boolean filterOn = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS);
        boolean columnStatsPresent = OrcConf.ROW_INDEX_STRIDE.getLong((Configuration)this.conf) != 0L;
        OrcConf.STRIPE_SIZE.setLong((Configuration)this.conf, 1L);
        this.conf.set("schema.evolution.columns", BigRow.getColumnNamesProperty());
        this.conf.set("schema.evolution.columns.types", BigRow.getColumnTypesProperty());
        OrcRecordUpdater.OrcOptions orcOptions = new OrcRecordUpdater.OrcOptions((Configuration)this.conf);
        orcOptions.orcOptions(OrcFile.writerOptions((Configuration)this.conf).batchSize(1));
        int bucket = 1;
        AcidOutputFormat.Options options = orcOptions.filesystem(this.fs).bucket(bucket).writingBase(true).minimumWriteId(10000002L).maximumWriteId(10000002L).inspector(this.bigRowInspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
        int bucketProperty = BucketCodec.V1.encode(options);
        byte[] data = new byte[1000];
        OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
        updater.insert(10000002L, (Object)new BigRow(data, 0L, 0L, bucket));
        updater.insert(10000002L, (Object)new BigRow(data, 1L, 0L, bucket));
        updater.insert(10000002L, (Object)new BigRow(data, 2L, 0L, bucket));
        updater.close(false);
        String acidFile = "base_10000002/bucket_00001";
        Path acidFilePath = new Path(this.root, acidFile);
        Reader reader = OrcFile.createReader((Path)acidFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        List stripes = reader.getStripes();
        Assert.assertEquals((long)3L, (long)stripes.size());
        long fileLength = this.fs.getFileStatus(acidFilePath).getLen();
        StripeInformation stripe = (StripeInformation)stripes.get(1);
        OrcSplit split = new OrcSplit(acidFilePath, null, stripe.getOffset() + 50L, stripe.getLength() - 100L, new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        this.validateKeyInterval(split, new RecordIdentifier(1L, 1, 1L), new RecordIdentifier(0L, 0, 0L), filterOn);
        stripe = (StripeInformation)stripes.get(2);
        split = new OrcSplit(acidFilePath, null, stripe.getOffset() + 50L, stripe.getLength() - 100L, new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        this.validateKeyInterval(split, new RecordIdentifier(1L, 1, 1L), new RecordIdentifier(0L, 0, 0L), filterOn);
        stripe = (StripeInformation)stripes.get(0);
        split = new OrcSplit(acidFilePath, null, stripe.getOffset(), stripe.getLength() - 50L, new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        if (columnStatsPresent) {
            this.validateKeyInterval(split, new RecordIdentifier(10000002L, bucketProperty, 0L), new RecordIdentifier(10000002L, bucketProperty, 0L), filterOn);
        } else {
            this.validateKeyInterval(split, null, new RecordIdentifier(10000002L, bucketProperty, 0L), filterOn);
        }
        stripe = (StripeInformation)stripes.get(1);
        split = new OrcSplit(acidFilePath, null, stripe.getOffset(), stripe.getLength() + 50L, new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        this.validateKeyInterval(split, new RecordIdentifier(10000002L, bucketProperty, 1L), new RecordIdentifier(10000002L, bucketProperty, 2L), filterOn);
        stripe = (StripeInformation)stripes.get(2);
        split = new OrcSplit(acidFilePath, null, stripe.getOffset() - 50L, stripe.getLength() + 50L, new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        this.validateKeyInterval(split, new RecordIdentifier(10000002L, bucketProperty, 2L), new RecordIdentifier(10000002L, bucketProperty, 2L), filterOn);
        split = new OrcSplit(acidFilePath, null, ((StripeInformation)stripes.get(0)).getOffset() + 50L, reader.getContentLength() - 50L, new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        this.validateKeyInterval(split, new RecordIdentifier(10000002L, bucketProperty, 1L), new RecordIdentifier(10000002L, bucketProperty, 2L), filterOn);
        split = new OrcSplit(acidFilePath, null, ((StripeInformation)stripes.get(0)).getOffset(), reader.getContentLength(), new String[]{"localhost"}, null, false, true, this.getDeltaMetaDataWithBucketFile(1), fileLength, fileLength, this.root, null);
        if (columnStatsPresent) {
            this.validateKeyInterval(split, new RecordIdentifier(10000002L, bucketProperty, 0L), new RecordIdentifier(10000002L, bucketProperty, 2L), filterOn);
        } else {
            this.validateKeyInterval(split, null, new RecordIdentifier(10000002L, bucketProperty, 2L), filterOn);
        }
    }

    private void validateKeyInterval(OrcSplit split, RecordIdentifier lowKey, RecordIdentifier highKey, boolean filterOn) throws Exception {
        VectorizedOrcAcidRowBatchReader vectorizedReader = new VectorizedOrcAcidRowBatchReader(split, this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        OrcRawRecordMerger.KeyInterval keyInterval = vectorizedReader.getKeyInterval();
        SearchArgument sarg = vectorizedReader.getDeleteEventSarg();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(lowKey, highKey), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
            Assert.assertNull((Object)sarg);
        }
    }

    @Test
    public void testDeleteEventOriginalFilteringOn() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        this.testDeleteEventOriginalFiltering();
    }

    @Test
    public void testDeleteEventOriginalFilteringOff() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)false);
        this.testDeleteEventOriginalFiltering();
    }

    public void testDeleteEventOriginalFiltering() throws Exception {
        boolean filterOn = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS);
        this.conf.setBoolean("transactional", false);
        Properties properties = new Properties();
        properties.setProperty("columns", DummyOriginalRow.getColumnNamesProperty());
        properties.setProperty("columns.types", DummyOriginalRow.getColumnTypesProperty());
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Properties)properties, (Configuration)this.conf);
        writerOptions.inspector(this.originalInspector);
        Path testFilePath = new Path(this.root, "000000_0");
        Writer writer = OrcFile.createWriter((Path)testFilePath, (OrcFile.WriterOptions)writerOptions);
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.close();
        testFilePath = new Path(this.root, "000000_0_copy_1");
        writer = OrcFile.createWriter((Path)testFilePath, (OrcFile.WriterOptions)writerOptions);
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.close();
        testFilePath = new Path(this.root, "000000_0_copy_2");
        writer = OrcFile.createWriter((Path)testFilePath, (OrcFile.WriterOptions)writerOptions);
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.addRow((Object)new DummyOriginalRow(0L));
        writer.close();
        this.conf.setBoolean("transactional", true);
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        int bucket = 0;
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).bucket(bucket).writingBase(false).minimumWriteId(1L).maximumWriteId(1L).inspector(this.inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
        int bucketProperty = BucketCodec.V1.encode(options);
        OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 2L, 0L, bucket));
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 3L, 0L, bucket));
        updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 7L, 0L, bucket));
        updater.close(false);
        this.conf.set("hive.txn.valid.writeids", "tbl:2:9223372036854775807::");
        MapWork mapWork = new MapWork();
        mapWork.setVectorMode(true);
        VectorizedRowBatchCtx vrbContext = new VectorizedRowBatchCtx();
        mapWork.setVectorizedRowBatchCtx(vrbContext);
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN, (String)"//tmp");
        Utilities.setMapWork((Configuration)this.conf, (MapWork)mapWork);
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.getSplitStrategies();
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)3L, (long)splits.size());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "000000_0"), (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "000000_0_copy_1"), (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(1)).isOriginal());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "000000_0_copy_2"), (Object)((OrcSplit)splits.get(2)).getPath().toUri().toString());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(2)).isOriginal());
        VectorizedOrcAcidRowBatchReader vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(0), this.conf, Reporter.NULL, vrbContext);
        VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 1", (long)(filterOn ? 1L : 3L), (long)deleteEventRegistry.size());
        OrcRawRecordMerger.KeyInterval keyInterval = vectorizedReader.getKeyInterval();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(0L, bucketProperty, 0L), new RecordIdentifier(0L, bucketProperty, 2L)), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
        }
        vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(1), this.conf, Reporter.NULL, vrbContext);
        deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 2", (long)(filterOn ? 1L : 3L), (long)deleteEventRegistry.size());
        keyInterval = vectorizedReader.getKeyInterval();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(0L, bucketProperty, 3L), new RecordIdentifier(0L, bucketProperty, 5L)), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
        }
        vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(2), this.conf, Reporter.NULL, vrbContext);
        deleteEventRegistry = (VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry)vectorizedReader.getDeleteEventRegistry();
        Assert.assertEquals((String)"number of delete events for stripe 3", (long)(filterOn ? 1L : 3L), (long)deleteEventRegistry.size());
        keyInterval = vectorizedReader.getKeyInterval();
        if (filterOn) {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(new RecordIdentifier(0L, bucketProperty, 6L), new RecordIdentifier(0L, bucketProperty, 8L)), (Object)keyInterval);
        } else {
            Assert.assertEquals((Object)new OrcRawRecordMerger.KeyInterval(null, null), (Object)keyInterval);
        }
    }

    @Test
    public void testDeleteEventOriginalFilteringOff2() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)false);
        this.testDeleteEventOriginalFiltering2();
    }

    @Test
    public void testDeleteEventOriginalFilteringOn2() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        this.testDeleteEventOriginalFiltering2();
    }

    private void testDeleteEventOriginalFiltering2() throws Exception {
        boolean filterOn = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS);
        this.conf.setBoolean("transactional", false);
        this.conf.set("schema.evolution.columns", BigRow.getColumnNamesProperty());
        this.conf.set("schema.evolution.columns.types", BigRow.getColumnTypesProperty());
        Properties properties = new Properties();
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Properties)properties, (Configuration)this.conf);
        writerOptions.inspector(this.bigOriginalRowInspector).stripeSize(1L).batchSize(1);
        String originalFile = "000000_0";
        Path originalFilePath = new Path(this.root, originalFile);
        byte[] data = new byte[1000];
        Writer writer = OrcFile.createWriter((Path)originalFilePath, (OrcFile.WriterOptions)writerOptions);
        writer.addRow((Object)new BigOriginalRow(data));
        writer.addRow((Object)new BigOriginalRow(data));
        writer.addRow((Object)new BigOriginalRow(data));
        writer.close();
        Reader reader = OrcFile.createReader((Path)originalFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        List stripes = reader.getStripes();
        Assert.assertEquals((long)3L, (long)stripes.size());
        FileStatus fileStatus = this.fs.getFileStatus(originalFilePath);
        long fileLength = fileStatus.getLen();
        MapWork mapWork = new MapWork();
        mapWork.setVectorMode(true);
        VectorizedRowBatchCtx vrbContext = new VectorizedRowBatchCtx();
        mapWork.setVectorizedRowBatchCtx(vrbContext);
        HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN, (String)"//tmp");
        Utilities.setMapWork((Configuration)this.conf, (MapWork)mapWork);
        OrcSplit.OffsetAndBucketProperty syntheticProps = VectorizedOrcAcidRowBatchReader.computeOffsetAndBucket((FileStatus)fileStatus, (Path)this.root, (boolean)true, (boolean)true, (Configuration)this.conf);
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).bucket(0);
        int bucketProperty = BucketCodec.V1.encode(options);
        StripeInformation stripe = (StripeInformation)stripes.get(1);
        OrcSplit split = new OrcSplit(originalFilePath, null, stripe.getOffset() + 50L, stripe.getLength() - 100L, new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 2L), new RecordIdentifier(0L, bucketProperty, 1L), filterOn);
        stripe = (StripeInformation)stripes.get(2);
        split = new OrcSplit(originalFilePath, null, stripe.getOffset() + 50L, stripe.getLength() - 100L, new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 3L), new RecordIdentifier(0L, bucketProperty, 2L), filterOn);
        stripe = (StripeInformation)stripes.get(0);
        split = new OrcSplit(originalFilePath, null, stripe.getOffset(), stripe.getLength() - 50L, new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 0L), new RecordIdentifier(0L, bucketProperty, 0L), filterOn);
        stripe = (StripeInformation)stripes.get(1);
        split = new OrcSplit(originalFilePath, null, stripe.getOffset(), stripe.getLength() + 50L, new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 1L), new RecordIdentifier(0L, bucketProperty, 2L), filterOn);
        stripe = (StripeInformation)stripes.get(2);
        split = new OrcSplit(originalFilePath, null, stripe.getOffset() - 50L, stripe.getLength() + 50L, new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 2L), new RecordIdentifier(0L, bucketProperty, 2L), filterOn);
        split = new OrcSplit(originalFilePath, null, ((StripeInformation)stripes.get(0)).getOffset() + 50L, reader.getContentLength() - 50L, new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 1L), new RecordIdentifier(0L, bucketProperty, 2L), filterOn);
        split = new OrcSplit(originalFilePath, null, ((StripeInformation)stripes.get(0)).getOffset(), reader.getContentLength(), new String[]{"localhost"}, null, true, true, this.getDeltaMetaDataWithBucketFile(0), fileLength, fileLength, this.root, syntheticProps);
        this.validateKeyInterval(split, new RecordIdentifier(0L, bucketProperty, 0L), new RecordIdentifier(0L, bucketProperty, 2L), filterOn);
    }

    @Test
    public void testVectorizedOrcAcidRowBatchReader() throws Exception {
        long j;
        long i;
        this.conf.set("bucket_count", "1");
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        int bucket = 0;
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).bucket(bucket).writingBase(false).minimumWriteId(1L).maximumWriteId(10L).inspector(this.inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
        OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
        for (long i2 = 1L; i2 <= 10L; ++i2) {
            for (long j2 = 0L; j2 < 15000L; ++j2) {
                long payload = (i2 - 1L) * 15000L + j2;
                updater.insert(i2, (Object)new DummyRow(payload, j2, i2, bucket));
            }
        }
        updater.close(false);
        long currTxnId = 11L;
        options.minimumWriteId(currTxnId).maximumWriteId(currTxnId);
        updater = new OrcRecordUpdater(this.root, options);
        for (i = 1L; i <= 10L; ++i) {
            for (j = 0L; j < 15000L; ++j) {
                if (j % 2L != 0L || j % 3L == 0L) continue;
                updater.delete(currTxnId, (Object)new DummyRow(-1L, j, i, bucket));
            }
        }
        updater.close(false);
        currTxnId = 12L;
        options.minimumWriteId(currTxnId).maximumWriteId(currTxnId);
        updater = new OrcRecordUpdater(this.root, options);
        for (i = 1L; i <= 10L; ++i) {
            for (j = 0L; j < 15000L; ++j) {
                if (j % 2L == 0L || j % 3L != 0L) continue;
                updater.delete(currTxnId, (Object)new DummyRow(-1L, j, i, bucket));
            }
        }
        updater.close(false);
        currTxnId = 13L;
        options.minimumWriteId(currTxnId).maximumWriteId(currTxnId);
        updater = new OrcRecordUpdater(this.root, options);
        for (i = 1L; i <= 10L; ++i) {
            for (j = 0L; j < 15000L; ++j) {
                if (j % 2L != 0L || j % 3L != 0L) continue;
                updater.delete(currTxnId, (Object)new DummyRow(-1L, j, i, bucket));
            }
        }
        updater.close(false);
        this.testVectorizedOrcAcidRowBatchReader(VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry.class.getName());
        int oldValue = this.conf.getInt(HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname, 1000000);
        this.conf.setInt(HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname, 1000);
        this.testVectorizedOrcAcidRowBatchReader(VectorizedOrcAcidRowBatchReader.SortMergedDeleteEventRegistry.class.getName());
        this.conf.setInt(HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname, oldValue);
    }

    private void testVectorizedOrcAcidRowBatchReader(String deleteEventRegistry) throws Exception {
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.getSplitStrategies();
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertEquals((Object)(this.root.toUri().toString() + File.separator + "delta_0000001_0000010_0000/bucket_00000"), (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        this.conf.set("hive.txn.valid.writeids", "tbl:14:1:1:5");
        VectorizedOrcAcidRowBatchReader vectorizedReader = new VectorizedOrcAcidRowBatchReader((OrcSplit)splits.get(0), this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
        if (deleteEventRegistry.equals(VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry.class.getName())) {
            Assert.assertTrue((boolean)(vectorizedReader.getDeleteEventRegistry() instanceof VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry));
        }
        if (deleteEventRegistry.equals(VectorizedOrcAcidRowBatchReader.SortMergedDeleteEventRegistry.class.getName())) {
            Assert.assertTrue((boolean)(vectorizedReader.getDeleteEventRegistry() instanceof VectorizedOrcAcidRowBatchReader.SortMergedDeleteEventRegistry));
        }
        TypeDescription schema = OrcInputFormat.getDesiredRowTypeDescr((Configuration)this.conf, (boolean)true, (int)Integer.MAX_VALUE);
        VectorizedRowBatch vectorizedRowBatch = schema.createRowBatchV2();
        vectorizedRowBatch.setPartitionInfo(1, 0);
        long previousPayload = Long.MIN_VALUE;
        while (vectorizedReader.next(null, vectorizedRowBatch)) {
            Assert.assertTrue((boolean)vectorizedRowBatch.selectedInUse);
            LongColumnVector col = (LongColumnVector)vectorizedRowBatch.cols[0];
            for (int i = 0; i < vectorizedRowBatch.size; ++i) {
                int idx = vectorizedRowBatch.selected[i];
                long payload = col.vector[idx];
                long owid = payload / 15000L + 1L;
                long rowId = payload % 15000L;
                Assert.assertFalse((rowId % 2L == 0L || rowId % 3L == 0L ? 1 : 0) != 0);
                Assert.assertTrue((owid != 5L ? 1 : 0) != 0);
                Assert.assertTrue((payload > previousPayload ? 1 : 0) != 0);
                previousPayload = payload;
            }
        }
    }

    private List<OrcInputFormat.SplitStrategy<?>> getSplitStrategies() throws Exception {
        this.conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> this.fs, this.root, false, null);
        AcidUtils.Directory adi = gen.call();
        return OrcInputFormat.determineSplitStrategies(null, (OrcInputFormat.Context)context, (FileSystem)adi.getFs(), (Path)adi.getPath(), (List)adi.getFiles(), (List)adi.getDeleteDeltas(), null, null, (boolean)true);
    }

    @Test
    public void testIsQualifiedDeleteDeltaForSplit() throws IOException {
        this.checkPath("00000_0", "delete_delta_000012_000012_0000", true);
        this.checkPath("00000_0", "delete_delta_000001_000001", true);
        this.checkPath("00000_0_copy", "delete_delta_0000012_0000012_0000", true);
        this.checkPath("00000_0_copy", "delete_delta_0000001_0000001", true);
        this.checkPath("base_00000002/bucket_0000001", "delete_delta_0000012_0000012_0000", true);
        this.checkPath("base_0000002_v123/bucket_00000_0", "delete_delta_0000012_0000012_0000", true);
        this.checkPath("delta_00000002_0000002/bucket_00001_1", "delete_delta_0000012_0000012_0000", true);
        this.checkPath("delta_00000002_0000002/bucket_00001_1", "delete_delta_0000002_0000002", false);
        this.checkPath("delta_00000002_0000002/bucket_00001_1", "delete_delta_0000001_0000001_0001", false);
        this.checkPath("delta_0000002_0000002_124/bucket_00001", "delete_delta_000012_000012_0000", true);
        this.checkPath("delta_0000002_0000002_124/bucket_00001", "delete_delta_000002_000002", false);
        this.checkPath("delta_0000002_0000002_124/bucket_00001", "delete_delta_000001_000001_0001", false);
        this.checkPath("delta_0000002_0000002_0000/000000_0", "delete_delta_0000012_0000012_0000", true);
        this.checkPath("delta_0000002_0000002_0000/000000_0", "delete_delta_0000002_0000002", false);
        this.checkPath("delta_0000002_0000002_0000/000000_0", "delete_delta_0000001_0000001_0001", false);
        this.checkPath("delta_0000002_0000005_124/bucket_00001", "delete_delta_0000012_0000012_0000", true);
        this.checkPath("delta_0000002_0000005_124/bucket_00001", "delete_delta_0000003_0000003", true);
        this.checkPath("delta_0000002_0000005_124/bucket_00001", "delete_delta_0000002_0000005", true);
        this.checkPath("delta_0000002_0000005_124/bucket_00001", "delete_delta_0000002_0000002", false);
        this.checkPath("delta_0000002_0000005_124/bucket_00001", "delete_delta_0000001_0000001_0001", false);
        this.checkPath("delta_0000002_0000002_0000/bucket_00001", "delete_delta_0000002_0000002_0000", false);
        this.checkPath("delta_0000002_0000002_0001/bucket_00001", "delete_delta_0000002_0000002_0000", false);
        this.checkPath("delta_0000002_0000002_0001/bucket_00001", "delete_delta_0000002_0000002_0002", true);
        this.checkPath("delta_0000002_0000002_0001/bucket_00001", "delete_delta_0000002_0000002", false);
        this.checkPath("delta_0000002_0000002/bucket_00001", "delete_delta_0000002_0000002", false);
        this.checkPath("delta_0000002_0000002/bucket_00001", "delete_delta_0000002_0000002_0001", true);
    }

    private void checkPath(String splitPath, String deleteDeltaPath, boolean expected) throws IOException {
        boolean result;
        String tableDir = "";
        AcidOutputFormat.Options ao = AcidUtils.parseBaseOrDeltaBucketFilename((Path)new Path(tableDir + splitPath), (Configuration)this.conf);
        AcidUtils.ParsedDeltaLight parsedDelta = AcidUtils.ParsedDeltaLight.parse((Path)new Path(tableDir + deleteDeltaPath));
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(parsedDelta.getMinWriteId(), parsedDelta.getMaxWriteId(), new ArrayList(), parsedDelta.getVisibilityTxnId(), new ArrayList());
        Integer stmtId = null;
        if (parsedDelta.getStatementId() > -1) {
            deltaMetaData.getStmtIds().add(parsedDelta.getStatementId());
            stmtId = parsedDelta.getStatementId();
        }
        Assert.assertTrue((expected == (result = VectorizedOrcAcidRowBatchReader.ColumnizedDeleteEventRegistry.isQualifiedDeleteDeltaForSplit((AcidOutputFormat.Options)ao, (AcidInputFormat.DeltaMetaData)deltaMetaData, stmtId)) ? 1 : 0) != 0);
    }

    private List<AcidInputFormat.DeltaMetaData> getDeltaMetaDataWithBucketFile(int bucketId) {
        AcidInputFormat.DeltaFileMetaData file = new AcidInputFormat.DeltaFileMetaData(0L, 0L, null, null, null, bucketId);
        return Collections.singletonList(new AcidInputFormat.DeltaMetaData(0L, 0L, new ArrayList(), 0L, Collections.singletonList(file)));
    }

    public static class BigOriginalRow {
        BytesWritable field;

        BigOriginalRow(byte[] val) {
            this.field = new BytesWritable(val);
        }

        static String getColumnNamesProperty() {
            return "field";
        }

        static String getColumnTypesProperty() {
            return "binary";
        }
    }

    public static class BigRow {
        BytesWritable field;
        RecordIdentifier rowId;

        BigRow(byte[] val) {
            this.field = new BytesWritable(val);
        }

        BigRow(byte[] val, long rowId, long origTxn, int bucket) {
            this.field = new BytesWritable(val);
            bucket = BucketCodec.V1.encode(new AcidOutputFormat.Options(null).bucket(bucket));
            this.rowId = new RecordIdentifier(origTxn, bucket, rowId);
        }

        static String getColumnNamesProperty() {
            return "field";
        }

        static String getColumnTypesProperty() {
            return "binary";
        }
    }

    public static class DummyOriginalRow {
        LongWritable field;

        DummyOriginalRow(long val) {
            this.field = new LongWritable(val);
        }

        static String getColumnNamesProperty() {
            return "field";
        }

        static String getColumnTypesProperty() {
            return "bigint";
        }
    }

    public static class DummyRow {
        LongWritable field;
        RecordIdentifier ROW__ID;

        DummyRow(long val) {
            this.field = new LongWritable(val);
            this.ROW__ID = null;
        }

        DummyRow(long val, long rowId, long origTxn, int bucket) {
            this.field = new LongWritable(val);
            bucket = BucketCodec.V1.encode(new AcidOutputFormat.Options(null).bucket(bucket));
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        static String getColumnNamesProperty() {
            return "field";
        }

        static String getColumnTypesProperty() {
            return "bigint";
        }
    }
}

