/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFileKeyWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcFileStripeMergeRecordReader;
import org.apache.hadoop.hive.ql.io.orc.OrcFileValueWrapper;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestOrcFileStripeMergeRecordReader {
    private final int DEFAULT_STRIPE_SIZE = 5000;
    private OrcFileKeyWrapper key;
    private OrcFileValueWrapper value;
    private Path tmpPath;
    private Configuration conf;
    private FileSystem fs;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.key = new OrcFileKeyWrapper();
        this.value = new OrcFileValueWrapper();
        this.tmpPath = this.prepareTmpPath();
    }

    @Test
    public void testSplitStartsWithOffset() throws IOException {
        this.createOrcFile(5000, 5001);
        FileStatus fileStatus = this.fs.getFileStatus(this.tmpPath);
        long length = fileStatus.getLen();
        long offset = length / 2L;
        FileSplit split = new FileSplit(this.tmpPath, offset, length, (String[])null);
        OrcFileStripeMergeRecordReader reader = new OrcFileStripeMergeRecordReader(this.conf, split);
        reader.next(this.key, this.value);
        Assert.assertEquals((String)"InputPath", (Object)this.tmpPath, (Object)this.key.getInputPath());
        Assert.assertEquals((String)"NumberOfValues", (long)1L, (long)this.value.getStripeStatistics().getColStats(0).getNumberOfValues());
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrcFile(int stripSize, int numberOfRows) throws IOException {
        Class<TestOrcFileStripeMergeRecordReader> clazz = TestOrcFileStripeMergeRecordReader.class;
        synchronized (TestOrcFileStripeMergeRecordReader.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(StringIntIntIntRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.tmpPath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize((long)stripSize).compress(CompressionKind.ZLIB).bufferSize(5000).rowIndexStride(1000));
            Random rand = new Random(157L);
            for (int i = 0; i < numberOfRows; ++i) {
                writer.addRow((Object)new StringIntIntIntRow(Integer.toBinaryString(i), rand.nextInt(), rand.nextInt(), rand.nextInt()));
            }
            writer.close();
            return;
        }
    }

    private Path prepareTmpPath() throws IOException {
        Path path = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp") + File.separator + "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(path, false);
        return path;
    }

    public static class StringIntIntIntRow {
        Text string1 = new Text();
        int int1;
        int int2;
        int int3;

        StringIntIntIntRow(String string1, int int1, int int2, int int3) {
            this.string1.set(string1);
            this.int1 = int1;
            this.int2 = int2;
            this.int3 = int3;
        }
    }
}

