/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.tez.ColumnarSplitSizeEstimator;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.TestVectorizedOrcAcidRowBatchReader;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowBatchReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileFormatException;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInputOutputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestInputOutputFormat.class);
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target/tmp"));
    static final int MILLIS_IN_DAY = 86400000;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final TimeZone LOCAL_TIMEZONE = TimeZone.getDefault();
    @Rule
    public TestName testCaseName = new TestName();
    JobConf conf;
    FileSystem fs;
    Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestInputOutputFormat." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    @Test
    public void testOverlap() throws Exception {
        Assert.assertEquals((long)0L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)100L, (long)100L, (long)200L, (long)100L));
        Assert.assertEquals((long)0L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)0L, (long)1000L, (long)2000L, (long)100L));
        Assert.assertEquals((long)100L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)1000L, (long)1000L, (long)1500L, (long)100L));
        Assert.assertEquals((long)250L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)1000L, (long)250L, (long)500L, (long)2000L));
        Assert.assertEquals((long)100L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)1000L, (long)1000L, (long)1900L, (long)1000L));
        Assert.assertEquals((long)500L, (long)OrcInputFormat.SplitGenerator.getOverlap((long)2000L, (long)1000L, (long)2500L, (long)2000L));
    }

    @Test
    public void testGetInputPaths() throws Exception {
        this.conf.set("mapred.input.dir", "a,b,c");
        Assert.assertArrayEquals((Object[])new Path[]{new Path("a"), new Path("b"), new Path("c")}, (Object[])OrcInputFormat.getInputPaths((Configuration)this.conf));
        this.conf.set("mapred.input.dir", "/a/b/c/d/e");
        Assert.assertArrayEquals((Object[])new Path[]{new Path("/a/b/c/d/e")}, (Object[])OrcInputFormat.getInputPaths((Configuration)this.conf));
        this.conf.set("mapred.input.dir", "/a/b/c\\,d,/e/f\\,g/h");
        Assert.assertArrayEquals((Object[])new Path[]{new Path("/a/b/c,d"), new Path("/e/f,g/h")}, (Object[])OrcInputFormat.getInputPaths((Configuration)this.conf));
    }

    private FileSystem generateMockFiles(int count, int size) {
        byte[] data = new byte[size];
        MockFile[] files = new MockFile[count];
        for (int i = 0; i < count; ++i) {
            files[i] = new MockFile(String.format("mock:/a/b/part-%d", i), size, data, new MockBlock[0]);
        }
        return new MockFileSystem((Configuration)this.conf, files);
    }

    @Test
    public void testSplitStrategySelection() throws Exception {
        OrcInputFormat.SplitStrategy<?> splitStrategy;
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies;
        OrcInputFormat.FileGenerator gen;
        OrcInputFormat.Context context;
        FileSystem fs;
        this.conf.set("mapreduce.input.fileinputformat.split.maxsize", "500");
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_MEMORY_SIZE.varname, "10Mb");
        int[] counts = new int[]{1, 10, 100, 256};
        int[] sizes = new int[]{100, 1000};
        int[] numSplits = new int[]{1, 9, 10, 11, 99, 111};
        String[] strategyResults = new String[]{"ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "BISplitStrategy", "BISplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "BISplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy", "ETLSplitStrategy"};
        int k = 0;
        for (int c : counts) {
            for (int s : sizes) {
                fs = this.generateMockFiles(c, s);
                for (int n : numSplits) {
                    context = new OrcInputFormat.Context((Configuration)this.conf, n);
                    gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a/b"), false, null);
                    splitStrategies = this.createSplitStrategies(context, gen);
                    Assert.assertEquals((long)1L, (long)splitStrategies.size());
                    splitStrategy = splitStrategies.get(0);
                    Assert.assertTrue((String)String.format("Split strategy for %d files x %d size for %d splits", c, s, n), (boolean)splitStrategy.getClass().getSimpleName().equals(strategyResults[k++]));
                }
            }
        }
        k = 0;
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_MEMORY_SIZE.varname, "0");
        for (int c : counts) {
            for (int s : sizes) {
                fs = this.generateMockFiles(c, s);
                for (int n : numSplits) {
                    context = new OrcInputFormat.Context((Configuration)this.conf, n);
                    gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a/b"), false, null);
                    splitStrategies = this.createSplitStrategies(context, gen);
                    Assert.assertEquals((long)1L, (long)splitStrategies.size());
                    splitStrategy = splitStrategies.get(0);
                    Assert.assertTrue((String)String.format("Split strategy for %d files x %d size for %d splits", c, s, n), (boolean)splitStrategy.getClass().getSimpleName().equals(strategyResults[k++]));
                }
            }
        }
    }

    @Test
    public void testFileGenerator() throws Exception {
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/b/part-01", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/b/_part-02", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/b/.part-03", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/b/part-04", 1000, new byte[1], new MockBlock[0]));
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a/b"), false, null);
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.BISplitStrategy));
        this.conf.set("mapreduce.input.fileinputformat.split.maxsize", "500");
        context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs1 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[1000], new MockBlock[0]), new MockFile("mock:/a/b/part-01", 1000, new byte[1000], new MockBlock[0]), new MockFile("mock:/a/b/_part-02", 1000, new byte[1000], new MockBlock[0]), new MockFile("mock:/a/b/.part-03", 1000, new byte[1000], new MockBlock[0]), new MockFile("mock:/a/b/part-04", 1000, new byte[1000], new MockBlock[0]));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs1, (Path)new MockPath(fs, "mock:/a/b"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ETLSplitStrategy));
    }

    @Test
    public void testACIDSplitStrategy() throws Exception {
        this.conf.set("bucket_count", "2");
        this.conf.setBoolean("transactional", true);
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/delta_000_001/bucket_000000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_000_001/bucket_000001", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_001_002/bucket_000000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_001_002/bucket_000001", 1000, new byte[1], new MockBlock("host1")));
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a"), false, null);
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        ColumnarSplitSizeEstimator splitSizeEstimator = new ColumnarSplitSizeEstimator();
        for (OrcSplit split : splits) {
            Assert.assertEquals((long)1L, (long)splitSizeEstimator.getEstimatedSize((InputSplit)split));
        }
        Assert.assertEquals((long)4L, (long)splits.size());
    }

    @Test
    public void testACIDSplitStrategyForSplitUpdate() throws Exception {
        this.conf.set("bucket_count", "2");
        this.conf.set("transactional", "true");
        this.conf.set("transactional_properties", "default");
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/000000_0", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/b/000000_1", 1000, new byte[1], new MockBlock("host1")));
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a"), false, null);
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)2L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/b/000000_0", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/b/000000_1", (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(1)).isOriginal());
        MockFileSystem fs1 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/000000_0", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/b/000000_1", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/base_0000001/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/base_0000001/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs1, (Path)new MockPath(fs1, "mock:/a"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
        splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)2L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/base_0000001/bucket_00000", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/base_0000001/bucket_00001", (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(1)).isOriginal());
        MockFileSystem fs3 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/000000_0", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/b/000000_1", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_0000001_0000001_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_0000001_0000001_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delete_delta_0000001_0000001_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delete_delta_0000001_0000001_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs3, (Path)new MockPath(fs3, "mock:/a"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)2L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
        splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)2L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/b/000000_0", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/b/000000_1", (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(1)).isOriginal());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(1) instanceof OrcInputFormat.ACIDSplitStrategy));
        splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(1)).getSplits();
        Assert.assertEquals((long)2L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/delta_0000001_0000001_0000/bucket_00000", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/delta_0000001_0000001_0000/bucket_00001", (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(1)).isOriginal());
        MockFileSystem fs4 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/000000_0", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_0000001_0000001_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delete_delta_0000001_0000001_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delete_delta_0000001_0000001_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs4, (Path)new MockPath(fs4, "mock:/a"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)2L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
        splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/b/000000_0", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertTrue((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(1) instanceof OrcInputFormat.ACIDSplitStrategy));
        splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(1)).getSplits();
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/delta_0000001_0000001_0000/bucket_00000", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        MockFileSystem fs5 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/000000_0", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/b/000000_1", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/base_0000001/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/base_0000001/bucket_00001", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_0000002_0000002_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delta_0000002_0000002_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delete_delta_0000002_0000002_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")), new MockFile("mock:/a/delete_delta_0000002_0000002_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs5, (Path)new MockPath(fs5, "mock:/a"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
        splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)4L, (long)splits.size());
        Assert.assertEquals((Object)"mock:/a/base_0000001/bucket_00000", (Object)((OrcSplit)splits.get(0)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/base_0000001/bucket_00001", (Object)((OrcSplit)splits.get(1)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/delta_0000002_0000002_0000/bucket_00000", (Object)((OrcSplit)splits.get(2)).getPath().toUri().toString());
        Assert.assertEquals((Object)"mock:/a/delta_0000002_0000002_0000/bucket_00001", (Object)((OrcSplit)splits.get(3)).getPath().toUri().toString());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(0)).isOriginal());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(1)).isOriginal());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(2)).isOriginal());
        Assert.assertFalse((boolean)((OrcSplit)splits.get(3)).isOriginal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFSCallsVectorizedOrcAcidRowBatchReader() throws IOException {
        try {
            MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/base_0000001/bucket_00000", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/base_0000001/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/base_0000001/bucket_00002", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/base_0000001/bucket_00003", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000002_0000002_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000002_0000002_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000002_0000002_0000/bucket_00002", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000002_0000002_0000/bucket_00003", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000003_0000003_0000/bucket_00000", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000003_0000003_0000/bucket_00001", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000003_0000003_0000/bucket_00002", 1000, new byte[1], new MockBlock("host1")));
            MockFileSystem.addGlobalFile(new MockFile("mock:/a/delta_0000003_0000003_0000/bucket_00003", 1000, new byte[1], new MockBlock("host1")));
            this.conf.set("bucket_count", "4");
            this.setupAcidProperties(this.conf, RowType.DUMMYROW);
            this.conf.setBoolean(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, true);
            MockPath mockPath = new MockPath(fs, "mock:/a");
            this.conf.set("mapred.input.dir", mockPath.toString());
            this.conf.set("fs.defaultFS", "mock:///");
            this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
            OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
            OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a"), false, null);
            List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.createSplitStrategies(context, gen);
            Assert.assertEquals((long)1L, (long)splitStrategies.size());
            Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
            List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
            System.out.println("STATS TRACE START - " + this.testCaseName.getMethodName());
            int readsBefore = fs.statistics.getReadOps();
            for (OrcSplit split : splits) {
                try {
                    new VectorizedOrcAcidRowBatchReader(split, this.conf, Reporter.NULL, new VectorizedRowBatchCtx());
                }
                catch (FileFormatException fileFormatException) {}
            }
            int readsAfter = fs.statistics.getReadOps();
            System.out.println("STATS TRACE END - " + this.testCaseName.getMethodName());
            int delta = readsAfter - readsBefore;
            Assert.assertEquals((long)12L, (long)delta);
        }
        finally {
            MockFileSystem.clearGlobalFiles();
        }
    }

    @Test
    public void testBIStrategySplitBlockBoundary() throws Exception {
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[1], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-01", 1000, new byte[1], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-02", 1000, new byte[1], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-03", 1000, new byte[1], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-04", 1000, new byte[1], new MockBlock("host1", "host2")));
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/a/b"), false, null);
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.BISplitStrategy));
        List splits = ((OrcInputFormat.BISplitStrategy)splitStrategies.get(0)).getSplits();
        int numSplits = splits.size();
        Assert.assertEquals((long)5L, (long)numSplits);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs0 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[1000], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-01", 1000, new byte[1000], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-02", 1000, new byte[1000], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-03", 1000, new byte[1000], new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-04", 1000, new byte[1000], new MockBlock("host1", "host2")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs0, (Path)new MockPath(fs0, "mock:/a/b"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.BISplitStrategy));
        splits = ((OrcInputFormat.BISplitStrategy)splitStrategies.get(0)).getSplits();
        numSplits = splits.size();
        Assert.assertEquals((long)5L, (long)numSplits);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs1 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[1100], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-01", 1000, new byte[1100], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-02", 1000, new byte[1100], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-03", 1000, new byte[1100], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-04", 1000, new byte[1100], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs1, (Path)new MockPath(fs1, "mock:/a/b"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.BISplitStrategy));
        splits = ((OrcInputFormat.BISplitStrategy)splitStrategies.get(0)).getSplits();
        numSplits = splits.size();
        Assert.assertEquals((long)10L, (long)numSplits);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs2 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[2000], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-01", 1000, new byte[2000], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-02", 1000, new byte[2000], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-03", 1000, new byte[2000], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-04", 1000, new byte[2000], new MockBlock("host1", "host2"), new MockBlock("host1", "host2")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs2, (Path)new MockPath(fs2, "mock:/a/b"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.BISplitStrategy));
        splits = ((OrcInputFormat.BISplitStrategy)splitStrategies.get(0)).getSplits();
        numSplits = splits.size();
        Assert.assertEquals((long)10L, (long)numSplits);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs3 = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/b/part-00", 1000, new byte[2200], new MockBlock("host1", "host2"), new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-01", 1000, new byte[2200], new MockBlock("host1", "host2"), new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-02", 1000, new byte[2200], new MockBlock("host1", "host2"), new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-03", 1000, new byte[2200], new MockBlock("host1", "host2"), new MockBlock("host1", "host2"), new MockBlock("host1", "host2")), new MockFile("mock:/a/b/part-04", 1000, new byte[2200], new MockBlock("host1", "host2"), new MockBlock("host1", "host2"), new MockBlock("host1", "host2")));
        gen = new OrcInputFormat.FileGenerator(context, () -> fs3, (Path)new MockPath(fs3, "mock:/a/b"), false, null);
        splitStrategies = this.createSplitStrategies(context, gen);
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.BISplitStrategy));
        splits = ((OrcInputFormat.BISplitStrategy)splitStrategies.get(0)).getSplits();
        numSplits = splits.size();
        Assert.assertEquals((long)15L, (long)numSplits);
    }

    @Test
    public void testEtlCombinedStrategy() throws Exception {
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "ETL");
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_DIRECTORY_BATCH_MS.varname, "1000000");
        AcidUtils.setAcidOperationalProperties((Configuration)this.conf, (boolean)true, null);
        this.conf.setBoolean("transactional", true);
        this.conf.set("transactional_properties", "default");
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/1/part-00", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/1/part-01", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/2/part-00", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/2/part-01", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/3/base_0/bucket_00001", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/4/base_0/bucket_00001", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/5/base_0/bucket_00001", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/5/delta_0_25/bucket_00001", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/6/delta_27_29/bucket_00001", 1000, new byte[1], new MockBlock[0]), new MockFile("mock:/a/6/delete_delta_27_29/bucket_00001", 1000, new byte[1], new MockBlock[0]));
        OrcInputFormat.CombinedCtx combineCtx = new OrcInputFormat.CombinedCtx();
        List<OrcInputFormat.SplitStrategy<?>> ss = this.createOrCombineStrategies(context, fs, "mock:/a/1", combineCtx);
        Assert.assertTrue((boolean)ss.isEmpty());
        Assert.assertTrue((boolean)(combineCtx.combined instanceof OrcInputFormat.ETLSplitStrategy));
        OrcInputFormat.ETLSplitStrategy etlSs = combineCtx.combined;
        Assert.assertEquals((long)2L, (long)etlSs.files.size());
        Assert.assertTrue((boolean)etlSs.isOriginal);
        Assert.assertEquals((long)1L, (long)etlSs.dirs.size());
        ss = this.createOrCombineStrategies(context, fs, "mock:/a/2", combineCtx);
        Assert.assertTrue((boolean)ss.isEmpty());
        Assert.assertTrue((boolean)(combineCtx.combined instanceof OrcInputFormat.ETLSplitStrategy));
        Assert.assertEquals((long)4L, (long)etlSs.files.size());
        Assert.assertEquals((long)2L, (long)etlSs.dirs.size());
        ss = this.createOrCombineStrategies(context, fs, "mock:/a/3", combineCtx);
        Assert.assertEquals((long)1L, (long)ss.size());
        Assert.assertSame((Object)etlSs, ss.get(0));
        Assert.assertEquals((long)4L, (long)etlSs.files.size());
        Assert.assertEquals((long)2L, (long)etlSs.dirs.size());
        Assert.assertTrue((boolean)(combineCtx.combined instanceof OrcInputFormat.ETLSplitStrategy));
        etlSs = combineCtx.combined;
        Assert.assertEquals((long)1L, (long)etlSs.files.size());
        Assert.assertFalse((boolean)etlSs.isOriginal);
        Assert.assertEquals((long)1L, (long)etlSs.dirs.size());
        ss = this.createOrCombineStrategies(context, fs, "mock:/a/1", combineCtx);
        Assert.assertEquals((long)1L, (long)ss.size());
        Assert.assertTrue((boolean)(ss.get(0) instanceof OrcInputFormat.ETLSplitStrategy));
        Assert.assertNotSame((Object)etlSs, ss.get(0));
        OrcInputFormat.ETLSplitStrategy rejectedEtlSs = (OrcInputFormat.ETLSplitStrategy)ss.get(0);
        Assert.assertEquals((long)2L, (long)rejectedEtlSs.files.size());
        Assert.assertEquals((long)1L, (long)rejectedEtlSs.dirs.size());
        Assert.assertTrue((boolean)rejectedEtlSs.isOriginal);
        Assert.assertEquals((long)1L, (long)etlSs.files.size());
        Assert.assertEquals((long)1L, (long)etlSs.dirs.size());
        ss = this.createOrCombineStrategies(context, fs, "mock:/a/4", combineCtx);
        Assert.assertTrue((boolean)ss.isEmpty());
        Assert.assertTrue((boolean)(combineCtx.combined instanceof OrcInputFormat.ETLSplitStrategy));
        Assert.assertEquals((long)2L, (long)etlSs.files.size());
        Assert.assertEquals((long)2L, (long)etlSs.dirs.size());
        ss = this.createOrCombineStrategies(context, fs, "mock:/a/5", combineCtx);
        Assert.assertTrue((boolean)ss.isEmpty());
        Assert.assertTrue((boolean)(combineCtx.combined instanceof OrcInputFormat.ETLSplitStrategy));
        Assert.assertEquals((long)4L, (long)etlSs.files.size());
        Assert.assertEquals((long)3L, (long)etlSs.dirs.size());
        ss = this.createOrCombineStrategies(context, fs, "mock:/a/6", combineCtx);
        Assert.assertEquals((long)1L, (long)ss.size());
        Assert.assertTrue((boolean)(ss.get(0) instanceof OrcInputFormat.ETLSplitStrategy));
        Assert.assertNotSame((Object)etlSs, ss);
        Assert.assertEquals((long)4L, (long)etlSs.files.size());
        Assert.assertEquals((long)3L, (long)etlSs.dirs.size());
    }

    public List<OrcInputFormat.SplitStrategy<?>> createOrCombineStrategies(OrcInputFormat.Context context, MockFileSystem fs, String path, OrcInputFormat.CombinedCtx combineCtx) throws IOException {
        AcidUtils.Directory adi = this.createAdi(context, fs, path);
        return OrcInputFormat.determineSplitStrategies((OrcInputFormat.CombinedCtx)combineCtx, (OrcInputFormat.Context)context, (FileSystem)adi.getFs(), (Path)adi.getPath(), (List)adi.getFiles(), (List)adi.getDeleteDeltas(), null, null, (boolean)true);
    }

    public AcidUtils.Directory createAdi(OrcInputFormat.Context context, MockFileSystem fs, String path) throws IOException {
        return new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, path), false, null).call();
    }

    private List<OrcInputFormat.SplitStrategy<?>> createSplitStrategies(OrcInputFormat.Context context, OrcInputFormat.FileGenerator gen) throws IOException {
        AcidUtils.Directory adi = gen.call();
        return OrcInputFormat.determineSplitStrategies(null, (OrcInputFormat.Context)context, (FileSystem)adi.getFs(), (Path)adi.getPath(), (List)adi.getFiles(), (List)adi.getDeleteDeltas(), null, null, (boolean)true);
    }

    static void fill(DataOutputBuffer out, long length) throws IOException {
        int i = 0;
        while ((long)i < length) {
            out.write(0);
            ++i;
        }
    }

    static byte[] createMockOrcFile(long ... stripeLengths) throws IOException {
        OrcProto.Footer.Builder footer = OrcProto.Footer.newBuilder();
        long headerLen = 3L;
        long offset = 3L;
        DataOutputBuffer buffer = new DataOutputBuffer();
        for (long stripeLength : stripeLengths) {
            footer.addStripes(OrcProto.StripeInformation.newBuilder().setOffset(offset).setIndexLength(0L).setDataLength(stripeLength - 10L).setFooterLength(10L).setNumberOfRows(1000L));
            offset += stripeLength;
        }
        TestInputOutputFormat.fill(buffer, offset);
        footer.addTypes(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addFieldNames("col1").addSubtypes(1));
        footer.addTypes(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRING));
        footer.setNumberOfRows((long)(1000 * stripeLengths.length)).setHeaderLength(3L).setContentLength(offset - 3L);
        footer.addStatistics(OrcProto.ColumnStatistics.newBuilder().setNumberOfValues((long)(1000 * stripeLengths.length)).build());
        footer.addStatistics(OrcProto.ColumnStatistics.newBuilder().setNumberOfValues((long)(1000 * stripeLengths.length)).setStringStatistics(OrcProto.StringStatistics.newBuilder().setMaximum("zzz").setMinimum("aaa").setSum((long)(3000 * stripeLengths.length)).build()).build());
        footer.build().writeTo((OutputStream)buffer);
        int footerEnd = buffer.getLength();
        OrcProto.PostScript ps = OrcProto.PostScript.newBuilder().setCompression(OrcProto.CompressionKind.NONE).setFooterLength((long)footerEnd - offset).setMagic("ORC").build();
        ps.writeTo((OutputStream)buffer);
        buffer.write(buffer.getLength() - footerEnd);
        byte[] result = new byte[buffer.getLength()];
        System.arraycopy(buffer.getData(), 0, result, 0, buffer.getLength());
        return result;
    }

    @Test
    public void testAddSplit() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/file", 500, TestInputOutputFormat.createMockOrcFile(197L, 300L, 600L, 200L, 200L, 100L, 100L, 100L, 100L, 100L), new MockBlock("host1-1", "host1-2", "host1-3"), new MockBlock("host2-1", "host0", "host2-3"), new MockBlock("host0", "host3-2", "host3-3"), new MockBlock("host4-1", "host4-2", "host4-3"), new MockBlock("host5-1", "host5-2", "host5-3")));
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.SplitGenerator splitter = new OrcInputFormat.SplitGenerator(new OrcInputFormat.SplitInfo(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, null, true, new ArrayList(), true, null, null), null, true, true);
        OrcSplit result = splitter.createSplit(0L, 200L, null);
        Assert.assertEquals((long)0L, (long)result.getStart());
        Assert.assertEquals((long)200L, (long)result.getLength());
        Assert.assertEquals((Object)"mock:/a/file", (Object)result.getPath().toString());
        String[] locs = result.getLocations();
        Assert.assertEquals((long)3L, (long)locs.length);
        Assert.assertEquals((Object)"host1-1", (Object)locs[0]);
        Assert.assertEquals((Object)"host1-2", (Object)locs[1]);
        Assert.assertEquals((Object)"host1-3", (Object)locs[2]);
        result = splitter.createSplit(500L, 600L, null);
        locs = result.getLocations();
        Assert.assertEquals((long)3L, (long)locs.length);
        Assert.assertEquals((Object)"host2-1", (Object)locs[0]);
        Assert.assertEquals((Object)"host0", (Object)locs[1]);
        Assert.assertEquals((Object)"host2-3", (Object)locs[2]);
        result = splitter.createSplit(0L, 2500L, null);
        locs = result.getLocations();
        Assert.assertEquals((long)1L, (long)locs.length);
        Assert.assertEquals((Object)"host0", (Object)locs[0]);
    }

    @Test
    public void testSplitGenerator() throws Exception {
        long[] stripeSizes = new long[]{197L, 300L, 600L, 200L, 200L, 100L, 100L, 100L, 100L, 100L};
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/file", 500, TestInputOutputFormat.createMockOrcFile(stripeSizes), new MockBlock("host1-1", "host1-2", "host1-3"), new MockBlock("host2-1", "host0", "host2-3"), new MockBlock("host0", "host3-2", "host3-3"), new MockBlock("host4-1", "host4-2", "host4-3"), new MockBlock("host5-1", "host5-2", "host5-3")));
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)300L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)200L);
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.SplitGenerator splitter = new OrcInputFormat.SplitGenerator(new OrcInputFormat.SplitInfo(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, null, true, new ArrayList(), true, null, null), null, true, true);
        List results = splitter.call();
        OrcSplit result = (OrcSplit)results.get(0);
        Assert.assertEquals((long)3L, (long)result.getStart());
        Assert.assertEquals((long)497L, (long)result.getLength());
        result = (OrcSplit)results.get(1);
        Assert.assertEquals((long)500L, (long)result.getStart());
        Assert.assertEquals((long)600L, (long)result.getLength());
        result = (OrcSplit)results.get(2);
        Assert.assertEquals((long)1100L, (long)result.getStart());
        Assert.assertEquals((long)400L, (long)result.getLength());
        result = (OrcSplit)results.get(3);
        Assert.assertEquals((long)1500L, (long)result.getStart());
        Assert.assertEquals((long)300L, (long)result.getLength());
        result = (OrcSplit)results.get(4);
        Assert.assertEquals((long)1800L, (long)result.getStart());
        Assert.assertEquals((long)200L, (long)result.getLength());
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)0L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)0L);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        splitter = new OrcInputFormat.SplitGenerator(new OrcInputFormat.SplitInfo(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, null, true, new ArrayList(), true, null, null), null, true, true);
        results = splitter.call();
        for (int i = 0; i < stripeSizes.length; ++i) {
            Assert.assertEquals((String)("checking stripe " + i + " size"), (long)stripeSizes[i], (long)((OrcSplit)results.get(i)).getLength());
        }
    }

    @Test
    public void testProjectedColumnSize() throws Exception {
        long[] stripeSizes = new long[]{200L, 200L, 200L, 200L, 100L};
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile("mock:/a/file", 500, TestInputOutputFormat.createMockOrcFile(stripeSizes), new MockBlock("host1-1", "host1-2", "host1-3"), new MockBlock("host2-1", "host0", "host2-3"), new MockBlock("host0", "host3-2", "host3-3"), new MockBlock("host4-1", "host4-2", "host4-3"), new MockBlock("host5-1", "host5-2", "host5-3")));
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)300L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)200L);
        this.conf.setBoolean("hive.io.file.read.all.columns", false);
        this.conf.set("hive.io.file.readcolumn.ids", "0");
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.SplitGenerator splitter = new OrcInputFormat.SplitGenerator(new OrcInputFormat.SplitInfo(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, null, true, new ArrayList(), true, null, null), null, true, true);
        List results = splitter.call();
        OrcSplit result = (OrcSplit)results.get(0);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)3L, (long)result.getStart());
        Assert.assertEquals((long)400L, (long)result.getLength());
        Assert.assertEquals((long)175168L, (long)result.getProjectedColumnsUncompressedSize());
        result = (OrcSplit)results.get(1);
        Assert.assertEquals((long)403L, (long)result.getStart());
        Assert.assertEquals((long)400L, (long)result.getLength());
        Assert.assertEquals((long)175168L, (long)result.getProjectedColumnsUncompressedSize());
        result = (OrcSplit)results.get(2);
        Assert.assertEquals((long)803L, (long)result.getStart());
        Assert.assertEquals((long)100L, (long)result.getLength());
        Assert.assertEquals((long)43792L, (long)result.getProjectedColumnsUncompressedSize());
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)0L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)0L);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        splitter = new OrcInputFormat.SplitGenerator(new OrcInputFormat.SplitInfo(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, null, true, new ArrayList(), true, null, null), null, true, true);
        results = splitter.call();
        Assert.assertEquals((long)5L, (long)results.size());
        for (int i = 0; i < stripeSizes.length; ++i) {
            Assert.assertEquals((String)("checking stripe " + i + " size"), (long)stripeSizes[i], (long)((OrcSplit)results.get(i)).getLength());
            if (i == stripeSizes.length - 1) {
                Assert.assertEquals((long)43792L, (long)((OrcSplit)results.get(i)).getProjectedColumnsUncompressedSize());
                continue;
            }
            Assert.assertEquals((long)87584L, (long)((OrcSplit)results.get(i)).getProjectedColumnsUncompressedSize());
        }
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)1000L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)100000L);
        context = new OrcInputFormat.Context((Configuration)this.conf);
        splitter = new OrcInputFormat.SplitGenerator(new OrcInputFormat.SplitInfo(context, (FileSystem)fs, fs.getFileStatus(new Path("/a/file")), null, null, true, new ArrayList(), true, null, null), null, true, true);
        results = splitter.call();
        Assert.assertEquals((long)1L, (long)results.size());
        result = (OrcSplit)results.get(0);
        Assert.assertEquals((long)3L, (long)result.getStart());
        Assert.assertEquals((long)900L, (long)result.getLength());
        Assert.assertEquals((long)394128L, (long)result.getProjectedColumnsUncompressedSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInOutFormat() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("columns", "x,y");
        properties.setProperty("columns.types", "int:int");
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
            writer.write(serde.serialize((Object)new MyRow(1, 2), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new MyRow(2, 2), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new MyRow(3, 2), (ObjectInspector)inspector));
            writer.close(true);
            serde = new OrcSerde();
            serde.initialize((Configuration)this.conf, properties, null);
            Assert.assertEquals(OrcSerde.OrcSerdeRow.class, (Object)serde.getSerializedClass());
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<x:int,y:int>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
            Assert.assertEquals((Object)false, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            fileList.add(this.fs.getFileStatus(this.testFilePath));
            Assert.assertEquals((Object)true, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            fileList.add(this.fs.getFileStatus(this.workDir));
            Assert.assertEquals((Object)false, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            this.conf.set("schema.evolution.columns", MyRow.getColumnNamesProperty());
            this.conf.set("schema.evolution.columns.types", MyRow.getColumnTypesProperty());
            org.apache.hadoop.mapred.RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Writable value = (Writable)reader.createValue();
            int rowNum = 0;
            List fields = inspector.getAllStructFieldRefs();
            IntObjectInspector intInspector = (IntObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(0))));
                Assert.assertEquals((long)2L, (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(1))));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)1.0E-5);
            reader.close();
            ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, Collections.singletonList(0));
            reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            key = reader.createKey();
            value = (Writable)reader.createValue();
            rowNum = 0;
            fields = inspector.getAllStructFieldRefs();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
                Assert.assertEquals(null, (Object)inspector.getStructFieldData((Object)value, (StructField)fields.get(1)));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            ColumnProjectionUtils.setReadAllColumns((Configuration)this.conf);
            reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            key = reader.createKey();
            value = (Writable)reader.createValue();
            rowNum = 0;
            fields = inspector.getAllStructFieldRefs();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
                Assert.assertEquals((long)2L, (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(1))));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMROutput() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(NestedRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(1, 2, 3), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(4, 5, 6), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(7, 8, 9), (ObjectInspector)inspector));
            writer.close(Reporter.NULL);
            serde = new OrcSerde();
            properties.setProperty("columns", "z,r");
            properties.setProperty("columns.types", "int:struct<x:int,y:int>");
            serde.initialize((Configuration)this.conf, properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, Collections.singletonList(1));
            this.conf.set("columns", "z,r");
            this.conf.set("columns.types", "int:struct<x:int,y:int>");
            org.apache.hadoop.mapred.RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Object value = reader.createValue();
            int rowNum = 0;
            List fields = inspector.getAllStructFieldRefs();
            StructObjectInspector inner = (StructObjectInspector)((StructField)fields.get(1)).getFieldObjectInspector();
            List inFields = inner.getAllStructFieldRefs();
            IntObjectInspector intInspector = (IntObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            while (reader.next(key, value)) {
                Assert.assertEquals(null, (Object)inspector.getStructFieldData(value, (StructField)fields.get(0)));
                Object sub = inspector.getStructFieldData(value, (StructField)fields.get(1));
                Assert.assertEquals((long)(3 * rowNum + 1), (long)intInspector.get(inner.getStructFieldData(sub, (StructField)inFields.get(0))));
                Assert.assertEquals((long)(3 * rowNum + 2), (long)intInspector.get(inner.getStructFieldData(sub, (StructField)inFields.get(1))));
                ++rowNum;
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            return;
        }
    }

    @Test
    public void testEmptyFile() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("columns", "x,y");
        properties.setProperty("columns.types", "int:int");
        OrcOutputFormat outFormat = new OrcOutputFormat();
        FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
        writer.close(true);
        OrcSerde serde = new OrcSerde();
        serde.initialize((Configuration)this.conf, properties, null);
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertTrue((0 == splits.length ? 1 : 0) != 0);
        Assert.assertEquals(null, (Object)serde.getSerDeStats());
    }

    @Test(expected=RuntimeException.class)
    public void testSplitGenFailure() throws IOException {
        Properties properties = new Properties();
        OrcOutputFormat outFormat = new OrcOutputFormat();
        FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
        writer.write(new OrcSerde().serialize(null, null));
        writer.close(true);
        OrcInputFormat in = new OrcInputFormat();
        this.fs.setPermission(this.testFilePath, FsPermission.createImmutable((short)219));
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        try {
            in.getSplits(this.conf, 1);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)true, (Object)e.getMessage().contains("Permission denied"));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultTypes() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("columns", "str,str2");
        properties.setProperty("columns.types", "string:string");
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(StringRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, StringRow.class, true, properties, (Progressable)Reporter.NULL);
            writer.write(serde.serialize((Object)new StringRow("owen"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("beth"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("laurel"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("hazen"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("colin"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("miles"), (ObjectInspector)inspector));
            writer.close(true);
            serde = new OrcSerde();
            serde.initialize((Configuration)this.conf, properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<str:string,str2:string>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            this.conf.set("columns", StringRow.getColumnNamesProperty());
            this.conf.set("columns.types", StringRow.getColumnTypesProperty());
            org.apache.hadoop.mapred.RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Writable value = (Writable)reader.createValue();
            List fields = inspector.getAllStructFieldRefs();
            StringObjectInspector strInspector = (StringObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"owen", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"beth", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"laurel", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"hazen", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"colin", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"miles", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)false, (Object)reader.next(key, (Object)value));
            reader.close();
            return;
        }
    }

    static JobConf createMockExecutionEnvironment(Path workDir, Path warehouseDir, String tableName, ObjectInspector objectInspector, boolean isVectorized, int partitions, String currFileSystemName) throws IOException, HiveException {
        JobConf conf = new JobConf();
        Utilities.clearWorkMap((Configuration)conf);
        conf.set("hive.exec.plan", workDir.toString());
        conf.set("mapred.job.tracker", "local");
        String isVectorizedString = Boolean.toString(isVectorized);
        conf.set("hive.vectorized.execution.enabled", isVectorizedString);
        conf.set("VECTOR_MODE", isVectorizedString);
        conf.set("USE_VECTORIZED_INPUT_FILE_FORMAT", isVectorizedString);
        conf.set("fs.mock.impl", currFileSystemName);
        conf.set("mapred.mapper.class", ExecMapper.class.getName());
        Path root = new Path(warehouseDir, tableName);
        ((MockFileSystem)root.getFileSystem((Configuration)conf)).clear();
        String[] partPath = new String[partitions];
        StringBuilder buffer = new StringBuilder();
        for (int p = 0; p < partitions; ++p) {
            partPath[p] = new Path(root, "p=" + p).toString();
            if (p != 0) {
                buffer.append(',');
            }
            buffer.append(partPath[p]);
        }
        conf.set("mapred.input.dir", buffer.toString());
        StringBuilder columnIds = new StringBuilder();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        StructObjectInspector structOI = (StructObjectInspector)objectInspector;
        List fields = structOI.getAllStructFieldRefs();
        int numCols = fields.size();
        for (int i = 0; i < numCols; ++i) {
            if (i != 0) {
                columnIds.append(',');
                columnNames.append(',');
                columnTypes.append(',');
            }
            columnIds.append(i);
            columnNames.append(((StructField)fields.get(i)).getFieldName());
            columnTypes.append(((StructField)fields.get(i)).getFieldObjectInspector().getTypeName());
        }
        conf.set("hive.io.file.readcolumn.ids", columnIds.toString());
        conf.set("partition_columns", "p");
        conf.set("columns", columnNames.toString());
        conf.set("columns.types", columnTypes.toString());
        MockFileSystem fs = (MockFileSystem)warehouseDir.getFileSystem((Configuration)conf);
        fs.clear();
        Properties tblProps = new Properties();
        tblProps.put("name", tableName);
        tblProps.put("serialization.lib", OrcSerde.class.getName());
        tblProps.put("columns", columnNames.toString());
        tblProps.put("columns.types", columnTypes.toString());
        TableDesc tbl = new TableDesc(OrcInputFormat.class, OrcOutputFormat.class, tblProps);
        MapWork mapWork = new MapWork();
        mapWork.setVectorMode(isVectorized);
        if (isVectorized) {
            VectorizedRowBatchCtx vectorizedRowBatchCtx = new VectorizedRowBatchCtx();
            vectorizedRowBatchCtx.init(structOI, new String[0]);
            mapWork.setVectorizedRowBatchCtx(vectorizedRowBatchCtx);
        }
        mapWork.setUseBucketizedHiveInputFormat(false);
        LinkedHashMap aliasMap = new LinkedHashMap();
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(tableName);
        LinkedHashMap<Path, PartitionDesc> partMap = new LinkedHashMap<Path, PartitionDesc>();
        for (int p = 0; p < partitions; ++p) {
            Path path = new Path(partPath[p]);
            aliasMap.put(path, aliases);
            LinkedHashMap partSpec = new LinkedHashMap();
            PartitionDesc part = new PartitionDesc(tbl, partSpec);
            if (isVectorized) {
                part.setVectorPartitionDesc(VectorPartitionDesc.createVectorizedInputFileFormat((String)"MockInputFileFormatClassName", (boolean)false, null));
            }
            partMap.put(path, part);
        }
        mapWork.setPathToAliases(aliasMap);
        mapWork.setPathToPartitionInfo(partMap);
        FileSystem localFs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path mapXml = new Path(workDir, "map.xml");
        localFs.delete(mapXml, true);
        FSDataOutputStream planStream = localFs.create(mapXml);
        SerializationUtilities.serializePlan((Object)mapWork, (OutputStream)planStream);
        conf.setBoolean("has.map.work", true);
        planStream.close();
        return conf;
    }

    static void setBlocks(Path path, Configuration conf, MockBlock ... blocks) throws IOException {
        FileSystem mockFs = path.getFileSystem(conf);
        MockOutputStream stream = (MockOutputStream)mockFs.create(path);
        stream.setBlocks(blocks);
    }

    static int getLength(Path path, Configuration conf) throws IOException {
        FileSystem mockFs = path.getFileSystem(conf);
        FileStatus stat = mockFs.getFileStatus(path);
        return (int)stat.getLen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVectorization() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            JobConf conf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "vectorization", (ObjectInspector)inspector, true, 1, MockFileSystem.class.getName());
            Path path = new Path(conf.get("mapred.input.dir") + "/0_0");
            Writer writer = OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            TestInputOutputFormat.setBlocks(path, (Configuration)conf, new MockBlock("host0", "host1"));
            HiveInputFormat inputFormat = new HiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 10);
            Assert.assertEquals((long)1L, (long)splits.length);
            org.apache.hadoop.mapred.RecordReader reader = inputFormat.getRecordReader(splits[0], conf, Reporter.NULL);
            NullWritable key = (NullWritable)reader.createKey();
            VectorizedRowBatch value = (VectorizedRowBatch)reader.createValue();
            Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
            Assert.assertEquals((long)10L, (long)value.count());
            LongColumnVector col0 = (LongColumnVector)value.cols[0];
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((String)("checking " + i), (long)i, (long)col0.vector[i]);
            }
            Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVectorizationWithBuckets() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            JobConf conf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "vectorBuckets", (ObjectInspector)inspector, true, 1, MockFileSystem.class.getName());
            Path path = new Path(conf.get("mapred.input.dir") + "/0_0");
            Writer writer = OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            TestInputOutputFormat.setBlocks(path, (Configuration)conf, new MockBlock("host0", "host1"));
            conf.setInt("bucket_count", 3);
            HiveInputFormat inputFormat = new HiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 10);
            Assert.assertEquals((long)1L, (long)splits.length);
            org.apache.hadoop.mapred.RecordReader reader = inputFormat.getRecordReader(splits[0], conf, Reporter.NULL);
            NullWritable key = (NullWritable)reader.createKey();
            VectorizedRowBatch value = (VectorizedRowBatch)reader.createValue();
            Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
            Assert.assertEquals((long)10L, (long)value.count());
            LongColumnVector col0 = (LongColumnVector)value.cols[0];
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((String)("checking " + i), (long)i, (long)col0.vector[i]);
            }
            Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
            return;
        }
    }

    @Test
    public void testVectorizationWithAcid() throws Exception {
        BigRowInspector inspector = new BigRowInspector();
        JobConf conf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "vectorizationAcid", (ObjectInspector)inspector, true, 1, MockFileSystem.class.getName());
        this.setupAcidProperties(conf, RowType.BIGROW);
        Path partDir = new Path(conf.get("mapred.input.dir"));
        OrcRecordUpdater writer = new OrcRecordUpdater(partDir, new AcidOutputFormat.Options((Configuration)conf).maximumWriteId(10L).writingBase(true).bucket(0).inspector((ObjectInspector)inspector).finalDestination(partDir));
        for (int i = 0; i < 100; ++i) {
            BigRow row = new BigRow(i);
            writer.insert(10L, (Object)row);
        }
        writer.close(false);
        Path path = new Path("mock:/vectorizationAcid/p=0/base_0000010/bucket_00000");
        TestInputOutputFormat.setBlocks(path, (Configuration)conf, new MockBlock("host0", "host1"));
        HiveInputFormat inputFormat = new HiveInputFormat();
        InputSplit[] splits = inputFormat.getSplits(conf, 10);
        Assert.assertEquals((long)1L, (long)splits.length);
        org.apache.hadoop.mapred.RecordReader reader = inputFormat.getRecordReader(splits[0], conf, Reporter.NULL);
        NullWritable key = (NullWritable)reader.createKey();
        VectorizedRowBatch value = (VectorizedRowBatch)reader.createValue();
        Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
        Assert.assertEquals((long)100L, (long)value.count());
        LongColumnVector booleanColumn = (LongColumnVector)value.cols[0];
        LongColumnVector byteColumn = (LongColumnVector)value.cols[1];
        LongColumnVector shortColumn = (LongColumnVector)value.cols[2];
        LongColumnVector intColumn = (LongColumnVector)value.cols[3];
        LongColumnVector longColumn = (LongColumnVector)value.cols[4];
        DoubleColumnVector floatColumn = (DoubleColumnVector)value.cols[5];
        DoubleColumnVector doubleCoulmn = (DoubleColumnVector)value.cols[6];
        BytesColumnVector stringColumn = (BytesColumnVector)value.cols[7];
        DecimalColumnVector decimalColumn = (DecimalColumnVector)value.cols[8];
        LongColumnVector dateColumn = (LongColumnVector)value.cols[9];
        TimestampColumnVector timestampColumn = (TimestampColumnVector)value.cols[10];
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((String)("checking boolean " + i), (long)(i % 2 == 0 ? 1L : 0L), (long)booleanColumn.vector[i]);
            Assert.assertEquals((String)("checking byte " + i), (long)((byte)i), (long)byteColumn.vector[i]);
            Assert.assertEquals((String)("checking short " + i), (long)((short)i), (long)shortColumn.vector[i]);
            Assert.assertEquals((String)("checking int " + i), (long)i, (long)intColumn.vector[i]);
            Assert.assertEquals((String)("checking long " + i), (long)i, (long)longColumn.vector[i]);
            Assert.assertEquals((String)("checking float " + i), (double)i, (double)floatColumn.vector[i], (double)1.0E-4);
            Assert.assertEquals((String)("checking double " + i), (double)i, (double)doubleCoulmn.vector[i], (double)1.0E-4);
            Text strValue = new Text();
            strValue.set(stringColumn.vector[i], stringColumn.start[i], stringColumn.length[i]);
            Assert.assertEquals((String)("checking string " + i), (Object)new Text(Long.toHexString(i)), (Object)strValue);
            Assert.assertEquals((String)("checking decimal " + i), (Object)HiveDecimal.create((int)i), (Object)decimalColumn.vector[i].getHiveDecimal());
            Assert.assertEquals((String)("checking date " + i), (long)i, (long)dateColumn.vector[i]);
            long millis = (long)i * 86400000L;
            millis -= (long)LOCAL_TIMEZONE.getOffset(millis);
            Assert.assertEquals((String)("checking timestamp " + i), (long)millis, (long)timestampColumn.getTime(i));
        }
        Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCombinationInputFormat() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            JobConf conf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "combination", (ObjectInspector)inspector, false, 1, MockFileSystem.class.getName());
            Path partDir = new Path(conf.get("mapred.input.dir"));
            Writer writer = OrcFile.createWriter((Path)new Path(partDir, "0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            Path path = new Path("mock:/combination/p=0/0_0");
            TestInputOutputFormat.setBlocks(path, (Configuration)conf, new MockBlock("host0", "host1"));
            MockFileSystem mockFs = (MockFileSystem)partDir.getFileSystem((Configuration)conf);
            int length0 = TestInputOutputFormat.getLength(path, (Configuration)conf);
            writer = OrcFile.createWriter((Path)new Path(partDir, "1_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 10; i < 20; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            Path path1 = new Path("mock:/combination/p=0/1_0");
            TestInputOutputFormat.setBlocks(path1, (Configuration)conf, new MockBlock("host1", "host2"));
            CombineHiveInputFormat inputFormat = new CombineHiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            CombineHiveInputFormat.CombineHiveInputSplit split = (CombineHiveInputFormat.CombineHiveInputSplit)splits[0];
            Assert.assertEquals((long)2L, (long)split.getNumPaths());
            Assert.assertEquals((Object)(partDir.toString() + "/0_0"), (Object)split.getPath(0).toString());
            Assert.assertEquals((Object)(partDir.toString() + "/1_0"), (Object)split.getPath(1).toString());
            Assert.assertEquals((long)length0, (long)split.getLength(0));
            Assert.assertEquals((long)TestInputOutputFormat.getLength(path1, (Configuration)conf), (long)split.getLength(1));
            Assert.assertEquals((long)0L, (long)split.getOffset(0));
            Assert.assertEquals((long)0L, (long)split.getOffset(1));
            Assert.assertTrue((3 >= split.getLocations().length ? 1 : 0) != 0);
            org.apache.hadoop.mapred.RecordReader reader = inputFormat.getRecordReader((InputSplit)split, conf, Reporter.NULL);
            CombineHiveKey key = (CombineHiveKey)reader.createKey();
            OrcStruct value = (OrcStruct)reader.createValue();
            for (int i = 0; i < 20; ++i) {
                Assert.assertEquals((Object)true, (Object)reader.next((Object)key, (Object)value));
                Assert.assertEquals((long)i, (long)((IntWritable)value.getFieldValue(0)).get());
            }
            Assert.assertEquals((Object)false, (Object)reader.next((Object)key, (Object)value));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCombinationInputFormatWithAcid() throws Exception {
        int PARTITIONS = 2;
        int BUCKETS = 3;
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            JobConf conf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "combinationAcid", (ObjectInspector)inspector, false, 2, MockFileSystem.class.getName());
            Path[] partDir = new Path[2];
            String[] paths = conf.getStrings("mapred.input.dir");
            for (int p = 0; p < 2; ++p) {
                partDir[p] = new Path(paths[p]);
            }
            OrcRecordUpdater writer = new OrcRecordUpdater(partDir[0], new AcidOutputFormat.Options((Configuration)conf).maximumWriteId(10L).writingBase(true).bucket(0).inspector((ObjectInspector)inspector).finalDestination(partDir[0]));
            for (int i = 0; i < 10; ++i) {
                writer.insert(10L, (Object)new MyRow(i, 2 * i));
            }
            writer.close(false);
            Path base0 = new Path("mock:/combinationAcid/p=0/base_0000010/bucket_00000");
            TestInputOutputFormat.setBlocks(base0, (Configuration)conf, new MockBlock("host1", "host2"));
            writer = new OrcRecordUpdater(partDir[0], new AcidOutputFormat.Options((Configuration)conf).maximumWriteId(10L).writingBase(true).bucket(1).inspector((ObjectInspector)inspector).finalDestination(partDir[0]));
            for (int i = 10; i < 20; ++i) {
                writer.insert(10L, (Object)new MyRow(i, 2 * i));
            }
            writer.close(false);
            Path base1 = new Path("mock:/combinationAcid/p=0/base_0000010/bucket_00001");
            TestInputOutputFormat.setBlocks(base1, (Configuration)conf, new MockBlock("host1", "host2"));
            for (int bucket = 0; bucket < 3; ++bucket) {
                Path path = new Path(partDir[1], "00000" + bucket + "_0");
                Writer orc = OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
                orc.addRow((Object)new MyRow(1, 2));
                orc.close();
                TestInputOutputFormat.setBlocks(path, (Configuration)conf, new MockBlock("host3", "host4"));
            }
            conf.setInt("bucket_count", 3);
            this.setupAcidProperties(conf, RowType.MYROW);
            CombineHiveInputFormat inputFormat = new CombineHiveInputFormat();
            InputSplit[] splits = inputFormat.getSplits(conf, 1);
            Assert.assertEquals((long)3L, (long)splits.length);
            HiveInputFormat.HiveInputSplit split = (HiveInputFormat.HiveInputSplit)splits[0];
            Assert.assertEquals((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", (Object)split.inputFormatClassName());
            Assert.assertEquals((Object)"mock:/combinationAcid/p=0/base_0000010/bucket_00000", (Object)split.getPath().toString());
            Assert.assertEquals((long)0L, (long)split.getStart());
            Assert.assertEquals((long)702L, (long)split.getLength());
            split = (HiveInputFormat.HiveInputSplit)splits[1];
            Assert.assertEquals((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", (Object)split.inputFormatClassName());
            Assert.assertEquals((Object)"mock:/combinationAcid/p=0/base_0000010/bucket_00001", (Object)split.getPath().toString());
            Assert.assertEquals((long)0L, (long)split.getStart());
            Assert.assertEquals((long)726L, (long)split.getLength());
            CombineHiveInputFormat.CombineHiveInputSplit combineSplit = (CombineHiveInputFormat.CombineHiveInputSplit)splits[2];
            Assert.assertEquals((long)3L, (long)combineSplit.getNumPaths());
            for (int bucket = 0; bucket < 3; ++bucket) {
                Assert.assertEquals((Object)("mock:/combinationAcid/p=1/00000" + bucket + "_0"), (Object)combineSplit.getPath(bucket).toString());
                Assert.assertEquals((long)0L, (long)combineSplit.getOffset(bucket));
                Assert.assertEquals((long)253L, (long)combineSplit.getLength(bucket));
            }
            String[] hosts = combineSplit.getLocations();
            Assert.assertEquals((long)2L, (long)hosts.length);
            return;
        }
    }

    @Test
    public void testSetSearchArgument() throws Exception {
        Reader.Options options = new Reader.Options();
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder();
        builder.setKind(OrcProto.Type.Kind.STRUCT).addAllFieldNames(Arrays.asList("op", "owid", "bucket", "rowid", "cwid", "row")).addAllSubtypes(Arrays.asList(1, 2, 3, 4, 5, 6));
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.INT);
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.STRUCT).addAllFieldNames(Arrays.asList("url", "purchase", "cost", "store")).addAllSubtypes(Arrays.asList(7, 8, 9, 10));
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.STRING);
        types.add(builder.build());
        builder.clear().setKind(OrcProto.Type.Kind.INT);
        types.add(builder.build());
        types.add(builder.build());
        types.add(builder.build());
        SearchArgument isNull = SearchArgumentFactory.newBuilder().startAnd().isNull("cost", PredicateLeaf.Type.LONG).end().build();
        this.conf.set("sarg.pushdown", ConvertAstToSearchArg.sargToKryo((SearchArgument)isNull));
        this.conf.set("hive.io.file.readcolumn.names", "url,cost");
        options.include(new boolean[]{true, true, false, true, false});
        OrcInputFormat.setSearchArgument((Reader.Options)options, types, (Configuration)this.conf, (boolean)false);
        String[] colNames = options.getColumnNames();
        Assert.assertEquals(null, (Object)colNames[0]);
        Assert.assertEquals((Object)"url", (Object)colNames[1]);
        Assert.assertEquals(null, (Object)colNames[2]);
        Assert.assertEquals((Object)"cost", (Object)colNames[3]);
        Assert.assertEquals(null, (Object)colNames[4]);
        SearchArgument arg = options.getSearchArgument();
        List leaves = arg.getLeaves();
        Assert.assertEquals((Object)"cost", (Object)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IS_NULL, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitElimination() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("columns", "z,r");
        properties.setProperty("columns.types", "int:struct<x:int,y:int>");
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(NestedRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            this.conf.setInt("mapred.max.split.size", 50);
            RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(1, 2, 3), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(4, 5, 6), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(7, 8, 9), (ObjectInspector)inspector));
            writer.close(Reporter.NULL);
            serde = new OrcSerde();
            SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("z", PredicateLeaf.Type.LONG, (Object)0L).end().build();
            this.conf.set("sarg.pushdown", ConvertAstToSearchArg.sargToKryo((SearchArgument)sarg));
            this.conf.set("hive.io.file.readcolumn.names", "z,r");
            serde.initialize((Configuration)this.conf, properties, null);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)0L, (long)splits.length);
            return;
        }
    }

    @Test
    public void testSplitEliminationNullStats() throws Exception {
        Properties properties = new Properties();
        StructObjectInspector inspector = this.createSoi();
        OrcSerde serde = new OrcSerde();
        OrcOutputFormat outFormat = new OrcOutputFormat();
        this.conf.setInt("mapred.max.split.size", 50);
        RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
        writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new SimpleRow(null), (ObjectInspector)inspector));
        writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new SimpleRow(null), (ObjectInspector)inspector));
        writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new SimpleRow(null), (ObjectInspector)inspector));
        writer.close(Reporter.NULL);
        serde = new OrcSerde();
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("z", PredicateLeaf.Type.STRING, (Object)new String("foo")).end().build();
        this.conf.set("sarg.pushdown", ConvertAstToSearchArg.sargToKryo((SearchArgument)sarg));
        this.conf.set("hive.io.file.readcolumn.names", "z");
        properties.setProperty("columns", "z");
        properties.setProperty("columns.types", "string");
        serde.initialize((Configuration)this.conf, properties, null);
        inspector = (StructObjectInspector)serde.getObjectInspector();
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)0L, (long)splits.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoAs() throws Exception {
        this.conf.setInt(HiveConf.ConfVars.HIVE_ORC_COMPUTE_SPLITS_NUM_THREADS.varname, 1);
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "ETL");
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_IN_TEST.varname, true);
        this.conf.setClass("fs.mock.impl", MockFileSystem.class, FileSystem.class);
        String badUser = UserGroupInformation.getCurrentUser().getShortUserName() + "-foo";
        MockFileSystem.setBlockedUgi(badUser);
        MockFileSystem.clearGlobalFiles();
        OrcInputFormat.Context.resetThreadPool();
        try {
            block6: {
                MockFileSystem.addGlobalFile(new MockFile("mock:/ugi/1/file", 10000, TestInputOutputFormat.createMockOrcFile(197L, 300L, 600L), new MockBlock("host1-1", "host1-2", "host1-3")));
                MockFileSystem.addGlobalFile(new MockFile("mock:/ugi/2/file", 10000, TestInputOutputFormat.createMockOrcFile(197L, 300L, 600L), new MockBlock("host1-1", "host1-2", "host1-3")));
                FileInputFormat.setInputPaths((JobConf)this.conf, (String)"mock:/ugi/1");
                UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)badUser, (String[])new String[0]);
                Assert.assertEquals((long)0L, (long)OrcInputFormat.Context.getCurrentThreadPoolSize());
                try {
                    ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            OrcInputFormat.generateSplitsInfo((Configuration)TestInputOutputFormat.this.conf, (OrcInputFormat.Context)new OrcInputFormat.Context((Configuration)TestInputOutputFormat.this.conf, -1, null));
                            return null;
                        }
                    });
                    Assert.fail((String)"Didn't throw");
                }
                catch (Exception ex) {
                    boolean found = false;
                    for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof MockFileSystem.MockAccessDenied)) continue;
                        found = true;
                        break;
                    }
                    if (found) break block6;
                    throw ex;
                }
            }
            Assert.assertEquals((long)1L, (long)OrcInputFormat.Context.getCurrentThreadPoolSize());
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)"mock:/ugi/2");
            List splits = OrcInputFormat.generateSplitsInfo((Configuration)this.conf, (OrcInputFormat.Context)new OrcInputFormat.Context((Configuration)this.conf, -1, null));
            Assert.assertEquals((long)1L, (long)splits.size());
        }
        finally {
            MockFileSystem.clearGlobalFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructObjectInspector createSoi() {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(SimpleRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitGenReadOps() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        this.conf.set("mapred.input.dir", "mock:///mocktable");
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        MockPath mockPath = new MockPath(fs, "mock:///mocktable");
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)3L, (long)readOpsDelta);
            Assert.assertEquals((long)2L, (long)splits.length);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitGenReadOpsLocalCache() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktbl");
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_MEMORY_SIZE.varname, "0");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)3L, (long)readOpsDelta);
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)1L, (long)readOpsDelta);
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_CACHE_STRIPE_DETAILS_MEMORY_SIZE.varname, "10Mb");
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "HYBRID");
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)3L, (long)readOpsDelta);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)1L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitGenReadOpsLocalCacheChangeFileLen() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktbl1");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i2 = 0; i2 < 10; ++i2) {
                writer.addRow((Object)new MyRow(i2, 2 * i2));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i2 = 0; i2 < 10; ++i2) {
                writer.addRow((Object)new MyRow(i2, 2 * i2));
            }
            writer.close();
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)3L, (long)readOpsDelta);
            fs.clear();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 100; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 100; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)3L, (long)readOpsDelta);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)1L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitGenReadOpsLocalCacheChangeModificationTime() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktbl2");
        this.conf.set("hive.orc.cache.use.soft.references", "true");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)3L, (long)readOpsDelta);
            FileSystem fs1 = FileSystem.get((Configuration)this.conf);
            MockFile mockFile = ((MockFileSystem)fs1).findFile(new Path((Object)((Object)mockPath) + "/0_0"));
            ((MockFileSystem)fs1).touch(mockFile);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)2L, (long)readOpsDelta);
            fs1 = FileSystem.get((Configuration)this.conf);
            mockFile = ((MockFileSystem)fs1).findFile(new Path((Object)((Object)mockPath) + "/0_1"));
            ((MockFileSystem)fs1).touch(mockFile);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)2L, (long)readOpsDelta);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            orcInputFormat = new OrcInputFormat();
            splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)1L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonVectorReaderNoFooterSerialize() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable1");
        this.conf.set("hive.orc.splits.include.file.footer", "false");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=false"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((boolean)split.toString().contains("deltas=0"));
                if (split instanceof OrcSplit) {
                    Assert.assertFalse((String)"No footer serialize test for non-vector reader, hasFooter is not expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                }
                orcInputFormat.getRecordReader(split, this.conf, null);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)2L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonVectorReaderFooterSerialize() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable2");
        this.conf.set("hive.orc.splits.include.file.footer", "true");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=true"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((boolean)split.toString().contains("deltas=0"));
                if (split instanceof OrcSplit) {
                    Assert.assertTrue((String)"Footer serialize test for non-vector reader, hasFooter is expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                }
                orcInputFormat.getRecordReader(split, this.conf, null);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)2L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVectorReaderNoFooterSerialize() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable3");
        this.conf.set("hive.orc.splits.include.file.footer", "false");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            JobConf jobConf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "mocktable3", (ObjectInspector)inspector, true, 0, MockFileSystem.class.getName());
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=false"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((boolean)split.toString().contains("deltas=0"));
                if (split instanceof OrcSplit) {
                    Assert.assertFalse((String)"No footer serialize test for vector reader, hasFooter is not expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                }
                orcInputFormat.getRecordReader(split, jobConf, Reporter.NULL);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)2L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVectorReaderFooterSerialize() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable4");
        this.conf.set("hive.orc.splits.include.file.footer", "true");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            JobConf jobConf = TestInputOutputFormat.createMockExecutionEnvironment(this.workDir, new Path("mock:///"), "mocktable4", (ObjectInspector)inspector, true, 0, MockFileSystem.class.getName());
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=true"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((boolean)split.toString().contains("deltas=0"));
                if (split instanceof OrcSplit) {
                    Assert.assertTrue((String)"Footer serialize test for vector reader, hasFooter is expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                }
                orcInputFormat.getRecordReader(split, jobConf, Reporter.NULL);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)2L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testACIDReaderNoFooterSerialize() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable5");
        this.setupAcidProperties(this.conf, RowType.MYROW);
        this.conf.set("hive.orc.splits.include.file.footer", "false");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=false"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((boolean)split.toString().contains("deltas=0"));
                Assert.assertTrue((boolean)split.toString().contains("isOriginal=true"));
                if (split instanceof OrcSplit) {
                    Assert.assertFalse((String)"No footer serialize test for non-vector reader, hasFooter is not expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                }
                orcInputFormat.getRecordReader(split, this.conf, Reporter.NULL);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)6L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testACIDReaderFooterSerialize() throws Exception {
        MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable6");
        this.setupAcidProperties(this.conf, RowType.MYROW);
        this.conf.set("hive.orc.splits.include.file.footer", "true");
        this.conf.set("mapred.input.dir", mockPath.toString());
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_1"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=true"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((boolean)split.toString().contains("deltas=0"));
                Assert.assertTrue((boolean)split.toString().contains("isOriginal=true"));
                if (split instanceof OrcSplit) {
                    Assert.assertTrue((String)"Footer serialize test for ACID reader, hasFooter is expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                }
                orcInputFormat.getRecordReader(split, this.conf, Reporter.NULL);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)6L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testACIDReaderNoFooterSerializeWithDeltas() throws Exception {
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable7");
        this.setupAcidProperties(this.conf, RowType.MYROW);
        this.conf.set("hive.orc.splits.include.file.footer", "false");
        this.conf.set("mapred.input.dir", mockPath.toString());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).bucket(1).minimumWriteId(1L).maximumWriteId(1L).inspector((ObjectInspector)inspector).finalDestination((Path)mockPath);
            OrcOutputFormat of = new OrcOutputFormat();
            RecordUpdater ru = of.getRecordUpdater((Path)mockPath, options);
            for (int i = 0; i < 10; ++i) {
                ru.insert(options.getMinimumWriteId(), (Object)new MyRow(i, 2 * i));
            }
            ru.close(false);
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=false"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertFalse((String)"No footer serialize test for ACID reader, hasFooter is not expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                orcInputFormat.getRecordReader(split, this.conf, Reporter.NULL);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)4L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testACIDReaderFooterSerializeWithDeltas() throws Exception {
        this.conf.set("fs.defaultFS", "mock:///");
        this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        MockPath mockPath = new MockPath(fs, "mock:///mocktable8");
        this.setupAcidProperties(this.conf, RowType.MYROW);
        this.conf.set("hive.orc.splits.include.file.footer", "true");
        this.conf.set("mapred.input.dir", mockPath.toString());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path((Object)((Object)mockPath) + "/0_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).blockPadding(false).bufferSize(1024).inspector((ObjectInspector)inspector));
            for (int i = 0; i < 10; ++i) {
                writer.addRow((Object)new MyRow(i, 2 * i));
            }
            writer.close();
            AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).bucket(1).minimumWriteId(1L).maximumWriteId(1L).inspector((ObjectInspector)inspector).finalDestination((Path)mockPath);
            OrcOutputFormat of = new OrcOutputFormat();
            RecordUpdater ru = of.getRecordUpdater((Path)mockPath, options);
            for (int i = 0; i < 10; ++i) {
                ru.insert(options.getMinimumWriteId(), (Object)new MyRow(i, 2 * i));
            }
            ru.close(false);
            OrcInputFormat orcInputFormat = new OrcInputFormat();
            InputSplit[] splits = orcInputFormat.getSplits(this.conf, 2);
            Assert.assertEquals((long)2L, (long)splits.length);
            int readOpsBefore = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsBefore = statistics.getReadOps();
            }
            Assert.assertTrue((String)"MockFS has stats. Read ops not expected to be -1", (readOpsBefore != -1 ? 1 : 0) != 0);
            for (InputSplit split : splits) {
                Assert.assertTrue((String)"OrcSplit is expected", (boolean)(split instanceof OrcSplit));
                Assert.assertTrue((boolean)split.toString().contains("start=3"));
                Assert.assertTrue((boolean)split.toString().contains("hasFooter=true"));
                Assert.assertTrue((boolean)split.toString().contains("hasBase=true"));
                Assert.assertTrue((String)"Footer serialize test for ACID reader, hasFooter is not expected in orc splits.", (boolean)((OrcSplit)split).hasFooter());
                orcInputFormat.getRecordReader(split, this.conf, Reporter.NULL);
            }
            int readOpsDelta = -1;
            for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
                if (!statistics.getScheme().equalsIgnoreCase("mock")) continue;
                readOpsDelta = statistics.getReadOps() - readOpsBefore;
            }
            Assert.assertEquals((long)4L, (long)readOpsDelta);
            this.conf.set("fs.defaultFS", "file:///");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowNumberUniquenessInDifferentSplits() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("columns", "x,y");
        properties.setProperty("columns.types", "int:int");
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            long oldDefaultStripeSize = this.conf.getLong(OrcConf.STRIPE_SIZE.getHiveConfName(), -1L);
            long oldMaxSplitSize = this.conf.getLong(HiveConf.ConfVars.MAPREDMAXSPLITSIZE.varname, -1L);
            long newStripeSize = 10000L;
            long newMaxSplitSize = 100L;
            this.conf.setLong(OrcConf.STRIPE_SIZE.getHiveConfName(), newStripeSize);
            this.conf.setLong(HiveConf.ConfVars.MAPREDMAXSPLITSIZE.varname, newMaxSplitSize);
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
            int i = 0;
            while ((long)i < newStripeSize * 10L) {
                writer.write(serde.serialize((Object)new MyRow(i, i + 1), (ObjectInspector)inspector));
                ++i;
            }
            writer.close(true);
            serde = new OrcSerde();
            serde.initialize((Configuration)this.conf, properties, null);
            Assert.assertEquals(OrcSerde.OrcSerdeRow.class, (Object)serde.getSerializedClass());
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<x:int,y:int>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            int numExpectedSplits = 20;
            InputSplit[] splits = in.getSplits(this.conf, numExpectedSplits);
            Assert.assertEquals((long)numExpectedSplits, (long)splits.length);
            for (int i2 = 0; i2 < numExpectedSplits; ++i2) {
                OrcSplit split = (OrcSplit)splits[i2];
                Reader.Options orcReaderOptions = new Reader.Options();
                orcReaderOptions.range(split.getStart(), split.getLength());
                OrcFile.ReaderOptions qlReaderOptions = OrcFile.readerOptions((Configuration)this.conf).maxLength(split.getFileLength());
                Reader reader = OrcFile.createReader((Path)split.getPath(), (OrcFile.ReaderOptions)qlReaderOptions);
                RecordReader recordReader = reader.rowsOptions(orcReaderOptions);
                int j = 0;
                while (recordReader.hasNext()) {
                    long rowNum = i2 * 5000 + j;
                    long rowNumActual = recordReader.getRowNumber();
                    Assert.assertEquals((String)("rowNum=" + rowNum), (long)rowNum, (long)rowNumActual);
                    Object object = recordReader.next(null);
                    ++j;
                }
                recordReader.close();
            }
            if (oldDefaultStripeSize != -1L) {
                this.conf.setLong(OrcConf.STRIPE_SIZE.getHiveConfName(), oldDefaultStripeSize);
            } else {
                this.conf.unset(OrcConf.STRIPE_SIZE.getHiveConfName());
            }
            if (oldMaxSplitSize != -1L) {
                this.conf.setLong(HiveConf.ConfVars.MAPREDMAXSPLITSIZE.varname, oldMaxSplitSize);
            } else {
                this.conf.unset(HiveConf.ConfVars.MAPREDMAXSPLITSIZE.varname);
            }
            return;
        }
    }

    @Test
    public void testSchemaEvolutionOldDecimal() throws Exception {
        int r;
        TypeDescription fileSchema = TypeDescription.fromString((String)"struct<a:int,b:struct<c:int>,d:string>");
        this.conf.set(HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED.varname, "decimal_64");
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).setSchema(fileSchema).compress(CompressionKind.NONE));
        VectorizedRowBatch batch = fileSchema.createRowBatch(1000);
        batch.size = 1000;
        LongColumnVector lcv = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[0];
        for (int r2 = 0; r2 < 1000; ++r2) {
            ((LongColumnVector)batch.cols[0]).vector[r2] = r2 * 42;
            lcv.vector[r2] = r2 * 10001;
            ((BytesColumnVector)batch.cols[2]).setVal(r2, Integer.toHexString(r2).getBytes(StandardCharsets.UTF_8));
        }
        writer.addRowBatch(batch);
        writer.close();
        TypeDescription readerSchema = TypeDescription.fromString((String)"struct<a:int,b:struct<c:int,future1:int>,d:string,future2:int>");
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        RecordReader rows = reader.rowsOptions(new Reader.Options().schema(readerSchema));
        batch = readerSchema.createRowBatch();
        lcv = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[0];
        LongColumnVector future1 = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[1];
        Assert.assertEquals((Object)true, (Object)rows.nextBatch(batch));
        Assert.assertEquals((long)1000L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)future1.isRepeating);
        Assert.assertEquals((Object)true, (Object)future1.isNull[0]);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isRepeating);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isNull[0]);
        for (r = 0; r < batch.size; ++r) {
            Assert.assertEquals((String)("row " + r), (long)(r * 42), (long)((LongColumnVector)batch.cols[0]).vector[r]);
            Assert.assertEquals((String)("row " + r), (long)(r * 10001), (long)lcv.vector[r]);
            Assert.assertEquals((String)("row " + r), (long)(r * 10001), (long)lcv.vector[r]);
            Assert.assertEquals((String)("row " + r), (Object)Integer.toHexString(r), (Object)((BytesColumnVector)batch.cols[2]).toString(r));
        }
        Assert.assertEquals((Object)false, (Object)rows.nextBatch(batch));
        rows.close();
        rows = reader.rowsOptions(new Reader.Options().schema(readerSchema).include(new boolean[]{false, true, true, true, false, false, true}));
        batch = readerSchema.createRowBatch();
        lcv = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[0];
        future1 = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[1];
        Assert.assertEquals((Object)true, (Object)rows.nextBatch(batch));
        Assert.assertEquals((long)1000L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)future1.isRepeating);
        Assert.assertEquals((Object)true, (Object)future1.isNull[0]);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isRepeating);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isNull[0]);
        Assert.assertEquals((Object)true, (Object)batch.cols[2].isRepeating);
        Assert.assertEquals((Object)true, (Object)batch.cols[2].isNull[0]);
        for (r = 0; r < batch.size; ++r) {
            Assert.assertEquals((String)("row " + r), (long)(r * 42), (long)((LongColumnVector)batch.cols[0]).vector[r]);
            Assert.assertEquals((String)("row " + r), (long)(r * 10001), (long)lcv.vector[r]);
        }
        Assert.assertEquals((Object)false, (Object)rows.nextBatch(batch));
        rows.close();
    }

    @Test
    public void testSchemaEvolutionDecimal64() throws Exception {
        int r;
        TypeDescription fileSchema = TypeDescription.fromString((String)"struct<a:int,b:struct<c:int>,d:string>");
        this.conf.set(HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED.varname, "decimal_64");
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).setSchema(fileSchema).compress(CompressionKind.NONE));
        VectorizedRowBatch batch = fileSchema.createRowBatch(TypeDescription.RowBatchVersion.USE_DECIMAL64, 1000);
        batch.size = 1000;
        LongColumnVector lcv = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[0];
        for (int r2 = 0; r2 < 1000; ++r2) {
            ((LongColumnVector)batch.cols[0]).vector[r2] = r2 * 42;
            lcv.vector[r2] = r2 * 10001;
            ((BytesColumnVector)batch.cols[2]).setVal(r2, Integer.toHexString(r2).getBytes(StandardCharsets.UTF_8));
        }
        writer.addRowBatch(batch);
        writer.close();
        TypeDescription readerSchema = TypeDescription.fromString((String)"struct<a:int,b:struct<c:int,future1:int>,d:string,future2:int>");
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        RecordReader rows = reader.rowsOptions(new Reader.Options().schema(readerSchema));
        batch = readerSchema.createRowBatchV2();
        lcv = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[0];
        LongColumnVector future1 = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[1];
        Assert.assertEquals((Object)true, (Object)rows.nextBatch(batch));
        Assert.assertEquals((long)1000L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)future1.isRepeating);
        Assert.assertEquals((Object)true, (Object)future1.isNull[0]);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isRepeating);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isNull[0]);
        for (r = 0; r < batch.size; ++r) {
            Assert.assertEquals((String)("row " + r), (long)(r * 42), (long)((LongColumnVector)batch.cols[0]).vector[r]);
            Assert.assertEquals((String)("row " + r), (long)(r * 10001), (long)lcv.vector[r]);
            Assert.assertEquals((String)("row " + r), (long)(r * 10001), (long)lcv.vector[r]);
            Assert.assertEquals((String)("row " + r), (Object)Integer.toHexString(r), (Object)((BytesColumnVector)batch.cols[2]).toString(r));
        }
        Assert.assertEquals((Object)false, (Object)rows.nextBatch(batch));
        rows.close();
        rows = reader.rowsOptions(new Reader.Options().schema(readerSchema).include(new boolean[]{false, true, true, true, false, false, true}));
        batch = readerSchema.createRowBatchV2();
        lcv = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[0];
        future1 = (LongColumnVector)((StructColumnVector)batch.cols[1]).fields[1];
        Assert.assertEquals((Object)true, (Object)rows.nextBatch(batch));
        Assert.assertEquals((long)1000L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)future1.isRepeating);
        Assert.assertEquals((Object)true, (Object)future1.isNull[0]);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isRepeating);
        Assert.assertEquals((Object)true, (Object)batch.cols[3].isNull[0]);
        Assert.assertEquals((Object)true, (Object)batch.cols[2].isRepeating);
        Assert.assertEquals((Object)true, (Object)batch.cols[2].isNull[0]);
        for (r = 0; r < batch.size; ++r) {
            Assert.assertEquals((String)("row " + r), (long)(r * 42), (long)((LongColumnVector)batch.cols[0]).vector[r]);
            Assert.assertEquals((String)("row " + r), (long)(r * 10001), (long)lcv.vector[r]);
        }
        Assert.assertEquals((Object)false, (Object)rows.nextBatch(batch));
        rows.close();
    }

    @Test
    public void testColumnProjectionWithAcid() throws Exception {
        Path baseDir = new Path(this.workDir, "base_00100");
        this.testFilePath = new Path(baseDir, "bucket_00000");
        this.fs.mkdirs(baseDir);
        this.fs.delete(this.testFilePath, true);
        TypeDescription fileSchema = TypeDescription.fromString((String)"struct<operation:int,originalTransaction:bigint,bucket:int,rowId:bigint,currentTransaction:bigint,row:struct<a:int,b:struct<c:int>,d:string>>");
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).setSchema(fileSchema).compress(CompressionKind.NONE));
        VectorizedRowBatch batch = fileSchema.createRowBatch(TypeDescription.RowBatchVersion.USE_DECIMAL64, 1000);
        batch.size = 1000;
        StructColumnVector scv = (StructColumnVector)batch.cols[5];
        batch.cols[0].isRepeating = true;
        ((LongColumnVector)batch.cols[0]).vector[0] = 0L;
        batch.cols[1].isRepeating = true;
        ((LongColumnVector)batch.cols[1]).vector[0] = 1L;
        batch.cols[2].isRepeating = true;
        ((LongColumnVector)batch.cols[2]).vector[0] = 0L;
        batch.cols[4].isRepeating = true;
        ((LongColumnVector)batch.cols[4]).vector[0] = 1L;
        LongColumnVector lcv = (LongColumnVector)((StructColumnVector)scv.fields[1]).fields[0];
        for (int r = 0; r < 1000; ++r) {
            ((LongColumnVector)batch.cols[3]).vector[r] = r;
            ((LongColumnVector)scv.fields[0]).vector[r] = r * 42;
            lcv.vector[r] = r * 10001;
            ((BytesColumnVector)scv.fields[2]).setVal(r, Integer.toHexString(r).getBytes(StandardCharsets.UTF_8));
        }
        writer.addRowBatch(batch);
        writer.addUserMetadata("hive.acid.key.index", ByteBuffer.wrap("0,0,999".getBytes(StandardCharsets.UTF_8)));
        writer.close();
        long fileLength = this.fs.getFileStatus(this.testFilePath).getLen();
        this.conf.set("hive.txn.valid.writeids", "tbl:100:99:");
        this.conf.set("schema.evolution.columns", "a,b,d");
        this.conf.set("schema.evolution.columns.types", "int,struct<c:int>,string");
        this.conf.set("hive.io.file.read.all.columns", "false");
        this.conf.set("hive.io.file.readcolumn.ids", "0,2");
        OrcSplit split = new OrcSplit(this.testFilePath, null, 0L, fileLength, new String[0], null, false, true, new ArrayList(), fileLength, fileLength, this.workDir, null);
        OrcInputFormat inputFormat = new OrcInputFormat();
        AcidInputFormat.RowReader reader = inputFormat.getReader((InputSplit)split, new AcidInputFormat.Options((Configuration)this.conf));
        int record = 0;
        RecordIdentifier id = (RecordIdentifier)reader.createKey();
        OrcStruct struct = (OrcStruct)reader.createValue();
        while (reader.next((Object)id, (Object)struct)) {
            Assert.assertEquals((String)("id " + record), (long)record, (long)id.getRowId());
            Assert.assertEquals((String)("bucket " + record), (long)0L, (long)id.getBucketProperty());
            Assert.assertEquals((String)("writeid " + record), (long)1L, (long)id.getWriteId());
            Assert.assertEquals((String)("a " + record), (long)(42 * record), (long)((IntWritable)struct.getFieldValue(0)).get());
            Assert.assertEquals(null, (Object)struct.getFieldValue(1));
            Assert.assertEquals((String)("d " + record), (Object)Integer.toHexString(record), (Object)struct.getFieldValue(2).toString());
            ++record;
        }
        Assert.assertEquals((long)1000L, (long)record);
        reader.close();
        this.conf.set("schema.evolution.columns", "a,b,d,f");
        this.conf.set("schema.evolution.columns.types", "int,struct<c:int,e:string>,string,int");
        this.conf.set("hive.io.file.read.all.columns", "false");
        this.conf.set("hive.io.file.readcolumn.ids", "0,2,3");
        split = new OrcSplit(this.testFilePath, null, 0L, fileLength, new String[0], null, false, true, new ArrayList(), fileLength, fileLength, this.workDir, null);
        inputFormat = new OrcInputFormat();
        reader = inputFormat.getReader((InputSplit)split, new AcidInputFormat.Options((Configuration)this.conf));
        record = 0;
        id = (RecordIdentifier)reader.createKey();
        struct = (OrcStruct)reader.createValue();
        while (reader.next((Object)id, (Object)struct)) {
            Assert.assertEquals((String)("id " + record), (long)record, (long)id.getRowId());
            Assert.assertEquals((String)("bucket " + record), (long)0L, (long)id.getBucketProperty());
            Assert.assertEquals((String)("writeid " + record), (long)1L, (long)id.getWriteId());
            Assert.assertEquals((String)("a " + record), (long)(42 * record), (long)((IntWritable)struct.getFieldValue(0)).get());
            Assert.assertEquals(null, (Object)struct.getFieldValue(1));
            Assert.assertEquals((String)("d " + record), (Object)Integer.toHexString(record), (Object)struct.getFieldValue(2).toString());
            Assert.assertEquals((String)("f " + record), null, (Object)struct.getFieldValue(3));
            ++record;
        }
        Assert.assertEquals((long)1000L, (long)record);
        reader.close();
    }

    @Test
    public void testAcidReadPastLastStripeOffset() throws Exception {
        Path baseDir = new Path(this.workDir, "base_00100");
        this.testFilePath = new Path(baseDir, "bucket_00000");
        this.fs.mkdirs(baseDir);
        this.fs.delete(this.testFilePath, true);
        TypeDescription fileSchema = TypeDescription.fromString((String)"struct<operation:int,originalTransaction:bigint,bucket:int,rowId:bigint,currentTransaction:bigint,row:struct<a:int,b:struct<c:int>,d:string>>");
        OrcRecordUpdater.KeyIndexBuilder indexBuilder = new OrcRecordUpdater.KeyIndexBuilder("test");
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).setSchema(fileSchema).compress(CompressionKind.NONE).callback((OrcFile.WriterCallback)indexBuilder).stripeSize(128L);
        Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)options);
        VectorizedRowBatch batch = fileSchema.createRowBatch(TypeDescription.RowBatchVersion.USE_DECIMAL64, 1000);
        batch.size = 1000;
        StructColumnVector scv = (StructColumnVector)batch.cols[5];
        batch.cols[0].isRepeating = true;
        ((LongColumnVector)batch.cols[0]).vector[0] = 0L;
        batch.cols[1].isRepeating = true;
        ((LongColumnVector)batch.cols[1]).vector[0] = 1L;
        batch.cols[2].isRepeating = true;
        ((LongColumnVector)batch.cols[2]).vector[0] = BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.conf).bucket(0).statementId(0));
        batch.cols[4].isRepeating = true;
        ((LongColumnVector)batch.cols[4]).vector[0] = 1L;
        LongColumnVector lcv = (LongColumnVector)((StructColumnVector)scv.fields[1]).fields[0];
        for (int r = 0; r < 1000; ++r) {
            ((LongColumnVector)batch.cols[3]).vector[r] = r;
            ((LongColumnVector)scv.fields[0]).vector[r] = r * 42;
            lcv.vector[r] = r * 10001;
            ((BytesColumnVector)scv.fields[2]).setVal(r, Integer.toHexString(r).getBytes(StandardCharsets.UTF_8));
            indexBuilder.addKey(0, 1L, (int)((LongColumnVector)batch.cols[2]).vector[0], (long)r);
        }
        for (int idx = 0; idx < 8; ++idx) {
            writer.addRowBatch(batch);
            batch.cols[2].isRepeating = true;
            ((LongColumnVector)batch.cols[2]).vector[0] = BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.conf).bucket(0).statementId(idx + 1));
            for (long row_id : ((LongColumnVector)batch.cols[3]).vector) {
                indexBuilder.addKey(0, 1L, (int)((LongColumnVector)batch.cols[2]).vector[0], row_id);
            }
        }
        writer.close();
        long fileLength = this.fs.getFileStatus(this.testFilePath).getLen();
        Reader orcReader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath);
        List stripes = orcReader.getStripes();
        StripeInformation lastStripe = (StripeInformation)stripes.get(stripes.size() - 1);
        long lastStripeOffset = lastStripe.getOffset();
        long lastStripeLength = lastStripe.getLength();
        RecordIdentifier[] keyIndex = OrcRecordUpdater.parseKeyIndex((Reader)orcReader);
        Assert.assertEquals((String)"Index length doesn't match number of stripes", (long)stripes.size(), (long)keyIndex.length);
        Assert.assertEquals((String)"1st Index entry mismatch", (Object)new RecordIdentifier(1L, 0x20000004, 999L), (Object)keyIndex[0]);
        Assert.assertEquals((String)"2nd Index entry mismatch", (Object)new RecordIdentifier(1L, 0x20000008, 999L), (Object)keyIndex[1]);
        this.conf.set("hive.txn.valid.txns", "100:99:");
        this.conf.set("schema.evolution.columns", "a,b,d");
        this.conf.set("schema.evolution.columns.types", "int,struct<c:int>,string");
        this.conf.set("hive.io.file.read.all.columns", "false");
        this.conf.set("hive.io.file.readcolumn.ids", "0,2");
        LOG.info("Last stripe " + stripes.size() + ", offset " + lastStripeOffset + ", length " + lastStripeLength);
        OrcSplit split = new OrcSplit(this.testFilePath, null, lastStripeOffset + 1L, lastStripeLength, new String[0], null, false, true, new ArrayList(), fileLength, fileLength, this.workDir, null);
        OrcInputFormat inputFormat = new OrcInputFormat();
        AcidInputFormat.RowReader reader = inputFormat.getReader((InputSplit)split, new AcidInputFormat.Options((Configuration)this.conf));
        int record = 0;
        RecordIdentifier id = (RecordIdentifier)reader.createKey();
        OrcStruct struct = (OrcStruct)reader.createValue();
        while (reader.next((Object)id, (Object)struct)) {
            ++record;
        }
        Assert.assertEquals((long)0L, (long)record);
        reader.close();
    }

    private static List<MockFile> mockDeltaWithSideFileForStreaming(String delta, int contentLength, int flush_length) {
        int blockSize = 1000;
        boolean isDeltaHflushed = contentLength < flush_length;
        LinkedList<MockFile> files = new LinkedList<MockFile>();
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(flush_length);
        bb.array();
        MockBlock[] blocks = new MockBlock[contentLength / 1000 + 1];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = new MockBlock("host1");
        }
        files.add(new MockFile("mock:/streaming/" + delta + "/bucket_00000", 1000, new byte[contentLength], isDeltaHflushed, blocks));
        files.add(new MockFile("mock:/streaming/" + delta + "/bucket_00000_flush_length", 1000, bb.array(), false, new MockBlock("host1")));
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OrcSplit> splitsForStreamingAcidTable(List<MockFile> files) throws Exception {
        try {
            MockFileSystem fs = new MockFileSystem((Configuration)this.conf, new MockFile[0]);
            files.forEach(f -> MockFileSystem.addGlobalFile(f));
            this.conf.set("bucket_count", "1");
            this.setupAcidProperties(this.conf, RowType.DUMMYROW);
            this.conf.setBoolean(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, true);
            MockPath mockPath = new MockPath(fs, "mock:/streaming");
            this.conf.set("mapred.input.dir", mockPath.toString());
            this.conf.set("fs.defaultFS", "mock:///");
            this.conf.set("fs.mock.impl", MockFileSystem.class.getName());
            this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
            OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf, 0);
            OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> fs, (Path)new MockPath(fs, "mock:/streaming"), false, null);
            List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.createSplitStrategies(context, gen);
            Assert.assertEquals((long)1L, (long)splitStrategies.size());
            Assert.assertEquals((Object)true, (Object)(splitStrategies.get(0) instanceof OrcInputFormat.ACIDSplitStrategy));
            List list = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
            return list;
        }
        finally {
            MockFileSystem.clearGlobalFiles();
        }
    }

    @Test
    public void testAcidTableStreamingBISplitGeneration() throws Exception {
        List<OrcSplit> result = null;
        LinkedList<MockFile> files = new LinkedList<MockFile>();
        files.addAll(TestInputOutputFormat.mockDeltaWithSideFileForStreaming("delta_0000001_0000010_0000", 1000, 1000));
        files.addAll(TestInputOutputFormat.mockDeltaWithSideFileForStreaming("delta_0000011_0000020_0000", 15, 95));
        result = this.splitsForStreamingAcidTable(files);
        files.clear();
        Assert.assertEquals((long)1000L, (long)result.get(0).getLength());
        Assert.assertEquals((long)95L, (long)result.get(1).getLength());
        files.addAll(TestInputOutputFormat.mockDeltaWithSideFileForStreaming("delta_0000021_0000030_0000", 2500, 2800));
        result = this.splitsForStreamingAcidTable(files);
        files.clear();
        Assert.assertEquals((long)1000L, (long)result.get(0).getLength());
        Assert.assertEquals((long)1000L, (long)result.get(1).getLength());
        Assert.assertEquals((long)800L, (long)result.get(2).getLength());
        files.addAll(TestInputOutputFormat.mockDeltaWithSideFileForStreaming("delta_0000021_0000030_0000", 1000, 450));
        result = this.splitsForStreamingAcidTable(files);
        files.clear();
        Assert.assertEquals((long)450L, (long)result.get(0).getLength());
    }

    private void setupAcidProperties(JobConf conf, RowType rowType) {
        switch (rowType) {
            case DUMMYROW: {
                conf.set("schema.evolution.columns", TestVectorizedOrcAcidRowBatchReader.DummyRow.getColumnNamesProperty());
                conf.set("schema.evolution.columns.types", TestVectorizedOrcAcidRowBatchReader.DummyRow.getColumnTypesProperty());
                break;
            }
            case MYROW: {
                conf.set("schema.evolution.columns", MyRow.getColumnNamesProperty());
                conf.set("schema.evolution.columns.types", MyRow.getColumnTypesProperty());
                break;
            }
            case BIGROW: {
                conf.set("schema.evolution.columns", BigRow.getColumnNamesProperty());
                conf.set("schema.evolution.columns.types", BigRow.getColumnTypesProperty());
            }
        }
        conf.setBoolean("transactional", true);
        conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        AcidUtils.setAcidOperationalProperties((Configuration)conf, (boolean)true, (AcidUtils.AcidOperationalProperties)AcidUtils.AcidOperationalProperties.getDefault());
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT+0");
        DATE_FORMAT.setTimeZone(gmt);
        TIME_FORMAT.setTimeZone(gmt);
    }

    static enum RowType {
        DUMMYROW,
        MYROW,
        BIGROW;

    }

    static class StringRow
    implements Writable {
        String str;
        String str2;

        StringRow(String s) {
            this.str = s;
            this.str2 = s;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }

        static String getColumnNamesProperty() {
            return "str,str2";
        }

        static String getColumnTypesProperty() {
            return "string:string";
        }
    }

    static class NestedRow
    implements Writable {
        int z;
        MyRow r;

        NestedRow(int x, int y, int z) {
            this.z = z;
            this.r = new MyRow(x, y);
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }
    }

    static class SimpleRow
    implements Writable {
        Text z;

        public SimpleRow(Text t) {
            this.z = t;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }
    }

    public static class MockFileSystem
    extends FileSystem {
        final List<MockFile> files = new ArrayList<MockFile>();
        final Map<MockFile, FileStatus> fileStatusMap = new HashMap<MockFile, FileStatus>();
        Path workingDir = new Path("/");
        private static String blockedUgi = null;
        private static final List<MockFile> globalFiles = new ArrayList<MockFile>();
        protected FileSystem.Statistics statistics;
        private int numOpenFileCalls;

        public MockFileSystem() {
        }

        public boolean exists(Path f) throws IOException {
            return super.exists(f);
        }

        public void initialize(URI uri, Configuration conf) {
            this.setConf(conf);
            this.statistics = MockFileSystem.getStatistics((String)"mock", ((Object)((Object)this)).getClass());
        }

        public MockFileSystem(Configuration conf, MockFile ... files) {
            this.setConf(conf);
            this.files.addAll(Arrays.asList(files));
            this.statistics = MockFileSystem.getStatistics((String)"mock", ((Object)((Object)this)).getClass());
        }

        public static void setBlockedUgi(String s) {
            blockedUgi = s;
        }

        void clear() {
            this.files.clear();
        }

        public URI getUri() {
            try {
                return new URI("mock:///");
            }
            catch (URISyntaxException err) {
                throw new IllegalArgumentException("huh?", err);
            }
        }

        public String getScheme() {
            return "mock";
        }

        public void touch(MockFile file) {
            if (this.fileStatusMap.containsKey(file)) {
                FileStatus fileStatus = this.fileStatusMap.get(file);
                FileStatus fileStatusNew = new FileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime() + 1L, fileStatus.getAccessTime(), fileStatus.getPermission(), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPath());
                this.fileStatusMap.put(file, fileStatusNew);
            }
        }

        public FSDataInputStream open(Path path, int i) throws IOException {
            ++this.numOpenFileCalls;
            this.statistics.incrementReadOps(1);
            System.out.println("STATS: open - " + path);
            this.checkAccess();
            MockFile file = this.findFile(path);
            if (file != null) {
                return new FSDataInputStream((InputStream)((Object)new MockInputStream(file)));
            }
            throw new FileNotFoundException("File not found: " + path);
        }

        private MockFile findFile(Path path) {
            for (MockFile file : this.files) {
                if (!file.path.equals((Object)path)) continue;
                return file;
            }
            for (MockFile file : globalFiles) {
                if (!file.path.equals((Object)path)) continue;
                return file;
            }
            return null;
        }

        private void checkAccess() throws IOException {
            if (blockedUgi == null) {
                return;
            }
            if (!blockedUgi.equals(UserGroupInformation.getCurrentUser().getShortUserName())) {
                return;
            }
            throw new MockAccessDenied();
        }

        public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
            this.statistics.incrementWriteOps(1);
            this.checkAccess();
            MockFile file = this.findFile(path);
            if (file == null) {
                file = new MockFile(path.toString(), (int)blockSize, new byte[0], new MockBlock[0]);
                this.files.add(file);
            }
            return new MockOutputStream(file);
        }

        public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
            this.statistics.incrementWriteOps(1);
            this.checkAccess();
            return this.create(path, FsPermission.getDefault(), true, bufferSize, (short)3, 262144L, progressable);
        }

        public boolean rename(Path path, Path path2) throws IOException {
            this.statistics.incrementWriteOps(1);
            this.checkAccess();
            return false;
        }

        public boolean delete(Path path) throws IOException {
            MockFile mf;
            int i;
            this.statistics.incrementWriteOps(1);
            this.checkAccess();
            int removed = 0;
            for (i = 0; i < this.files.size(); ++i) {
                mf = this.files.get(i);
                if (!path.equals((Object)mf.path)) continue;
                this.files.remove(i);
                ++removed;
                break;
            }
            for (i = 0; i < globalFiles.size(); ++i) {
                mf = this.files.get(i);
                if (!path.equals((Object)mf.path)) continue;
                globalFiles.remove(i);
                ++removed;
                break;
            }
            return removed > 0;
        }

        public boolean delete(Path path, boolean b) throws IOException {
            if (b) {
                throw new UnsupportedOperationException();
            }
            return this.delete(path);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private Iterator<LocatedFileStatus> iterator;
                {
                    this.iterator = this.listLocatedFileStatuses(f).iterator();
                }

                public boolean hasNext() throws IOException {
                    return this.iterator.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    return this.iterator.next();
                }
            };
        }

        private List<LocatedFileStatus> listLocatedFileStatuses(Path path) throws IOException {
            this.statistics.incrementReadOps(1);
            System.out.println("STATS: listLocatedFileStatuses - " + path);
            this.checkAccess();
            path = path.makeQualified((FileSystem)this);
            ArrayList<LocatedFileStatus> result = new ArrayList<LocatedFileStatus>();
            String pathname = path.toString();
            String pathnameAsDir = pathname + "/";
            TreeSet<String> dirs = new TreeSet<String>();
            MockFile file = this.findFile(path);
            if (file != null) {
                result.add(this.createLocatedStatus(file));
                return result;
            }
            this.findMatchingLocatedFiles(this.files, pathnameAsDir, dirs, result);
            this.findMatchingLocatedFiles(globalFiles, pathnameAsDir, dirs, result);
            for (String dir : dirs) {
                result.add(this.createLocatedDirectory(new MockPath(this, pathnameAsDir + dir)));
            }
            return result;
        }

        public FileStatus[] listStatus(Path path) throws IOException {
            this.statistics.incrementReadOps(1);
            System.out.println("STATS: listStatus - " + path);
            this.checkAccess();
            path = path.makeQualified((FileSystem)this);
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            String pathname = path.toString();
            String pathnameAsDir = pathname + "/";
            TreeSet<String> dirs = new TreeSet<String>();
            MockFile file = this.findFile(path);
            if (file != null) {
                return new FileStatus[]{this.createStatus(file)};
            }
            this.findMatchingFiles(this.files, pathnameAsDir, dirs, result);
            this.findMatchingFiles(globalFiles, pathnameAsDir, dirs, result);
            for (String dir : dirs) {
                result.add(this.createDirectory(new MockPath(this, pathnameAsDir + dir)));
            }
            return result.toArray(new FileStatus[result.size()]);
        }

        private void findMatchingFiles(List<MockFile> files, String pathnameAsDir, Set<String> dirs, List<FileStatus> result) {
            for (MockFile file : files) {
                String filename = file.path.toString();
                if (!filename.startsWith(pathnameAsDir)) continue;
                String tail = filename.substring(pathnameAsDir.length());
                int nextSlash = tail.indexOf(47);
                if (nextSlash > 0) {
                    dirs.add(tail.substring(0, nextSlash));
                    continue;
                }
                result.add(this.createStatus(file));
            }
        }

        private void findMatchingLocatedFiles(List<MockFile> files, String pathnameAsDir, Set<String> dirs, List<LocatedFileStatus> result) throws IOException {
            for (MockFile file : files) {
                String filename = file.path.toString();
                if (!filename.startsWith(pathnameAsDir)) continue;
                String tail = filename.substring(pathnameAsDir.length());
                int nextSlash = tail.indexOf(47);
                if (nextSlash > 0) {
                    dirs.add(tail.substring(0, nextSlash));
                    continue;
                }
                result.add(this.createLocatedStatus(file));
            }
        }

        public void setWorkingDirectory(Path path) {
            this.workingDir = path;
        }

        public Path getWorkingDirectory() {
            return this.workingDir;
        }

        public boolean mkdirs(Path path, FsPermission fsPermission) {
            this.statistics.incrementWriteOps(1);
            return false;
        }

        private FileStatus createStatus(MockFile file) {
            if (this.fileStatusMap.containsKey(file)) {
                return this.fileStatusMap.get(file);
            }
            FileStatus fileStatus = new FileStatus((long)file.length, false, 1, (long)file.blockSize, 0L, 0L, FsPermission.createImmutable((short)644), "owen", "group", file.path);
            this.fileStatusMap.put(file, fileStatus);
            return fileStatus;
        }

        private FileStatus createDirectory(Path dir) {
            return new FileStatus(0L, true, 0, 0L, 0L, 0L, FsPermission.createImmutable((short)755), "owen", "group", dir);
        }

        private LocatedFileStatus createLocatedStatus(MockFile file) throws IOException {
            FileStatus fileStatus = this.createStatus(file);
            if (file.isHdfsHflushed) {
                LocatedBlocks lb = new LocatedBlocks(fileStatus.getLen(), true, null, null, false, null, null);
                HdfsLocatedFileStatus mockStatus = (HdfsLocatedFileStatus)Mockito.mock(HdfsLocatedFileStatus.class);
                Mockito.when((Object)mockStatus.getLocatedBlocks()).thenReturn((Object)lb);
                Mockito.when((Object)mockStatus.getPath()).thenReturn((Object)fileStatus.getPath());
                Mockito.when((Object)mockStatus.getLen()).thenReturn((Object)fileStatus.getLen());
                Mockito.when((Object)mockStatus.isDirectory()).thenReturn((Object)false);
                Mockito.when((Object)mockStatus.isFile()).thenReturn((Object)true);
                Mockito.when((Object)mockStatus.getBlockSize()).thenReturn((Object)fileStatus.getBlockSize());
                Mockito.when((Object)mockStatus.getBlockLocations()).thenReturn((Object)this.getFileBlockLocationsImpl(fileStatus, 0L, fileStatus.getLen(), false));
                return mockStatus;
            }
            return new LocatedFileStatus(fileStatus, this.getFileBlockLocationsImpl(fileStatus, 0L, fileStatus.getLen(), false));
        }

        private LocatedFileStatus createLocatedDirectory(Path dir) throws IOException {
            FileStatus fileStatus = this.createDirectory(dir);
            return new LocatedFileStatus(fileStatus, this.getFileBlockLocationsImpl(fileStatus, 0L, fileStatus.getLen(), false));
        }

        public FileStatus getFileStatus(Path path) throws IOException {
            this.statistics.incrementReadOps(1);
            System.out.println("STATS: getFileStatus - " + path);
            this.checkAccess();
            path = path.makeQualified((FileSystem)this);
            String pathnameAsDir = path.toString() + "/";
            MockFile file = this.findFile(path);
            if (file != null) {
                return this.createStatus(file);
            }
            for (MockFile dir : this.files) {
                if (!dir.path.toString().startsWith(pathnameAsDir)) continue;
                return this.createDirectory(path);
            }
            for (MockFile dir : globalFiles) {
                if (!dir.path.toString().startsWith(pathnameAsDir)) continue;
                return this.createDirectory(path);
            }
            throw new FileNotFoundException("File " + path + " does not exist");
        }

        public BlockLocation[] getFileBlockLocations(FileStatus stat, long start, long len) throws IOException {
            return this.getFileBlockLocationsImpl(stat, start, len, true);
        }

        private BlockLocation[] getFileBlockLocationsImpl(FileStatus stat, long start, long len, boolean updateStats) throws IOException {
            if (updateStats) {
                this.statistics.incrementReadOps(1);
                System.out.println("STATS: getFileBlockLocationsImpl - " + stat.getPath());
            }
            this.checkAccess();
            ArrayList<BlockLocation> result = new ArrayList<BlockLocation>();
            MockFile file = this.findFile(stat.getPath());
            if (file != null) {
                for (MockBlock block : file.blocks) {
                    if (OrcInputFormat.SplitGenerator.getOverlap((long)block.offset, (long)block.length, (long)start, (long)len) <= 0L) continue;
                    String[] topology = new String[block.hosts.length];
                    for (int i = 0; i < topology.length; ++i) {
                        topology[i] = "/rack/ " + block.hosts[i];
                    }
                    result.add(new BlockLocation(block.hosts, block.hosts, topology, (long)block.offset, (long)block.length));
                }
                return result.toArray(new BlockLocation[result.size()]);
            }
            return new BlockLocation[0];
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFs{files:[");
            for (int i = 0; i < this.files.size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.files.get(i));
            }
            buffer.append("]}");
            return buffer.toString();
        }

        public int getNumOpenFileCalls() {
            return this.numOpenFileCalls;
        }

        public static void addGlobalFile(MockFile mockFile) {
            globalFiles.add(mockFile);
        }

        public static void clearGlobalFiles() {
            globalFiles.clear();
        }

        public static class MockAccessDenied
        extends IOException {
        }
    }

    public static class MockOutputStream
    extends FSDataOutputStream {
        private final MockFile file;

        public MockOutputStream(MockFile file) throws IOException {
            super((OutputStream)new DataOutputBuffer(), null);
            this.file = file;
        }

        public void setBlocks(MockBlock ... blocks) {
            this.file.blocks = blocks;
            int offset = 0;
            for (int i = 0; offset < this.file.length && i < blocks.length; offset += blocks[i].length, ++i) {
                blocks[i].offset = offset;
                blocks[i].length = Math.min(this.file.length - offset, this.file.blockSize);
            }
        }

        public void close() throws IOException {
            super.close();
            DataOutputBuffer buf = (DataOutputBuffer)this.getWrappedStream();
            this.file.length = buf.getLength();
            this.file.content = new byte[this.file.length];
            MockBlock block = new MockBlock("host1");
            block.setLength(this.file.length);
            this.setBlocks(block);
            System.arraycopy(buf.getData(), 0, this.file.content, 0, this.file.length);
        }

        public String toString() {
            return "Out stream to " + this.file.toString();
        }
    }

    public static class MockPath
    extends Path {
        private final FileSystem fs;

        public MockPath(FileSystem fs, String path) {
            super(path);
            this.fs = fs;
        }

        public FileSystem getFileSystem(Configuration conf) {
            return this.fs;
        }
    }

    static class MockInputStream
    extends FSInputStream {
        final MockFile file;
        int offset = 0;

        public MockInputStream(MockFile file) throws IOException {
            this.file = file;
        }

        public void seek(long offset) throws IOException {
            this.offset = (int)offset;
        }

        public long getPos() throws IOException {
            return this.offset;
        }

        public boolean seekToNewSource(long l) throws IOException {
            return false;
        }

        public int read() throws IOException {
            if (this.offset < this.file.length) {
                return this.file.content[this.offset++] & 0xFF;
            }
            return -1;
        }

        public int available() throws IOException {
            return this.file.length - this.offset;
        }
    }

    public static class MockFile {
        final Path path;
        int blockSize;
        int length;
        MockBlock[] blocks;
        byte[] content;
        boolean isHdfsHflushed = false;

        public MockFile(String path, int blockSize, byte[] content, MockBlock ... blocks) {
            this(path, blockSize, content, false, blocks);
        }

        public MockFile(String path, int blockSize, byte[] content, boolean isHdfsHflushed, MockBlock ... blocks) {
            this.path = new Path(path);
            this.blockSize = blockSize;
            this.blocks = blocks;
            this.content = content;
            this.length = content.length;
            this.isHdfsHflushed = isHdfsHflushed;
            int offset = 0;
            for (MockBlock block : blocks) {
                block.offset = offset;
                block.length = Math.min(this.length - offset, blockSize);
                offset += block.length;
            }
        }

        public int hashCode() {
            return this.path.hashCode() + 31 * this.length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MockFile)) {
                return false;
            }
            return ((MockFile)obj).path.equals((Object)this.path) && ((MockFile)obj).length == this.length;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mockFile{path: ");
            buffer.append(this.path.toString());
            buffer.append(", blkSize: ");
            buffer.append(this.blockSize);
            buffer.append(", len: ");
            buffer.append(this.length);
            buffer.append(", blocks: [");
            for (int i = 0; i < this.blocks.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.blocks[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MockBlock {
        int offset;
        int length;
        final String[] hosts;

        public MockBlock(String ... hosts) {
            this.hosts = hosts;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("block{offset: ");
            buffer.append(this.offset);
            buffer.append(", length: ");
            buffer.append(this.length);
            buffer.append(", hosts: [");
            for (int i = 0; i < this.hosts.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.hosts[i]);
            }
            buffer.append("]}");
            return buffer.toString();
        }
    }

    public static class MyRow
    implements Writable {
        int x;
        int y;

        MyRow(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }

        static String getColumnNamesProperty() {
            return "x,y";
        }

        static String getColumnTypesProperty() {
            return "int:int";
        }
    }

    public static class BigRowInspector
    extends StructObjectInspector {
        static final List<BigRowField> FIELDS = new ArrayList<BigRowField>();

        public List<? extends StructField> getAllStructFieldRefs() {
            return FIELDS;
        }

        public StructField getStructFieldRef(String fieldName) {
            for (StructField structField : FIELDS) {
                if (!structField.getFieldName().equals(fieldName)) continue;
                return structField;
            }
            throw new IllegalArgumentException("Can't find field " + fieldName);
        }

        public Object getStructFieldData(Object data, StructField fieldRef) {
            BigRow obj = (BigRow)data;
            switch (((BigRowField)fieldRef).id) {
                case 0: {
                    return obj.booleanValue;
                }
                case 1: {
                    return obj.byteValue;
                }
                case 2: {
                    return obj.shortValue;
                }
                case 3: {
                    return obj.intValue;
                }
                case 4: {
                    return obj.longValue;
                }
                case 5: {
                    return Float.valueOf(obj.floatValue);
                }
                case 6: {
                    return obj.doubleValue;
                }
                case 7: {
                    return obj.stringValue;
                }
                case 8: {
                    return obj.decimalValue;
                }
                case 9: {
                    return obj.dateValue;
                }
                case 10: {
                    return obj.timestampValue;
                }
            }
            throw new IllegalArgumentException("No such field " + fieldRef);
        }

        public List<Object> getStructFieldsDataAsList(Object data) {
            BigRow obj = (BigRow)data;
            ArrayList<Object> result = new ArrayList<Object>(11);
            result.add(obj.booleanValue);
            result.add(obj.byteValue);
            result.add(obj.shortValue);
            result.add(obj.intValue);
            result.add(obj.longValue);
            result.add(Float.valueOf(obj.floatValue));
            result.add(obj.doubleValue);
            result.add(obj.stringValue);
            result.add(obj.decimalValue);
            result.add(obj.dateValue);
            result.add(obj.timestampValue);
            return result;
        }

        public String getTypeName() {
            return "struct<booleanValue:boolean,byteValue:tinyint,shortValue:smallint,intValue:int,longValue:bigint,floatValue:float,doubleValue:double,stringValue:string,decimalValue:decimal>";
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.STRUCT;
        }

        static {
            FIELDS.add(new BigRowField(0, "booleanValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector));
            FIELDS.add(new BigRowField(1, "byteValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector));
            FIELDS.add(new BigRowField(2, "shortValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector));
            FIELDS.add(new BigRowField(3, "intValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector));
            FIELDS.add(new BigRowField(4, "longValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector));
            FIELDS.add(new BigRowField(5, "floatValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector));
            FIELDS.add(new BigRowField(6, "doubleValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector));
            FIELDS.add(new BigRowField(7, "stringValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
            FIELDS.add(new BigRowField(8, "decimalValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector));
            FIELDS.add(new BigRowField(9, "dateValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector));
            FIELDS.add(new BigRowField(10, "timestampValue", (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector));
        }
    }

    public static class BigRowField
    implements StructField {
        private final int id;
        private final String fieldName;
        private final ObjectInspector inspector;

        BigRowField(int id, String fieldName, ObjectInspector inspector) {
            this.id = id;
            this.fieldName = fieldName;
            this.inspector = inspector;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public String getFieldComment() {
            return null;
        }

        public int getFieldID() {
            return this.id;
        }

        public String toString() {
            return "field " + this.id + " " + this.fieldName;
        }
    }

    public static class BigRow
    implements Writable {
        boolean booleanValue;
        byte byteValue;
        short shortValue;
        int intValue;
        long longValue;
        float floatValue;
        double doubleValue;
        String stringValue;
        HiveDecimal decimalValue;
        Date dateValue;
        Timestamp timestampValue;

        BigRow(long x) {
            this.booleanValue = x % 2L == 0L;
            this.byteValue = (byte)x;
            this.shortValue = (short)x;
            this.intValue = (int)x;
            this.longValue = x;
            this.floatValue = x;
            this.doubleValue = x;
            this.stringValue = Long.toHexString(x);
            this.decimalValue = HiveDecimal.create((long)x);
            long millisUtc = x * 86400000L;
            millisUtc -= (long)LOCAL_TIMEZONE.getOffset(millisUtc);
            this.dateValue = Date.ofEpochMilli((long)millisUtc);
            this.timestampValue = Timestamp.ofEpochMilli((long)millisUtc);
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("bigrow{booleanValue: ");
            builder.append(this.booleanValue);
            builder.append(", byteValue: ");
            builder.append(this.byteValue);
            builder.append(", shortValue: ");
            builder.append(this.shortValue);
            builder.append(", intValue: ");
            builder.append(this.intValue);
            builder.append(", longValue: ");
            builder.append(this.longValue);
            builder.append(", floatValue: ");
            builder.append(this.floatValue);
            builder.append(", doubleValue: ");
            builder.append(this.doubleValue);
            builder.append(", stringValue: ");
            builder.append(this.stringValue);
            builder.append(", decimalValue: ");
            builder.append(this.decimalValue);
            builder.append(", dateValue: ");
            builder.append(DATE_FORMAT.format(this.dateValue));
            builder.append(", timestampValue: ");
            builder.append(TIME_FORMAT.format(this.timestampValue));
            builder.append("}");
            return builder.toString();
        }

        static String getColumnNamesProperty() {
            return "booleanValue,byteValue,shortValue,intValue,longValue,floatValue,doubleValue,stringValue,decimalValue,dateValue,timestampValue";
        }

        static String getColumnTypesProperty() {
            return "boolean:tinyint:smallint:int:bigint:float:double:string:decimal(38,18):date:timestamp";
        }
    }
}

