/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.io.arrow.Serializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSerializer {
    @Test
    public void testEmptyList() {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"array<tinyint>");
        List<String> fieldNames = Arrays.asList("a");
        Serializer converter = new Serializer((Configuration)new HiveConf(), "attemptId", (List)typeInfos, fieldNames);
        ArrowWrapperWritable writable = converter.emptyBatch();
        Assert.assertEquals((Object)"Schema<a: List<$data$: Int(8, true)>>", (Object)writable.getVectorSchemaRoot().getSchema().toString());
    }

    @Test
    public void testEmptyStruct() {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"struct<b:int,c:string>");
        List<String> fieldNames = Arrays.asList("a");
        Serializer converter = new Serializer((Configuration)new HiveConf(), "attemptId", (List)typeInfos, fieldNames);
        ArrowWrapperWritable writable = converter.emptyBatch();
        Assert.assertEquals((Object)"Schema<a: Struct<b: Int(32, true), c: Utf8>>", (Object)writable.getVectorSchemaRoot().getSchema().toString());
    }

    @Test
    public void testEmptyMap() {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"map<string,string>");
        List<String> fieldNames = Arrays.asList("a");
        Serializer converter = new Serializer((Configuration)new HiveConf(), "attemptId", (List)typeInfos, fieldNames);
        ArrowWrapperWritable writable = converter.emptyBatch();
        Assert.assertEquals((Object)"Schema<a: List<$data$: Struct<keys: Utf8, values: Utf8>>>", (Object)writable.getVectorSchemaRoot().getSchema().toString());
    }

    @Test
    public void testEmptyComplexStruct() {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"struct<b:array<tinyint>,c:map<string,string>,d:struct<e:array<tinyint>,f:map<string,string>>>");
        List<String> fieldNames = Arrays.asList("a");
        Serializer converter = new Serializer((Configuration)new HiveConf(), "attemptId", (List)typeInfos, fieldNames);
        ArrowWrapperWritable writable = converter.emptyBatch();
        Assert.assertEquals((Object)"Schema<a: Struct<b: List<$data$: Int(8, true)>, c: List<$data$: Struct<keys: Utf8, values: Utf8>>, d: Struct<e: List<$data$: Int(8, true)>, f: List<$data$: Struct<keys: Utf8, values: Utf8>>>>>", (Object)writable.getVectorSchemaRoot().getSchema().toString());
    }

    @Test
    public void testEmptyComplexMap() {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"map<array<tinyint>,struct<b:array<tinyint>,c:map<string,string>>>");
        List<String> fieldNames = Arrays.asList("a");
        Serializer converter = new Serializer((Configuration)new HiveConf(), "attemptId", (List)typeInfos, fieldNames);
        ArrowWrapperWritable writable = converter.emptyBatch();
        Assert.assertEquals((Object)"Schema<a: List<$data$: Struct<keys: List<$data$: Int(8, true)>, values: Struct<b: List<$data$: Int(8, true)>, c: List<$data$: Struct<keys: Utf8, values: Utf8>>>>>>", (Object)writable.getVectorSchemaRoot().getSchema().toString());
    }

    @Test
    public void testEmptyComplexList() {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)"struct<b:array<array<tinyint>>,c:array<map<string,string>>,d:array<struct<e:array<tinyint>,f:map<string,string>>>>");
        List<String> fieldNames = Arrays.asList("a");
        Serializer converter = new Serializer((Configuration)new HiveConf(), "attemptId", (List)typeInfos, fieldNames);
        ArrowWrapperWritable writable = converter.emptyBatch();
        Assert.assertEquals((Object)"Schema<a: Struct<b: List<$data$: List<$data$: Int(8, true)>>, c: List<$data$: List<$data$: Struct<keys: Utf8, values: Utf8>>>, d: List<$data$: Struct<e: List<$data$: Int(8, true)>, f: List<$data$: Struct<keys: Utf8, values: Utf8>>>>>>", (Object)writable.getVectorSchemaRoot().getSchema().toString());
    }
}

