/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSymlinkTextInputFormat {
    private static final Logger log = LoggerFactory.getLogger(TestSymlinkTextInputFormat.class);
    private Configuration conf;
    private JobConf job;
    private FileSystem fileSystem;
    private Path testDir;
    Reporter reporter;
    private Path dataDir1;
    private Path dataDir2;
    private Path symlinkDir;

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.job = new JobConf(this.conf);
        TableDesc tblDesc = Utilities.defaultTd;
        PartitionDesc partDesc = new PartitionDesc(tblDesc, null);
        LinkedHashMap<Path, PartitionDesc> pt = new LinkedHashMap<Path, PartitionDesc>();
        pt.put(new Path("/tmp/testfolder"), partDesc);
        MapredWork mrwork = new MapredWork();
        mrwork.getMapWork().setPathToPartitionInfo(pt);
        Utilities.setMapRedWork((Configuration)this.job, (MapredWork)mrwork, (Path)new Path("/tmp/" + System.getProperty("user.name"), "hive"));
        this.fileSystem = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new Path(System.getProperty("test.tmp.dir", System.getProperty("user.dir", new File(".").getAbsolutePath())) + "/TestSymlinkTextInputFormat");
        this.reporter = Reporter.NULL;
        this.fileSystem.delete(this.testDir, true);
        this.dataDir1 = new Path(this.testDir, "datadir1");
        this.dataDir2 = new Path(this.testDir, "datadir2");
        this.symlinkDir = new Path(this.testDir, "symlinkdir");
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCombine() throws Exception {
        JobConf newJob = new JobConf((Configuration)this.job);
        FileSystem fs = this.dataDir1.getFileSystem((Configuration)newJob);
        Path dir1_file1 = new Path(this.dataDir1, "combinefile1_1");
        this.writeTextFile(dir1_file1, "dir1_file1_line1\ndir1_file1_line2\n");
        Path dir2_file1 = new Path(this.dataDir2, "combinefile2_1");
        this.writeTextFile(dir2_file1, "dir2_file1_line1\ndir2_file1_line2\n");
        this.writeSymlinkFile(new Path(this.symlinkDir, "symlink_file"), new Path(this.dataDir1, "combinefile1_1"), new Path(this.dataDir2, "combinefile2_1"));
        HiveConf hiveConf = new HiveConf(TestSymlinkTextInputFormat.class);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_REWORK_MAPREDWORK, (boolean)true);
        HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        Driver drv = new Driver(hiveConf);
        String tblName = "text_symlink_text";
        String createSymlinkTableCmd = "create table " + tblName + " (key int) stored as  inputformat 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat'  outputformat 'org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat'";
        SessionState.start((HiveConf)hiveConf);
        boolean tblCreated = false;
        try {
            int ecode = 0;
            drv.run(createSymlinkTableCmd);
            tblCreated = true;
            String loadFileCommand = "LOAD DATA LOCAL INPATH '" + new Path(this.symlinkDir, "symlink_file").toString() + "' INTO TABLE " + tblName;
            drv.run(loadFileCommand);
            String cmd = "select key*1 from " + tblName;
            ecode = drv.compile(cmd, true);
            if (ecode != 0) {
                throw new Exception("Select compile: " + cmd + " failed with exit code= " + ecode);
            }
            Context ctx = new Context((Configuration)newJob);
            Path emptyScratchDir = ctx.getMRTmpPath();
            FileSystem fileSys = emptyScratchDir.getFileSystem((Configuration)newJob);
            fileSys.mkdirs(emptyScratchDir);
            QueryPlan plan = drv.getPlan();
            MapRedTask selectTask = (MapRedTask)plan.getRootTasks().get(0);
            List inputPaths = Utilities.getInputPaths((JobConf)newJob, (MapWork)((MapredWork)selectTask.getWork()).getMapWork(), (Path)emptyScratchDir, (Context)ctx, (boolean)false);
            Utilities.setInputPaths((JobConf)newJob, (List)inputPaths);
            Utilities.setMapRedWork((Configuration)newJob, (MapredWork)((MapredWork)selectTask.getWork()), (Path)ctx.getMRTmpPath());
            CombineHiveInputFormat combineInputFormat = (CombineHiveInputFormat)ReflectionUtils.newInstance(CombineHiveInputFormat.class, (Configuration)newJob);
            InputSplit[] retSplits = combineInputFormat.getSplits(newJob, 1);
            Assert.assertEquals((long)1L, (long)retSplits.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Caught exception " + e));
        }
        finally {
            if (tblCreated) {
                drv.run("drop table text_symlink_text");
            }
        }
    }

    @Test
    public void testAccuracy1() throws IOException {
        FileSystem fs = this.dataDir1.getFileSystem((Configuration)this.job);
        int symbolLinkedFileSize = 0;
        Path dir1_file1 = new Path(this.dataDir1, "file1");
        this.writeTextFile(dir1_file1, "dir1_file1_line1\ndir1_file1_line2\n");
        symbolLinkedFileSize = (int)((long)symbolLinkedFileSize + fs.getFileStatus(dir1_file1).getLen());
        Path dir1_file2 = new Path(this.dataDir1, "file2");
        this.writeTextFile(dir1_file2, "dir1_file2_line1\ndir1_file2_line2\n");
        Path dir2_file1 = new Path(this.dataDir2, "file1");
        this.writeTextFile(dir2_file1, "dir2_file1_line1\ndir2_file1_line2\n");
        Path dir2_file2 = new Path(this.dataDir2, "file2");
        this.writeTextFile(dir2_file2, "dir2_file2_line1\ndir2_file2_line2\n");
        symbolLinkedFileSize = (int)((long)symbolLinkedFileSize + fs.getFileStatus(dir2_file2).getLen());
        this.writeSymlinkFile(new Path(this.symlinkDir, "symlink_file"), new Path(this.dataDir1, "file1"), new Path(this.dataDir2, "file2"));
        SymlinkTextInputFormat inputFormat = new SymlinkTextInputFormat();
        ContentSummary cs = inputFormat.getContentSummary(this.symlinkDir, this.job);
        Assert.assertEquals((long)symbolLinkedFileSize, (long)cs.getLength());
        Assert.assertEquals((long)2L, (long)cs.getFileCount());
        Assert.assertEquals((long)0L, (long)cs.getDirectoryCount());
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.symlinkDir});
        InputSplit[] splits = inputFormat.getSplits(this.job, 2);
        log.info("Number of splits: " + splits.length);
        ArrayList<String> received = new ArrayList<String>();
        for (InputSplit split : splits) {
            RecordReader reader = inputFormat.getRecordReader(split, this.job, this.reporter);
            LongWritable key = (LongWritable)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                received.add(value.toString());
            }
            reader.close();
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("dir1_file1_line1");
        expected.add("dir1_file1_line2");
        expected.add("dir2_file2_line1");
        expected.add("dir2_file2_line2");
        Assert.assertEquals(expected, received);
    }

    @Test
    public void testAccuracy2() throws IOException {
        this.fileSystem.mkdirs(this.symlinkDir);
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.symlinkDir});
        SymlinkTextInputFormat inputFormat = new SymlinkTextInputFormat();
        ContentSummary cs = inputFormat.getContentSummary(this.symlinkDir, this.job);
        Assert.assertEquals((long)0L, (long)cs.getLength());
        Assert.assertEquals((long)0L, (long)cs.getFileCount());
        Assert.assertEquals((long)0L, (long)cs.getDirectoryCount());
        InputSplit[] splits = inputFormat.getSplits(this.job, 2);
        log.info("Number of splits: " + splits.length);
        ArrayList<String> received = new ArrayList<String>();
        for (InputSplit split : splits) {
            RecordReader reader = inputFormat.getRecordReader(split, this.job, this.reporter);
            LongWritable key = (LongWritable)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                received.add(value.toString());
            }
            reader.close();
        }
        ArrayList expected = new ArrayList();
        Assert.assertEquals(expected, received);
    }

    @Test
    public void testFailure() {
        SymlinkTextInputFormat inputFormat = new SymlinkTextInputFormat();
        try {
            inputFormat.getSplits(this.job, 2);
            Assert.fail((String)"IOException expected if no job input paths specified.");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Incorrect exception message for no job input paths error.", (Object)"No input paths specified in job.", (Object)e.getMessage());
        }
    }

    private void writeTextFile(Path file, String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.fileSystem.create(file));
        writer.write(content);
        writer.close();
    }

    private void writeSymlinkFile(Path symlinkFile, Path ... paths) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.fileSystem.create(symlinkFile));
        for (Path path : paths) {
            writer.write(path.toString());
            writer.write("\n");
        }
        writer.close();
    }
}

