/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.io.NonSyncDataInputBuffer;
import org.apache.hadoop.hive.ql.io.NonSyncDataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveInputOutputBuffer {
    private static final int numCases = 14;
    private static final String asciiLine1 = "Foo 12345 moo";
    private static final String asciiLine2 = "Line two";
    private static final String asciiString = "Foo 12345 moo\nLine two\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadAndWrite() throws IOException {
        String testString = "test_hive_input_output_number_0";
        byte[] string_bytes = testString.getBytes();
        NonSyncDataInputBuffer inBuffer = new NonSyncDataInputBuffer();
        NonSyncDataOutputBuffer outBuffer = new NonSyncDataOutputBuffer();
        try {
            outBuffer.write(string_bytes);
            inBuffer.reset(outBuffer.getData(), 0, outBuffer.getLength());
            byte[] readBytes = new byte[string_bytes.length];
            inBuffer.read(readBytes);
            String readString = new String(readBytes);
            Assert.assertEquals((String)"Field testReadAndWrite()", (Object)readString, (Object)testString);
        }
        finally {
            inBuffer.close();
            outBuffer.close();
        }
    }

    private static void readJunk(NonSyncDataInputBuffer in, Random r, long seed, int iter) throws IOException {
        r.setSeed(seed);
        block16: for (int i = 0; i < iter; ++i) {
            switch (r.nextInt(14)) {
                case 0: {
                    Assert.assertEquals((long)((byte)(r.nextInt() & 0xFF)), (long)in.readByte());
                    continue block16;
                }
                case 1: {
                    Assert.assertEquals((long)((short)(r.nextInt() & 0xFFFF)), (long)in.readShort());
                    continue block16;
                }
                case 2: {
                    Assert.assertEquals((long)r.nextInt(), (long)in.readInt());
                    continue block16;
                }
                case 3: {
                    Assert.assertEquals((long)r.nextLong(), (long)in.readLong());
                    continue block16;
                }
                case 4: {
                    Assert.assertEquals((long)Double.doubleToLongBits(r.nextDouble()), (long)Double.doubleToLongBits(in.readDouble()));
                    continue block16;
                }
                case 5: {
                    Assert.assertEquals((long)Float.floatToIntBits(r.nextFloat()), (long)Float.floatToIntBits(in.readFloat()));
                    continue block16;
                }
                case 6: {
                    int len = r.nextInt(1024);
                    byte[] vb = new byte[len];
                    r.nextBytes(vb);
                    byte[] b = new byte[len];
                    in.readFully(b, 0, len);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    r.nextBytes(vb);
                    in.read(b, 0, len);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    r.nextBytes(vb);
                    in.readFully(b);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    continue block16;
                }
                case 7: {
                    Assert.assertEquals((Object)r.nextBoolean(), (Object)in.readBoolean());
                    continue block16;
                }
                case 8: {
                    Assert.assertEquals((long)((char)r.nextInt()), (long)in.readChar());
                    continue block16;
                }
                case 9: {
                    int actualUB = in.readUnsignedByte();
                    Assert.assertTrue((actualUB >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((actualUB <= 255 ? 1 : 0) != 0);
                    Assert.assertEquals((long)(r.nextInt() & 0xFF), (long)actualUB);
                    continue block16;
                }
                case 10: {
                    int actualUS = in.readUnsignedShort();
                    Assert.assertTrue((actualUS >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((actualUS <= 65535 ? 1 : 0) != 0);
                    Assert.assertEquals((long)(r.nextInt() & 0xFFFF), (long)actualUS);
                    continue block16;
                }
                case 11: {
                    String expectedString1 = TestHiveInputOutputBuffer.composeString(1024, r);
                    Assert.assertEquals((Object)expectedString1, (Object)in.readUTF());
                    String expectedString2 = TestHiveInputOutputBuffer.composeString(1024, r);
                    Assert.assertEquals((Object)expectedString2, (Object)NonSyncDataInputBuffer.readUTF((DataInput)in));
                    continue block16;
                }
                case 12: {
                    Assert.assertEquals((Object)asciiLine1, (Object)in.readLine());
                    Assert.assertEquals((Object)asciiLine2, (Object)in.readLine());
                    continue block16;
                }
                case 13: {
                    in.skipBytes(8);
                    r.nextLong();
                    Assert.assertEquals((long)r.nextLong(), (long)in.readLong());
                }
            }
        }
    }

    private static void writeJunk(DataOutput out, Random r, long seed, int iter) throws IOException {
        r.setSeed(seed);
        block16: for (int i = 0; i < iter; ++i) {
            switch (r.nextInt(14)) {
                case 0: {
                    out.writeByte(r.nextInt());
                    continue block16;
                }
                case 1: {
                    out.writeShort((short)(r.nextInt() & 0xFFFF));
                    continue block16;
                }
                case 2: {
                    out.writeInt(r.nextInt());
                    continue block16;
                }
                case 3: {
                    out.writeLong(r.nextLong());
                    continue block16;
                }
                case 4: {
                    out.writeDouble(r.nextDouble());
                    continue block16;
                }
                case 5: {
                    out.writeFloat(r.nextFloat());
                    continue block16;
                }
                case 6: {
                    byte[] b = new byte[r.nextInt(1024)];
                    r.nextBytes(b);
                    out.write(b);
                    r.nextBytes(b);
                    out.write(b);
                    r.nextBytes(b);
                    out.write(b);
                    continue block16;
                }
                case 7: {
                    out.writeBoolean(r.nextBoolean());
                    continue block16;
                }
                case 8: {
                    out.writeChar((char)r.nextInt());
                    continue block16;
                }
                case 9: {
                    out.writeByte((byte)r.nextInt());
                    continue block16;
                }
                case 10: {
                    out.writeShort((short)r.nextInt());
                    continue block16;
                }
                case 11: {
                    String string = TestHiveInputOutputBuffer.composeString(1024, r);
                    out.writeUTF(string);
                    String string2 = TestHiveInputOutputBuffer.composeString(1024, r);
                    out.writeUTF(string2);
                    continue block16;
                }
                case 12: {
                    byte[] bb = asciiString.getBytes("UTF-8");
                    out.write(bb);
                    continue block16;
                }
                case 13: {
                    out.writeLong(r.nextLong());
                    out.writeLong(r.nextLong());
                }
            }
        }
    }

    private static String composeString(int len, Random r) {
        char[] cc = new char[len];
        for (int i = 0; i < len; ++i) {
            char ch;
            while (!Character.isDefined(ch = (char)r.nextInt()) || Character.isHighSurrogate(ch) || Character.isLowSurrogate(ch)) {
            }
            cc[i] = ch;
        }
        return new String(cc);
    }

    @Test
    public void testBaseBuffers() throws IOException {
        NonSyncDataOutputBuffer dob = new NonSyncDataOutputBuffer();
        Random r = new Random();
        long seed = 81985529216486895L;
        r.setSeed(81985529216486895L);
        System.out.println("SEED: 81985529216486895");
        TestHiveInputOutputBuffer.writeJunk((DataOutput)dob, r, 81985529216486895L, 1000);
        NonSyncDataInputBuffer dib = new NonSyncDataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        Assert.assertEquals((long)0L, (long)dib.getPosition());
        Assert.assertEquals((long)dob.getLength(), (long)dib.getLength());
        TestHiveInputOutputBuffer.readJunk(dib, r, 81985529216486895L, 1000);
        dob.reset();
        TestHiveInputOutputBuffer.writeJunk((DataOutput)dob, r, 81985529216486895L, 1000);
        dib.reset(dob.getData(), dob.getLength());
        Assert.assertEquals((long)0L, (long)dib.getPosition());
        Assert.assertEquals((long)dob.getLength(), (long)dib.getLength());
        TestHiveInputOutputBuffer.readJunk(dib, r, 81985529216486895L, 1000);
    }
}

