/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestAcidInputFormat {
    @Mock
    private DataInput mockDataInput;

    @Test
    public void testDeltaMetaDataReadFieldsNoStatementIds() throws Exception {
        Mockito.when((Object)this.mockDataInput.readLong()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        Mockito.when((Object)this.mockDataInput.readInt()).thenReturn((Object)0, (Object[])new Integer[]{0});
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData();
        deltaMetaData.readFields(this.mockDataInput);
        ((DataInput)Mockito.verify((Object)this.mockDataInput, (VerificationMode)Mockito.times((int)2))).readInt();
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDeltaMetaDataReadFieldsWithStatementIds() throws Exception {
        Mockito.when((Object)this.mockDataInput.readLong()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        Mockito.when((Object)this.mockDataInput.readInt()).thenReturn((Object)2, (Object[])new Integer[]{100, 101, 0});
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData();
        deltaMetaData.readFields(this.mockDataInput);
        ((DataInput)Mockito.verify((Object)this.mockDataInput, (VerificationMode)Mockito.times((int)4))).readInt();
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(deltaMetaData.getStmtIds().get(0), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat(deltaMetaData.getStmtIds().get(1), (Matcher)CoreMatchers.is((Object)101));
    }

    @Test
    public void testDeltaMetaConstructWithState() throws Exception {
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, Arrays.asList(97, 98, 99), 0L, null);
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)2000L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2001L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(deltaMetaData.getStmtIds().get(0), (Matcher)CoreMatchers.is((Object)97));
        Assert.assertThat(deltaMetaData.getStmtIds().get(1), (Matcher)CoreMatchers.is((Object)98));
        Assert.assertThat(deltaMetaData.getStmtIds().get(2), (Matcher)CoreMatchers.is((Object)99));
    }

    @Test
    public void testDeltaMetaWithFile() throws Exception {
        FileStatus fs = new FileStatus(200L, false, 100, 100L, 100L, new Path("mypath"));
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, new ArrayList(), 0L, Collections.singletonList(new AcidInputFormat.DeltaFileMetaData((HadoopShims.HdfsFileStatusWithId)new HdfsUtils.HdfsFileStatusWithoutId(fs), null, 1)));
        Assert.assertEquals((long)2000L, (long)deltaMetaData.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)deltaMetaData.getMaxWriteId());
        Assert.assertEquals((long)0L, (long)deltaMetaData.getStmtIds().size());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        deltaMetaData.write((DataOutput)new DataOutputStream(byteArrayOutputStream));
        byte[] bytes = byteArrayOutputStream.toByteArray();
        AcidInputFormat.DeltaMetaData copy = new AcidInputFormat.DeltaMetaData();
        copy.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        Assert.assertEquals((long)2000L, (long)copy.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)copy.getMaxWriteId());
        Assert.assertEquals((long)0L, (long)copy.getStmtIds().size());
        AcidInputFormat.DeltaFileMetaData fileMetaData = (AcidInputFormat.DeltaFileMetaData)copy.getDeltaFiles().get(0);
        Object fileId = fileMetaData.getFileId(new Path("deleteDelta"), 1, (Configuration)new HiveConf());
        Assert.assertTrue((boolean)(fileId instanceof SyntheticFileId));
        Assert.assertEquals((long)100L, (long)((SyntheticFileId)fileId).getModTime());
        Assert.assertEquals((long)200L, (long)((SyntheticFileId)fileId).getLength());
        String fileName = fileMetaData.getPath(new Path("deleteDelta"), 1).getName();
        Assert.assertEquals((Object)"bucket_00001", (Object)fileName);
    }

    @Test
    public void testDeltaMetaWithHdfsFileId() throws Exception {
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, new ArrayList(), 0L, Collections.singletonList(new AcidInputFormat.DeltaFileMetaData(100L, 200L, null, Long.valueOf(123L), null, 1)));
        Assert.assertEquals((long)2000L, (long)deltaMetaData.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)deltaMetaData.getMaxWriteId());
        Assert.assertEquals((long)0L, (long)deltaMetaData.getStmtIds().size());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        deltaMetaData.write((DataOutput)new DataOutputStream(byteArrayOutputStream));
        byte[] bytes = byteArrayOutputStream.toByteArray();
        AcidInputFormat.DeltaMetaData copy = new AcidInputFormat.DeltaMetaData();
        copy.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        Assert.assertEquals((long)2000L, (long)copy.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)copy.getMaxWriteId());
        Assert.assertEquals((long)0L, (long)copy.getStmtIds().size());
        AcidInputFormat.DeltaFileMetaData fileMetaData = (AcidInputFormat.DeltaFileMetaData)copy.getDeltaFiles().get(0);
        Object fileId = fileMetaData.getFileId(new Path("deleteDelta"), 1, (Configuration)new HiveConf());
        Assert.assertTrue((boolean)(fileId instanceof Long));
        long fId = (Long)fileId;
        Assert.assertEquals((long)123L, (long)fId);
        String fileName = fileMetaData.getPath(new Path("deleteDelta"), 1).getName();
        Assert.assertEquals((Object)"bucket_00001", (Object)fileName);
    }

    @Test
    public void testDeltaMetaWithAttemptId() throws Exception {
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, new ArrayList(), 0L, Collections.singletonList(new AcidInputFormat.DeltaFileMetaData(100L, 200L, Integer.valueOf(123), null, null, 1)));
        Assert.assertEquals((long)2000L, (long)deltaMetaData.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)deltaMetaData.getMaxWriteId());
        Assert.assertEquals((long)0L, (long)deltaMetaData.getStmtIds().size());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        deltaMetaData.write((DataOutput)new DataOutputStream(byteArrayOutputStream));
        byte[] bytes = byteArrayOutputStream.toByteArray();
        AcidInputFormat.DeltaMetaData copy = new AcidInputFormat.DeltaMetaData();
        copy.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        Assert.assertEquals((long)2000L, (long)copy.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)copy.getMaxWriteId());
        Assert.assertEquals((long)0L, (long)copy.getStmtIds().size());
        AcidInputFormat.DeltaFileMetaData fileMetaData = (AcidInputFormat.DeltaFileMetaData)copy.getDeltaFiles().get(0);
        Object fileId = fileMetaData.getFileId(new Path("deleteDelta"), 1, (Configuration)new HiveConf());
        Assert.assertTrue((boolean)(fileId instanceof SyntheticFileId));
        Assert.assertEquals((long)100L, (long)((SyntheticFileId)fileId).getModTime());
        Assert.assertEquals((long)200L, (long)((SyntheticFileId)fileId).getLength());
        String fileName = fileMetaData.getPath(new Path("deleteDelta"), 1).getName();
        Assert.assertEquals((Object)"bucket_00001_123", (Object)fileName);
    }

    @Test
    public void testDeltaMetaWithFileMultiStatement() throws Exception {
        FileStatus fs = new FileStatus(200L, false, 100, 100L, 100L, new Path("mypath"));
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, Arrays.asList(97, 98, 99), 0L, Collections.singletonList(new AcidInputFormat.DeltaFileMetaData((HadoopShims.HdfsFileStatusWithId)new HdfsUtils.HdfsFileStatusWithoutId(fs), Integer.valueOf(97), 1)));
        Assert.assertEquals((long)2000L, (long)deltaMetaData.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)deltaMetaData.getMaxWriteId());
        Assert.assertEquals((long)3L, (long)deltaMetaData.getStmtIds().size());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        deltaMetaData.write((DataOutput)new DataOutputStream(byteArrayOutputStream));
        byte[] bytes = byteArrayOutputStream.toByteArray();
        AcidInputFormat.DeltaMetaData copy = new AcidInputFormat.DeltaMetaData();
        copy.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)));
        Assert.assertEquals((long)2000L, (long)copy.getMinWriteId());
        Assert.assertEquals((long)2001L, (long)copy.getMaxWriteId());
        Assert.assertEquals((long)3L, (long)copy.getStmtIds().size());
        Object fileId = ((AcidInputFormat.DeltaFileMetaData)copy.getDeltaFiles().get(0)).getFileId(new Path("deleteDelta"), 1, (Configuration)new HiveConf());
        Assert.assertTrue((boolean)(fileId instanceof SyntheticFileId));
        Assert.assertEquals((long)100L, (long)((SyntheticFileId)fileId).getModTime());
        Assert.assertEquals((long)200L, (long)((SyntheticFileId)fileId).getLength());
        Assert.assertEquals((long)1L, (long)copy.getDeltaFilesForStmtId(Integer.valueOf(97)).size());
        Assert.assertEquals((long)0L, (long)copy.getDeltaFilesForStmtId(Integer.valueOf(99)).size());
    }

    @Test
    public void testDeltaMetaDataReadFieldsWithStatementIdsResetsState() throws Exception {
        Mockito.when((Object)this.mockDataInput.readLong()).thenReturn((Object)1L, (Object[])new Long[]{2L});
        Mockito.when((Object)this.mockDataInput.readInt()).thenReturn((Object)2, (Object[])new Integer[]{100, 101, 0});
        ArrayList<Integer> statementIds = new ArrayList<Integer>();
        statementIds.add(97);
        statementIds.add(98);
        statementIds.add(99);
        AcidInputFormat.DeltaMetaData deltaMetaData = new AcidInputFormat.DeltaMetaData(2000L, 2001L, statementIds, 0L, null);
        deltaMetaData.readFields(this.mockDataInput);
        ((DataInput)Mockito.verify((Object)this.mockDataInput, (VerificationMode)Mockito.times((int)4))).readInt();
        Assert.assertThat((Object)deltaMetaData.getMinWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)deltaMetaData.getMaxWriteId(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)deltaMetaData.getStmtIds().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(deltaMetaData.getStmtIds().get(0), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat(deltaMetaData.getStmtIds().get(1), (Matcher)CoreMatchers.is((Object)101));
    }
}

