/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookWithParseHooks;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestQueryHooks {
    private static HiveConf conf;

    @BeforeClass
    public static void setUpBeforeClass() {
        conf = new HiveConf(TestQueryHooks.class);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
    }

    @Test
    public void testAllQueryLifeTimeWithParseHooks() throws Exception {
        String query = "select 1";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHookWithParseHooks mockHook = (QueryLifeTimeHookWithParseHooks)Mockito.mock(QueryLifeTimeHookWithParseHooks.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook((QueryLifeTimeHook)mockHook);
        driver.run(query);
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeParse((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterParse((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)false));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)false));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeExecution((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterExecution((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testQueryLifeTimeWithParseHooksWithParseError() throws Exception {
        String query = "invalidquery";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHookWithParseHooks mockHook = (QueryLifeTimeHookWithParseHooks)Mockito.mock(QueryLifeTimeHookWithParseHooks.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook((QueryLifeTimeHook)mockHook);
        try {
            driver.run(query);
            Assert.fail((String)"Expected parsing to fail");
        }
        catch (CommandProcessorException commandProcessorException) {
            // empty catch block
        }
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeParse((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterParse((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)true));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeCompile((QueryLifeTimeHookContext)ArgumentMatchers.any());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterCompile((QueryLifeTimeHookContext)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeExecution((QueryLifeTimeHookContext)ArgumentMatchers.any());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterExecution((QueryLifeTimeHookContext)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testQueryLifeTimeWithParseHooksWithCompileError() throws Exception {
        String query = "select * from foo";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHookWithParseHooks mockHook = (QueryLifeTimeHookWithParseHooks)Mockito.mock(QueryLifeTimeHookWithParseHooks.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook((QueryLifeTimeHook)mockHook);
        try {
            driver.run(query);
            Assert.fail((String)"Expected compilation to fail");
        }
        catch (CommandProcessorException commandProcessorException) {
            // empty catch block
        }
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeParse((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterParse((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)false));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)true));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeExecution((QueryLifeTimeHookContext)ArgumentMatchers.any());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterExecution((QueryLifeTimeHookContext)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testAllQueryLifeTimeHooks() throws Exception {
        String query = "select 1";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHook mockHook = (QueryLifeTimeHook)Mockito.mock(QueryLifeTimeHook.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook(mockHook);
        driver.run(query);
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)false));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).beforeExecution((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).afterExecution((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testQueryLifeTimeWithCompileError() throws Exception {
        String query = "select * from foo";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHook mockHook = (QueryLifeTimeHook)Mockito.mock(QueryLifeTimeHook.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook(mockHook);
        try {
            driver.run(query);
            Assert.fail((String)"Expected compilation to fail");
        }
        catch (CommandProcessorException commandProcessorException) {
            // empty catch block
        }
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)ArgumentMatchers.argThat((ArgumentMatcher)argMatcher), ArgumentMatchers.eq((boolean)true));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeExecution((QueryLifeTimeHookContext)ArgumentMatchers.any());
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterExecution((QueryLifeTimeHookContext)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    private Driver createDriver() throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        return driver;
    }

    private static final class QueryLifeTimeHookContextMatcher
    implements ArgumentMatcher<QueryLifeTimeHookContext> {
        private final String command;

        private QueryLifeTimeHookContextMatcher(String command) {
            this.command = command;
        }

        public boolean matches(QueryLifeTimeHookContext queryLifeTimeHookContext) {
            return queryLifeTimeHookContext.getCommand().equals(this.command);
        }
    }
}

