/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.HiveProtoLoggingHook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.proto.HiveHookEvents;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.history.logging.proto.DatePartitionedLogger;
import org.apache.tez.dag.history.logging.proto.ProtoMessageReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHiveProtoLoggingHook {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private HiveConf conf;
    private HookContext context;
    private String tmpFolder;

    @Before
    public void setup() throws Exception {
        this.conf = new HiveConf();
        this.conf.set(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, "llap_queue");
        this.conf.set(HiveConf.ConfVars.HIVE_PROTO_EVENTS_QUEUE_CAPACITY.varname, "3");
        this.conf.set("mapreduce.job.queuename", "mr_queue");
        this.conf.set("tez.queue.name", "tez_queue");
        this.tmpFolder = this.folder.newFolder().getAbsolutePath();
        this.conf.setVar(HiveConf.ConfVars.HIVE_PROTO_EVENTS_BASE_PATH, this.tmpFolder);
        QueryState state = new QueryState.Builder().withHiveConf(this.conf).build();
        QueryPlan queryPlan = new QueryPlan(HiveOperation.QUERY){};
        queryPlan.setQueryId("test_queryId");
        queryPlan.setQueryStartTime(Long.valueOf(1234L));
        queryPlan.setQueryString("SELECT * FROM t WHERE i > 10");
        queryPlan.setRootTasks(new ArrayList());
        queryPlan.setInputs(new HashSet());
        queryPlan.setOutputs(new HashSet());
        PerfLogger perf = PerfLogger.getPerfLogger((HiveConf)this.conf, (boolean)true);
        this.context = new HookContext(queryPlan, state, null, "test_user", "192.168.10.10", "hive_addr", "test_op_id", "test_session_id", "test_thread_id", true, perf, null);
    }

    @Test
    public void testPreEventLog() throws Exception {
        this.context.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, (Clock)SystemClock.getInstance());
        evtLogger.handle(this.context);
        evtLogger.shutdown();
        HiveHookEvents.HiveHookEventProto event = this.loadEvent(this.conf, this.tmpFolder);
        Assert.assertEquals((Object)HiveProtoLoggingHook.EventType.QUERY_SUBMITTED.name(), (Object)event.getEventType());
        Assert.assertEquals((long)1234L, (long)event.getTimestamp());
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)event.getUser());
        Assert.assertEquals((Object)"test_user", (Object)event.getRequestUser());
        Assert.assertEquals((Object)"test_queryId", (Object)event.getHiveQueryId());
        Assert.assertEquals((Object)"test_op_id", (Object)event.getOperationId());
        Assert.assertEquals((Object)HiveProtoLoggingHook.ExecutionMode.NONE.name(), (Object)event.getExecutionMode());
        Assert.assertFalse((boolean)event.hasQueue());
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.TEZ, Boolean.FALSE.toString());
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.MAPRED, Boolean.FALSE.toString());
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.CLIENT_IP_ADDRESS, "192.168.10.10");
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.SESSION_ID, "test_session_id");
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.THREAD_NAME, "test_thread_id");
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.HIVE_INSTANCE_TYPE, "HS2");
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.HIVE_ADDRESS, "hive_addr");
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.CONF, null);
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.QUERY, null);
    }

    @Test
    public void testQueueLogs() throws Exception {
        this.context.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, (Clock)SystemClock.getInstance());
        this.context.getQueryPlan().getRootTasks().add(new ExecDriver());
        evtLogger.handle(this.context);
        MapWork mapWork = new MapWork();
        TezWork tezWork = new TezWork("test_queryid");
        tezWork.add((BaseWork)mapWork);
        TezTask task = new TezTask();
        task.setId("id1");
        task.setWork((Serializable)tezWork);
        this.context.getQueryPlan().getRootTasks().add(task);
        this.context.getQueryPlan().getRootTasks().add(new TezTask());
        evtLogger.handle(this.context);
        mapWork.setLlapMode(true);
        evtLogger.handle(this.context);
        evtLogger.shutdown();
        ProtoMessageReader<HiveHookEvents.HiveHookEventProto> reader = TestHiveProtoLoggingHook.getTestReader(this.conf, this.tmpFolder);
        HiveHookEvents.HiveHookEventProto event = (HiveHookEvents.HiveHookEventProto)reader.readEvent();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)HiveProtoLoggingHook.ExecutionMode.MR.name(), (Object)event.getExecutionMode());
        Assert.assertEquals((Object)event.getQueue(), (Object)"mr_queue");
        event = (HiveHookEvents.HiveHookEventProto)reader.readEvent();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)HiveProtoLoggingHook.ExecutionMode.TEZ.name(), (Object)event.getExecutionMode());
        Assert.assertEquals((Object)event.getQueue(), (Object)"tez_queue");
        event = (HiveHookEvents.HiveHookEventProto)reader.readEvent();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)HiveProtoLoggingHook.ExecutionMode.LLAP.name(), (Object)event.getExecutionMode());
        Assert.assertEquals((Object)event.getQueue(), (Object)"llap_queue");
    }

    @Ignore(value="might fail intermittently")
    @Test
    public void testDropsEventWhenQueueIsFull() throws Exception {
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, (Clock)SystemClock.getInstance());
        this.context.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
        evtLogger.handle(this.context);
        evtLogger.handle(this.context);
        evtLogger.handle(this.context);
        evtLogger.handle(this.context);
        evtLogger.shutdown();
        ProtoMessageReader<HiveHookEvents.HiveHookEventProto> reader = TestHiveProtoLoggingHook.getTestReader(this.conf, this.tmpFolder);
        reader.readEvent();
        reader.readEvent();
        reader.readEvent();
        try {
            reader.readEvent();
            Assert.fail((String)"Expected 3 events due to queue capacity limit, got 4.");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testPreAndPostEventBoth() throws Exception {
        this.context.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, (Clock)SystemClock.getInstance());
        evtLogger.handle(this.context);
        this.context.setHookType(HookContext.HookType.POST_EXEC_HOOK);
        evtLogger.handle(this.context);
        evtLogger.shutdown();
        ProtoMessageReader<HiveHookEvents.HiveHookEventProto> reader = TestHiveProtoLoggingHook.getTestReader(this.conf, this.tmpFolder);
        HiveHookEvents.HiveHookEventProto event = (HiveHookEvents.HiveHookEventProto)reader.readEvent();
        Assert.assertNotNull((String)"Pre hook event not found", (Object)event);
        Assert.assertEquals((Object)HiveProtoLoggingHook.EventType.QUERY_SUBMITTED.name(), (Object)event.getEventType());
        event = (HiveHookEvents.HiveHookEventProto)reader.readEvent();
        Assert.assertNotNull((String)"Post hook event not found", (Object)event);
        Assert.assertEquals((Object)HiveProtoLoggingHook.EventType.QUERY_COMPLETED.name(), (Object)event.getEventType());
    }

    @Test
    public void testPostEventLog() throws Exception {
        this.context.setHookType(HookContext.HookType.POST_EXEC_HOOK);
        this.context.getPerfLogger().perfLogBegin("test", "LogTest");
        this.context.getPerfLogger().perfLogEnd("test", "LogTest");
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, (Clock)SystemClock.getInstance());
        evtLogger.handle(this.context);
        evtLogger.shutdown();
        HiveHookEvents.HiveHookEventProto event = this.loadEvent(this.conf, this.tmpFolder);
        Assert.assertEquals((Object)HiveProtoLoggingHook.EventType.QUERY_COMPLETED.name(), (Object)event.getEventType());
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)event.getUser());
        Assert.assertEquals((Object)"test_user", (Object)event.getRequestUser());
        Assert.assertEquals((Object)"test_queryId", (Object)event.getHiveQueryId());
        Assert.assertEquals((Object)"test_op_id", (Object)event.getOperationId());
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.STATUS, Boolean.TRUE.toString());
        String val = this.findOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.PERF);
        Map map = (Map)new ObjectMapper().readValue(val, (TypeReference)new TypeReference<Map<String, Long>>(){});
        Assert.assertTrue((String)"Expected LogTest in PERF", ((Long)map.get("LogTest") < 100L ? 1 : 0) != 0);
    }

    @Test
    public void testFailureEventLog() throws Exception {
        this.context.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
        this.context.setErrorMessage("test_errormessage");
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, (Clock)SystemClock.getInstance());
        evtLogger.handle(this.context);
        evtLogger.shutdown();
        HiveHookEvents.HiveHookEventProto event = this.loadEvent(this.conf, this.tmpFolder);
        Assert.assertEquals((Object)HiveProtoLoggingHook.EventType.QUERY_COMPLETED.name(), (Object)event.getEventType());
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)event.getUser());
        Assert.assertEquals((Object)"test_user", (Object)event.getRequestUser());
        Assert.assertEquals((Object)"test_queryId", (Object)event.getHiveQueryId());
        Assert.assertEquals((Object)"test_op_id", (Object)event.getOperationId());
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.STATUS, Boolean.FALSE.toString());
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.ERROR_MESSAGE, "test_errormessage");
        this.assertOtherInfo(event, HiveProtoLoggingHook.OtherInfoType.PERF, null);
    }

    @Test
    public void testRolloverFiles() throws Exception {
        int i;
        long waitTime = 100L;
        this.context.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
        this.conf.setTimeDuration(HiveConf.ConfVars.HIVE_PROTO_EVENTS_ROLLOVER_CHECK_INTERVAL.varname, waitTime, TimeUnit.MICROSECONDS);
        Path path = new Path(this.tmpFolder);
        FileSystem fs = path.getFileSystem((Configuration)this.conf);
        AtomicLong time = new AtomicLong();
        HiveProtoLoggingHook.EventLogger evtLogger = new HiveProtoLoggingHook.EventLogger(this.conf, () -> time.get());
        evtLogger.handle(this.context);
        int statusLen = 0;
        for (i = 0; i < 3; ++i) {
            Thread.sleep(waitTime + 100L);
            statusLen = fs.listStatus(path).length;
            if (statusLen > 0) break;
        }
        Assert.assertEquals((long)1L, (long)statusLen);
        time.set(86401000L);
        for (i = 0; i < 3; ++i) {
            Thread.sleep(waitTime + 100L);
            statusLen = fs.listStatus(path).length;
            if (statusLen > 1) break;
        }
        Assert.assertEquals((long)2L, (long)statusLen);
    }

    public static ProtoMessageReader<HiveHookEvents.HiveHookEventProto> getTestReader(HiveConf conf, String tmpFolder) throws IOException {
        Path path = new Path(tmpFolder);
        FileSystem fs = path.getFileSystem((Configuration)conf);
        FileStatus[] status = fs.listStatus(path);
        Assert.assertEquals((long)1L, (long)status.length);
        status = fs.listStatus(status[0].getPath());
        Assert.assertEquals((long)1L, (long)status.length);
        DatePartitionedLogger logger = new DatePartitionedLogger(HiveHookEvents.HiveHookEventProto.PARSER, path, (Configuration)conf, (Clock)SystemClock.getInstance());
        return logger.getReader(status[0].getPath());
    }

    private HiveHookEvents.HiveHookEventProto loadEvent(HiveConf conf, String tmpFolder) throws IOException {
        ProtoMessageReader<HiveHookEvents.HiveHookEventProto> reader = TestHiveProtoLoggingHook.getTestReader(conf, tmpFolder);
        HiveHookEvents.HiveHookEventProto event = (HiveHookEvents.HiveHookEventProto)reader.readEvent();
        Assert.assertNotNull((Object)event);
        return event;
    }

    private String findOtherInfo(HiveHookEvents.HiveHookEventProto event, HiveProtoLoggingHook.OtherInfoType key) {
        for (HiveHookEvents.MapFieldEntry otherInfo : event.getOtherInfoList()) {
            if (!otherInfo.getKey().equals(key.name())) continue;
            return otherInfo.getValue();
        }
        Assert.fail((String)("Cannot find key " + key));
        return null;
    }

    private void assertOtherInfo(HiveHookEvents.HiveHookEventProto event, HiveProtoLoggingHook.OtherInfoType key, String value) {
        String val = this.findOtherInfo(event, key);
        if (value != null) {
            Assert.assertEquals((Object)value, (Object)val);
        }
    }
}

