/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HiveHooks;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveHooks {
    @Test
    public void testLoadHooksFromConf() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.PREEXECHOOKS, PreExecHook.class.getName() + "," + PreExecHook.class.getName());
        hiveConf.setVar(HiveConf.ConfVars.POSTEXECHOOKS, PostExecHook.class.getName());
        hiveConf.setVar(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, SemanticAnalysisHook.class.getName());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_OOM_HOOKS, OomRunner.class.getName() + "," + OomRunner.class.getName() + "," + OomRunner.class.getName());
        HiveHooks loader = new HiveHooks(hiveConf);
        this.verify(HookContext.HookType.HIVE_SERVER2_OOM_HOOKS, loader, OomRunner.class, 0, 3);
        this.verify(HookContext.HookType.PRE_EXEC_HOOK, loader, PreExecHook.class, 0, 2);
        this.verify(HookContext.HookType.POST_EXEC_HOOK, loader, PostExecHook.class, 0, 1);
        this.verify(HookContext.HookType.SEMANTIC_ANALYZER_HOOK, loader, SemanticAnalysisHook.class, 0, 1);
        this.verify(HookContext.HookType.HIVE_SERVER2_OOM_HOOKS, loader, OomRunner.class, 3, 3);
        this.verify(HookContext.HookType.PRE_EXEC_HOOK, loader, PreExecHook.class, 2, 2);
        this.verify(HookContext.HookType.POST_EXEC_HOOK, loader, PostExecHook.class, 1, 1);
        this.verify(HookContext.HookType.SEMANTIC_ANALYZER_HOOK, loader, SemanticAnalysisHook.class, 1, 1);
    }

    private <T> void verify(HookContext.HookType type, HiveHooks loader, Class<T> expectedCls, int beforeSize, int afterSize) throws Exception {
        int i;
        List loadedHooks = loader.getHooks(type, false);
        Assert.assertTrue((loadedHooks.size() == beforeSize ? 1 : 0) != 0);
        for (i = 0; i < loadedHooks.size(); ++i) {
            Assert.assertTrue((boolean)expectedCls.isAssignableFrom(loadedHooks.get(i).getClass()));
        }
        loader.loadHooksFromConf(type);
        loadedHooks = loader.getHooks(type, expectedCls);
        Assert.assertTrue((loadedHooks.size() == afterSize ? 1 : 0) != 0);
        for (i = 0; i < loadedHooks.size(); ++i) {
            Assert.assertTrue((boolean)expectedCls.isAssignableFrom(loadedHooks.get(i).getClass()));
        }
    }

    @Test
    public void testAddHooks() throws Exception {
        HiveConf hiveConf = new HiveConf();
        HiveHooks loader = new HiveHooks(hiveConf);
        this.verify(HookContext.HookType.HIVE_SERVER2_OOM_HOOKS, loader, Runnable.class, OomRunner.class);
        this.verify(HookContext.HookType.PRE_EXEC_HOOK, loader, ExecuteWithHookContext.class, PreExecHook.class);
        this.verify(HookContext.HookType.POST_EXEC_HOOK, loader, ExecuteWithHookContext.class, PostExecHook.class);
        this.verify(HookContext.HookType.SEMANTIC_ANALYZER_HOOK, loader, HiveSemanticAnalyzerHook.class, SemanticAnalysisHook.class);
    }

    private <T> void verify(HookContext.HookType type, HiveHooks loader, Class<T> superCls, Class realCls) throws Exception {
        List origHooks = loader.getHooks(type, superCls);
        int size = origHooks.size();
        this.verify(type, loader, superCls, size, size);
        loader.addHook(type, realCls.newInstance());
        this.verify(type, loader, superCls, size + 1, size + 1);
        List loadedHooks = loader.getHooks(type, superCls);
        Object hook = loadedHooks.get(loadedHooks.size() - 1);
        Assert.assertTrue((hook.getClass() == realCls ? 1 : 0) != 0);
    }

    public static class OomRunner
    implements Runnable {
        @Override
        public void run() {
        }
    }

    public static class SemanticAnalysisHook
    implements HiveSemanticAnalyzerHook {
        public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
            return null;
        }

        public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<?>> rootTasks) throws SemanticException {
        }
    }

    public static class PreExecHook
    implements ExecuteWithHookContext {
        public void run(HookContext hookContext) {
        }
    }

    public static class PostExecHook
    implements ExecuteWithHookContext {
        public void run(HookContext hookContext) {
        }
    }
}

