/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.hooks.HiveHookEventProtoPartialBuilder;
import org.apache.hadoop.hive.ql.hooks.HiveProtoLoggingHook;
import org.apache.hadoop.hive.ql.hooks.proto.HiveHookEvents;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveHookEventProtoPartialBuilder {
    private static final String QUERY_1 = "query1";
    private static final String HIVE = "hive";
    private static final String LLAP = "llap";
    private static final String TEZ = "tez";
    private static final long TIMESTAMP = System.currentTimeMillis();

    @Test
    public void testEquality() {
        JSONObject json = new JSONObject();
        json.put("key1", (Object)"value1");
        json.put("key2", (Object)"value2");
        json.put("key3", (Object)"value3");
        HiveHookEvents.HiveHookEventProto event1 = this.buildWithOtherInfo(json);
        HiveHookEvents.HiveHookEventProto event2 = this.buildIn2Steps(json);
        Assert.assertArrayEquals((byte[])event1.toByteArray(), (byte[])event2.toByteArray());
    }

    private HiveHookEvents.HiveHookEventProto buildWithOtherInfo(JSONObject json) {
        return HiveHookEvents.HiveHookEventProto.newBuilder().setEventType(HiveProtoLoggingHook.EventType.QUERY_SUBMITTED.name()).setTimestamp(TIMESTAMP).setHiveQueryId(QUERY_1).setUser(HIVE).setRequestUser(HIVE).setQueue(LLAP).setExecutionMode(TEZ).addAllOtherInfo(Collections.singletonList(HiveHookEvents.MapFieldEntry.newBuilder().setKey(HiveProtoLoggingHook.OtherInfoType.CONF.name()).setValue(json.toString()).build())).build();
    }

    private HiveHookEvents.HiveHookEventProto buildIn2Steps(JSONObject json) {
        HiveHookEvents.HiveHookEventProto.Builder builder = HiveHookEvents.HiveHookEventProto.newBuilder().setEventType(HiveProtoLoggingHook.EventType.QUERY_SUBMITTED.name()).setTimestamp(TIMESTAMP).setHiveQueryId(QUERY_1).setUser(HIVE).setRequestUser(HIVE).setQueue(LLAP).setExecutionMode(TEZ);
        HashMap<HiveProtoLoggingHook.OtherInfoType, JSONObject> otherInfo = new HashMap<HiveProtoLoggingHook.OtherInfoType, JSONObject>();
        otherInfo.put(HiveProtoLoggingHook.OtherInfoType.CONF, json);
        return new HiveHookEventProtoPartialBuilder(builder, null, otherInfo, null, null).build();
    }
}

