/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util.batchgen;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerator;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorColumnGroupGenerator {
    private VectorBatchGenerator.GenerateType[] generateTypes;
    private int[] columnNums;
    private Object[] arrays;
    private boolean[][] isNullArrays;

    public VectorColumnGroupGenerator(int columnNum, VectorBatchGenerator.GenerateType generateType) {
        this.columnNums = new int[]{columnNum};
        this.generateTypes = new VectorBatchGenerator.GenerateType[]{generateType};
        this.allocateArrays(1024);
    }

    public VectorColumnGroupGenerator(int startColumnNum, VectorBatchGenerator.GenerateType[] generateTypes) {
        this.columnNums = new int[generateTypes.length];
        for (int i = 0; i < generateTypes.length; ++i) {
            this.columnNums[i] = startColumnNum + i;
        }
        this.generateTypes = generateTypes;
        this.allocateArrays(1024);
    }

    public VectorBatchGenerator.GenerateType[] generateTypes() {
        return this.generateTypes;
    }

    private void allocateArrays(int size) {
        this.arrays = new Object[this.generateTypes.length];
        this.isNullArrays = new boolean[this.generateTypes.length][];
        for (int i = 0; i < this.generateTypes.length; ++i) {
            VectorBatchGenerator.GenerateType generateType = this.generateTypes[i];
            VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
            Object array = null;
            switch (category) {
                case BOOLEAN: {
                    array = new boolean[size];
                    break;
                }
                case BYTE: {
                    array = new byte[size];
                    break;
                }
                case SHORT: {
                    array = new short[size];
                    break;
                }
                case INT: {
                    array = new int[size];
                    break;
                }
                case LONG: {
                    array = new long[size];
                    break;
                }
                case FLOAT: {
                    array = new float[size];
                    break;
                }
                case DOUBLE: {
                    array = new double[size];
                    break;
                }
                case STRING: {
                    array = new String[size];
                    break;
                }
                case BINARY: {
                    array = new byte[size][];
                    break;
                }
                case DATE: {
                    array = new Date[size];
                    break;
                }
                case TIMESTAMP: {
                    array = new Timestamp[size];
                    break;
                }
                case CHAR: {
                    array = new HiveChar[size];
                    break;
                }
                case VARCHAR: {
                    array = new HiveVarchar[size];
                    break;
                }
                case DECIMAL: {
                    array = new HiveDecimalWritable[size];
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected generate category " + (Object)((Object)category));
                }
            }
            this.arrays[i] = array;
            this.isNullArrays[i] = new boolean[size];
        }
    }

    public void clearColumnValueArrays() {
        block16: for (int i = 0; i < this.generateTypes.length; ++i) {
            VectorBatchGenerator.GenerateType generateType = this.generateTypes[i];
            VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
            Object array = this.arrays[i];
            switch (category) {
                case BOOLEAN: {
                    Arrays.fill((boolean[])array, false);
                    continue block16;
                }
                case BYTE: {
                    Arrays.fill((byte[])array, (byte)0);
                    continue block16;
                }
                case SHORT: {
                    Arrays.fill((short[])array, (short)0);
                    continue block16;
                }
                case INT: {
                    Arrays.fill((int[])array, 0);
                    continue block16;
                }
                case LONG: {
                    Arrays.fill((long[])array, 0L);
                    continue block16;
                }
                case FLOAT: {
                    Arrays.fill((float[])array, 0.0f);
                    continue block16;
                }
                case DOUBLE: {
                    Arrays.fill((double[])array, 0.0);
                    continue block16;
                }
                case STRING: {
                    Arrays.fill((String[])array, null);
                    continue block16;
                }
                case BINARY: {
                    Arrays.fill((Object[])((byte[][])array), null);
                    continue block16;
                }
                case DATE: {
                    Arrays.fill((Date[])array, null);
                    continue block16;
                }
                case TIMESTAMP: {
                    Arrays.fill((Timestamp[])array, null);
                    continue block16;
                }
                case CHAR: {
                    Arrays.fill((HiveChar[])array, null);
                    continue block16;
                }
                case VARCHAR: {
                    Arrays.fill((HiveVarchar[])array, null);
                    continue block16;
                }
                case DECIMAL: {
                    Arrays.fill((HiveDecimalWritable[])array, null);
                    continue block16;
                }
            }
        }
    }

    public void generateRowValues(int rowIndex, Random random) {
        for (int i = 0; i < this.generateTypes.length; ++i) {
            this.generateRowColumnValue(rowIndex, i, random);
        }
    }

    private void generateRowColumnValue(int rowIndex, int columnIndex, Random random) {
        VectorBatchGenerator.GenerateType generateType = this.generateTypes[columnIndex];
        VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
        boolean allowNulls = generateType.getAllowNulls();
        if (allowNulls && random.nextInt(100) < 5) {
            this.isNullArrays[columnIndex][rowIndex] = true;
            return;
        }
        Object array = this.arrays[columnIndex];
        switch (category) {
            case BOOLEAN: {
                boolean value;
                ((boolean[])array)[rowIndex] = value = random.nextBoolean();
                break;
            }
            case BYTE: {
                byte value;
                ((byte[])array)[rowIndex] = value = (byte)(random.nextBoolean() ? -random.nextInt(129) : random.nextInt(128));
                break;
            }
            case SHORT: {
                short value;
                ((short[])array)[rowIndex] = value = (short)(random.nextBoolean() ? -random.nextInt(32769) : random.nextInt(32768));
                break;
            }
            case INT: {
                int value;
                ((int[])array)[rowIndex] = value = random.nextInt();
                break;
            }
            case LONG: {
                long value;
                ((long[])array)[rowIndex] = value = random.nextLong();
                break;
            }
            case FLOAT: {
                float value;
                ((float[])array)[rowIndex] = value = (float)random.nextLong();
                break;
            }
            case DOUBLE: {
                double value;
                ((double[])array)[rowIndex] = value = (double)random.nextLong();
                break;
            }
            case STRING: {
                String value;
                ((String[])array)[rowIndex] = value = RandomTypeUtil.getRandString((Random)random);
                break;
            }
            case BINARY: {
                byte[] value = RandomTypeUtil.getRandBinary((Random)random, (int)10);
                ((byte[][])array)[rowIndex] = value;
                break;
            }
            case DATE: {
                Date value;
                ((Date[])array)[rowIndex] = value = RandomTypeUtil.getRandDate((Random)random);
                break;
            }
            case TIMESTAMP: {
                Timestamp value;
                ((Timestamp[])array)[rowIndex] = value = RandomTypeUtil.getRandTimestamp((Random)random).toSqlTimestamp();
                break;
            }
            case CHAR: {
                HiveChar value;
                ((HiveChar[])array)[rowIndex] = value = new HiveChar(RandomTypeUtil.getRandString((Random)random), 10);
                break;
            }
            case VARCHAR: {
                HiveVarchar value;
                ((HiveVarchar[])array)[rowIndex] = value = new HiveVarchar(RandomTypeUtil.getRandString((Random)random), 10);
                break;
            }
            case DECIMAL: {
                HiveDecimalWritable value;
                ((HiveDecimalWritable[])array)[rowIndex] = value = new HiveDecimalWritable(RandomTypeUtil.getRandHiveDecimal((Random)random));
                break;
            }
        }
    }

    public void fillDownRowValues(int rowIndex, int seriesCount, Random random) {
        for (int i = 0; i < this.generateTypes.length; ++i) {
            this.fillDownRowColumnValue(rowIndex, i, seriesCount, random);
        }
    }

    private void fillDownRowColumnValue(int rowIndex, int columnIndex, int seriesCount, Random random) {
        VectorBatchGenerator.GenerateType generateType = this.generateTypes[columnIndex];
        VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
        boolean allowNulls = generateType.getAllowNulls();
        Object array = this.arrays[columnIndex];
        boolean[] isNull = this.isNullArrays[columnIndex];
        if (allowNulls && isNull[rowIndex]) {
            for (int i = 1; i < seriesCount; ++i) {
                isNull[rowIndex + i] = true;
            }
            return;
        }
        switch (category) {
            case BOOLEAN: {
                boolean[] booleanArray = (boolean[])array;
                boolean value = booleanArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    booleanArray[rowIndex + i] = value;
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = (byte[])array;
                byte value = byteArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    byteArray[rowIndex + i] = value;
                }
                break;
            }
            case SHORT: {
                short[] shortArray = (short[])array;
                short value = shortArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    shortArray[rowIndex + i] = value;
                }
                break;
            }
            case INT: {
                int[] intArray = (int[])array;
                int value = intArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    intArray[rowIndex + i] = value;
                }
                break;
            }
            case LONG: {
                long[] longArray = (long[])array;
                long value = longArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    longArray[rowIndex + i] = value;
                }
                break;
            }
            case FLOAT: {
                float[] floatArray = (float[])array;
                float value = floatArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    floatArray[rowIndex + i] = value;
                }
                break;
            }
            case DOUBLE: {
                double[] doubleArray = (double[])array;
                double value = doubleArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    doubleArray[rowIndex + i] = value;
                }
                break;
            }
            case STRING: {
                String[] stringArray = (String[])array;
                String value = stringArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    stringArray[rowIndex + i] = value;
                }
                break;
            }
            case BINARY: {
                byte[][] byteArrayArray = (byte[][])array;
                byte[] value = byteArrayArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    byteArrayArray[rowIndex + i] = value;
                }
                break;
            }
            case DATE: {
                Date[] dateArray = (Date[])array;
                Date value = dateArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    dateArray[rowIndex + i] = value;
                }
                break;
            }
            case TIMESTAMP: {
                Timestamp[] timestampArray = (Timestamp[])array;
                Timestamp value = timestampArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    timestampArray[rowIndex + i] = value;
                }
                break;
            }
            case CHAR: {
                HiveChar[] hiveCharArray = (HiveChar[])array;
                HiveChar value = hiveCharArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    hiveCharArray[rowIndex + i] = value;
                }
                break;
            }
            case VARCHAR: {
                HiveVarchar[] hiveVarcharArray = (HiveVarchar[])array;
                HiveVarchar value = hiveVarcharArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    hiveVarcharArray[rowIndex + i] = value;
                }
                break;
            }
            case DECIMAL: {
                HiveDecimalWritable[] hiveDecimalWritableArray = (HiveDecimalWritable[])array;
                HiveDecimalWritable value = hiveDecimalWritableArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    hiveDecimalWritableArray[rowIndex + i] = value;
                }
                break;
            }
        }
    }

    public void generateDownRowValues(int rowIndex, int seriesCount, Random random) {
        for (int i = 0; i < this.generateTypes.length; ++i) {
            for (int g = 1; g < seriesCount; ++g) {
                this.generateRowColumnValue(rowIndex + g, i, random);
            }
        }
    }

    public void populateBatch(VectorizedRowBatch batch, int size, boolean isRepeated) {
        assert (!isRepeated);
        for (int i = 0; i < size; ++i) {
            for (int g = 0; g < this.generateTypes.length; ++g) {
                this.populateBatchColumn(batch, g, size);
            }
        }
    }

    private void populateBatchColumn(VectorizedRowBatch batch, int logicalColumnIndex, int size) {
        int columnNum = this.columnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[columnNum];
        VectorBatchGenerator.GenerateType generateType = this.generateTypes[logicalColumnIndex];
        VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
        boolean allowNulls = generateType.getAllowNulls();
        boolean[] isNull = this.isNullArrays[logicalColumnIndex];
        if (allowNulls) {
            for (int i = 0; i < size; ++i) {
                if (!isNull[i]) continue;
                colVector.isNull[i] = true;
                colVector.noNulls = false;
            }
        }
        Object array = this.arrays[logicalColumnIndex];
        switch (category) {
            case BOOLEAN: {
                boolean[] booleanArray = (boolean[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0L : (long)(booleanArray[i] ? 1 : 0);
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = (byte[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0L : (long)byteArray[i];
                }
                break;
            }
            case SHORT: {
                short[] shortArray = (short[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0L : (long)shortArray[i];
                }
                break;
            }
            case INT: {
                int[] intArray = (int[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0L : (long)intArray[i];
                }
                break;
            }
            case LONG: {
                long[] longArray = (long[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0L : longArray[i];
                }
                break;
            }
            case FLOAT: {
                float[] floatArray = (float[])array;
                double[] vector = ((DoubleColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0.0 : (double)floatArray[i];
                }
                break;
            }
            case DOUBLE: {
                double[] doubleArray = (double[])array;
                double[] vector = ((DoubleColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = isNull[i] ? 0.0 : doubleArray[i];
                }
                break;
            }
            case STRING: {
                String[] stringArray = (String[])array;
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    byte[] bytes = stringArray[i].getBytes();
                    bytesColVec.setVal(i, bytes);
                }
                break;
            }
            case BINARY: {
                byte[][] byteArrayArray = (byte[][])array;
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    byte[] bytes = byteArrayArray[i];
                    bytesColVec.setVal(i, bytes);
                }
                break;
            }
            case DATE: {
                Date[] dateArray = (Date[])array;
                LongColumnVector longColVec = (LongColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    Date date = dateArray[i];
                    longColVec.vector[i] = DateWritableV2.dateToDays((Date)date);
                }
                break;
            }
            case TIMESTAMP: {
                Timestamp[] timestampArray = (Timestamp[])array;
                TimestampColumnVector timestampColVec = (TimestampColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    Timestamp timestamp = timestampArray[i];
                    timestampColVec.set(i, timestamp);
                }
                break;
            }
            case CHAR: {
                HiveChar[] hiveCharArray = (HiveChar[])array;
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    byte[] bytes = hiveCharArray[i].getValue().getBytes();
                    bytesColVec.setVal(i, bytes);
                }
                break;
            }
            case VARCHAR: {
                HiveVarchar[] hiveCharArray = (HiveVarchar[])array;
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    byte[] bytes = hiveCharArray[i].getValue().getBytes();
                    bytesColVec.setVal(i, bytes);
                }
                break;
            }
            case DECIMAL: {
                HiveDecimalWritable[] hiveDecimalWritableArray = (HiveDecimalWritable[])array;
                DecimalColumnVector decimalColVec = (DecimalColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    if (isNull[i]) continue;
                    HiveDecimalWritable decWritable = hiveDecimalWritableArray[i];
                    decimalColVec.set(i, decWritable);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unepected generate category " + (Object)((Object)category));
            }
        }
    }
}

