/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class VerifyFastRow {
    public static void verifyDeserializeRead(DeserializeRead deserializeRead, TypeInfo typeInfo, Object object) throws IOException {
        boolean isNull = !deserializeRead.readNextField();
        VerifyFastRow.doVerifyDeserializeRead(deserializeRead, typeInfo, object, isNull);
    }

    public static void doVerifyDeserializeRead(DeserializeRead deserializeRead, TypeInfo typeInfo, Object object, boolean isNull) throws IOException {
        if (isNull) {
            if (object != null) {
                TestCase.fail((String)("Field reports null but object is not null (class " + object.getClass().getName() + ", " + object.toString() + ")"));
            }
            return;
        }
        if (object == null) {
            TestCase.fail((String)"Field report not null but object is null");
        }
        block0 : switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        boolean expected;
                        boolean value = deserializeRead.currentBoolean;
                        if (!(object instanceof BooleanWritable)) {
                            TestCase.fail((String)"Boolean expected writable not Boolean");
                        }
                        if (value == (expected = ((BooleanWritable)object).get())) break block0;
                        TestCase.fail((String)("Boolean field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case BYTE: {
                        byte expected;
                        byte value = deserializeRead.currentByte;
                        if (!(object instanceof ByteWritable)) {
                            TestCase.fail((String)"Byte expected writable not Byte");
                        }
                        if (value == (expected = ((ByteWritable)object).get())) break block0;
                        TestCase.fail((String)("Byte field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case SHORT: {
                        short expected;
                        short value = deserializeRead.currentShort;
                        if (!(object instanceof ShortWritable)) {
                            TestCase.fail((String)"Short expected writable not Short");
                        }
                        if (value == (expected = ((ShortWritable)object).get())) break block0;
                        TestCase.fail((String)("Short field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case INT: {
                        int expected;
                        int value = deserializeRead.currentInt;
                        if (!(object instanceof IntWritable)) {
                            TestCase.fail((String)"Integer expected writable not Integer");
                        }
                        if (value == (expected = ((IntWritable)object).get())) break block0;
                        TestCase.fail((String)("Int field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case LONG: {
                        Long expected;
                        long value = deserializeRead.currentLong;
                        if (!(object instanceof LongWritable)) {
                            TestCase.fail((String)"Long expected writable not Long");
                        }
                        if (value == (expected = Long.valueOf(((LongWritable)object).get()))) break block0;
                        TestCase.fail((String)("Long field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case FLOAT: {
                        float expected;
                        float value = deserializeRead.currentFloat;
                        if (!(object instanceof FloatWritable)) {
                            TestCase.fail((String)"Float expected writable not Float");
                        }
                        if (value == (expected = ((FloatWritable)object).get())) break block0;
                        TestCase.fail((String)("Float field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case DOUBLE: {
                        double expected;
                        double value = deserializeRead.currentDouble;
                        if (!(object instanceof DoubleWritable)) {
                            TestCase.fail((String)"Double expected writable not Double");
                        }
                        if (value == (expected = ((DoubleWritable)object).get())) break block0;
                        TestCase.fail((String)("Double field mismatch (expected " + expected + " found " + value + ")"));
                        break block0;
                    }
                    case STRING: {
                        byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                        Text text = new Text(stringBytes);
                        String string = text.toString();
                        String expected = ((Text)object).toString();
                        if (string.equals(expected)) break block0;
                        TestCase.fail((String)("String field mismatch (expected '" + expected + "' found '" + string + "')"));
                        break block0;
                    }
                    case CHAR: {
                        byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                        Text text = new Text(stringBytes);
                        String string = text.toString();
                        HiveChar hiveChar = new HiveChar(string, ((CharTypeInfo)primitiveTypeInfo).getLength());
                        HiveChar expected = ((HiveCharWritable)object).getHiveChar();
                        if (hiveChar.equals((Object)expected)) break block0;
                        TestCase.fail((String)("Char field mismatch (expected '" + expected + "' found '" + hiveChar + "')"));
                        break block0;
                    }
                    case VARCHAR: {
                        byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                        Text text = new Text(stringBytes);
                        String string = text.toString();
                        HiveVarchar hiveVarchar = new HiveVarchar(string, ((VarcharTypeInfo)primitiveTypeInfo).getLength());
                        HiveVarchar expected = ((HiveVarcharWritable)object).getHiveVarchar();
                        if (hiveVarchar.equals((Object)expected)) break block0;
                        TestCase.fail((String)("Varchar field mismatch (expected '" + expected + "' found '" + hiveVarchar + "')"));
                        break block0;
                    }
                    case DECIMAL: {
                        HiveDecimal expected;
                        HiveDecimal value = deserializeRead.currentHiveDecimalWritable.getHiveDecimal();
                        if (value == null) {
                            TestCase.fail((String)"Decimal field evaluated to NULL");
                        }
                        if (value.equals((Object)(expected = ((HiveDecimalWritable)object).getHiveDecimal()))) break block0;
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                        int precision = decimalTypeInfo.getPrecision();
                        int scale = decimalTypeInfo.getScale();
                        TestCase.fail((String)("Decimal field mismatch (expected " + expected.toString() + " found " + value.toString() + ") precision " + precision + ", scale " + scale));
                        break block0;
                    }
                    case DATE: {
                        Date value = deserializeRead.currentDateWritable.get();
                        Date expected = ((DateWritableV2)object).get();
                        if (value.equals((Object)expected)) break block0;
                        TestCase.fail((String)("Date field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                        break block0;
                    }
                    case TIMESTAMP: {
                        Timestamp value = deserializeRead.currentTimestampWritable.getTimestamp();
                        Timestamp expected = ((TimestampWritableV2)object).getTimestamp();
                        if (value.equals((Object)expected)) break block0;
                        TestCase.fail((String)("Timestamp field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        HiveIntervalYearMonth value = deserializeRead.currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth();
                        HiveIntervalYearMonth expected = ((HiveIntervalYearMonthWritable)object).getHiveIntervalYearMonth();
                        if (value.equals((Object)expected)) break block0;
                        TestCase.fail((String)("HiveIntervalYearMonth field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        HiveIntervalDayTime value = deserializeRead.currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime();
                        HiveIntervalDayTime expected = ((HiveIntervalDayTimeWritable)object).getHiveIntervalDayTime();
                        if (value.equals((Object)expected)) break block0;
                        TestCase.fail((String)("HiveIntervalDayTime field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                        break block0;
                    }
                    case BINARY: {
                        byte[] byteArray = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                        BytesWritable bytesWritable = (BytesWritable)object;
                        byte[] expected = Arrays.copyOfRange(bytesWritable.getBytes(), 0, bytesWritable.getLength());
                        if (byteArray.length != expected.length) {
                            TestCase.fail((String)("Byte Array field mismatch (expected " + Arrays.toString(expected) + " found " + Arrays.toString(byteArray) + ")"));
                        }
                        for (int b = 0; b < byteArray.length; ++b) {
                            if (byteArray[b] == expected[b]) continue;
                            TestCase.fail((String)("Byte Array field mismatch (expected " + Arrays.toString(expected) + " found " + Arrays.toString(byteArray) + ")"));
                        }
                        break block0;
                    }
                    default: {
                        throw new Error("Unknown primitive category " + primitiveTypeInfo.getPrimitiveCategory());
                    }
                }
            }
            case LIST: 
            case MAP: 
            case STRUCT: 
            case UNION: {
                throw new Error("Complex types need to be handled separately");
            }
            default: {
                throw new Error("Unknown category " + typeInfo.getCategory());
            }
        }
    }

    public static void serializeWrite(SerializeWrite serializeWrite, TypeInfo typeInfo, Object object) throws IOException {
        if (object == null) {
            serializeWrite.writeNull();
            return;
        }
        block0 : switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        boolean value = ((BooleanWritable)object).get();
                        serializeWrite.writeBoolean(value);
                        break block0;
                    }
                    case BYTE: {
                        byte value = ((ByteWritable)object).get();
                        serializeWrite.writeByte(value);
                        break block0;
                    }
                    case SHORT: {
                        short value = ((ShortWritable)object).get();
                        serializeWrite.writeShort(value);
                        break block0;
                    }
                    case INT: {
                        int value = ((IntWritable)object).get();
                        serializeWrite.writeInt(value);
                        break block0;
                    }
                    case LONG: {
                        long value = ((LongWritable)object).get();
                        serializeWrite.writeLong(value);
                        break block0;
                    }
                    case FLOAT: {
                        float value = ((FloatWritable)object).get();
                        serializeWrite.writeFloat(value);
                        break block0;
                    }
                    case DOUBLE: {
                        double value = ((DoubleWritable)object).get();
                        serializeWrite.writeDouble(value);
                        break block0;
                    }
                    case STRING: {
                        Text value = (Text)object;
                        byte[] stringBytes = value.getBytes();
                        int stringLength = stringBytes.length;
                        serializeWrite.writeString(stringBytes, 0, stringLength);
                        break block0;
                    }
                    case CHAR: {
                        HiveChar value = ((HiveCharWritable)object).getHiveChar();
                        serializeWrite.writeHiveChar(value);
                        break block0;
                    }
                    case VARCHAR: {
                        HiveVarchar value = ((HiveVarcharWritable)object).getHiveVarchar();
                        serializeWrite.writeHiveVarchar(value);
                        break block0;
                    }
                    case DECIMAL: {
                        HiveDecimal value = ((HiveDecimalWritable)object).getHiveDecimal();
                        DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                        serializeWrite.writeHiveDecimal(value, decTypeInfo.scale());
                        break block0;
                    }
                    case DATE: {
                        Date value = ((DateWritableV2)object).get();
                        serializeWrite.writeDate(value);
                        break block0;
                    }
                    case TIMESTAMP: {
                        Timestamp value = ((TimestampWritableV2)object).getTimestamp();
                        serializeWrite.writeTimestamp(value);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        HiveIntervalYearMonth value = ((HiveIntervalYearMonthWritable)object).getHiveIntervalYearMonth();
                        serializeWrite.writeHiveIntervalYearMonth(value);
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        HiveIntervalDayTime value = ((HiveIntervalDayTimeWritable)object).getHiveIntervalDayTime();
                        serializeWrite.writeHiveIntervalDayTime(value);
                        break block0;
                    }
                    case BINARY: {
                        BytesWritable byteWritable = (BytesWritable)object;
                        byte[] binaryBytes = byteWritable.getBytes();
                        int length = byteWritable.getLength();
                        serializeWrite.writeBinary(binaryBytes, 0, length);
                        break block0;
                    }
                }
                throw new Error("Unknown primitive category " + primitiveTypeInfo.getPrimitiveCategory().name());
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeInfo elementTypeInfo = listTypeInfo.getListElementTypeInfo();
                ArrayList elements = (ArrayList)object;
                serializeWrite.beginList((List)elements);
                boolean isFirst = true;
                for (Object elementObject : elements) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        serializeWrite.separateList();
                    }
                    if (elementObject == null) {
                        serializeWrite.writeNull();
                        continue;
                    }
                    VerifyFastRow.serializeWrite(serializeWrite, elementTypeInfo, elementObject);
                }
                serializeWrite.finishList();
                break;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                Map hashMap = (Map)object;
                serializeWrite.beginMap(hashMap);
                boolean isFirst = true;
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        serializeWrite.separateKeyValuePair();
                    }
                    if (entry.getKey() == null) {
                        serializeWrite.writeNull();
                    } else {
                        VerifyFastRow.serializeWrite(serializeWrite, keyTypeInfo, entry.getKey());
                    }
                    serializeWrite.separateKey();
                    if (entry.getValue() == null) {
                        serializeWrite.writeNull();
                        continue;
                    }
                    VerifyFastRow.serializeWrite(serializeWrite, valueTypeInfo, entry.getValue());
                }
                serializeWrite.finishMap();
                break;
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                List fieldValues = (List)object;
                int size = fieldValues.size();
                serializeWrite.beginStruct(fieldValues);
                boolean isFirst = true;
                for (int i = 0; i < size; ++i) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        serializeWrite.separateStruct();
                    }
                    VerifyFastRow.serializeWrite(serializeWrite, (TypeInfo)fieldTypeInfos.get(i), fieldValues.get(i));
                }
                serializeWrite.finishStruct();
                break;
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List fieldTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                int size = fieldTypeInfos.size();
                StandardUnionObjectInspector.StandardUnion standardUnion = (StandardUnionObjectInspector.StandardUnion)object;
                byte tag = standardUnion.getTag();
                serializeWrite.beginUnion((int)tag);
                VerifyFastRow.serializeWrite(serializeWrite, (TypeInfo)fieldTypeInfos.get(tag), standardUnion.getObject());
                serializeWrite.finishUnion();
                break;
            }
            default: {
                throw new Error("Unknown category " + typeInfo.getCategory().name());
            }
        }
    }

    public Object readComplexPrimitiveField(DeserializeRead deserializeRead, PrimitiveTypeInfo primitiveTypeInfo) throws IOException {
        boolean isNull;
        boolean bl = isNull = !deserializeRead.readComplexField();
        if (isNull) {
            return null;
        }
        return VerifyFastRow.doReadComplexPrimitiveField(deserializeRead, primitiveTypeInfo);
    }

    private static Object doReadComplexPrimitiveField(DeserializeRead deserializeRead, PrimitiveTypeInfo primitiveTypeInfo) throws IOException {
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return new BooleanWritable(deserializeRead.currentBoolean);
            }
            case BYTE: {
                return new ByteWritable(deserializeRead.currentByte);
            }
            case SHORT: {
                return new ShortWritable(deserializeRead.currentShort);
            }
            case INT: {
                return new IntWritable(deserializeRead.currentInt);
            }
            case LONG: {
                return new LongWritable(deserializeRead.currentLong);
            }
            case FLOAT: {
                return new FloatWritable(deserializeRead.currentFloat);
            }
            case DOUBLE: {
                return new DoubleWritable(deserializeRead.currentDouble);
            }
            case STRING: {
                return new Text(new String(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesLength, StandardCharsets.UTF_8));
            }
            case CHAR: {
                return new HiveCharWritable(new HiveChar(new String(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesLength, StandardCharsets.UTF_8), ((CharTypeInfo)primitiveTypeInfo).getLength()));
            }
            case VARCHAR: {
                if (deserializeRead.currentBytes == null) {
                    throw new RuntimeException();
                }
                return new HiveVarcharWritable(new HiveVarchar(new String(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesLength, StandardCharsets.UTF_8), ((VarcharTypeInfo)primitiveTypeInfo).getLength()));
            }
            case DECIMAL: {
                return new HiveDecimalWritable(deserializeRead.currentHiveDecimalWritable);
            }
            case DATE: {
                return new DateWritableV2(deserializeRead.currentDateWritable);
            }
            case TIMESTAMP: {
                return new TimestampWritableV2(deserializeRead.currentTimestampWritable);
            }
            case INTERVAL_YEAR_MONTH: {
                return new HiveIntervalYearMonthWritable(deserializeRead.currentHiveIntervalYearMonthWritable);
            }
            case INTERVAL_DAY_TIME: {
                return new HiveIntervalDayTimeWritable(deserializeRead.currentHiveIntervalDayTimeWritable);
            }
            case BINARY: {
                return new BytesWritable(Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesLength + deserializeRead.currentBytesStart));
            }
        }
        throw new Error("Unknown primitive category " + primitiveTypeInfo.getPrimitiveCategory());
    }

    public static Object deserializeReadComplexType(DeserializeRead deserializeRead, TypeInfo typeInfo) throws IOException {
        boolean isNull;
        boolean bl = isNull = !deserializeRead.readNextField();
        if (isNull) {
            return null;
        }
        return VerifyFastRow.getComplexField(deserializeRead, typeInfo);
    }

    private static Object getComplexField(DeserializeRead deserializeRead, TypeInfo typeInfo) throws IOException {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return VerifyFastRow.doReadComplexPrimitiveField(deserializeRead, (PrimitiveTypeInfo)typeInfo);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeInfo elementTypeInfo = listTypeInfo.getListElementTypeInfo();
                ArrayList<Object> list = new ArrayList<Object>();
                while (deserializeRead.isNextComplexMultiValue()) {
                    boolean isNull = !deserializeRead.readComplexField();
                    Object eleObj = isNull ? null : VerifyFastRow.getComplexField(deserializeRead, elementTypeInfo);
                    list.add(eleObj);
                }
                return list;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                LinkedHashMap<Object, Object> hashMap = new LinkedHashMap<Object, Object>();
                while (deserializeRead.isNextComplexMultiValue()) {
                    boolean isNull = !deserializeRead.readComplexField();
                    Object keyObj = isNull ? null : VerifyFastRow.getComplexField(deserializeRead, keyTypeInfo);
                    isNull = !deserializeRead.readComplexField();
                    Object valueObj = isNull ? null : VerifyFastRow.getComplexField(deserializeRead, valueTypeInfo);
                    hashMap.put(keyObj, valueObj);
                }
                return hashMap;
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                int size = fieldTypeInfos.size();
                ArrayList<Object> fieldValues = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    boolean isNull = !deserializeRead.readComplexField();
                    Object fieldObj = isNull ? null : VerifyFastRow.getComplexField(deserializeRead, (TypeInfo)fieldTypeInfos.get(i));
                    fieldValues.add(fieldObj);
                }
                deserializeRead.finishComplexVariableFieldsType();
                return fieldValues;
            }
            case UNION: {
                StandardUnionObjectInspector.StandardUnion unionObj;
                boolean isNull;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List unionTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                int size = unionTypeInfos.size();
                boolean bl = isNull = !deserializeRead.readComplexField();
                if (isNull) {
                    unionObj = null;
                } else {
                    Object tagObj = VerifyFastRow.getComplexField(deserializeRead, (TypeInfo)TypeInfoFactory.intTypeInfo);
                    int tag = ((IntWritable)tagObj).get();
                    isNull = !deserializeRead.readComplexField();
                    unionObj = isNull ? null : new StandardUnionObjectInspector.StandardUnion((byte)tag, VerifyFastRow.getComplexField(deserializeRead, (TypeInfo)unionTypeInfos.get(tag)));
                }
                deserializeRead.finishComplexVariableFieldsType();
                return unionObj;
            }
        }
        throw new Error("Unexpected category " + typeInfo.getCategory());
    }
}

