/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.junit.Before;
import org.junit.Test;

public class TestVectorMapJoinFastLongHashMapNonMatched
extends CommonFastHashTable {
    public static final Properties ANY_TABLE_PROPERTIES = new Properties();
    private static TableDesc tableDesc = new TableDesc();

    @Before
    public void setUp() throws Exception {
        tableDesc.setProperties(ANY_TABLE_PROPERTIES);
    }

    @Test
    public void testOneKey() throws Exception {
        random = new Random(33221L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        long key = random.nextLong();
        byte[] value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verifyNonMatched(map, random);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(900L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verifyNonMatched(map, random);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(5227L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 1, 1.0E-7f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        for (int i = 0; i < 6; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verifyNonMatched(map, random);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastLongHashMap map, CheckFastHashTable.VerifyFastLongHashMap verifyTable) throws HiveException, IOException {
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable, -1);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastLongHashMap map, CheckFastHashTable.VerifyFastLongHashMap verifyTable, int fixedValueLength) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = fixedValueLength == -1 ? new byte[TestVectorMapJoinFastLongHashMapNonMatched.generateLargeCount() - 1] : new byte[fixedValueLength];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                long key;
                while (verifyTable.contains(key = random.nextLong())) {
                }
                map.testPutRow(key, value);
                verifyTable.add(key, value);
                continue;
            }
            long randomExistingKey = verifyTable.addRandomExisting(value, random);
            map.testPutRow(randomExistingKey, value);
        }
        verifyTable.verifyNonMatched(map, random);
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(8L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        int keyCount = 100;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(20L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 512, 0.75f, 8192, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        int keyCount = 100;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }
}

