/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestVectorMapJoinFastLongHashMap
extends CommonFastHashTable {
    private static TableDesc tableDesc = new TableDesc();

    @Before
    public void setUp() throws Exception {
        tableDesc.setProperties(new Properties());
    }

    @Test
    public void testOneKey() throws Exception {
        random = new Random(33221L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        long key = random.nextLong();
        byte[] value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verify(map);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verify(map);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verify(map);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(900L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verify(map);
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(450L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        long key1 = random.nextLong();
        byte[] value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key1, value);
        verifyTable.add(key1, value);
        verifyTable.verify(map);
        long key2 = ++key1;
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key2, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertTrue((!hashMapResult.hasRows() ? 1 : 0) != 0);
        map.testPutRow(key2, value);
        verifyTable.add(key2, value);
        verifyTable.verify(map);
        long key3 = ++key2;
        hashMapResult = map.createHashMapResult();
        joinResult = map.lookup(key3, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertTrue((!hashMapResult.hasRows() ? 1 : 0) != 0);
    }

    @Test
    public void testFullMap() throws Exception {
        long anotherKey;
        random = new Random(93440L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 1.0f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        for (int i = 0; i < 8; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verify(map);
        while (verifyTable.contains(anotherKey = random.nextLong())) {
        }
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(anotherKey, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(5227L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 1, 1.0E-7f, 128, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        for (int i = 0; i < 6; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verify(map);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastLongHashMap map, CheckFastHashTable.VerifyFastLongHashMap verifyTable) throws HiveException, IOException {
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable, -1);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastLongHashMap map, CheckFastHashTable.VerifyFastLongHashMap verifyTable, int fixedValueLength) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = fixedValueLength == -1 ? new byte[TestVectorMapJoinFastLongHashMap.generateLargeCount() - 1] : new byte[fixedValueLength];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                long key;
                while (verifyTable.contains(key = random.nextLong())) {
                }
                map.testPutRow(key, value);
                verifyTable.add(key, value);
                verifyTable.verify(map);
            } else {
                long randomExistingKey = verifyTable.addRandomExisting(value, random);
                map.testPutRow(randomExistingKey, value);
            }
            verifyTable.verify(map);
        }
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(8L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(20L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 512, 0.75f, 8192, -1L, tableDesc);
        CheckFastHashTable.VerifyFastLongHashMap verifyTable = new CheckFastHashTable.VerifyFastLongHashMap();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Ignore
    @Test
    public void testOutOfBounds() throws Exception {
        random = new Random(42662L);
        int HIGHEST_INT_POWER_OF_2 = 0x40000000;
        boolean error = false;
        try {
            VectorMapJoinFastMultiKeyHashMap vectorMapJoinFastMultiKeyHashMap = new VectorMapJoinFastMultiKeyHashMap(false, HIGHEST_INT_POWER_OF_2, 0.75f, 8192, -1L);
        }
        catch (MapJoinMemoryExhaustionError e) {
            error = true;
        }
        assert (error);
    }
}

