/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestVectorMapJoinFastBytesHashMap
extends CommonFastHashTable {
    @Test
    public void testOneKey() throws Exception {
        random = new Random(82733L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        byte[] key = new byte[random.nextInt(100)];
        random.nextBytes(key);
        byte[] value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(29383L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            byte[] key = new byte[random.nextInt(100)];
            random.nextBytes(key);
            if (!verifyTable.contains(key)) break;
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
            verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
        }
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(1002L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        byte[] key1 = new byte[random.nextInt(100)];
        random.nextBytes(key1);
        byte[] value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key1, value);
        verifyTable.add(key1, value);
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
        byte[] key2 = new byte[random.nextInt(100)];
        random.nextBytes(key2);
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(key2, 0, key2.length, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertTrue((!hashMapResult.hasRows() ? 1 : 0) != 0);
        map.testPutRow(key2, value);
        verifyTable.add(key2, value);
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
        byte[] key3 = new byte[random.nextInt(100)];
        random.nextBytes(key3);
        hashMapResult = map.createHashMapResult();
        joinResult = map.lookup(key3, 0, key3.length, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertTrue((!hashMapResult.hasRows() ? 1 : 0) != 0);
    }

    @Test
    public void testFullMap() throws Exception {
        byte[] anotherKey;
        random = new Random(200001L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 1.0f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        for (int i = 0; i < 8; ++i) {
            byte[] key;
            do {
                key = new byte[random.nextInt(100)];
                random.nextBytes(key);
            } while (verifyTable.contains(key));
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
        do {
            anotherKey = new byte[random.nextInt(100)];
            random.nextBytes(anotherKey);
        } while (verifyTable.contains(anotherKey));
        VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
        JoinUtil.JoinResult joinResult = map.lookup(anotherKey, 0, anotherKey.length, hashMapResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(99221L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 1, 1.0E-7f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        for (int i = 0; i < 6; ++i) {
            byte[] key;
            do {
                key = new byte[random.nextInt(100)];
                random.nextBytes(key);
            } while (verifyTable.contains(key));
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastMultiKeyHashMap map, CheckFastHashTable.VerifyFastBytesHashMap verifyTable) throws HiveException, IOException {
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable, 100, -1);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastMultiKeyHashMap map, CheckFastHashTable.VerifyFastBytesHashMap verifyTable, int maxKeyLength, int fixedValueLength) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = fixedValueLength == -1 ? new byte[TestVectorMapJoinFastBytesHashMap.generateLargeCount() - 1] : new byte[fixedValueLength];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                byte[] key;
                do {
                    key = new byte[random.nextInt(maxKeyLength)];
                    random.nextBytes(key);
                } while (verifyTable.contains(key));
                map.testPutRow(key, value);
                verifyTable.add(key, value);
                continue;
            }
            byte[] randomExistingKey = verifyTable.addRandomExisting(value, random);
            map.testPutRow(randomExistingKey, value);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMap)map);
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(9332L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(21111L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 512, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testReallyBig() throws Exception {
        random = new Random(42662L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 1000000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Ignore
    @Test
    public void testOutOfBounds() throws Exception {
        random = new Random(42662L);
        int HIGHEST_INT_POWER_OF_2 = 0x40000000;
        boolean error = false;
        try {
            VectorMapJoinFastMultiKeyHashMap vectorMapJoinFastMultiKeyHashMap = new VectorMapJoinFastMultiKeyHashMap(false, HIGHEST_INT_POWER_OF_2, 0.75f, 8192, -1L);
        }
        catch (MapJoinMemoryExhaustionError e) {
            error = true;
        }
        assert (error);
    }
}

