/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.CountCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperatorBase;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjectsMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestConfig;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestData;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestMapJoinOperator {
    private boolean addLongHiveConfVariation(int hiveConfVariation, HiveConf hiveConf) {
        HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MINMAX_ENABLED, (boolean)false);
        HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD, (int)-1);
        switch (hiveConfVariation) {
            case 0: {
                break;
            }
            case 1: {
                HiveConf.setBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MINMAX_ENABLED, (boolean)true);
                break;
            }
            case 2: {
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD, (int)5);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean goodTestVariation(MapJoinTestDescription testDesc) {
        int smallTableValueSize = testDesc.smallTableRetainValueColumnNums.length;
        switch (testDesc.vectorMapJoinVariation) {
            case INNER: {
                return smallTableValueSize > 0;
            }
            case INNER_BIG_ONLY: 
            case LEFT_SEMI: 
            case LEFT_ANTI: {
                return smallTableValueSize == 0;
            }
            case OUTER: {
                return true;
            }
            case FULL_OUTER: {
                return true;
            }
        }
        throw new RuntimeException("Unexpected vectorMapJoinVariation " + testDesc.vectorMapJoinVariation);
    }

    @Ignore
    @Test
    public void testLong0() throws Exception {
        long seed = 234882L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong0(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    private boolean doTestLong0(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.longTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.dateTypeInfo};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong0");
        return false;
    }

    @Ignore
    @Test
    public void testLong0_NoRegularKeys() throws Exception {
        long seed = 234882L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong0_NoRegularKeys(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    private boolean doTestLong0_NoRegularKeys(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        smallTableGenerationParameters.setValueOption(MapJoinTestDescription.SmallTableGenerationParameters.ValueOption.NO_REGULAR_SMALL_KEYS);
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.longTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.dateTypeInfo};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "doTestLong0_NoRegularKeys");
        return false;
    }

    @Ignore
    @Test
    public void testLong1() throws Exception {
        long seed = 234882L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong1(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong1(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.intTypeInfo, TypeInfoFactory.longTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong1");
        return false;
    }

    @Test
    public void testLong2() throws Exception {
        long seed = 3553L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong2(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong2(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.shortTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.timestampTypeInfo};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong2");
        return false;
    }

    @Test
    public void testLong3() throws Exception {
        long seed = 9934L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong3(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong3(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18)};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong3");
        return false;
    }

    @Test
    public void testLong3_NoRegularKeys() throws Exception {
        long seed = 9934L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong3_NoRegularKeys(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong3_NoRegularKeys(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        smallTableGenerationParameters.setValueOption(MapJoinTestDescription.SmallTableGenerationParameters.ValueOption.NO_REGULAR_SMALL_KEYS);
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.intTypeInfo, TypeInfoFactory.stringTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18)};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "doTestLong3_NoRegularKeys");
        return false;
    }

    @Test
    public void testLong4() throws Exception {
        long seed = 3982L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong4(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong4(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.intTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[0];
        smallTableRetainKeyColumnNums = new int[0];
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong4");
        return false;
    }

    @Test
    public void testLong5() throws Exception {
        long seed = 3553L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong5(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong5(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.longTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[0];
        smallTableRetainKeyColumnNums = new int[]{0};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong5");
        return false;
    }

    @Test
    public void testLong6() throws Exception {
        long seed = 9384L;
        int rowCount = 10;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestLong6(seed, rowCount, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestLong6(long seed, int rowCount, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (!this.addLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.longTypeInfo, TypeInfoFactory.timestampTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[0];
        smallTableRetainKeyColumnNums = new int[]{0};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testLong6");
        return false;
    }

    private boolean addNonLongHiveConfVariation(int hiveConfVariation, HiveConf hiveConf) {
        HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD, (int)-1);
        switch (hiveConfVariation) {
            case 0: {
                break;
            }
            case 1: {
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD, (int)5);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Test
    public void testMultiKey0() throws Exception {
        long seed = 28322L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestMultiKey0(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestMultiKey0(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.shortTypeInfo, TypeInfoFactory.intTypeInfo};
        bigTableKeyColumnNums = new int[]{0, 1};
        smallTableValueTypeInfos = new TypeInfo[0];
        smallTableRetainKeyColumnNums = new int[]{0, 1};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testMultiKey0");
        return false;
    }

    @Test
    public void testMultiKey1() throws Exception {
        long seed = 87543L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestMultiKey1(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestMultiKey1(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.timestampTypeInfo, TypeInfoFactory.shortTypeInfo, TypeInfoFactory.stringTypeInfo};
        bigTableKeyColumnNums = new int[]{0, 1, 2};
        smallTableRetainKeyColumnNums = new int[]{0, 1, 2};
        smallTableValueTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18)};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testMultiKey1");
        return false;
    }

    @Test
    public void testMultiKey2() throws Exception {
        long seed = 87543L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestMultiKey2(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestMultiKey2(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.longTypeInfo, TypeInfoFactory.shortTypeInfo, TypeInfoFactory.stringTypeInfo};
        bigTableKeyColumnNums = new int[]{0, 1, 2};
        smallTableRetainKeyColumnNums = new int[]{0, 1, 2};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testMultiKey0");
        return false;
    }

    @Test
    public void testMultiKey3() throws Exception {
        long seed = 87543L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestMultiKey3(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestMultiKey3(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.dateTypeInfo, TypeInfoFactory.byteTypeInfo};
        bigTableKeyColumnNums = new int[]{0, 1};
        smallTableValueTypeInfos = new TypeInfo[0];
        smallTableRetainKeyColumnNums = new int[]{0, 1};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testMultiKey3");
        return false;
    }

    @Test
    public void testString0() throws Exception {
        long seed = 87543L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestString0(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestString0(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.dateTypeInfo, TypeInfoFactory.timestampTypeInfo};
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testString0");
        return false;
    }

    @Test
    public void testString1() throws Exception {
        long seed = 3422L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestString1(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestString1(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.binaryTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableRetainKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[]{TypeInfoFactory.shortTypeInfo, TypeInfoFactory.floatTypeInfo, new DecimalTypeInfo(38, 18)};
        smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testString1");
        return false;
    }

    @Test
    public void testString2() throws Exception {
        long seed = 7439L;
        int hiveConfVariation = 0;
        boolean hiveConfVariationsDone = false;
        do {
            for (VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation : VectorMapJoinDesc.VectorMapJoinVariation.values()) {
                hiveConfVariationsDone = this.doTestString2(seed, hiveConfVariation, vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation.DYNAMIC_PARTITION_HASH_JOIN);
            }
            ++seed;
            ++hiveConfVariation;
        } while (!hiveConfVariationsDone);
    }

    public boolean doTestString2(long seed, int hiveConfVariation, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, MapJoinTestDescription.MapJoinPlanVariation mapJoinPlanVariation) throws Exception {
        int rowCount = 10;
        HiveConf hiveConf = new HiveConf();
        if (!this.addNonLongHiveConfVariation(hiveConfVariation, hiveConf)) {
            return true;
        }
        TypeInfo[] bigTableTypeInfos = null;
        int[] bigTableKeyColumnNums = null;
        TypeInfo[] smallTableValueTypeInfos = null;
        int[] smallTableRetainKeyColumnNums = null;
        MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        MapJoinTestDescription testDesc = null;
        MapJoinTestData testData = null;
        bigTableTypeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        bigTableKeyColumnNums = new int[]{0};
        smallTableValueTypeInfos = new TypeInfo[0];
        smallTableRetainKeyColumnNums = new int[]{0};
        smallTableGenerationParameters = new MapJoinTestDescription.SmallTableGenerationParameters();
        testDesc = new MapJoinTestDescription(hiveConf, vectorMapJoinVariation, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
        if (!this.goodTestVariation(testDesc)) {
            return false;
        }
        testData = new MapJoinTestData(rowCount, testDesc, seed);
        this.executeTest(testDesc, testData, "testString2");
        return false;
    }

    private void addBigTableRetained(MapJoinTestDescription testDesc, Object[] bigTableRowObjects, Object[] outputObjects) {
        int bigTableRetainColumnNumsLength = testDesc.bigTableRetainColumnNums.length;
        for (int o = 0; o < bigTableRetainColumnNumsLength; ++o) {
            outputObjects[o] = bigTableRowObjects[testDesc.bigTableRetainColumnNums[o]];
        }
    }

    private void addToOutput(MapJoinTestDescription testDesc, RowTestObjectsMultiSet expectedTestRowMultiSet, Object[] outputObjects, RowTestObjectsMultiSet.RowFlag rowFlag) {
        for (int c = 0; c < outputObjects.length; ++c) {
            PrimitiveObjectInspector primitiveObjInsp = (PrimitiveObjectInspector)testDesc.outputObjectInspectors[c];
            Object outputObject = outputObjects[c];
            outputObjects[c] = primitiveObjInsp.copyObject(outputObject);
        }
        expectedTestRowMultiSet.add(new RowTestObjects(outputObjects), rowFlag);
    }

    private String rowToCsvString(Object[] rowObjects) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowObjects.length; ++i) {
            Object obj;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((obj = rowObjects[i]) == null) {
                sb.append("\\N");
                continue;
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    private RowTestObjectsMultiSet createExpectedTestRowMultiSet(MapJoinTestDescription testDesc, MapJoinTestData testData) throws HiveException {
        int o;
        int smallTableRetainValueColumnNumsLength;
        Object[] valueRow;
        int smallTableRetainKeyColumnNumsLength;
        RowTestObjectsMultiSet expectedTestRowMultiSet = new RowTestObjectsMultiSet();
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(testDesc.bigTableTypeInfos);
        int bigTableColumnCount = testDesc.bigTableTypeInfos.length;
        Object[] bigTableRowObjects = new Object[bigTableColumnCount];
        int bigTableKeyColumnCount = testDesc.bigTableKeyTypeInfos.length;
        Object[] bigTableKeyObjects = new Object[bigTableKeyColumnCount];
        VectorRandomBatchSource bigTableBatchSource = testData.getBigTableBatchSource();
        VectorizedRowBatch batch = testData.getBigTableBatch();
        bigTableBatchSource.resetBatchIteration();
        while (bigTableBatchSource.fillNextBatch(batch)) {
            int size = testData.bigTableBatch.size;
            block5: for (int r = 0; r < size; ++r) {
                int o2;
                vectorExtractRow.extractRow(testData.bigTableBatch, r, bigTableRowObjects);
                boolean hasAnyNulls = false;
                for (int k = 0; k < bigTableKeyColumnCount; ++k) {
                    int keyColumnNum = testDesc.bigTableKeyColumnNums[k];
                    Object keyObject = bigTableRowObjects[keyColumnNum];
                    if (keyObject == null) {
                        hasAnyNulls = true;
                    }
                    bigTableKeyObjects[k] = keyObject;
                    bigTableKeyObjects[k] = ((PrimitiveObjectInspector)testDesc.bigTableObjectInspectors[keyColumnNum]).copyObject(bigTableKeyObjects[k]);
                }
                RowTestObjects testKey = new RowTestObjects(bigTableKeyObjects);
                if (testData.smallTableKeyHashMap.containsKey(testKey) && !hasAnyNulls) {
                    int smallTableKeyIndex = testData.smallTableKeyHashMap.get(testKey);
                    switch (testDesc.vectorMapJoinVariation) {
                        case INNER: 
                        case OUTER: 
                        case FULL_OUTER: {
                            ArrayList<RowTestObjects> valueList = testData.smallTableValues.get(smallTableKeyIndex);
                            int valueCount = valueList.size();
                            for (int v = 0; v < valueCount; ++v) {
                                Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                                this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                                int outputColumnNum = testDesc.bigTableRetainColumnNums.length;
                                smallTableRetainKeyColumnNumsLength = testDesc.smallTableRetainKeyColumnNums.length;
                                for (int o3 = 0; o3 < smallTableRetainKeyColumnNumsLength; ++o3) {
                                    outputObjects[outputColumnNum++] = bigTableKeyObjects[testDesc.smallTableRetainKeyColumnNums[o3]];
                                }
                                valueRow = valueList.get(v).getRow();
                                smallTableRetainValueColumnNumsLength = testDesc.smallTableRetainValueColumnNums.length;
                                for (o = 0; o < smallTableRetainValueColumnNumsLength; ++o) {
                                    outputObjects[outputColumnNum++] = valueRow[testDesc.smallTableRetainValueColumnNums[o]];
                                }
                                this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects, RowTestObjectsMultiSet.RowFlag.REGULAR);
                            }
                            continue block5;
                        }
                        case INNER_BIG_ONLY: 
                        case LEFT_SEMI: 
                        case LEFT_ANTI: {
                            Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                            this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                            int outputColumnNum = testDesc.bigTableRetainColumnNums.length;
                            int smallTableRetainKeyColumnNumsLength2 = testDesc.smallTableRetainKeyColumnNums.length;
                            for (o2 = 0; o2 < smallTableRetainKeyColumnNumsLength2; ++o2) {
                                outputObjects[outputColumnNum++] = bigTableKeyObjects[testDesc.smallTableRetainKeyColumnNums[o2]];
                            }
                            this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects, RowTestObjectsMultiSet.RowFlag.REGULAR);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown operator variation " + testDesc.vectorMapJoinVariation);
                        }
                    }
                    continue;
                }
                if (testDesc.vectorMapJoinVariation != VectorMapJoinDesc.VectorMapJoinVariation.OUTER && testDesc.vectorMapJoinVariation != VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER) continue;
                Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                this.addBigTableRetained(testDesc, bigTableRowObjects, outputObjects);
                int outputColumnNum = testDesc.bigTableRetainColumnNums.length;
                int smallTableRetainKeyColumnNumsLength3 = testDesc.smallTableRetainKeyColumnNums.length;
                for (int o4 = 0; o4 < smallTableRetainKeyColumnNumsLength3; ++o4) {
                    outputObjects[outputColumnNum++] = null;
                }
                int smallTableRetainValueColumnNumsLength2 = testDesc.smallTableRetainValueColumnNums.length;
                for (o2 = 0; o2 < smallTableRetainValueColumnNumsLength2; ++o2) {
                    outputObjects[outputColumnNum++] = null;
                }
                this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects, RowTestObjectsMultiSet.RowFlag.LEFT_OUTER);
            }
        }
        if (testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER) {
            System.out.println("*BENCHMARK* ----------------------------------------------------------------------");
            System.out.println("*BENCHMARK* FULL OUTER non-match key count " + testData.fullOuterAdditionalSmallTableKeys.size());
            for (RowTestObjects smallTableKey : testData.fullOuterAdditionalSmallTableKeys) {
                int smallTableKeyIndex = testData.smallTableKeyHashMap.get(smallTableKey);
                ArrayList<RowTestObjects> valueList = testData.smallTableValues.get(smallTableKeyIndex);
                int valueCount = valueList.size();
                for (int v = 0; v < valueCount; ++v) {
                    Object[] outputObjects = new Object[testDesc.outputColumnNames.length];
                    int bigTableRetainColumnNumsLength = testDesc.bigTableRetainColumnNums.length;
                    for (int o5 = 0; o5 < bigTableRetainColumnNumsLength; ++o5) {
                        outputObjects[o5] = null;
                    }
                    int outputColumnNum = testDesc.bigTableRetainColumnNums.length;
                    Object[] smallKeyObjects = smallTableKey.getRow();
                    smallTableRetainKeyColumnNumsLength = testDesc.smallTableRetainKeyColumnNums.length;
                    for (int o6 = 0; o6 < smallTableRetainKeyColumnNumsLength; ++o6) {
                        outputObjects[outputColumnNum++] = smallKeyObjects[testDesc.smallTableRetainKeyColumnNums[o6]];
                    }
                    valueRow = valueList.get(v).getRow();
                    smallTableRetainValueColumnNumsLength = testDesc.smallTableRetainValueColumnNums.length;
                    for (o = 0; o < smallTableRetainValueColumnNumsLength; ++o) {
                        outputObjects[outputColumnNum++] = valueRow[testDesc.smallTableRetainValueColumnNums[o]];
                    }
                    this.addToOutput(testDesc, expectedTestRowMultiSet, outputObjects, RowTestObjectsMultiSet.RowFlag.FULL_OUTER);
                }
            }
        }
        return expectedTestRowMultiSet;
    }

    private void generateBigAndSmallTableRowLogLines(MapJoinTestDescription testDesc, MapJoinTestData testData) throws HiveException {
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(testDesc.bigTableTypeInfos);
        int bigTableColumnCount = testDesc.bigTableTypeInfos.length;
        Object[] bigTableRowObjects = new Object[bigTableColumnCount];
        VectorRandomBatchSource bigTableBatchSource = testData.getBigTableBatchSource();
        VectorizedRowBatch batch = testData.getBigTableBatch();
        bigTableBatchSource.resetBatchIteration();
        while (bigTableBatchSource.fillNextBatch(batch)) {
            int size = testData.bigTableBatch.size;
            for (int r = 0; r < size; ++r) {
                vectorExtractRow.extractRow(testData.bigTableBatch, r, bigTableRowObjects);
            }
        }
        int keyKeyColumnNumsLength = testDesc.bigTableKeyColumnNums.length;
        int smallTableRetainValueLength = testDesc.smallTableRetainValueColumnNums.length;
        int smallTableLength = keyKeyColumnNumsLength + smallTableRetainValueLength;
        for (Map.Entry<RowTestObjects, Integer> entry : testData.smallTableKeyHashMap.entrySet()) {
            if (smallTableRetainValueLength == 0) {
                Object[] objectArray = entry.getKey().getRow();
                continue;
            }
            Integer valueIndex = entry.getValue();
            ArrayList<RowTestObjects> valueList = testData.smallTableValues.get(valueIndex);
            int valueCount = valueList.size();
            for (int v = 0; v < valueCount; ++v) {
                Object[] smallTableRowObjects = new Object[smallTableLength];
                System.arraycopy(entry.getKey().getRow(), 0, smallTableRowObjects, 0, keyKeyColumnNumsLength);
                int outputColumnNum = keyKeyColumnNumsLength;
                Object[] valueRow = valueList.get(v).getRow();
                for (int o = 0; o < smallTableRetainValueLength; ++o) {
                    smallTableRowObjects[outputColumnNum++] = valueRow[testDesc.smallTableRetainValueColumnNums[o]];
                }
            }
        }
    }

    private void executeTest(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        switch (testDesc.vectorMapJoinVariation) {
            case INNER: {
                this.executeTestInner(testDesc, testData, title);
                break;
            }
            case INNER_BIG_ONLY: {
                this.executeTestInnerBigOnly(testDesc, testData, title);
                break;
            }
            case LEFT_SEMI: {
                this.executeTestLeftSemi(testDesc, testData, title);
                break;
            }
            case OUTER: {
                this.executeTestOuter(testDesc, testData, title);
                break;
            }
            case FULL_OUTER: {
                this.executeTestFullOuter(testDesc, testData, title);
                break;
            }
            case LEFT_ANTI: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected Vector MapJoin variation " + testDesc.vectorMapJoinVariation);
            }
        }
    }

    private void executeTestInner(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        this.doExecuteTest(testDesc, testData, title);
    }

    private void executeTestInnerBigOnly(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        this.doExecuteTest(testDesc, testData, title);
    }

    private void executeTestLeftSemi(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        this.doExecuteTest(testDesc, testData, title);
    }

    private void executeTestOuter(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        this.doExecuteTest(testDesc, testData, title);
    }

    private void executeTestFullOuter(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        this.doExecuteTest(testDesc, testData, title);
    }

    private void doExecuteTest(MapJoinTestDescription testDesc, MapJoinTestData testData, String title) throws Exception {
        RowTestObjectsMultiSet expectedTestRowMultiSet = this.createExpectedTestRowMultiSet(testDesc, testData);
        this.generateBigAndSmallTableRowLogLines(testDesc, testData);
        System.out.println("*BENCHMARK* expectedTestRowMultiSet  totalKeyCount " + expectedTestRowMultiSet.getTotalKeyCount() + " totalValueCount " + expectedTestRowMultiSet.getTotalValueCount());
        block7: for (MapJoinTestConfig.MapJoinTestImplementation mapJoinImplementation : MapJoinTestConfig.MapJoinTestImplementation.values()) {
            if (testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER && mapJoinImplementation == MapJoinTestConfig.MapJoinTestImplementation.ROW_MODE_HASH_MAP) continue;
            switch (mapJoinImplementation) {
                case ROW_MODE_HASH_MAP: {
                    this.executeRowModeHashMap(testDesc, testData, expectedTestRowMultiSet, title);
                    continue block7;
                }
                case ROW_MODE_OPTIMIZED: {
                    this.executeRowModeOptimized(testDesc, testData, expectedTestRowMultiSet, title);
                    continue block7;
                }
                case VECTOR_PASS_THROUGH: {
                    this.executeVectorPassThrough(testDesc, testData, expectedTestRowMultiSet, title);
                    continue block7;
                }
                case NATIVE_VECTOR_OPTIMIZED: {
                    this.executeNativeVectorOptimized(testDesc, testData, expectedTestRowMultiSet, title);
                    continue block7;
                }
                case NATIVE_VECTOR_FAST: {
                    this.executeNativeVectorFast(testDesc, testData, expectedTestRowMultiSet, title);
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unexpected vector map join test variation");
                }
            }
        }
    }

    private void executeRowModeHashMap(MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet, String title) throws Exception {
        this.executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation.ROW_MODE_HASH_MAP, testDesc, testData, expectedTestRowMultiSet, title);
    }

    private void executeRowModeOptimized(MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet, String title) throws Exception {
        this.executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation.ROW_MODE_OPTIMIZED, testDesc, testData, expectedTestRowMultiSet, title);
    }

    private void executeVectorPassThrough(MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet, String title) throws Exception {
        this.executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation.VECTOR_PASS_THROUGH, testDesc, testData, expectedTestRowMultiSet, title);
    }

    private void executeNativeVectorOptimized(MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet, String title) throws Exception {
        this.executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation.NATIVE_VECTOR_OPTIMIZED, testDesc, testData, expectedTestRowMultiSet, title);
    }

    private void executeNativeVectorFast(MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet, String title) throws Exception {
        this.executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation.NATIVE_VECTOR_FAST, testDesc, testData, expectedTestRowMultiSet, title);
    }

    private void executeTestImplementation(MapJoinTestConfig.MapJoinTestImplementation mapJoinImplementation, MapJoinTestDescription testDesc, MapJoinTestData testData, RowTestObjectsMultiSet expectedTestRowMultiSet, String title) throws Exception {
        RowCollectorTestOperatorBase testCollectorOperator;
        System.out.println("*BENCHMARK* Starting implementation " + (Object)((Object)mapJoinImplementation) + " variation " + testDesc.vectorMapJoinVariation + " title " + title);
        MapJoinDesc mapJoinDesc = MapJoinTestConfig.createMapJoinDesc(testDesc);
        boolean isVectorOutput = MapJoinTestConfig.isVectorOutput(mapJoinImplementation);
        RowTestObjectsMultiSet outputTestRowMultiSet = new RowTestObjectsMultiSet();
        MapJoinTestConfig.CreateMapJoinResult result = MapJoinTestConfig.createMapJoinImplementation(mapJoinImplementation, testDesc, testData, mapJoinDesc);
        MapJoinOperator mapJoinOperator = result.mapJoinOperator;
        MapJoinTableContainer mapJoinTableContainer = result.mapJoinTableContainer;
        MapJoinTableContainerSerDe mapJoinTableContainerSerDe = result.mapJoinTableContainerSerDe;
        if (!isVectorOutput) {
            testCollectorOperator = new MapJoinTestConfig.TestMultiSetCollectorOperator(testDesc.outputObjectInspectors, outputTestRowMultiSet);
        } else {
            VectorizationContext vOutContext = ((VectorizationContextRegion)mapJoinOperator).getOutputVectorizationContext();
            testCollectorOperator = new MapJoinTestConfig.TestMultiSetVectorCollectorOperator(ArrayUtils.toPrimitive((Integer[])vOutContext.getProjectedColumns().toArray(new Integer[0])), testDesc.outputTypeInfos, testDesc.outputObjectInspectors, outputTestRowMultiSet);
        }
        MapJoinTestConfig.connectOperators((Operator<? extends OperatorDesc>)mapJoinOperator, testCollectorOperator);
        CountCollectorTestOperator interceptTestCollectorOperator = null;
        if (testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER && !mapJoinDesc.isDynamicPartitionHashJoin()) {
            if (mapJoinImplementation == MapJoinTestConfig.MapJoinTestImplementation.ROW_MODE_HASH_MAP) {
                return;
            }
            interceptTestCollectorOperator = MapJoinTestConfig.addFullOuterIntercept(mapJoinImplementation, testDesc, outputTestRowMultiSet, testData, mapJoinOperator, mapJoinTableContainer, mapJoinTableContainerSerDe);
        } else {
            mapJoinOperator.initialize((Configuration)testDesc.hiveConf, testDesc.inputObjectInspectors);
            mapJoinOperator.setTestMapJoinTableContainer(1, mapJoinTableContainer, mapJoinTableContainerSerDe);
        }
        if (!isVectorOutput) {
            MapJoinTestData.driveBigTableData(testDesc, testData, mapJoinOperator);
        } else {
            MapJoinTestData.driveVectorBigTableData(testDesc, testData, mapJoinOperator);
        }
        if (!testCollectorOperator.getIsClosed()) {
            Assert.fail((String)"collector operator not closed");
        }
        if (testCollectorOperator.getIsAborted()) {
            Assert.fail((String)"collector operator aborted");
        }
        if (testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER && !mapJoinDesc.isDynamicPartitionHashJoin()) {
            if (!interceptTestCollectorOperator.getIsClosed()) {
                Assert.fail((String)"intercept collector operator not closed");
            }
            if (interceptTestCollectorOperator.getIsAborted()) {
                Assert.fail((String)"intercept collector operator aborted");
            }
        }
        System.out.println("*BENCHMARK* executeTestImplementation row count " + testCollectorOperator.getRowCount());
        String option = "";
        if (testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER) {
            option = " mapJoinPlanVariation " + testDesc.mapJoinPlanVariation.name();
        }
        if (!expectedTestRowMultiSet.verify(outputTestRowMultiSet, "expected", "actual")) {
            System.out.println("*BENCHMARK* " + title + " verify failed for implementation " + (Object)((Object)mapJoinImplementation) + " variation " + testDesc.vectorMapJoinVariation + option);
            expectedTestRowMultiSet.displayDifferences(outputTestRowMultiSet, "expected", "actual");
        } else {
            System.out.println("*BENCHMARK* " + title + " verify succeeded  for implementation " + (Object)((Object)mapJoinImplementation) + " variation " + testDesc.vectorMapJoinVariation + option);
        }
    }
}

