/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.util.DescriptionTest;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class MapJoinTestDescription
extends DescriptionTest {
    final VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation;
    public String[] bigTableKeyColumnNames;
    public TypeInfo[] bigTableTypeInfos;
    public int[] bigTableKeyColumnNums;
    public TypeInfo[] smallTableValueTypeInfos;
    public int[] smallTableRetainKeyColumnNums;
    public SmallTableGenerationParameters smallTableGenerationParameters;
    public int[] bigTableColumnNums;
    public String[] bigTableColumnNames;
    public List<String> bigTableColumnNameList;
    public ObjectInspector[] bigTableObjectInspectors;
    public List<ObjectInspector> bigTableObjectInspectorList;
    public TypeInfo[] bigTableKeyTypeInfos;
    public List<String> smallTableKeyColumnNameList;
    public String[] smallTableKeyColumnNames;
    public TypeInfo[] smallTableKeyTypeInfos;
    public ObjectInspector[] smallTableKeyObjectInspectors;
    public List<ObjectInspector> smallTableKeyObjectInspectorList;
    public List<String> smallTableValueColumnNameList;
    public String[] smallTableValueColumnNames;
    public ObjectInspector[] smallTableValueObjectInspectors;
    public List<ObjectInspector> smallTableValueObjectInspectorList;
    public int[] bigTableRetainColumnNums;
    public int[] smallTableRetainValueColumnNums;
    public String[] smallTableColumnNames;
    public List<String> smallTableColumnNameList;
    public TypeInfo[] smallTableTypeInfos;
    public List<ObjectInspector> smallTableObjectInspectorList;
    public StandardStructObjectInspector bigTableStandardObjectInspector;
    public StandardStructObjectInspector smallTableStandardObjectInspector;
    public ObjectInspector[] inputObjectInspectors;
    public String[] outputColumnNames;
    public TypeInfo[] outputTypeInfos;
    public ObjectInspector[] outputObjectInspectors;
    final MapJoinPlanVariation mapJoinPlanVariation;

    public MapJoinTestDescription(HiveConf hiveConf, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, TypeInfo[] bigTableTypeInfos, int[] bigTableKeyColumnNums, TypeInfo[] smallTableValueTypeInfos, int[] smallTableRetainKeyColumnNums, SmallTableGenerationParameters smallTableGenerationParameters, MapJoinPlanVariation mapJoinPlanVariation) {
        this(hiveConf, vectorMapJoinVariation, null, bigTableTypeInfos, bigTableKeyColumnNums, smallTableValueTypeInfos, smallTableRetainKeyColumnNums, smallTableGenerationParameters, mapJoinPlanVariation);
    }

    public MapJoinTestDescription(HiveConf hiveConf, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, String[] bigTableColumnNames, TypeInfo[] bigTableTypeInfos, int[] bigTableKeyColumnNums, TypeInfo[] smallTableValueTypeInfos, int[] smallTableRetainKeyColumnNums, SmallTableGenerationParameters smallTableGenerationParameters, MapJoinPlanVariation mapJoinPlanVariation) {
        super(hiveConf);
        this.vectorMapJoinVariation = vectorMapJoinVariation;
        this.bigTableColumnNames = bigTableColumnNames;
        this.bigTableTypeInfos = bigTableTypeInfos;
        this.bigTableKeyColumnNums = bigTableKeyColumnNums;
        this.smallTableValueTypeInfos = smallTableValueTypeInfos;
        this.smallTableRetainKeyColumnNums = smallTableRetainKeyColumnNums;
        this.smallTableGenerationParameters = smallTableGenerationParameters;
        this.mapJoinPlanVariation = mapJoinPlanVariation;
        this.computeDerived();
    }

    public SmallTableGenerationParameters getSmallTableGenerationParameters() {
        return this.smallTableGenerationParameters;
    }

    public void computeDerived() {
        int i;
        int i2;
        int bigTableKeyColumnNum;
        int i3;
        int i4;
        int bigTableSize = this.bigTableTypeInfos.length;
        if (this.bigTableKeyColumnNames == null) {
            this.bigTableColumnNames = new String[bigTableSize];
            for (i4 = 0; i4 < bigTableSize; ++i4) {
                this.bigTableColumnNames[i4] = HiveConf.getColumnInternalName((int)i4);
            }
        }
        this.bigTableColumnNums = new int[bigTableSize];
        for (i4 = 0; i4 < bigTableSize; ++i4) {
            this.bigTableColumnNums[i4] = i4;
        }
        this.bigTableRetainColumnNums = new int[bigTableSize];
        for (i4 = 0; i4 < bigTableSize; ++i4) {
            this.bigTableRetainColumnNums[i4] = i4;
        }
        int keySize = this.bigTableKeyColumnNums.length;
        this.bigTableKeyColumnNames = new String[keySize];
        this.bigTableKeyTypeInfos = new TypeInfo[keySize];
        for (i3 = 0; i3 < keySize; ++i3) {
            bigTableKeyColumnNum = this.bigTableKeyColumnNums[i3];
            this.bigTableKeyColumnNames[i3] = this.bigTableColumnNames[bigTableKeyColumnNum];
            this.bigTableKeyTypeInfos[i3] = this.bigTableTypeInfos[bigTableKeyColumnNum];
        }
        this.bigTableObjectInspectors = new ObjectInspector[bigTableSize];
        for (i3 = 0; i3 < bigTableSize; ++i3) {
            this.bigTableObjectInspectors[i3] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.bigTableTypeInfos[i3]));
        }
        this.bigTableColumnNameList = Arrays.asList(this.bigTableColumnNames);
        this.bigTableObjectInspectorList = Arrays.asList(this.bigTableObjectInspectors);
        this.smallTableKeyColumnNames = new String[keySize];
        this.smallTableKeyTypeInfos = Arrays.copyOf(this.bigTableKeyTypeInfos, keySize);
        this.smallTableKeyObjectInspectors = new ObjectInspector[keySize];
        for (i3 = 0; i3 < keySize; ++i3) {
            this.smallTableKeyColumnNames[i3] = HiveConf.getColumnInternalName((int)i3);
            bigTableKeyColumnNum = this.bigTableKeyColumnNums[i3];
            this.smallTableKeyObjectInspectors[i3] = this.bigTableObjectInspectors[bigTableKeyColumnNum];
        }
        this.smallTableKeyColumnNameList = Arrays.asList(this.smallTableKeyColumnNames);
        this.smallTableKeyObjectInspectorList = Arrays.asList(this.smallTableKeyObjectInspectors);
        this.smallTableColumnNameList = new ArrayList<String>(this.smallTableKeyColumnNameList);
        ArrayList<TypeInfo> smallTableTypeInfoList = new ArrayList<TypeInfo>(Arrays.asList(this.smallTableKeyTypeInfos));
        this.smallTableObjectInspectorList = new ArrayList<ObjectInspector>();
        this.smallTableObjectInspectorList.addAll(this.smallTableKeyObjectInspectorList);
        int valueSize = this.smallTableValueTypeInfos.length;
        this.smallTableValueColumnNames = new String[valueSize];
        for (i2 = 0; i2 < valueSize; ++i2) {
            this.smallTableValueColumnNames[i2] = HiveConf.getColumnInternalName((int)(keySize + i2));
        }
        this.smallTableValueObjectInspectors = new ObjectInspector[valueSize];
        for (i2 = 0; i2 < valueSize; ++i2) {
            this.smallTableValueObjectInspectors[i2] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.smallTableValueTypeInfos[i2]));
        }
        this.smallTableValueColumnNameList = Arrays.asList(this.smallTableValueColumnNames);
        smallTableTypeInfoList.addAll(Arrays.asList(this.smallTableValueTypeInfos));
        this.smallTableValueObjectInspectorList = Arrays.asList(this.smallTableValueObjectInspectors);
        this.smallTableColumnNameList.addAll(this.smallTableValueColumnNameList);
        this.smallTableColumnNames = this.smallTableColumnNameList.toArray(new String[0]);
        this.smallTableTypeInfos = smallTableTypeInfoList.toArray(new TypeInfo[0]);
        this.smallTableObjectInspectorList.addAll(this.smallTableValueObjectInspectorList);
        this.bigTableStandardObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.bigTableColumnNameList, this.bigTableObjectInspectorList);
        this.smallTableStandardObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.smallTableColumnNameList, this.smallTableObjectInspectorList);
        this.inputObjectInspectors = new ObjectInspector[]{this.bigTableStandardObjectInspector, this.smallTableStandardObjectInspector};
        this.smallTableRetainValueColumnNums = new int[valueSize];
        for (i2 = 0; i2 < valueSize; ++i2) {
            this.smallTableRetainValueColumnNums[i2] = i2;
        }
        int outputLength = this.bigTableRetainColumnNums.length + this.smallTableRetainKeyColumnNums.length + this.smallTableRetainValueColumnNums.length;
        this.outputColumnNames = this.createOutputColumnNames(outputLength);
        this.outputTypeInfos = new TypeInfo[outputLength];
        int outputIndex = 0;
        int bigTableRetainSize = this.bigTableRetainColumnNums.length;
        for (i = 0; i < bigTableRetainSize; ++i) {
            this.outputTypeInfos[outputIndex++] = this.bigTableTypeInfos[this.bigTableRetainColumnNums[i]];
        }
        for (i = 0; i < this.smallTableRetainKeyColumnNums.length; ++i) {
            this.outputTypeInfos[outputIndex++] = this.smallTableKeyTypeInfos[this.smallTableRetainKeyColumnNums[i]];
        }
        for (i = 0; i < this.smallTableRetainValueColumnNums.length; ++i) {
            this.outputTypeInfos[outputIndex++] = this.smallTableValueTypeInfos[this.smallTableRetainValueColumnNums[i]];
        }
        this.outputObjectInspectors = new ObjectInspector[outputLength];
        for (i = 0; i < outputLength; ++i) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.outputTypeInfos[i];
            this.outputObjectInspectors[i] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo);
        }
    }

    private String[] createOutputColumnNames(int outputColumnCount) {
        String[] outputColumnNames = new String[outputColumnCount];
        int counter = 1;
        for (int i = 0; i < outputColumnCount; ++i) {
            outputColumnNames[i] = "out" + counter++;
        }
        return outputColumnNames;
    }

    public static class SmallTableGenerationParameters {
        private ValueOption valueOption = ValueOption.NO_RESTRICTION;
        private int keyOutOfAThousand = 50;
        private int noMatchKeyOutOfAThousand = 50;

        public void setValueOption(ValueOption valueOption) {
            this.valueOption = valueOption;
        }

        public ValueOption getValueOption() {
            return this.valueOption;
        }

        public void setKeyOutOfAThousand(int keyOutOfAThousand) {
            this.keyOutOfAThousand = keyOutOfAThousand;
        }

        public int getKeyOutOfAThousand() {
            return this.keyOutOfAThousand;
        }

        public void setNoMatchKeyOutOfAThousand(int noMatchKeyOutOfAThousand) {
            this.noMatchKeyOutOfAThousand = noMatchKeyOutOfAThousand;
        }

        public int getNoMatchKeyOutOfAThousand() {
            return this.noMatchKeyOutOfAThousand;
        }

        public static enum ValueOption {
            NO_RESTRICTION,
            ONLY_ONE,
            NO_REGULAR_SMALL_KEYS;

        }
    }

    public static enum MapJoinPlanVariation {
        DYNAMIC_PARTITION_HASH_JOIN,
        SHARED_SMALL_TABLE;

    }
}

