/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFBloomFilterMerge;
import org.apache.hive.common.util.BloomKFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorUDAFBloomFilterMerge {
    @Test
    public void testMergeBloomKFilterBytesParallel() throws Exception {
        this.testMergeBloomKFilterBytesParallel(1);
        this.testMergeBloomKFilterBytesParallel(2);
        this.testMergeBloomKFilterBytesParallel(4);
        this.testMergeBloomKFilterBytesParallel(8);
    }

    private void testMergeBloomKFilterBytesParallel(int threads) throws IOException {
        Configuration conf = new Configuration();
        conf.setInt(HiveConf.ConfVars.TEZ_BLOOM_FILTER_MERGE_THREADS.varname, threads);
        int expectedEntries = 1000000;
        byte[] bf1Bytes = this.getBloomKFilterBytesFromStringValues(expectedEntries, "bloo", "bloom fil", "bloom filter", "cuckoo filter");
        byte[] bf2Bytes = this.getBloomKFilterBytesFromStringValues(expectedEntries, "2_bloo", "2_bloom fil", "2_bloom filter", "2_cuckoo filter");
        byte[] bf3Bytes = this.getBloomKFilterBytesFromStringValues(expectedEntries, "3_bloo", "3_bloom fil", "3_bloom filter", "3_cuckoo filter");
        byte[] bf4Bytes = this.getBloomKFilterBytesFromStringValues(expectedEntries, "4_bloo", "4_bloom fil", "4_bloom filter", "4_cuckoo filter");
        byte[] bf5Bytes = this.getBloomKFilterBytesFromStringValues(expectedEntries, "5_bloo", "5_bloom fil", "5_bloom filter", "5_cuckoo filter");
        BytesColumnVector columnVector = new BytesColumnVector();
        columnVector.reset();
        columnVector.setVal(0, bf1Bytes);
        columnVector.setVal(1, bf2Bytes);
        columnVector.setVal(2, bf3Bytes);
        BytesColumnVector columnVector2 = new BytesColumnVector();
        columnVector2.reset();
        columnVector2.setVal(0, bf4Bytes);
        columnVector2.setVal(1, bf5Bytes);
        VectorUDAFBloomFilterMerge.Aggregation agg = new VectorUDAFBloomFilterMerge.Aggregation((long)expectedEntries, threads);
        agg.mergeBloomFilterBytesFromInputColumn(columnVector, 1024, false, null);
        agg.mergeBloomFilterBytesFromInputColumn(columnVector2, 1024, false, null);
        new VectorUDAFBloomFilterMerge().finish((VectorAggregateExpression.AggregationBuffer)agg, false);
        BloomKFilter merged = BloomKFilter.deserialize((InputStream)new ByteArrayInputStream(agg.bfBytes));
        Assert.assertTrue((boolean)merged.testBytes("bloo".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("cuckoo filter".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("2_bloo".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("2_cuckoo filter".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("3_bloo".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("3_cuckoo filter".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("4_bloo".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("4_cuckoo filter".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("5_bloo".getBytes()));
        Assert.assertTrue((boolean)merged.testBytes("5_cuckoo filter".getBytes()));
    }

    private byte[] getBloomKFilterBytesFromStringValues(int expectedEntries, String ... values) throws IOException {
        BloomKFilter bf = new BloomKFilter((long)expectedEntries);
        for (String val : values) {
            bf.addString(val);
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        BloomKFilter.serialize((OutputStream)bytesOut, (BloomKFilter)bf);
        return bytesOut.toByteArray();
    }
}

