/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToStringViaLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToFloat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TestVectorMathFunctions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToBooleanViaDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToBooleanViaLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToDouble;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.ql.util.TimestampUtils;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorTypeCasts {
    private HiveConf hiveConf = new HiveConf();
    public static final long NANOSECONDS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    public static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    public static final long NANOSECONDS_PER_MILLISSECOND = TimeUnit.MILLISECONDS.toNanos(1L);

    @Test
    public void testVectorCastLongToDouble() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastLongToDouble expr = new CastLongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)2.0, (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorCastDoubleToLong() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDoubleToLong expr = new CastDoubleToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resultV.vector[6]);
    }

    @Test
    public void testCastDateToString() throws HiveException {
        int[] intValues = new int[100];
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDateInStringOut(intValues);
        BytesColumnVector resultV = (BytesColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDateToString expr = new CastDateToString(0, 1);
        expr.evaluate(b);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setCalendar(DateTimeMath.getProlepticGregorianCalendarUTC());
        for (int i = 0; i < intValues.length; ++i) {
            String expected = formatter.format(new Date(DateWritableV2.daysToMillis((int)intValues[i])));
            byte[] subbyte = Arrays.copyOfRange(resultV.vector[i], resultV.start[i], resultV.start[i] + resultV.length[i]);
            String result = new String(subbyte, StandardCharsets.UTF_8);
            Assert.assertEquals((String)("Index: " + i + " Epoch day value: " + intValues[i]), (Object)expected, (Object)result);
        }
    }

    @Test
    public void testCastDateToTimestamp() throws HiveException {
        int[] intValues = new int[500];
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDateInTimestampOut(intValues);
        TimestampColumnVector resultV = (TimestampColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDateToTimestamp expr = new CastDateToTimestamp(0, 1);
        expr.evaluate(b);
        for (int i = 0; i < intValues.length; ++i) {
            Timestamp timestamp = resultV.asScratchTimestamp(i);
            long actual = DateWritableV2.millisToDays((long)timestamp.getTime());
            Assert.assertEquals((long)actual, (long)intValues[i]);
        }
    }

    @Test
    public void testCastDoubleToBoolean() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDoubleToBooleanViaDoubleToLong expr = new CastDoubleToBooleanViaDoubleToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)resultV.vector[3]);
        Assert.assertEquals((long)1L, (long)resultV.vector[4]);
    }

    @Test
    public void testCastDoubleToTimestamp() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInTimestampOut();
        TimestampColumnVector resultV = (TimestampColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastDoubleToTimestamp expr = new CastDoubleToTimestamp(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)0.0, (double)TimestampUtils.getDouble((Timestamp)resultV.asScratchTimestamp(3)), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.5, (double)TimestampUtils.getDouble((Timestamp)resultV.asScratchTimestamp(4)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCastLongToBoolean() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector inV = (LongColumnVector)b.cols[0];
        inV.vector[0] = 0L;
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastLongToBooleanViaLongToLong expr = new CastLongToBooleanViaLongToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)resultV.vector[0]);
        Assert.assertEquals((long)1L, (long)resultV.vector[1]);
    }

    @Test
    public void testCastStringToBoolean() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchStringInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastStringToBoolean expr = new CastStringToBoolean(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resultV.vector[0]);
        Assert.assertEquals((long)1L, (long)resultV.vector[1]);
        Assert.assertEquals((long)1L, (long)resultV.vector[2]);
        Assert.assertEquals((long)0L, (long)resultV.vector[3]);
        Assert.assertEquals((long)0L, (long)resultV.vector[4]);
        Assert.assertEquals((long)0L, (long)resultV.vector[5]);
        Assert.assertEquals((long)0L, (long)resultV.vector[6]);
        Assert.assertEquals((long)1L, (long)resultV.vector[7]);
    }

    @Test
    public void testCastLongToTimestamp() throws HiveException {
        long[] longValues = new long[500];
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInTimestampOut(longValues);
        TimestampColumnVector resultV = (TimestampColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastLongToTimestamp expr = new CastLongToTimestamp(0, 1);
        expr.evaluate(b);
        for (int i = 0; i < longValues.length; ++i) {
            Timestamp timestamp = resultV.asScratchTimestamp(i);
            long actual = TimestampWritableV2.getLong((org.apache.hadoop.hive.common.type.Timestamp)org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)timestamp.getTime(), (int)timestamp.getNanos()));
            Assert.assertEquals((long)actual, (long)longValues[i]);
        }
    }

    @Test
    public void testCastTimestampToLong() throws HiveException {
        long[] longValues = new long[500];
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchTimestampInLongOut(longValues);
        TimestampColumnVector inV = (TimestampColumnVector)b.cols[0];
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastTimestampToLong expr = new CastTimestampToLong(0, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo);
        expr.setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.NONE);
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(b);
        for (int i = 0; i < longValues.length; ++i) {
            long actual = resultV.vector[i];
            long timestampLong = inV.getTimestampAsLong(i);
            if (actual == timestampLong) continue;
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testCastTimestampToDouble() throws HiveException {
        double[] doubleValues = new double[500];
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchTimestampInDoubleOut(doubleValues);
        TimestampColumnVector inV = (TimestampColumnVector)b.cols[0];
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastTimestampToDouble expr = new CastTimestampToDouble(0, 1);
        expr.evaluate(b);
        for (int i = 0; i < doubleValues.length; ++i) {
            double actual = resultV.vector[i];
            double doubleValue = TimestampUtils.getDouble((Timestamp)inV.asScratchTimestamp(i));
            Assert.assertEquals((double)actual, (double)doubleValue, (double)1.0E-9f);
        }
    }

    @Test
    public void testCastTimestampToString() throws HiveException {
        int numberToTest = 100;
        long[] epochSecondValues = new long[numberToTest];
        int[] nanoValues = new int[numberToTest];
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchTimestampInStringOut(epochSecondValues, nanoValues);
        BytesColumnVector resultV = (BytesColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        CastTimestampToString expr = new CastTimestampToString(0, 1);
        expr.evaluate(b);
        for (int i = 0; i < numberToTest; ++i) {
            String expected = org.apache.hadoop.hive.common.type.Timestamp.ofEpochSecond((long)epochSecondValues[i], (int)nanoValues[i]).toString();
            byte[] subbyte = Arrays.copyOfRange(resultV.vector[i], resultV.start[i], resultV.start[i] + resultV.length[i]);
            String result = new String(subbyte, StandardCharsets.UTF_8);
            Assert.assertEquals((String)("Index: " + i + " Seconds since epoch: " + epochSecondValues[i] + " nanoseconds: " + nanoValues[i]), (Object)expected, (Object)result);
        }
    }

    public byte[] toBytes(String s) {
        byte[] b = null;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert string to UTF-8 byte array.");
        }
        return b;
    }

    @Test
    public void testCastLongToString() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        b.cols[1].noNulls = true;
        CastLongToString expr = new CastLongToString(1, 2);
        expr.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.longTypeInfo});
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(b);
        byte[] num255 = this.toBytes("255");
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])num255, (int)0, (int)num255.length, (byte[])resultV.vector[1], (int)resultV.start[1], (int)resultV.length[1]));
    }

    @Test
    public void testCastBooleanToString() throws HiveException {
        byte[] t = this.toBytes("TRUE");
        byte[] f = this.toBytes("FALSE");
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        LongColumnVector inV = (LongColumnVector)b.cols[1];
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        inV.vector[1] = 1L;
        CastBooleanToStringViaLongToString expr = new CastBooleanToStringViaLongToString(1, 2);
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])f, (int)0, (int)f.length, (byte[])resultV.vector[0], (int)resultV.start[0], (int)resultV.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])t, (int)0, (int)t.length, (byte[])resultV.vector[1], (int)resultV.start[1], (int)resultV.length[1]));
    }

    @Test
    public void testCastDecimalToLong() throws HiveException {
        VectorizedRowBatch b = this.getBatchDecimalLong();
        CastDecimalToLong expr = new CastDecimalToLong(0, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo);
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(b);
        LongColumnVector r = (LongColumnVector)b.cols[1];
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)-2L, (long)r.vector[1]);
        Assert.assertEquals((long)9999999999999999L, (long)r.vector[2]);
        b = this.getBatchDecimalLong();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        r = (LongColumnVector)b.cols[1];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[1]);
        Assert.assertFalse((boolean)r.isNull[0]);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        b = this.getBatchDecimalLong();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        r = (LongColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        b = this.getBatchDecimalLong();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        r = (LongColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testCastDecimalToBoolean() throws HiveException {
        VectorizedRowBatch b = this.getBatchDecimalLong();
        CastDecimalToBoolean expr = new CastDecimalToBoolean(0, 1);
        expr.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.decimalTypeInfo});
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        expr.transientInit((Configuration)this.hiveConf);
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[1].set(HiveDecimal.create((int)0));
        expr.evaluate(b);
        LongColumnVector r = (LongColumnVector)b.cols[1];
        Assert.assertEquals((long)1L, (long)r.vector[0]);
        Assert.assertEquals((long)0L, (long)r.vector[1]);
        Assert.assertEquals((long)1L, (long)r.vector[2]);
    }

    private VectorizedRowBatch getBatchDecimalLong() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new LongColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.1"));
        dv.vector[1].set(HiveDecimal.create((String)"-2.2"));
        dv.vector[2].set(HiveDecimal.create((String)"9999999999999999.00"));
        return b;
    }

    @Test
    public void testCastDecimalToDouble() throws HiveException {
        double eps = 1.0E-6;
        VectorizedRowBatch b = this.getBatchDecimalDouble();
        CastDecimalToDouble expr = new CastDecimalToDouble(0, 1);
        expr.evaluate(b);
        DoubleColumnVector r = (DoubleColumnVector)b.cols[1];
        Assert.assertEquals((double)1.1, (double)r.vector[0], (double)1.0E-6);
        Assert.assertEquals((double)-2.2, (double)r.vector[1], (double)1.0E-6);
        Assert.assertEquals((double)1.0E16, (double)r.vector[2], (double)1.0E-6);
        b = this.getBatchDecimalDouble();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[1]);
        Assert.assertFalse((boolean)r.isNull[0]);
        Assert.assertEquals((double)1.1, (double)r.vector[0], (double)1.0E-6);
        b = this.getBatchDecimalDouble();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertEquals((double)1.1, (double)r.vector[0], (double)1.0E-6);
        b = this.getBatchDecimalDouble();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    private VectorizedRowBatch getBatchDecimalDouble() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new DoubleColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.1"));
        dv.vector[1].set(HiveDecimal.create((String)"-2.2"));
        dv.vector[2].set(HiveDecimal.create((String)"9999999999999999.00"));
        return b;
    }

    @Test
    public void testCastDecimalToFloat() throws HiveException {
        double eps = 1.0E-14;
        double f1 = HiveDecimal.create((String)"1.1").floatValue();
        double f2 = HiveDecimal.create((String)"-2.2").floatValue();
        double f3 = HiveDecimal.create((String)"9999999999999999.00").floatValue();
        VectorizedRowBatch b = this.getBatchDecimalDouble();
        CastDecimalToFloat expr = new CastDecimalToFloat(0, 1);
        expr.evaluate(b);
        DoubleColumnVector r = (DoubleColumnVector)b.cols[1];
        Assert.assertEquals((double)f1, (double)r.vector[0], (double)1.0E-14);
        Assert.assertEquals((double)f2, (double)r.vector[1], (double)1.0E-14);
        Assert.assertEquals((double)f3, (double)r.vector[2], (double)1.0E-14);
        b = this.getBatchDecimalDouble();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[1]);
        Assert.assertFalse((boolean)r.isNull[0]);
        Assert.assertEquals((double)f1, (double)r.vector[0], (double)1.0E-14);
        b = this.getBatchDecimalDouble();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertEquals((double)f1, (double)r.vector[0], (double)1.0E-14);
        b = this.getBatchDecimalDouble();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        r = (DoubleColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testCastDecimalToString() throws HiveException {
        VectorizedRowBatch b = this.getBatchDecimalString();
        CastDecimalToString expr = new CastDecimalToString(0, 1);
        expr.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.decimalTypeInfo});
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(b);
        BytesColumnVector r = (BytesColumnVector)b.cols[1];
        byte[] v = this.toBytes("1.10");
        Assert.assertTrue((String)(Integer.valueOf(v.length).toString() + " " + r.length[0]), (v.length == r.length[0] ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])v, (int)0, (int)v.length, (byte[])r.vector[0], (int)r.start[0], (int)r.length[0]));
        v = this.toBytes("-2.20");
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])v, (int)0, (int)v.length, (byte[])r.vector[1], (int)r.start[1], (int)r.length[1]));
        v = this.toBytes("9999999999999999.00");
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])v, (int)0, (int)v.length, (byte[])r.vector[2], (int)r.start[2], (int)r.length[2]));
    }

    private VectorizedRowBatch getBatchDecimalString() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new BytesColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.1"));
        dv.vector[1].set(HiveDecimal.create((String)"-2.2"));
        dv.vector[2].set(HiveDecimal.create((String)"9999999999999999.00"));
        return b;
    }

    @Test
    public void testCastDecimalToTimestamp() throws HiveException {
        double[] doubleValues = new double[500];
        VectorizedRowBatch b = this.getBatchDecimalTimestamp(doubleValues);
        CastDecimalToTimestamp expr = new CastDecimalToTimestamp(0, 1);
        expr.evaluate(b);
        TimestampColumnVector r = (TimestampColumnVector)b.cols[1];
        for (int i = 0; i < doubleValues.length; ++i) {
            double expectedDouble = doubleValues[i];
            Timestamp timestamp = r.asScratchTimestamp(i);
            double asDouble = TimestampUtils.getDouble((Timestamp)timestamp);
            if (expectedDouble == asDouble) continue;
            Assert.assertTrue((boolean)false);
        }
    }

    private VectorizedRowBatch getBatchDecimalLong2() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 9;
        DecimalColumnVector dv = new DecimalColumnVector(18, scale);
        b.cols[0] = dv;
        b.cols[1] = new LongColumnVector();
        b.size = 3;
        dv.vector[0].set(HiveDecimal.create((String)"1.111111111"));
        dv.vector[1].set(HiveDecimal.create((String)"-2.222222222"));
        dv.vector[2].set(HiveDecimal.create((String)"31536000.999999999"));
        return b;
    }

    private VectorizedRowBatch getBatchDecimalTimestamp(double[] doubleValues) {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        DecimalColumnVector dv = new DecimalColumnVector(doubleValues.length, 38, 18);
        b.cols[0] = dv;
        b.cols[1] = new TimestampColumnVector(doubleValues.length);
        dv.noNulls = true;
        Random r = new Random(94830L);
        for (int i = 0; i < doubleValues.length; ++i) {
            double asDouble;
            long millis = RandomTypeUtil.randomMillis((Random)r);
            Timestamp ts = new Timestamp(millis);
            int nanos = RandomTypeUtil.randomNanos((Random)r);
            ts.setNanos(nanos);
            TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)ts.getTime(), (int)ts.getNanos()));
            doubleValues[i] = asDouble = tsw.getDouble();
            HiveDecimal hiveDecimal = HiveDecimal.create((BigDecimal)new BigDecimal(asDouble));
            dv.set(i, hiveDecimal);
        }
        b.size = doubleValues.length;
        return b;
    }

    @Test
    public void testCastLongToDecimal() throws HiveException {
        VectorizedRowBatch b = this.getBatchLongDecimal();
        CastLongToDecimal expr = new CastLongToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"99999999999999")));
    }

    private VectorizedRowBatch getBatchLongDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        LongColumnVector lv = new LongColumnVector();
        b.cols[0] = lv;
        b.cols[1] = new DecimalColumnVector(18, 2);
        lv.vector[0] = 0L;
        lv.vector[1] = -1L;
        lv.vector[2] = 99999999999999L;
        return b;
    }

    private VectorizedRowBatch getBatchTimestampDecimal(HiveDecimal[] hiveDecimalValues) {
        Random r = new Random(994L);
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        TimestampColumnVector tcv = new TimestampColumnVector(hiveDecimalValues.length);
        b.cols[0] = tcv;
        b.cols[1] = new DecimalColumnVector(hiveDecimalValues.length, 38, 18);
        for (int i = 0; i < hiveDecimalValues.length; ++i) {
            int optionalNanos = 0;
            switch (r.nextInt(4)) {
                case 0: {
                    break;
                }
                case 1: {
                    optionalNanos = r.nextInt((int)NANOSECONDS_PER_SECOND);
                    break;
                }
                case 2: {
                    optionalNanos = r.nextInt((int)MILLISECONDS_PER_SECOND) * (int)NANOSECONDS_PER_MILLISSECOND;
                    break;
                }
                case 3: {
                    optionalNanos = r.nextInt((int)NANOSECONDS_PER_MILLISSECOND);
                }
            }
            long millis = RandomTypeUtil.randomMillis((Random)r);
            Timestamp ts = new Timestamp(millis);
            ts.setNanos(optionalNanos);
            TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)ts.getTime(), (int)ts.getNanos()));
            hiveDecimalValues[i] = tsw.getHiveDecimal();
            tcv.set(i, ts);
        }
        b.size = hiveDecimalValues.length;
        return b;
    }

    @Test
    public void testCastDoubleToDecimal() throws HiveException {
        HiveDecimal hd2;
        HiveDecimal hd1;
        VectorizedRowBatch b = this.getBatchDoubleDecimal();
        CastDoubleToDecimal expr = new CastDoubleToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        HiveDecimal hd0 = HiveDecimal.create((String)"0.0");
        if (!hd0.equals((Object)r.vector[0].getHiveDecimal())) {
            Assert.assertTrue((boolean)false);
        }
        if (!(hd1 = HiveDecimal.create((String)"-1.0")).equals((Object)r.vector[1].getHiveDecimal())) {
            Assert.assertTrue((boolean)false);
        }
        if (!(hd2 = HiveDecimal.create((String)"99999999999999")).equals((Object)r.vector[2].getHiveDecimal())) {
            Assert.assertTrue((boolean)false);
        }
    }

    private VectorizedRowBatch getBatchDoubleDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        int scale = 2;
        DoubleColumnVector dv = new DoubleColumnVector();
        b.cols[0] = dv;
        b.cols[1] = new DecimalColumnVector(18, scale);
        b.size = 3;
        dv.vector[0] = 0.0;
        dv.vector[1] = -1.0;
        dv.vector[2] = 9.9999999999999E13;
        return b;
    }

    @Test
    public void testCastStringToDecimal() throws HiveException {
        VectorizedRowBatch b = this.getBatchStringDecimal();
        CastStringToDecimal expr = new CastStringToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.10")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-2.20")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"99999999999999.0")));
    }

    private VectorizedRowBatch getBatchStringDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        BytesColumnVector bv = new BytesColumnVector();
        b.cols[0] = bv;
        b.cols[1] = new DecimalColumnVector(18, 2);
        bv.initBuffer();
        byte[] x0 = this.toBytes("1.10");
        byte[] x1 = this.toBytes("-2.20");
        byte[] x2 = this.toBytes("99999999999999.0");
        bv.setVal(0, x0, 0, x0.length);
        bv.setVal(1, x1, 0, x1.length);
        bv.setVal(2, x2, 0, x2.length);
        return b;
    }

    @Test
    public void testCastTimestampToDecimal() throws HiveException {
        HiveDecimal expectedHiveDecimal;
        HiveDecimal hiveDecimal;
        int i;
        HiveDecimal[] hiveDecimalValues = new HiveDecimal[500];
        VectorizedRowBatch b = this.getBatchTimestampDecimal(hiveDecimalValues);
        CastTimestampToDecimal expr = new CastTimestampToDecimal(0, 1);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[1];
        for (i = 0; i < hiveDecimalValues.length; ++i) {
            hiveDecimal = r.vector[i].getHiveDecimal();
            if (hiveDecimal.equals((Object)(expectedHiveDecimal = hiveDecimalValues[i]))) continue;
            Assert.assertTrue((boolean)false);
        }
        r = new DecimalColumnVector(hiveDecimalValues.length, 5, 2);
        b.cols[1] = r;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[1];
        for (i = 0; i < hiveDecimalValues.length; ++i) {
            hiveDecimal = r.vector[i].getHiveDecimal();
            expectedHiveDecimal = hiveDecimalValues[i];
            if (HiveDecimal.enforcePrecisionScale((HiveDecimal)expectedHiveDecimal, (int)5, (int)2) == null) {
                Assert.assertTrue((boolean)r.isNull[i]);
                continue;
            }
            Assert.assertTrue((!r.isNull[i] ? 1 : 0) != 0);
            if (hiveDecimal.equals((Object)expectedHiveDecimal)) continue;
            Assert.assertTrue((boolean)false);
        }
    }

    private VectorizedRowBatch getBatchLongDecimalPrec5Scale2() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        LongColumnVector lv = new LongColumnVector();
        b.cols[0] = lv;
        b.cols[1] = new DecimalColumnVector(5, 2);
        lv.vector[0] = 0L;
        lv.vector[1] = -1L;
        lv.vector[2] = 99999999999999L;
        return b;
    }

    private VectorizedRowBatch getBatchDecimalDecimal() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        DecimalColumnVector v0 = new DecimalColumnVector(18, 4);
        b.cols[0] = v0;
        DecimalColumnVector v1 = new DecimalColumnVector(5, 2);
        b.cols[1] = v1;
        v0.vector[0].set(HiveDecimal.create((String)"10.0001"));
        v0.vector[1].set(HiveDecimal.create((String)"-9999999.9999"));
        v1.vector[0].set(HiveDecimal.create((String)"100.01"));
        v1.vector[1].set(HiveDecimal.create((String)"-200.02"));
        b.size = 2;
        return b;
    }
}

