/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorStructField {
    @Test
    public void testStructField() throws Exception {
        Random random = new Random(7743L);
        for (int i = 0; i < 5; ++i) {
            this.doStructFieldTests(random);
        }
    }

    private void doStructFieldTests(Random random) throws Exception {
        String structTypeName = VectorRandomRowSource.getDecoratedTypeName(random, "struct", VectorRandomRowSource.SupportedTypes.ALL, null, 0, 2);
        StructTypeInfo structTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)structTypeName);
        List fieldNameList = structTypeInfo.getAllStructFieldNames();
        int fieldCount = fieldNameList.size();
        for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
            this.doOneStructFieldTest(random, structTypeInfo, structTypeName, fieldIndex);
        }
    }

    private void doOneStructFieldTest(Random random, StructTypeInfo structTypeInfo, String structTypeName, int fieldIndex) throws Exception {
        int i;
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 1;
        generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType((TypeInfo)structTypeInfo));
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        String columnName = "col" + columnNum++;
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc((TypeInfo)structTypeInfo, columnName, "table", false);
        columns.add(columnName);
        ObjectInspector structObjectInspector = VectorRandomRowSource.getObjectInspector((TypeInfo)structTypeInfo);
        ArrayList<ObjectInspector> objectInspectorList = new ArrayList<ObjectInspector>();
        objectInspectorList.add(structObjectInspector);
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        List fieldNameList = structTypeInfo.getAllStructFieldNames();
        List fieldTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
        String randomFieldName = (String)fieldNameList.get(fieldIndex);
        TypeInfo outputTypeInfo = (TypeInfo)fieldTypeInfoList.get(fieldIndex);
        ExprNodeFieldDesc exprNodeFieldDesc = new ExprNodeFieldDesc(outputTypeInfo, (ExprNodeDesc)col1Expr, randomFieldName, Boolean.valueOf(false));
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[StructFieldTestMode.count][];
        block4: for (i = 0; i < StructFieldTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            StructFieldTestMode negativeTestMode = StructFieldTestMode.values()[i];
            switch (negativeTestMode) {
                case ROW_MODE: {
                    this.doRowStructFieldTest((TypeInfo)structTypeInfo, columns, children, exprNodeFieldDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), outputTypeInfo, resultObjects);
                    continue block4;
                }
                case VECTOR_EXPRESSION: {
                    this.doVectorStructFieldTest((TypeInfo)structTypeInfo, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, exprNodeFieldDesc, negativeTestMode, batchSource, exprNodeFieldDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected Negative operator test mode " + (Object)((Object)negativeTestMode));
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < StructFieldTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " structTypeName " + structTypeName + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)StructFieldTestMode.values()[v]) + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " structTypeName " + structTypeName + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)StructFieldTestMode.values()[v]) + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private void doRowStructFieldTest(TypeInfo typeInfo, List<String> columns, List<ExprNodeDesc> children, ExprNodeFieldDesc exprNodeFieldDesc, Object[][] randomRows, ObjectInspector rowInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprNodeFieldDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        for (Object[] row : randomRows) {
            Object result = evaluator.evaluate((Object)row);
            Object copyResult = null;
            try {
                copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            catch (Exception e) {
                System.out.println("here");
            }
            resultObjects[i] = copyResult;
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorStructFieldTest(TypeInfo typeInfo, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, ExprNodeFieldDesc exprNodeFieldDesc, StructFieldTestMode negativeTestMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprNodeFieldDesc);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (negativeTestMode == StructFieldTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " negativeTestMode " + (Object)((Object)negativeTestMode) + " vectorExpression " + vectorExpression.toString());
        }
        String[] outputScratchTypeNames = vectorizationContext.getScratchColumnTypeNames();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, typeInfos, dataTypePhysicalVariations, null, 0, 0, null, outputScratchTypeNames, null);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum StructFieldTestMode {
        ROW_MODE,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = StructFieldTestMode.values().length;
        }
    }
}

